/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.controls;

import ice.IcePanelManager;
import ice.event.IceClientErrorEvent;
import ice.exceptions.IcePanelException;
import ice.gui.panel.sans.controls.SansDeviceControlPanel;
import ice.gui.panel.sans.events.SansInputControlFocusListener;
import ice.gui.panel.sans.subpanels.SansCommandManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class NewWavelengthControlPanel
extends SansDeviceControlPanel {
    private JButton newWavelengthBtn;
    private JLabel newLabel;
    private JTextField newTextField;

    public NewWavelengthControlPanel(String name, String deviceName) {
        super(name, deviceName);
    }

    @Override
    protected void init() {
        super.init();
        this.newLabel = new JLabel();
        this.newTextField = new JTextField();
        this.newWavelengthBtn = new JButton();
        this.newTextField.addFocusListener(new SansInputControlFocusListener());
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.newWavelengthBtn.setText("F9: Redefine Wavelength");
        this.newWavelengthBtn.setActionCommand("SamplePosition");
        this.newWavelengthBtn.setHorizontalAlignment(2);
        this.newWavelengthBtn.addActionListener(new InitializeActionListiner());
        this.add((Component)this.newWavelengthBtn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.newLabel.setText("New Wavelength");
        this.add((Component)this.newLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.newTextField.setText(" ");
        this.newTextField.setPreferredSize(new Dimension(60, 20));
        this.add((Component)this.newTextField, gridBagConstraints);
    }

    @Override
    public String getCurrentValue() {
        return this.newTextField.getText();
    }

    @Override
    public String getTargetValue() {
        return null;
    }

    @Override
    public void setCurrentValue(String value) {
        this.newTextField.setText(value);
    }

    @Override
    public void setTargetValue(String value) {
    }

    private class InitializeActionListiner
    implements ActionListener {
        private InitializeActionListiner() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            String cValue = NewWavelengthControlPanel.this.getCurrentValue();
            if ((cValue = cValue.trim()).equals("")) {
                return;
            }
            try {
                double value = Double.parseDouble(NewWavelengthControlPanel.this.getCurrentValue());
            }
            catch (NumberFormatException ne) {
                IcePanelException ipe = new IcePanelException("Incorrect value format, please insert numeric value");
                IceClientErrorEvent errorEvent = new IceClientErrorEvent(NewWavelengthControlPanel.this, ipe);
                IcePanelManager panelManager = IcePanelManager.getReference();
                panelManager.notifyIceClientErrorListeners(errorEvent);
                NewWavelengthControlPanel.this.setCurrentValue(" ");
            }
            String command = "device set wavelength " + NewWavelengthControlPanel.this.getCurrentValue();
            SansCommandManager.takeQueuedAction(command);
            NewWavelengthControlPanel.this.setCurrentValue(" ");
        }
    }
}

