/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel.sans.actions;

import ice.ClientAPI;
import ice.IcePanelManager;
import ice.commands.QueuedCommand;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceWindow;
import ice.gui.core.controls.serverFileView.ServerFileSaveDialog;
import ice.gui.core.controls.serverFileView.ServerFolderView;
import ice.gui.panel.sans.DataAcquisitionPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.apache.log4j.Logger;

public class SaveCurrentConfigAction
implements ActionListener {
    private static Logger logger = Logger.getLogger("ErrorLogger.SaveCurrentConfig");

    @Override
    public void actionPerformed(ActionEvent event) {
        String fileName;
        IcePanelManager panelManager = IcePanelManager.getReference();
        GenericIcePanel panel = panelManager.findOpenPanelByName(DataAcquisitionPanel.title);
        IceWindow window = panelManager.getIceWindow(panel);
        String parentName = "";
        IceFile parentDir = null;
        ServerFileSaveDialog.FileNameAndParent fileNameAndParent = ServerFileSaveDialog.saveIceFileToServer(window, IceFileType.sansConfig, ServerFolderView.ValidServerFolders.USER, true);
        if (fileNameAndParent == null) {
            return;
        }
        parentDir = fileNameAndParent.getParent();
        if (parentDir != null && parentDir.isMagicWord()) {
            parentName = String.valueOf(parentDir.getName()) + ":";
        }
        if (!(fileName = fileNameAndParent.getFileName()).endsWith(".cfg") && !fileName.contains(".")) {
            fileName = String.valueOf(fileName) + ".cfg";
        }
        String message = "Scan SaveConfig " + parentName + fileName;
        try {
            ClientAPI messageSender = ClientAPI.getInstance();
            QueuedCommand command = new QueuedCommand(message, messageSender);
            command.runAsynchronous();
        }
        catch (Exception e) {
            logger.error("client api error", e.getCause());
        }
    }
}

