/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.IcePanelManager;
import ice.communication.SendQueueManager;
import ice.data.BaseScan;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.Queue;
import ice.data.QueueCommand;
import ice.data.Resource;
import ice.data.ScanList;
import ice.data.tas.bt7.Instrument;
import ice.event.LoadSaveableIcePanelEvent;
import ice.event.LoadSaveableIcePanelListener;
import ice.event.QueueChangedEvent;
import ice.event.QueueChangedListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.IceViewPanel;
import ice.gui.core.IceWindow;
import ice.jython.management.PythonContainer;
import ice.swing.CursorInsertJList;
import ice.swing.QueueListCellRenderer;
import ice.swing.ServerQueueTreeCellRenderer;
import ice.swing.ServerQueueTreeModel;
import ice.util.ConversionUtilities;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ServerQueuePanel
extends IceViewPanel
implements InstrumentValueChangedListener,
TreeModelListener,
ListSelectionListener,
QueueChangedListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.QueueLogger");
    private Instrument instrument;
    private Queue serverQueue;
    private SendQueueManager sendManager;
    private JPanel mainPanel;
    private JPanel navigationPanel;
    private JPanel progressPanel;
    private JPanel queuePanel;
    private JPanel buttonPanel;
    private JLabel currPointLabel;
    private JLabel currPointValue;
    private JLabel totalPointsLabel;
    private JLabel totalPointsValue;
    private JLabel monitorCountLabel;
    private JLabel monitorCountValue;
    private JLabel detectorCountLabel;
    private JLabel detectorCountValue;
    private DefaultListModel queueModel;
    private QueueList queueList;
    private TurnOnAndOffWithListSelectionButton upBtn;
    private TurnOnAndOffWithListSelectionButton removeBtn;
    private TurnOnAndOffWithListSelectionButton downBtn;
    private ICEFileTree fileTree;
    private JPanel statusBar;
    private JLabel estimatedTimeLabel;
    private ServerQueueTreeModel model;
    private JPopupMenu filePanelMenu;
    private JPopupMenu queuePanelMenu;
    private RemoveAction removeAction;
    private DeleteResourceAction deleteResourceAction;
    private JPopupMenu fileMenu;
    private JMenuItem editItem;
    JMenuItem editAsTextItem;
    JMenuItem loadPythonItem;
    JMenuItem addToQueueItem;
    JMenuItem dryRunItem;
    JMenuItem deleteItem;
    private Action cutAction = null;
    private Action copyAction = null;
    private Action pasteAction = null;
    private Controller controller;

    public ServerQueuePanel() throws IcePanelException {
        super("Server Queue");
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.valueChanged(null);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean selectionEmpty = false;
        Action cutAction = this.getCutAction();
        Action copyAction = this.getCopyAction();
        Action pasteAction = this.getPasteAction();
        if (this.queueList == null) {
            return;
        }
        selectionEmpty = this.queueList.isSelectionEmpty();
        Object[] selectionList = this.queueList.getSelectedValues();
        boolean commandIsCurrent = false;
        cutAction.setEnabled(false);
        copyAction.setEnabled(false);
        pasteAction.setEnabled(false);
        if (!selectionEmpty && selectionList.length > 1) {
            QueueCommand queueCommand = null;
            int i = 0;
            while (i < selectionList.length) {
                queueCommand = (QueueCommand)this.queueList.getModel().getElementAt(i);
                commandIsCurrent = queueCommand.isCurrent();
                cutAction.setEnabled(!commandIsCurrent);
                ++i;
            }
            cutAction.setEnabled(true);
            copyAction.setEnabled(true);
            pasteAction.setEnabled(false);
        } else {
            String clipBoardText = null;
            boolean isDataQueueListSelection = false;
            Clipboard system = null;
            Transferable transferable = null;
            system = Toolkit.getDefaultToolkit().getSystemClipboard();
            transferable = system.getContents(this);
            if (transferable != null) {
                try {
                    clipBoardText = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (clipBoardText != null) {
                        isDataQueueListSelection = this.queueList.isStringQueueSelectionString(clipBoardText);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            boolean validSelection = true;
            if (!selectionEmpty) {
                QueueCommand selectedValue = (QueueCommand)this.queueList.getSelectedValue();
                boolean isCurrentCommand = false;
                boolean isPastCommand = false;
                isPastCommand = selectedValue.isPast();
                if (isPastCommand) {
                    int selectedIndex = this.queueList.getSelectedIndex();
                    int size = this.queueList.getModel().getSize() - 1;
                    if (size == selectedIndex) {
                        validSelection = true;
                    } else if (selectedIndex < size) {
                        QueueCommand nextCommand = (QueueCommand)this.queueList.getModel().getElementAt(selectedIndex + 1);
                        validSelection = nextCommand.isFuture();
                    }
                }
                cutAction.setEnabled(!(commandIsCurrent = selectedValue.isCurrent()));
                copyAction.setEnabled(true);
            }
            pasteAction.setEnabled(validSelection && isDataQueueListSelection);
        }
    }

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        this.instrument = this.controller.getInstrument();
        this.serverQueue = this.controller.getServerQueue();
        try {
            this.instrument.addPropertyChangeListener(this);
            this.serverQueue.addChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ServerQueuePanel.init " + e);
        }
        this.sendManager = this.controller.getSendManager();
        IceFile rootFile = this.controller.getExpFolder();
        ScanList scanList = this.controller.getServerScanList();
        IceFile commonFolder = this.controller.getCommonFolder();
        this.model = new ServerQueueTreeModel(rootFile, commonFolder, scanList);
        this.fileTree = new ICEFileTree(this.model);
        this.removeAction = new RemoveAction();
        this.deleteResourceAction = new DeleteResourceAction();
        this.filePanelMenu = this.createFilePanelMenu();
        this.queuePanelMenu = this.createQueuePanelMenu();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        this.navigationPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new BorderLayout());
        labelPanel.setBorder(BorderFactory.createBevelBorder(0));
        labelPanel.add((Component)new JLabel("Files"), "Center");
        this.navigationPanel.add((Component)labelPanel, "North");
        this.fileTree.setCellRenderer(new ServerQueueTreeCellRenderer());
        this.navigationPanel.add((Component)new JScrollPane(this.fileTree, 22, 32), "Center");
        this.navigationPanel.setPreferredSize(new Dimension(200, 100));
        this.fileTree.addMouseListener(new FileTreePopupListener());
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.insets = new Insets(5, 5, 5, 5);
        this.progressPanel = new JPanel(new GridBagLayout());
        GridBagConstraints progressConstraints = new GridBagConstraints();
        progressConstraints.gridx = 0;
        progressConstraints.gridy = 0;
        progressConstraints.weightx = 0.0;
        progressConstraints.insets = new Insets(1, 2, 1, 2);
        this.progressPanel.setBorder(BorderFactory.createTitledBorder("Progress"));
        this.currPointLabel = new JLabel("<html><b>Current Point:</b></html>");
        this.currPointLabel.setAlignmentX(0.0f);
        this.currPointValue = new JLabel("N/A");
        JLabel emptyLabel1 = new JLabel("");
        this.totalPointsLabel = new JLabel("<html><b>Total Points:</b></html>");
        this.totalPointsValue = new JLabel("N/A");
        JLabel emptyLabel2 = new JLabel("");
        this.monitorCountLabel = new JLabel("<html><b>Monitor Count:</b></html>");
        this.monitorCountLabel.setAlignmentX(1.0f);
        this.monitorCountValue = new JLabel("N/A");
        this.detectorCountLabel = new JLabel("<html><b>Detector Count:</b></html>");
        this.detectorCountLabel.setAlignmentX(1.0f);
        this.detectorCountValue = new JLabel("N/A");
        progressConstraints.anchor = 17;
        this.progressPanel.add((Component)this.currPointLabel, progressConstraints);
        ++progressConstraints.gridx;
        this.progressPanel.add((Component)this.currPointValue, progressConstraints);
        ++progressConstraints.gridx;
        progressConstraints.weightx = 1.0;
        this.progressPanel.add((Component)emptyLabel1, progressConstraints);
        progressConstraints.weightx = 0.0;
        ++progressConstraints.gridx;
        progressConstraints.anchor = 13;
        this.progressPanel.add((Component)this.monitorCountLabel, progressConstraints);
        ++progressConstraints.gridx;
        progressConstraints.anchor = 17;
        this.progressPanel.add((Component)this.monitorCountValue, progressConstraints);
        progressConstraints.gridx = 0;
        ++progressConstraints.gridy;
        this.progressPanel.add((Component)this.totalPointsLabel, progressConstraints);
        ++progressConstraints.gridx;
        this.progressPanel.add((Component)this.totalPointsValue, progressConstraints);
        ++progressConstraints.gridx;
        progressConstraints.weightx = 1.0;
        this.progressPanel.add((Component)emptyLabel2, progressConstraints);
        progressConstraints.weightx = 0.0;
        ++progressConstraints.gridx;
        progressConstraints.anchor = 13;
        this.progressPanel.add((Component)this.detectorCountLabel, progressConstraints);
        ++progressConstraints.gridx;
        progressConstraints.anchor = 17;
        this.progressPanel.add((Component)this.detectorCountValue, progressConstraints);
        this.queuePanel = new JPanel(new BorderLayout());
        this.queueModel = new DefaultListModel();
        this.queueList = new QueueList(this.queueModel);
        this.queueList.setCellRenderer(new QueueListCellRenderer());
        this.queueList.addListSelectionListener(this);
        this.queueList.addMouseListener(new QueueListPopupListener());
        this.queuePanel.add(this.queueList);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 3));
        this.buttonPanel.add(Box.createVerticalGlue());
        this.buttonPanel.add(Box.createRigidArea(new Dimension(1, 100)));
        this.upBtn = new MoveUpButton(new MoveUpAction());
        this.upBtn.setAlignmentX(0.5f);
        this.queueList.addListSelectionListener(this.upBtn);
        this.buttonPanel.add(this.upBtn);
        this.removeBtn = new RemoveButton(new RemoveAction());
        this.removeBtn.setAlignmentX(0.5f);
        this.queueList.addListSelectionListener(this.removeBtn);
        this.buttonPanel.add(this.removeBtn);
        this.downBtn = new MoveDownButton(new MoveDownAction());
        this.downBtn.setAlignmentX(0.5f);
        this.queueList.addListSelectionListener(this.downBtn);
        this.buttonPanel.add(this.downBtn);
        this.buttonPanel.add(Box.createRigidArea(new Dimension(1, 100)));
        this.buttonPanel.add(Box.createVerticalGlue());
        mainConstraints.fill = 1;
        mainConstraints.weightx = 1.0;
        this.mainPanel.add((Component)this.progressPanel, mainConstraints);
        ++mainConstraints.gridy;
        mainConstraints.weighty = 1.0;
        this.mainPanel.add((Component)new JScrollPane(this.queuePanel, 20, 30), mainConstraints);
        this.mainPanel.setPreferredSize(new Dimension(200, 100));
        mainConstraints.weighty = 0.0;
        --mainConstraints.gridy;
        ++mainConstraints.gridx;
        mainConstraints.gridheight = 2;
        mainConstraints.weightx = 0.0;
        this.mainPanel.add((Component)this.buttonPanel, mainConstraints);
        JPanel splitPanel = new JPanel(new BorderLayout());
        splitPanel.add((Component)this.navigationPanel, "West");
        splitPanel.add((Component)this.mainPanel, "Center");
        this.add((Component)splitPanel, "Center");
        this.fileTree.setDragEnabled(false);
        this.buildStatusBar();
    }

    public Action getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = new CutAction();
        }
        return this.cutAction;
    }

    public Action getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = new CopyAction();
        }
        return this.copyAction;
    }

    public Action getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = new PasteAction();
        }
        return this.pasteAction;
    }

    private void buildStatusBar() {
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new BoxLayout(this.statusBar, 3));
        this.statusBar.setBorder(new BevelBorder(1));
        this.estimatedTimeLabel = new JLabel();
        this.statusBar.add(this.estimatedTimeLabel);
        SwingUtilities.invokeLater(new UpdateStatusBar());
    }

    @Override
    public void actionPerformed(QueueChangedEvent event) {
        SwingUtilities.invokeLater(new ModifyQueue());
        SwingUtilities.invokeLater(new UpdateStatusBar());
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent pce) {
        Object source = pce.getSource();
        Long currPoint = null;
        Long totalPoints = null;
        String propertyName = pce.getPropertyName();
        if (propertyName.equals("currScanPnt")) {
            currPoint = this.instrument.getCurrScanPnt();
        } else if (propertyName.equals("totalScanPnts")) {
            totalPoints = this.instrument.getTotalScanPnts();
        }
        this.updateProgressPanel(currPoint, totalPoints);
    }

    public void updateProgressPanel(Long currPoint, Long totalPoints) {
        if (currPoint != null) {
            final long currPoint2 = currPoint;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (currPoint2 == -1L) {
                        ServerQueuePanel.this.currPointValue.setText("N/A");
                    } else {
                        ServerQueuePanel.this.currPointValue.setText(String.valueOf(currPoint2));
                    }
                }
            });
        }
        if (totalPoints != null) {
            final long totalPoints2 = totalPoints;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (totalPoints2 == -1L) {
                        ServerQueuePanel.this.totalPointsValue.setText("N/A");
                    } else {
                        ServerQueuePanel.this.totalPointsValue.setText(String.valueOf(totalPoints2));
                    }
                }
            });
        }
    }

    @Override
    public JPanel getStatusBar() {
        return this.statusBar;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent arg0) {
        logger.debug("tree nodes changed");
    }

    @Override
    public void treeNodesInserted(TreeModelEvent arg0) {
        logger.debug("tree nodes inserted");
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent arg0) {
        logger.debug("tree nodes removed");
    }

    @Override
    public void treeStructureChanged(TreeModelEvent arg0) {
        logger.debug("tree structure changed");
    }

    private JPopupMenu createFilePanelMenu() {
        this.fileMenu = new JPopupMenu();
        this.editItem = new JMenuItem(new EditScanAction());
        this.editAsTextItem = new JMenuItem(new EditScanAsTextAction());
        this.loadPythonItem = new JMenuItem(new LoadPythonAction());
        this.addToQueueItem = new JMenuItem(new AddToQueueAction());
        this.dryRunItem = new JMenuItem(new DryRunAction());
        this.deleteItem = new JMenuItem(this.deleteResourceAction);
        this.fileMenu.add(this.editItem);
        this.fileMenu.add(this.editAsTextItem);
        this.fileMenu.add(this.loadPythonItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.addToQueueItem);
        this.fileMenu.add(this.dryRunItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.deleteItem);
        return this.fileMenu;
    }

    private JPopupMenu createQueuePanelMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem removeItem = new JMenuItem(this.removeAction);
        JMenuItem clearCompletedItem = new JMenuItem(new ClearCompletedAction());
        JMenuItem clearQueueItem = new JMenuItem(new ClearQueueAction());
        JMenuItem howLongItem = new JMenuItem(new HowLongAction());
        JMenuItem saveToSequenceItem = new JMenuItem(new SaveToSequenceAction());
        menu.add(removeItem);
        menu.addSeparator();
        menu.add(clearCompletedItem);
        menu.add(clearQueueItem);
        menu.addSeparator();
        menu.add(howLongItem);
        menu.addSeparator();
        menu.add(saveToSequenceItem);
        return menu;
    }

    private class AddToQueueAction
    extends AbstractAction {
        public AddToQueueAction() {
            this.putValue("Name", "Add to Queue");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String namePrefixAndSuffix = "";
            Object object = ((DefaultMutableTreeNode)ServerQueuePanel.this.fileTree.getSelectionPath().getLastPathComponent()).getUserObject();
            logger.debug("object: " + object.getClass());
            String name = ((Resource)object).getName();
            if (name.contains(" ")) {
                namePrefixAndSuffix = "\"";
            }
            if (object instanceof BaseScan) {
                ServerQueuePanel.this.sendManager.addMessage("scan runscan " + namePrefixAndSuffix + name + namePrefixAndSuffix);
            } else if (object instanceof IceFile) {
                IceFile parent = ((IceFile)object).getParent();
                String parentName = "";
                if (parent != null) {
                    parentName = String.valueOf(parent.getName()) + ":";
                }
                ServerQueuePanel.this.sendManager.addMessage("stack appendfile " + namePrefixAndSuffix + parentName + name + namePrefixAndSuffix);
            }
        }
    }

    private class ClearCompletedAction
    extends AbstractAction {
        public ClearCompletedAction() {
            this.putValue("Name", "Clear Completed");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ServerQueuePanel.this.serverQueue.clearPast();
        }
    }

    private class ClearQueueAction
    extends ConfirmableAction {
        public ClearQueueAction() {
            this.putValue("Name", "Clear Queue");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            String title = "Confirm Clear";
            String message = "Are you sure you want to clear the queue?";
            ArrayList<JButton> btns = this.createOkCancelBtns();
            ServerQueuePanel.this.throwConfirmDialog(title, message, btns);
        }

        @Override
        public void confirmed() {
            ServerQueuePanel.this.sendManager.addMessage("flushstack");
        }

        @Override
        public void declined() {
        }
    }

    private abstract class ConfirmableAction
    extends AbstractAction {
        private ConfirmableAction() {
        }

        protected ArrayList<JButton> createOkCancelBtns() {
            JButton okBtn = new JButton("OK");
            okBtn.addActionListener(new ConfirmAction());
            JButton cancelBtn = new JButton("Cancel");
            cancelBtn.addActionListener(new DeclineAction());
            ArrayList<JButton> btns = new ArrayList<JButton>();
            btns.add(okBtn);
            btns.add(cancelBtn);
            return btns;
        }

        protected abstract void confirmed();

        protected abstract void declined();

        protected class ConfirmAction
        implements ActionListener {
            protected ConfirmAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConfirmableAction.this.confirmed();
            }
        }

        protected class DeclineAction
        implements ActionListener {
            protected DeclineAction() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConfirmableAction.this.declined();
            }
        }
    }

    private class CopyAction
    extends AbstractAction {
        public CopyAction() {
            super("Copy");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ServerQueuePanel.this.queueList.handleCopy(ae);
        }
    }

    private class CutAction
    extends AbstractAction {
        public CutAction() {
            super("Cut");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ServerQueuePanel.this.queueList.handleCut(ae);
        }
    }

    private class DeleteResourceAction
    extends ConfirmableAction {
        private String deleteCmd;

        public DeleteResourceAction() {
            this.putValue("Name", "Delete");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object object = ((DefaultMutableTreeNode)ServerQueuePanel.this.fileTree.getSelectionPath().getLastPathComponent()).getUserObject();
            String namePrefixAndSuffix = "";
            String name = ((Resource)object).getName();
            if (name.contains(" ")) {
                namePrefixAndSuffix = "\"";
            }
            if (object instanceof BaseScan) {
                this.deleteCmd = "scan delete " + namePrefixAndSuffix + name + namePrefixAndSuffix;
            } else if (object instanceof IceFile) {
                IceFile parent = ((IceFile)object).getParent();
                String parentName = "";
                if (parent != null) {
                    parentName = String.valueOf(parent.getName()) + ":";
                }
                this.deleteCmd = "file delete " + parentName + namePrefixAndSuffix + name + namePrefixAndSuffix;
            } else {
                logger.error("Invalid object in file tree (" + object.getClass() + ").   THIS SHOULDN'T HAPPEN.");
                return;
            }
            String title = "Confirm Delete";
            String message = "Are you sure you want to delete '" + name + "'?";
            ArrayList<JButton> btns = this.createOkCancelBtns();
            ServerQueuePanel.this.throwConfirmDialog(title, message, btns);
        }

        @Override
        public void confirmed() {
            ServerQueuePanel.this.sendManager.addMessage(this.deleteCmd);
        }

        @Override
        public void declined() {
        }
    }

    private class DryRunAction
    extends AbstractAction {
        public DryRunAction() {
            this.putValue("Name", "Dry Run");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object object = ((DefaultMutableTreeNode)ServerQueuePanel.this.fileTree.getSelectionPath().getLastPathComponent()).getUserObject();
            if (object instanceof BaseScan) {
                String scanName = ((BaseScan)object).getName();
                if (scanName.contains(" ")) {
                    scanName = "\"" + scanName + "\"";
                }
                logger.debug("Dry running " + scanName);
                ServerQueuePanel.this.sendManager.addMessage("scan dryrun " + scanName);
            }
        }
    }

    private class EditScanAction
    extends AbstractAction {
        public EditScanAction() {
            super("Edit");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultMutableTreeNode node;
            Object obj;
            IceWindow window = null;
            IcePanelManager panelManager = IcePanelManager.getReference();
            window = panelManager.getIceWindow(ServerQueuePanel.this);
            if (window == null) {
                try {
                    throw new IcePanelException("No window is associated with this panel");
                }
                catch (IcePanelException e) {
                    logger.error("error in edit scan action", e);
                }
            }
            if ((obj = (node = (DefaultMutableTreeNode)ServerQueuePanel.this.fileTree.getSelectionPath().getLastPathComponent()).getUserObject()) instanceof BaseScan) {
                ArrayList<LoadSaveableIcePanelListener> Listeners = window.getLoadSaveableIcePanelListeners();
                for (LoadSaveableIcePanelListener listener : Listeners) {
                    LoadSaveableIcePanelEvent event = new LoadSaveableIcePanelEvent(window, null, (Resource)obj);
                    listener.instantiateSaveableIcePanel(event);
                }
            }
        }
    }

    private class EditScanAsTextAction
    extends AbstractAction {
        public EditScanAsTextAction() {
            super("Edit as Text");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ServerQueuePanel.this.fileTree.getSelectionPath().getLastPathComponent();
            Object obj = node.getUserObject();
            Resource rc = null;
            if (!(obj instanceof Resource)) {
                logger.error("Invalid file selected for editing (" + obj.getClass().getName() + ").  Ignoring.");
                return;
            }
            rc = (Resource)obj;
            IceWindow window = null;
            IcePanelManager panelManager = IcePanelManager.getReference();
            window = panelManager.getIceWindow(ServerQueuePanel.this);
            if (window == null) {
                try {
                    throw new IcePanelException("No window is associated with this panel");
                }
                catch (IcePanelException e) {
                    e.printStackTrace();
                }
            }
            ArrayList<LoadSaveableIcePanelListener> Listeners = window.getLoadSaveableIcePanelListeners();
            for (LoadSaveableIcePanelListener listener : Listeners) {
                LoadSaveableIcePanelEvent event = new LoadSaveableIcePanelEvent(window, null, rc, true);
                listener.instantiateSaveableIcePanel(event);
            }
        }
    }

    private class FileTreePopupListener
    extends MouseAdapter {
        protected static final int DRYRUN_MENUITEM_INDEX = 3;

        private FileTreePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.maybeShowPopup(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            logger.debug("mouseReleased");
            if (me.getClickCount() == 2 && me.getButton() == 1) {
                TreePath path = ServerQueuePanel.this.fileTree.getSelectionPath();
                if (path != null) {
                    Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    if (obj instanceof BaseScan) {
                        new EditScanAction().actionPerformed(null);
                    } else if (obj instanceof IceFile) {
                        new EditScanAsTextAction().actionPerformed(null);
                    }
                }
            } else {
                this.maybeShowPopup(me);
            }
        }

        private void maybeShowPopup(MouseEvent me) {
            if (me.isPopupTrigger()) {
                TreePath path = ServerQueuePanel.this.fileTree.getPathForLocation(me.getX(), me.getY());
                if (path != null) {
                    ServerQueuePanel.this.fileTree.setSelectionPath(path);
                }
                this.loadMenu(me);
            }
        }

        private void loadMenu(MouseEvent me) {
            TreePath path = ServerQueuePanel.this.fileTree.getSelectionPath();
            Object[] pathParts = null;
            int numberOfPathParts = -1;
            if (path == null) {
                return;
            }
            ServerQueuePanel.this.fileMenu.remove(ServerQueuePanel.this.editItem);
            Object obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (obj instanceof String) {
                return;
            }
            if (obj instanceof BaseScan) {
                ServerQueuePanel.this.fileMenu.insert(ServerQueuePanel.this.editItem, 0);
            }
            boolean isPython = false;
            boolean canDryRunAndQueue = false;
            isPython = ((Resource)obj).getFileType() == IceFileType.pythonScript;
            ServerQueuePanel.this.loadPythonItem.setEnabled(isPython);
            canDryRunAndQueue = ((Resource)obj).getFileType() == IceFileType.sequence || ((Resource)obj).getFileType().isAScanType();
            ServerQueuePanel.this.dryRunItem.setEnabled(canDryRunAndQueue);
            ServerQueuePanel.this.addToQueueItem.setEnabled(canDryRunAndQueue);
            ServerQueuePanel.this.filePanelMenu.show(me.getComponent(), me.getX(), me.getY());
        }
    }

    private class HowLongAction
    extends AbstractAction {
        public HowLongAction() {
            this.putValue("Name", "How Long?");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }

    private class ICEFileTree
    extends JTree
    implements DragSourceListener,
    DragGestureListener {
        private DragSource dragSource;
        private DragGestureRecognizer dragGestureRecognizer;

        public ICEFileTree() {
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        public ICEFileTree(Hashtable<?, ?> value) {
            super(value);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        public ICEFileTree(Object[] value) {
            super(value);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        public ICEFileTree(TreeModel newModel) {
            super(newModel);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        public ICEFileTree(TreeNode root, boolean asksAllowsChildren) {
            super(root, asksAllowsChildren);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        public ICEFileTree(TreeNode root) {
            super(root);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        public ICEFileTree(Vector<?> value) {
            super(value);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.initDragging();
        }

        private void initDragging() {
            this.dragSource = new DragSource();
            this.dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        }

        private String convertToMagicWord(String dir) {
            String returnValue = "EXPT";
            if (dir.equalsIgnoreCase("COMMON")) {
                returnValue = "COMM";
            } else if (dir.equalsIgnoreCase("SCANS")) {
                returnValue = "";
            }
            return returnValue;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            StringSelection transferable = null;
            Object[] pathParts = null;
            String theFile = null;
            String theMagicWord = "";
            String theMessage = "";
            int length = -1;
            TreePath thePath = this.getSelectionPath();
            pathParts = thePath.getPath();
            length = pathParts.length - 1;
            theFile = pathParts[length].toString();
            if (length > 1) {
                theMagicWord = pathParts[--length].toString();
                if ((theMagicWord = this.convertToMagicWord(theMagicWord)).length() > 0) {
                    theMagicWord = String.valueOf(theMagicWord) + ":";
                }
            }
            theMessage = String.valueOf(theMagicWord) + theFile;
            transferable = new StringSelection(theMessage);
            this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, transferable, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private class LoadPythonAction
    extends AbstractAction {
        public LoadPythonAction() {
            super("Load (Python)");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ServerQueuePanel.this.fileTree.getSelectionPath().getLastPathComponent();
            Object obj = node.getUserObject();
            IceFile rc = null;
            String message = "";
            boolean succeeded = false;
            if (obj instanceof IceFile && ((IceFile)obj).getFileType() == IceFileType.pythonScript) {
                rc = (IceFile)obj;
                PythonContainer pythonContainer = null;
                pythonContainer = PythonContainer.getReference();
                succeeded = pythonContainer.loadRemotePythonFile(rc);
                if (!succeeded) {
                    message = String.valueOf(message) + rc.getName() + " not found!";
                }
            } else {
                message = "Invalid file selected for loading (" + obj.getClass().getName() + ").  Ignoring.";
                logger.error(message);
            }
            if (!succeeded) {
                ServerQueuePanel.this.throwErrorDialog("Error", message);
            }
        }
    }

    private class ModifyQueue
    implements Runnable {
        private ModifyQueue() {
        }

        @Override
        public void run() {
            Object[] selectedValues = ServerQueuePanel.this.queueList.getSelectedValues();
            ServerQueuePanel.this.queueModel.removeAllElements();
            Iterator<QueueCommand> pastIterator = ServerQueuePanel.this.serverQueue.getPastCommands().iterator();
            while (pastIterator.hasNext()) {
                ServerQueuePanel.this.queueModel.addElement(pastIterator.next());
            }
            if (ServerQueuePanel.this.serverQueue.getCurrCommand() != null) {
                ServerQueuePanel.this.queueModel.addElement(ServerQueuePanel.this.serverQueue.getCurrCommand());
            }
            for (QueueCommand cmd : ServerQueuePanel.this.serverQueue.getFutureCommands()) {
                ServerQueuePanel.this.queueModel.addElement(cmd);
            }
            int i = 0;
            while (i < selectedValues.length) {
                QueueCommand selectedCommand = null;
                int index = -1;
                String selectedCommandString = null;
                selectedCommand = (QueueCommand)selectedValues[i];
                selectedCommandString = selectedCommand.toString();
                index = ServerQueuePanel.this.queueList.getNextMatch(selectedCommandString, 0, Position.Bias.Forward);
                if (index != -1) {
                    ServerQueuePanel.this.queueList.addSelectionInterval(index, index);
                }
                ++i;
            }
        }
    }

    private class MoveDownAction
    extends AbstractAction {
        public MoveDownAction() {
            this.putValue("Name", "Down");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int lastSelectedIndex = -1;
            int firstSelectedIndex = -1;
            int itemToMove = -1;
            QueueCommand commandToMove = null;
            QueueCommand commandToMoveBefore = null;
            String commandMessage = "";
            lastSelectedIndex = ServerQueuePanel.this.queueList.getMaxSelectionIndex();
            firstSelectedIndex = ServerQueuePanel.this.queueList.getMinSelectionIndex();
            itemToMove = lastSelectedIndex + 1;
            commandToMove = (QueueCommand)ServerQueuePanel.this.queueList.getModel().getElementAt(itemToMove);
            commandToMoveBefore = (QueueCommand)ServerQueuePanel.this.queueList.getModel().getElementAt(firstSelectedIndex);
            commandMessage = String.valueOf(commandMessage) + "Stack Move ";
            commandMessage = String.valueOf(commandMessage) + Long.toString(commandToMove.getID());
            commandMessage = String.valueOf(commandMessage) + ", ";
            commandMessage = String.valueOf(commandMessage) + Long.toString(commandToMoveBefore.getID());
            ServerQueuePanel.this.sendManager.addMessage(commandMessage, true);
        }
    }

    protected class MoveDownButton
    extends MoveUpOrDownButtonBase {
        public MoveDownButton(Action a) {
            super(a);
        }

        @Override
        protected void handleValueChanged(ListSelectionEvent e) {
            JList theList = null;
            boolean isLastItemSelected = false;
            int lastIndex = -1;
            theList = (JList)e.getSource();
            isLastItemSelected = theList.isSelectedIndex(lastIndex = theList.getModel().getSize() - 1);
            if (isLastItemSelected) {
                this.setEnabled(false);
            } else {
                super.handleValueChanged(e);
            }
        }
    }

    private class MoveUpAction
    extends AbstractAction {
        public MoveUpAction() {
            this.putValue("Name", "Up");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int lastSelectedIndex = -1;
            int firstSelectedIndex = -1;
            int itemToMove = -1;
            int maxIndex = ServerQueuePanel.this.queueList.getModel().getSize() - 1;
            QueueCommand commandToMove = null;
            QueueCommand commandToMoveAfter = null;
            String commandMessage = "";
            boolean couldNotMoveLastItemOnList = false;
            firstSelectedIndex = ServerQueuePanel.this.queueList.getMinSelectionIndex();
            lastSelectedIndex = ServerQueuePanel.this.queueList.getMaxSelectionIndex();
            itemToMove = firstSelectedIndex - 1;
            commandToMove = (QueueCommand)ServerQueuePanel.this.queueList.getModel().getElementAt(itemToMove);
            commandToMoveAfter = (QueueCommand)ServerQueuePanel.this.queueList.getModel().getElementAt(lastSelectedIndex);
            commandMessage = String.valueOf(commandMessage) + "Stack Move -a ";
            commandMessage = String.valueOf(commandMessage) + Long.toString(commandToMove.getID());
            commandMessage = String.valueOf(commandMessage) + " ";
            commandMessage = String.valueOf(commandMessage) + Long.toString(commandToMoveAfter.getID());
            ServerQueuePanel.this.sendManager.addMessage(commandMessage, true);
        }
    }

    protected class MoveUpButton
    extends MoveUpOrDownButtonBase {
        public MoveUpButton(Action a) {
            super(a);
        }

        @Override
        protected void handleValueChanged(ListSelectionEvent e) {
            JList theList = null;
            boolean isFirstItemSelected = false;
            boolean turnOn = true;
            theList = (JList)e.getSource();
            isFirstItemSelected = theList.isSelectedIndex(0);
            if (isFirstItemSelected) {
                this.setEnabled(false);
            } else {
                int theIndex = theList.getMinSelectionIndex() - 1;
                Object theElement = theList.getModel().getElementAt(theIndex);
                turnOn = ServerQueuePanel.this.serverQueue.getFutureCommands().contains(theElement);
                if (turnOn) {
                    super.handleValueChanged(e);
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }

    protected class MoveUpOrDownButtonBase
    extends TurnOnAndOffWithListSelectionButton {
        public MoveUpOrDownButtonBase(Action a) {
            super(a);
        }

        @Override
        protected void handleValueChanged(ListSelectionEvent e) {
            JList theList = null;
            int[] selectedIndexes = null;
            int numberOfIndices = -1;
            boolean infutureCommands = true;
            boolean turnOn = true;
            theList = (JList)e.getSource();
            selectedIndexes = theList.getSelectedIndices();
            numberOfIndices = selectedIndexes.length;
            if (numberOfIndices != 1) {
                int current = -1;
                int next = -1;
                int predictedNext = -1;
                int i = 1;
                Object elem = null;
                do {
                    current = selectedIndexes[i - 1];
                    predictedNext = current + 1;
                    next = selectedIndexes[i];
                    elem = theList.getModel().getElementAt(current);
                    infutureCommands = ServerQueuePanel.this.serverQueue.getFutureCommands().contains(elem);
                    if (predictedNext == next && infutureCommands) continue;
                    turnOn = false;
                    break;
                } while (++i < numberOfIndices);
            } else {
                Object theSelection = theList.getSelectedValue();
                turnOn = ServerQueuePanel.this.serverQueue.getFutureCommands().contains(theSelection);
            }
            this.setEnabled(turnOn);
        }
    }

    private class PasteAction
    extends AbstractAction {
        public PasteAction() {
            super("Paste");
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ServerQueuePanel.this.queueList.handlePaste(ae);
        }
    }

    private class QueueList
    extends CursorInsertJList
    implements DragSourceListener,
    DragGestureListener {
        private DragSource dragSource;
        private DragGestureRecognizer dragGestureRecognizer;
        private static final String QUEUE_SELECTION_TOKEN = "QUEUE_SELECTION";

        QueueList() {
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.init();
        }

        QueueList(ListModel dataModel) {
            super(dataModel);
            this.dragSource = null;
            this.dragGestureRecognizer = null;
            this.init();
        }

        protected void init() {
            this.dragSource = new DragSource();
            this.setSelectionMode(2);
            this.dragGestureRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        }

        protected String buildStringReprestationOfSelection() {
            String returnValue = "";
            Object[] selectedValues = null;
            selectedValues = this.getSelectedValues();
            if (selectedValues != null) {
                returnValue = String.valueOf(returnValue) + QUEUE_SELECTION_TOKEN;
                returnValue = String.valueOf(returnValue) + "[";
                int i = 0;
                while (i < selectedValues.length) {
                    returnValue = String.valueOf(returnValue) + ((QueueCommand)selectedValues[i]).toString();
                    if (i >= selectedValues.length - 1) break;
                    returnValue = String.valueOf(returnValue) + ",";
                    ++i;
                }
                returnValue = String.valueOf(returnValue) + "]";
            }
            return returnValue;
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            StringSelection transferable = null;
            String theMessage = "";
            theMessage = this.buildStringReprestationOfSelection();
            transferable = new StringSelection(theMessage);
            this.dragSource.startDrag(dge, DragSource.DefaultCopyDrop, transferable, this);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        protected boolean checkDrag(DropTargetDragEvent dtde, int dragIndex) {
            if (!dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            if (dragIndex >= this.getModel().getSize() || this.getModel().getSize() == 0) {
                return true;
            }
            QueueCommand insertionCommand = (QueueCommand)this.getModel().getElementAt(dragIndex);
            return insertionCommand.getState() != QueueCommand.State.past;
        }

        public boolean isStringQueueSelectionString(String theString) {
            boolean isQueueSelectionString = false;
            isQueueSelectionString = theString.startsWith(QUEUE_SELECTION_TOKEN);
            return isQueueSelectionString;
        }

        public ArrayList<ParsedQueueSelection> parseQueueSelectionString(String queueSelectionString) {
            ArrayList<ParsedQueueSelection> returnItems = new ArrayList<ParsedQueueSelection>();
            String tempString = null;
            if (queueSelectionString != null && queueSelectionString.startsWith(QUEUE_SELECTION_TOKEN) && (tempString = queueSelectionString.substring(QUEUE_SELECTION_TOKEN.length())).startsWith("[") && tempString.endsWith("]")) {
                String[] listOfQueueItems = null;
                String queueItem = null;
                String[] queueItemParts = null;
                ParsedQueueSelection parsedQueueSelection = null;
                tempString = tempString.substring(1, tempString.length() - 1);
                listOfQueueItems = tempString.split(",");
                int i = 0;
                while (i < listOfQueueItems.length) {
                    queueItem = listOfQueueItems[i];
                    if (queueItem != null && (queueItemParts = queueItem.split(":")).length == 2) {
                        parsedQueueSelection = new ParsedQueueSelection(queueItemParts[1], queueItemParts[0]);
                        returnItems.add(parsedQueueSelection);
                    }
                    ++i;
                }
            }
            return returnItems;
        }

        protected boolean handleSelfDragAndDrop(DropTargetDropEvent dtde, int dropIndex, String droppedText) {
            boolean returnValue = false;
            if (droppedText != null) {
                ArrayList<ParsedQueueSelection> parsedCommands = null;
                parsedCommands = this.parseQueueSelectionString(droppedText);
                if (parsedCommands.size() > 0) {
                    int numElements = this.getModel().getSize() - 1;
                    if (--dropIndex >= 0 && dropIndex <= numElements) {
                        QueueCommand queueCommand = null;
                        ListModel listModel = null;
                        listModel = this.getModel();
                        if (listModel != null && (queueCommand = (QueueCommand)listModel.getElementAt(dropIndex)) != null) {
                            boolean isCurrentCommand = false;
                            boolean isFutureCommand = false;
                            long commandLocatedAtDropIndex = -1L;
                            isFutureCommand = queueCommand.isFuture();
                            isCurrentCommand = queueCommand.isCurrent();
                            if (isFutureCommand) {
                                commandLocatedAtDropIndex = queueCommand.getID();
                                this.moveAfter(commandLocatedAtDropIndex, parsedCommands);
                                returnValue = true;
                            } else if (isCurrentCommand) {
                                try {
                                    queueCommand = (QueueCommand)listModel.getElementAt(dropIndex + 1);
                                    commandLocatedAtDropIndex = queueCommand.getID();
                                    this.moveBefore(commandLocatedAtDropIndex, parsedCommands);
                                    returnValue = true;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            return returnValue;
        }

        @Override
        protected boolean dropAction(DropTargetDropEvent dtde, int dropIndex) {
            Transferable tr = dtde.getTransferable();
            DataFlavor[] flavors = tr.getTransferDataFlavors();
            String commandPrefixAndSuffix = "";
            if (!dtde.isLocalTransfer()) {
                return false;
            }
            logger.debug("drop.  Source: " + dtde.getDropTargetContext().getComponent());
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].isMimeTypeEqual(DataFlavor.stringFlavor)) {
                    try {
                        String droppedItem;
                        String command = droppedItem = (String)tr.getTransferData(flavors[i]);
                        if (command.contains(" ")) {
                            commandPrefixAndSuffix = "\"";
                        }
                        if (command.startsWith(QUEUE_SELECTION_TOKEN)) {
                            boolean returnValue = false;
                            returnValue = this.handleSelfDragAndDrop(dtde, dropIndex, command);
                            return returnValue;
                        }
                        int numElements = this.getModel().getSize();
                        if (dropIndex >= numElements - 1) {
                            command = command.toLowerCase().endsWith(IceFileType.sequence.getExtension()) ? "stack appendfile " + commandPrefixAndSuffix + command + commandPrefixAndSuffix : "scan runscan " + commandPrefixAndSuffix + command + commandPrefixAndSuffix;
                        } else {
                            QueueCommand nextCmd = (QueueCommand)this.getModel().getElementAt(dropIndex);
                            command = command.toLowerCase().endsWith(IceFileType.sequence.getExtension()) ? "stack insert " + nextCmd.getID() + " stack runfile " + commandPrefixAndSuffix + command + commandPrefixAndSuffix : "stack insert " + nextCmd.getID() + " scan runscan " + commandPrefixAndSuffix + command + commandPrefixAndSuffix;
                        }
                        ServerQueuePanel.this.sendManager.addMessage(command);
                    }
                    catch (UnsupportedFlavorException ufe) {
                        logger.debug("exception: " + ufe);
                        return false;
                    }
                    catch (IOException ioe) {
                        logger.debug("exception: " + ioe);
                        return false;
                    }
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected void handleCopy(ActionEvent ae) {
            String clipBoardText = null;
            Clipboard system = null;
            StringSelection stringSelection = null;
            clipBoardText = this.buildStringReprestationOfSelection();
            stringSelection = new StringSelection(clipBoardText);
            system = Toolkit.getDefaultToolkit().getSystemClipboard();
            system.setContents(stringSelection, stringSelection);
        }

        protected void handleCut(ActionEvent ae) {
            this.handleCopy(ae);
            Object[] selectedValues = null;
            selectedValues = this.getSelectedValues();
            if (selectedValues != null) {
                QueueCommand queueCommand = null;
                String serverCommand = null;
                int i = 0;
                while (i < selectedValues.length) {
                    queueCommand = (QueueCommand)selectedValues[i];
                    serverCommand = "Stack DeleteID ";
                    serverCommand = String.valueOf(serverCommand) + Long.toString(queueCommand.getID());
                    ServerQueuePanel.this.sendManager.addMessage(serverCommand);
                    ++i;
                }
            }
        }

        protected void insertBefore(long commandId, ArrayList<ParsedQueueSelection> parsedCommands) {
            String serverCommand = null;
            ParsedQueueSelection parsedQueueSelection = null;
            int i = 0;
            while (i < parsedCommands.size()) {
                parsedQueueSelection = parsedCommands.get(i);
                serverCommand = "Stack insert  ";
                serverCommand = String.valueOf(serverCommand) + Long.toString(commandId) + " ";
                serverCommand = String.valueOf(serverCommand) + parsedQueueSelection.getCommand();
                ServerQueuePanel.this.sendManager.addMessage(serverCommand);
                ++i;
            }
        }

        protected void insertAfter(long commandId, ArrayList<ParsedQueueSelection> parsedCommands) {
            String serverCommand = null;
            ParsedQueueSelection parsedQueueSelection = null;
            int i = parsedCommands.size() - 1;
            while (i >= 0) {
                parsedQueueSelection = parsedCommands.get(i);
                serverCommand = "Stack insert -a ";
                serverCommand = String.valueOf(serverCommand) + Long.toString(commandId) + " ";
                serverCommand = String.valueOf(serverCommand) + parsedQueueSelection.getCommand();
                ServerQueuePanel.this.sendManager.addMessage(serverCommand);
                --i;
            }
        }

        protected void moveAfter(long commandId, ArrayList<ParsedQueueSelection> parsedCommands) {
            String serverCommand = null;
            serverCommand = "Stack Move -a ";
            int i = parsedCommands.size() - 1;
            while (true) {
                serverCommand = String.valueOf(serverCommand) + parsedCommands.get(i).getCommandId();
                if (--i < 0) break;
                serverCommand = String.valueOf(serverCommand) + ",";
            }
            serverCommand = String.valueOf(serverCommand) + " " + commandId;
            ServerQueuePanel.this.sendManager.addMessage(serverCommand);
        }

        protected void moveBefore(long commandId, ArrayList<ParsedQueueSelection> parsedCommands) {
            int numberOfCommands = -1;
            String serverCommand = null;
            numberOfCommands = parsedCommands.size() - 1;
            serverCommand = "Stack Move  ";
            int i = 0;
            while (true) {
                serverCommand = String.valueOf(serverCommand) + parsedCommands.get(i).getCommandId();
                if (i >= numberOfCommands) break;
                serverCommand = String.valueOf(serverCommand) + ",";
                ++i;
            }
            serverCommand = String.valueOf(serverCommand) + " " + commandId;
            ServerQueuePanel.this.sendManager.addMessage(serverCommand);
        }

        protected void insertIntoEmptyQueue(ArrayList<ParsedQueueSelection> parsedCommands) {
            String serverCommand = null;
            ParsedQueueSelection parsedQueueSelection = null;
            int i = parsedCommands.size() - 1;
            while (i >= 0) {
                parsedQueueSelection = parsedCommands.get(i);
                serverCommand = "Stack insertindex 0 ";
                serverCommand = String.valueOf(serverCommand) + parsedQueueSelection.getCommand();
                ServerQueuePanel.this.sendManager.addMessage(serverCommand);
                --i;
            }
        }

        protected void handlePaste(ActionEvent ae) {
            String clipBoardText = null;
            Clipboard system = null;
            Transferable transferable = null;
            system = Toolkit.getDefaultToolkit().getSystemClipboard();
            transferable = system.getContents(this);
            if (transferable != null) {
                try {
                    ArrayList<ParsedQueueSelection> parsedCommands = null;
                    int minSelectionIndex = -1;
                    QueueCommand minSelectionQueueCommand = null;
                    long minSelectionCommandNumber = -1L;
                    boolean isSelectionEmpty = false;
                    isSelectionEmpty = this.isSelectionEmpty();
                    if (!isSelectionEmpty) {
                        boolean isSelectionFutureCommand = false;
                        boolean isSelectionCurrentCommand = false;
                        minSelectionIndex = this.getMinSelectionIndex();
                        minSelectionQueueCommand = (QueueCommand)this.getModel().getElementAt(minSelectionIndex);
                        isSelectionFutureCommand = minSelectionQueueCommand.isFuture();
                        isSelectionCurrentCommand = minSelectionQueueCommand.isCurrent();
                        clipBoardText = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        parsedCommands = this.parseQueueSelectionString(clipBoardText);
                        if (parsedCommands.size() > 0) {
                            if (isSelectionFutureCommand) {
                                minSelectionCommandNumber = minSelectionQueueCommand.getID();
                                this.insertAfter(minSelectionCommandNumber, parsedCommands);
                            } else if (isSelectionCurrentCommand) {
                                try {
                                    minSelectionQueueCommand = (QueueCommand)this.getModel().getElementAt(minSelectionIndex + 1);
                                    minSelectionCommandNumber = minSelectionQueueCommand.getID();
                                    this.insertBefore(minSelectionCommandNumber, parsedCommands);
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    this.insertIntoEmptyQueue(parsedCommands);
                                }
                                catch (Exception exception) {}
                            } else {
                                this.insertIntoEmptyQueue(parsedCommands);
                            }
                        }
                    } else {
                        clipBoardText = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        parsedCommands = this.parseQueueSelectionString(clipBoardText);
                        this.insertIntoEmptyQueue(parsedCommands);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected class ParsedQueueSelection {
            private String command = "";
            private String commandId = "";

            public ParsedQueueSelection(String command, String commandId) {
                this.setCommand(command);
                this.setCommandId(commandId);
            }

            public String getCommand() {
                return this.command;
            }

            public void setCommand(String command) {
                this.command = command;
            }

            public String getCommandId() {
                return this.commandId;
            }

            public void setCommandId(String commandId) {
                this.commandId = commandId;
            }
        }
    }

    private class QueueListPopupListener
    extends MouseAdapter {
        private QueueListPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            super.mousePressed(me);
            this.maybeShowPopup(me);
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            super.mouseReleased(me);
            this.maybeShowPopup(me);
        }

        private void maybeShowPopup(MouseEvent me) {
            int index = ServerQueuePanel.this.queueList.locationToIndex(me.getPoint());
            Rectangle bounds = ServerQueuePanel.this.queueList.getCellBounds(ServerQueuePanel.this.queueList.getFirstVisibleIndex(), ServerQueuePanel.this.queueList.getLastVisibleIndex());
            logger.debug("bounds: " + bounds);
            logger.debug("index: " + index);
            if (bounds != null && bounds.contains(me.getPoint())) {
                logger.debug("contains point");
                ServerQueuePanel.this.removeAction.setEnabled(true);
                ServerQueuePanel.this.queueList.addSelectionInterval(index, index);
            } else {
                ServerQueuePanel.this.removeAction.setEnabled(false);
                ServerQueuePanel.this.queueList.clearSelection();
            }
            if (me.isPopupTrigger()) {
                ServerQueuePanel.this.queuePanelMenu.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }

    private class RemoveAction
    extends ConfirmableAction {
        public RemoveAction() {
            this.putValue("Name", "Remove");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object[] selectedValues = ServerQueuePanel.this.queueList.getSelectedValues();
            int numberOfSelectedValues = -1;
            if (selectedValues == null || selectedValues.length <= 0) {
                return;
            }
            numberOfSelectedValues = selectedValues.length - 1;
            String title = "Confirm Remove";
            String message = "Are you sure you want to remove ";
            int i = 0;
            while (true) {
                QueueCommand theCommand = (QueueCommand)selectedValues[i];
                message = String.valueOf(message) + theCommand.getCommandString();
                if (i >= numberOfSelectedValues) break;
                message = String.valueOf(message) + ", ";
                ++i;
            }
            message = String.valueOf(message) + " ?";
            ArrayList<JButton> btns = this.createOkCancelBtns();
            ServerQueuePanel.this.throwConfirmDialog(title, message, btns);
        }

        @Override
        public void confirmed() {
            Object[] selectedList = ServerQueuePanel.this.queueList.getSelectedValues();
            if (selectedList != null && selectedList.length > 0) {
                int i = 0;
                while (i < selectedList.length) {
                    QueueCommand fromCommand = null;
                    boolean isFutureCommand = false;
                    boolean isCurrentCommand = false;
                    boolean isPastCommand = false;
                    List<QueueCommand> commandsList = null;
                    fromCommand = (QueueCommand)selectedList[i];
                    isFutureCommand = fromCommand.isFuture();
                    if (isFutureCommand) {
                        long fromId = -1L;
                        long toId = -1L;
                        QueueCommand lookAheadCommand = null;
                        toId = fromId = fromCommand.getID();
                        int j = i + 1;
                        while (j < selectedList.length) {
                            lookAheadCommand = (QueueCommand)selectedList[j];
                            isFutureCommand = lookAheadCommand.isFuture();
                            if (isFutureCommand) {
                                long expectedId = -1L;
                                long lookAheadCommandsId = -1L;
                                lookAheadCommandsId = lookAheadCommand.getID();
                                if (lookAheadCommandsId == (expectedId = toId + 1L)) {
                                    ServerQueuePanel.this.serverQueue.removeCommand(lookAheadCommand);
                                    toId = lookAheadCommandsId;
                                    i = j++;
                                    continue;
                                }
                                i = j - 1;
                                break;
                            }
                            i = j - 1;
                            break;
                        }
                        ServerQueuePanel.this.sendManager.addMessage("Stack DeleteRange " + fromId + " " + toId);
                    } else {
                        isCurrentCommand = fromCommand.isCurrent();
                        if (isCurrentCommand) {
                            ServerQueuePanel.this.sendManager.addMessage("kill");
                            ServerQueuePanel.this.serverQueue.removeCommand(fromCommand);
                        } else {
                            commandsList = ServerQueuePanel.this.serverQueue.getPastCommands();
                            isPastCommand = fromCommand.isPast();
                            if (isPastCommand) {
                                ServerQueuePanel.this.serverQueue.removeCommand(fromCommand);
                            }
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        public void declined() {
        }
    }

    protected class RemoveButton
    extends TurnOnAndOffWithListSelectionButton {
        public RemoveButton(Action a) {
            super(a);
        }

        @Override
        protected void handleValueChanged(ListSelectionEvent e) {
        }
    }

    private class SaveToSequenceAction
    extends AbstractAction {
        public SaveToSequenceAction() {
            this.putValue("Name", "Save to Sequence...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            SaveDialog sd = new SaveDialog();
            sd.setLocationRelativeTo(ServerQueuePanel.this);
            sd.setVisible(true);
        }

        private class SaveDialog
        extends JDialog
        implements ActionListener {
            private JTextField filenameField = new JTextField(10);
            private JComboBox locationCB;
            private JButton saveBtn;
            private JButton cancelBtn;
            protected Pattern nameCheckPattern = null;

            public SaveDialog() {
                String[] magicWords = new String[]{"Current Experiment", "Common"};
                this.locationCB = new JComboBox<String>(magicWords);
                this.saveBtn = new JButton("Save");
                this.cancelBtn = new JButton("Cancel");
                this.saveBtn.addActionListener(this);
                this.cancelBtn.addActionListener(this);
                this.nameCheckPattern = Pattern.compile("[A-Za-z][A-Za-z0-9_\\.]*");
                this.buildGUI();
            }

            public void buildGUI() {
                this.setModal(true);
                this.setResizable(false);
                this.setTitle("Save Queue");
                this.setDefaultCloseOperation(2);
                JPanel contentPane = (JPanel)this.getContentPane();
                contentPane.setLayout(new GridBagLayout());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.fill = 2;
                constraints.insets = new Insets(5, 5, 5, 5);
                constraints.weightx = 0.0;
                constraints.gridx = 0;
                constraints.gridy = 0;
                contentPane.add((Component)new JLabel("File name:"), constraints);
                ++constraints.gridx;
                constraints.weightx = 1.0;
                contentPane.add((Component)this.filenameField, constraints);
                constraints.weightx = 0.0;
                ++constraints.gridx;
                contentPane.add((Component)new JLabel(""), constraints);
                constraints.gridx = 0;
                ++constraints.gridy;
                contentPane.add((Component)new JLabel("Location:"), constraints);
                ++constraints.gridx;
                constraints.weightx = 1.0;
                contentPane.add((Component)this.locationCB, constraints);
                constraints.weightx = 0.0;
                ++constraints.gridx;
                contentPane.add((Component)new JLabel(""), constraints);
                constraints.gridx = 0;
                ++constraints.gridy;
                contentPane.add((Component)new JLabel(""), constraints);
                ++constraints.gridx;
                JPanel btnPanel = new JPanel();
                btnPanel.add(this.saveBtn);
                btnPanel.add(this.cancelBtn);
                constraints.gridwidth = 2;
                contentPane.add((Component)btnPanel, constraints);
                this.pack();
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == this.cancelBtn) {
                    this.dispose();
                } else if (ae.getSource() == this.saveBtn) {
                    String filename = this.filenameField.getText();
                    boolean matches = this.nameCheckPattern.matcher(filename).matches();
                    if (filename.length() != 0 && matches) {
                        if (!filename.endsWith(".seq.txt")) {
                            filename = filename.concat(".seq.txt");
                        }
                        int size = ServerQueuePanel.this.queueModel.size();
                        String contents = "";
                        int i = 0;
                        while (i < size) {
                            contents = contents.concat(String.valueOf(((QueueCommand)ServerQueuePanel.this.queueModel.get(i)).getCommandString()) + "\n");
                            ++i;
                        }
                        contents = contents.replaceAll("\"", "\\\\\"");
                        String magicWord = "";
                        if (((String)this.locationCB.getSelectedItem()).equals("Personal")) {
                            magicWord = "USER:";
                        } else if (((String)this.locationCB.getSelectedItem()).equals("Current Experiment")) {
                            magicWord = "EXPT:";
                        } else if (((String)this.locationCB.getSelectedItem()).equals("Common")) {
                            magicWord = "COMM:";
                        }
                        String command = "transfer \"" + magicWord + filename + "\" \"" + contents + "\"";
                        ServerQueuePanel.this.sendManager.addMessage(command);
                        this.dispose();
                    } else {
                        JOptionPane.showMessageDialog(this, "Resource names must begin with a letter and may only contain alphanumeric, '_', or '.' characters and can not be zero length!");
                    }
                }
            }
        }
    }

    protected abstract class TurnOnAndOffWithListSelectionButton
    extends JButton
    implements ListSelectionListener {
        private static final long serialVersionUID = 1L;

        public TurnOnAndOffWithListSelectionButton() {
            this.initButton();
        }

        public TurnOnAndOffWithListSelectionButton(Action a) {
            super(a);
            this.initButton();
        }

        public TurnOnAndOffWithListSelectionButton(Icon icon) {
            super(icon);
            this.initButton();
        }

        public TurnOnAndOffWithListSelectionButton(String text, Icon icon) {
            super(text, icon);
            this.initButton();
        }

        public TurnOnAndOffWithListSelectionButton(String text) {
            super(text);
            this.initButton();
        }

        private void initButton() {
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JList theList = null;
            boolean isSomethingSelected = false;
            theList = (JList)e.getSource();
            isSomethingSelected = theList.isSelectionEmpty();
            if (isSomethingSelected) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.handleValueChanged(e);
            }
        }

        protected abstract void handleValueChanged(ListSelectionEvent var1);
    }

    private class UpdateStatusBar
    implements Runnable {
        private UpdateStatusBar() {
        }

        @Override
        public void run() {
            Double estimatedTime = ServerQueuePanel.this.serverQueue.getEstimatedCompletionTime();
            if (estimatedTime.isInfinite()) {
                ServerQueuePanel.this.estimatedTimeLabel.setText("Estimated time to completion: " + estimatedTime.toString());
                return;
            }
            String time = ConversionUtilities.convertSecondsToDays(estimatedTime);
            ServerQueuePanel.this.estimatedTimeLabel.setText("Estimated time to completion: " + time);
        }
    }
}

