/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.Global;
import ice.communication.CommunicationManager;
import ice.data.BaseScan;
import ice.data.IceFileType;
import ice.data.Resource;
import ice.data.tas.bt7.Instrument;
import ice.event.communication.BraggCalcEvent;
import ice.event.communication.BraggCalcListener;
import ice.exceptions.IcePanelException;
import ice.gui.tas.bt7.scan.BaseScanPanel;
import ice.swing.Bag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MotorScanPanel
extends BaseScanPanel
implements BraggCalcListener {
    private ArrayList<JCheckBox> checkboxes;
    protected JPanel braggPanel;
    private boolean waitingForServer;
    ArrayList<String> motorNames;

    public MotorScanPanel(Resource resource) throws IcePanelException {
        super((BaseScan)resource);
        logger.debug("Editing motor scan");
    }

    @Override
    protected void init() {
        Controller controller = Controller.getReference();
        CommunicationManager comunicationManager = controller.getCommMgr();
        this.checkboxes = new ArrayList();
        this.eTransferField = new JTextField(6);
        this.eTransferField.getDocument().addDocumentListener(this);
        this.eFixedField = new JTextField(6);
        this.eFixedField.getDocument().addDocumentListener(this);
        String[] fixedE = new String[]{"Fixed Ef", "Fixed Ei"};
        this.eFixedCB = new JComboBox<String>(fixedE);
        this.eFixedCB.addItemListener(this);
        this.hField = new JTextField(6);
        this.hField.getDocument().addDocumentListener(this);
        this.kField = new JTextField(6);
        this.kField.getDocument().addDocumentListener(this);
        this.lField = new JTextField(6);
        this.lField.getDocument().addDocumentListener(this);
        this.waitingForServer = false;
        this.motorNames = new ArrayList();
        this.motorNames.add("A1");
        this.motorNames.add("A2");
        this.motorNames.add("A3");
        this.motorNames.add("A4");
        this.motorNames.add("A5");
        Instrument instrument = controller.getInstrument();
        String instrumentName = instrument.getName();
        if (instrumentName.equalsIgnoreCase("bt7")) {
            this.motorNames.add("A6");
        }
        comunicationManager.addBraggCalcListener(this);
        this.createDeviceFields();
        this.createPanels();
    }

    @Override
    public void loadResource() {
        if (this.resource != null && this.resource instanceof BaseScan) {
            this.loadPanels((BaseScan)this.resource);
        }
    }

    @Override
    protected void createPanels() {
        super.createPanels();
        this.braggPanel = this.createBraggBuffer();
    }

    @Override
    public void buildGUI() {
        this.setLayout(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        this.add((Component)this.instrumentPanel, constraints.cell(x, y));
        this.add((Component)this.envPanel, constraints.cell(x, ++y));
        this.add((Component)this.braggPanel, constraints.cell(x, ++y));
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.add((Component)this.descrPanel, constraints.cellWithoutReset(x, ++y));
        this.add((Component)this.btnPanel, constraints.cell(x, ++y));
    }

    public static IceFileType[] getSupportedFileTypes() {
        IceFileType[] fileTypes = new IceFileType[]{IceFileType.motorScan};
        return fileTypes;
    }

    protected void createDeviceFields() {
        int size = this.motorNames.size();
        int i = 0;
        while (i < size) {
            JCheckBox checkbox = new JCheckBox(new ToggleFields(this.motorNames.get(i)));
            checkbox.setVerticalAlignment(1);
            this.checkboxes.add(checkbox);
            checkbox.addItemListener(this);
            this.addSingleDeviceEnabled(this.motorNames.get(i), Global.degreeSign(), false);
            ++i;
        }
    }

    @Override
    protected JPanel createInstrumentPanel() {
        int size = this.motorNames.size();
        JLabel leftSpacer = new JLabel("");
        JLabel rightSpacer = new JLabel("");
        int x = 0;
        int y = 0;
        JPanel instrumentPanel = new JPanel(new GridBagLayout());
        instrumentPanel.setBorder(BorderFactory.createTitledBorder("Instrument"));
        Bag instrumentConstraints = new Bag();
        int maxCols = 8;
        instrumentPanel.add((Component)leftSpacer, instrumentConstraints.cell(x, y).fillx(1.0));
        instrumentPanel.add((Component)this.modePanel, instrumentConstraints.cell(++x, y).colspan(maxCols));
        instrumentPanel.add((Component)rightSpacer, instrumentConstraints.cell(x += maxCols, y).fillx(1.0));
        x = 1;
        ++y;
        JLabel spacer = new JLabel("");
        Dimension d = spacer.getPreferredSize();
        double height = d.getHeight();
        d.setSize(135.0, height);
        spacer.setPreferredSize(d);
        instrumentPanel.add((Component)spacer, instrumentConstraints.cell(x, y));
        instrumentPanel.add((Component)this.column1Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column2Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column3Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column4Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)new JLabel("Units  ", 2), instrumentConstraints.cell(++x, y));
        JLabel spacer2 = new JLabel("");
        d = spacer2.getPreferredSize();
        height = d.getHeight();
        d.setSize(40.0, height);
        spacer2.setPreferredSize(d);
        instrumentPanel.add((Component)spacer2, instrumentConstraints.cell(++x, y));
        x = 1;
        ++y;
        Insets defaultInsets = new Insets(instrumentConstraints.insets.top, instrumentConstraints.insets.left, instrumentConstraints.insets.bottom, instrumentConstraints.insets.right);
        Insets unitInsets = new Insets(defaultInsets.top, 0, defaultInsets.bottom, defaultInsets.right);
        int i = 1;
        while (i <= size) {
            instrumentPanel.add((Component)this.checkboxes.get(i - 1), instrumentConstraints.cell(x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(i - 1)).getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            ++x;
            ++y;
            x = 1;
            ++i;
        }
        logger.debug("Adding additional device list");
        size = this.scanEntries_add.size();
        instrumentPanel.add((Component)new JSeparator(), instrumentConstraints.cell(x, y).colspan(maxCols));
        instrumentPanel.add((Component)this.createLabel("Additional Devices", 2), instrumentConstraints.cell(x, ++y).colspan(maxCols));
        ++y;
        for (BaseScanPanel.ScanEntry entry : this.scanEntries_add) {
            instrumentPanel.add((Component)entry.getComboBox(), instrumentConstraints.cell(x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getDeleteButton(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            ++x;
            ++y;
            x = 1;
        }
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 2));
        subPanel.add(new JButton(new AddDeviceAction()));
        instrumentConstraints.inset(defaultInsets);
        instrumentPanel.add((Component)subPanel, instrumentConstraints.cell(x, y).colspan(maxCols));
        x = 0;
        instrumentPanel.add((Component)this.parameterPanel, instrumentConstraints.cell(x, ++y).colspan(maxCols + 2));
        return instrumentPanel;
    }

    @Override
    protected void loadInstrumentPanel(BaseScan input) {
        HashMap<String, BaseScan.Range> devHash = input.getDeviceRanges();
        Set<String> ranges = devHash.keySet();
        Iterator<String> riter = ranges.iterator();
        while (riter.hasNext()) {
            boolean skipit = false;
            String dev = riter.next();
            int i = 0;
            while (i < this.checkboxes.size()) {
                if (dev.compareToIgnoreCase(this.checkboxes.get(i).getText()) == 0) {
                    this.checkboxes.get(i).setSelected(true);
                    ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                    ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                    ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().setEnabled(true);
                    ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().setEnabled(true);
                    skipit = true;
                }
                ++i;
            }
            if (dev.compareToIgnoreCase("H") == 0) {
                this.hField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            } else if (dev.compareToIgnoreCase("K") == 0) {
                this.kField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            } else if (dev.compareToIgnoreCase("L") == 0) {
                this.lField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            } else if (dev.compareToIgnoreCase("E") == 0) {
                this.eTransferField.setText(new Double(devHash.get(dev).getFirstValue()).toString());
            }
            this.createAdditionalDevice();
            boolean found = false;
            int size = this.scanEntries_add.size();
            int j = 0;
            while (j < ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().getItemCount()) {
                if (dev.compareToIgnoreCase(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().getItemAt(j).toString()) == 0) {
                    ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().setSelectedIndex(j);
                    found = true;
                }
                ++j;
            }
            if (!found) {
                BaseScanPanel.RemoveAdditionalItem action = new BaseScanPanel.RemoveAdditionalItem(this, size - 1);
                action.run();
                continue;
            }
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
        }
        BaseScan.FixedEnergy efixed = input.getFixedEnergyDevice();
        if (efixed == BaseScan.FixedEnergy.analyzer) {
            this.eFixedCB.setSelectedItem("Fixed Ef");
        } else if (efixed == BaseScan.FixedEnergy.monochromator) {
            this.eFixedCB.setSelectedItem("Fixed Ei");
        }
        Double fixede = input.getFixedEnergy();
        if (fixede != null) {
            this.eFixedField.setText(fixede.toString());
        }
    }

    private JPanel createBraggBuffer() {
        JLabel energyLabel = new JLabel("Et=(Ei-Ef)");
        JLabel units1 = new JLabel("meV");
        JLabel units2 = new JLabel("meV");
        JLabel units3 = new JLabel("meV");
        units3.setForeground(this.getBackground());
        JLabel hklLabel = new JLabel("h, k, l");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Bragg Buffer"));
        Bag panelConstraints = new Bag();
        JPanel topPanel = new JPanel(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        Insets originalInsets = constraints.insets;
        Insets smallerInsets = new Insets(originalInsets.top, 0, originalInsets.bottom, originalInsets.right);
        Insets largerInsets = new Insets(originalInsets.top, 15, originalInsets.bottom, originalInsets.right);
        topPanel.add((Component)energyLabel, constraints.cell(x, y));
        ++x;
        topPanel.add((Component)this.eTransferField, constraints.cell(++x, y));
        constraints.insets = smallerInsets;
        topPanel.add((Component)units1, constraints.cell(++x, y));
        constraints.insets = largerInsets;
        topPanel.add((Component)this.eFixedCB, constraints.cell(++x, y));
        constraints.insets = originalInsets;
        topPanel.add((Component)this.eFixedField, constraints.cell(++x, y));
        constraints.insets = smallerInsets;
        topPanel.add((Component)units2, constraints.cell(++x, y));
        constraints.insets = originalInsets;
        topPanel.add((Component)new JLabel(""), constraints.cell(++x, y).fillx(1.0));
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        Bag bottom_constraints = new Bag();
        x = 0;
        y = 0;
        bottomPanel.add((Component)hklLabel, bottom_constraints.cell(x, y));
        bottomPanel.add((Component)this.hField, bottom_constraints.cell(++x, y));
        bottomPanel.add((Component)this.kField, bottom_constraints.cell(++x, y));
        bottomPanel.add((Component)this.lField, bottom_constraints.cell(++x, y));
        JButton populateBtn = new JButton(new PopulateAction());
        bottomPanel.add((Component)populateBtn, bottom_constraints.cell(++x, y));
        bottomPanel.add((Component)new JLabel(""), bottom_constraints.cell(++x, y).fillx(1.0));
        JLabel instructionsLabel = new JLabel("<html>To center scan on a point in reciprocal space, enter values below<br>and press Populate Fields button to calculate appropriate angles.<br>If any field is left blank these values will be ignored.</html>");
        panel.add((Component)instructionsLabel, panelConstraints.cell(0, 0));
        panel.add((Component)topPanel, panelConstraints.cell(0, 1));
        panel.add((Component)bottomPanel, panelConstraints.cell(0, 2));
        panel.add((Component)new JLabel(""), panelConstraints.cell(0, 3).fillx(1.0));
        return panel;
    }

    @Override
    protected void clearFields() {
        this.clearScanDescriptionPanel();
        this.clearParameterPanel();
        this.clearEnvironmentPanel();
        this.eTransferField.setText("");
        this.eFixedField.setText("");
        this.hField.setText("");
        this.kField.setText("");
        this.lField.setText("");
        int i = 0;
        while (i < this.checkboxes.size()) {
            this.checkboxes.get(i).setSelected(false);
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getInfoLabel1().setText("N/A");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getInfoLabel2().setText("N/A");
            ++i;
        }
        i = 0;
        while (i < this.scanEntries_add.size()) {
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getFirstField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getSecondField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getInfoLabel1().setText("N/A");
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getInfoLabel2().setText("N/A");
            ++i;
        }
    }

    @Override
    protected String getDescr() {
        String envProperties = this.getEnvironmentDescr();
        String scanName = this.scanNameField.getText().trim();
        if (scanName.length() == 0) {
            logger.debug("No scan name entered.  Save cancelled.");
            this.throwErrorDialog("Incomplete Description", "Please specify a scan name.");
            return "";
        }
        String comments = this.commentsTextArea.getText();
        String prefix = this.prefixField.getText();
        String params = this.getParamDescr();
        if (params == null) {
            return "";
        }
        ArrayList<String> nameList = new ArrayList<String>();
        ArrayList<Double> firstList = new ArrayList<Double>();
        ArrayList<Double> secondList = new ArrayList<Double>();
        try {
            int i = 0;
            while (i < this.checkboxes.size()) {
                if (this.checkboxes.get(i).isSelected()) {
                    nameList.add(this.checkboxes.get(i).getText());
                    firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().getText().trim()));
                    secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().getText().trim()));
                }
                ++i;
            }
            i = 0;
            while (i < this.scanEntries_add.size()) {
                nameList.add(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getComboBox().getSelectedItem().toString());
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getSecondField().getText().trim()));
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            logger.debug("Invalid number in device ranges.  Save cancelled: ");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify valid numbers for device ranges.");
            return "";
        }
        BaseScanPanel.QandEPoint bragg = this.getBraggInfo();
        String scanDescr = "Scan:SubID=" + this.exptID + ":JType=MOTOR";
        if (bragg != null && bragg.isValid()) {
            scanDescr = scanDescr.concat(":Fixed=" + bragg.getFixedFlag());
            scanDescr = scanDescr.concat(":FixedE=" + bragg.getFixedE());
        }
        scanDescr = scanDescr.concat(params);
        if (prefix.length() > 0) {
            scanDescr = scanDescr.concat(":Filename=" + prefix);
        }
        String tag = "";
        if (this.mode == 0) {
            tag = " s";
        } else if (this.mode == 1) {
            tag = " i";
        }
        if (bragg != null && bragg.isValid()) {
            if (this.mode == 0) {
                scanDescr = scanDescr.concat(":Range=E=" + bragg.getE() + " " + bragg.getE() + tag);
                String qstring = ":Range=Q=" + bragg.getH() + "~" + bragg.getK() + "~" + bragg.getL() + " " + bragg.getH() + "~" + bragg.getK() + "~" + bragg.getL();
                scanDescr = scanDescr.concat(String.valueOf(qstring) + tag);
            } else {
                scanDescr = scanDescr.concat(":Range=Q=" + bragg.getH() + "~" + bragg.getK() + "~" + bragg.getL() + " 0~0~0" + tag);
                scanDescr = scanDescr.concat(":Range=E=" + bragg.getE() + " 0" + tag);
            }
        }
        if (envProperties.equals("")) {
            return "";
        }
        if (!envProperties.equals("noSetPoint")) {
            scanDescr = scanDescr.concat(envProperties);
        }
        int i = 0;
        while (i < nameList.size()) {
            scanDescr = scanDescr.concat(":Range=" + (String)nameList.get(i) + "=" + firstList.get(i) + " " + secondList.get(i) + tag);
            logger.debug(firstList.get(i) + " " + secondList.get(i) + tag);
            ++i;
        }
        if (comments.length() != 0) {
            scanDescr = scanDescr.concat(":Comment=" + this.getComments(comments));
        }
        return scanDescr;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void updateAdditionalDevices() {
        this.instrumentPanel = this.createInstrumentPanel();
        this.removeAll();
        this.buildGUI();
        this.invalidate();
    }

    @Override
    public void actionPerformed(BraggCalcEvent be) {
        logger.debug("Bragg event");
        if (this.waitingForServer) {
            if (!be.isValid()) {
                this.appendErrorMessage(this.eTransferField, "Bragg Calculations Error: Check input parameters. Check sample alignment parameters.");
            } else {
                this.removeErrorMessage(this.eTransferField);
                try {
                    ArrayList<Double> motorValues = be.getAMotorValues();
                    int x = 0;
                    while (x < motorValues.size()) {
                        JTextField entry = ((BaseScanPanel.ScanEntry)this.scanEntries.get(x)).getFirstField();
                        Double value = motorValues.get(x);
                        entry.setText(value.toString());
                        ++x;
                    }
                    this.invalidate();
                }
                catch (Exception nfe) {
                    logger.debug("Bragg Calculations: Invalid response from the server");
                    logger.debug(nfe);
                    this.throwErrorDialog("Calculation Error", "Bragg Calculations: Invalid response from the server");
                }
            }
            this.waitingForServer = false;
        }
    }

    public class AddDeviceAction
    extends AbstractAction {
        public AddDeviceAction() {
            this.putValue("Name", "Include Another Device in Scan");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("Trying to add a new device");
            MotorScanPanel.this.createAdditionalDevice();
            MotorScanPanel.this.instrumentPanel = MotorScanPanel.this.createInstrumentPanel();
            MotorScanPanel.this.removeAll();
            MotorScanPanel.this.buildGUI();
            MotorScanPanel.this.invalidate();
        }
    }

    protected class PopulateAction
    extends AbstractAction {
        public PopulateAction() {
            this.putValue("Name", "Populate Fields");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            BaseScanPanel.QandEPoint braggInfo = MotorScanPanel.this.getBraggInfo();
            if (braggInfo != null) {
                if (braggInfo.isValid()) {
                    String mess = "Ask QECALC Instrument Action Angles " + braggInfo.getE();
                    mess = String.valueOf(mess) + " " + braggInfo.getEfixedString() + " " + braggInfo.getFixedE();
                    mess = String.valueOf(mess) + " " + braggInfo.getH() + " " + braggInfo.getK() + " " + braggInfo.getL();
                    MotorScanPanel.this.sendManager.addMessage(mess);
                    logger.debug(mess);
                    MotorScanPanel.this.waitingForServer = true;
                } else {
                    logger.debug("Incomplete Bragg information");
                }
            }
        }
    }

    private class ToggleFields
    extends AbstractAction {
        public ToggleFields(String name) {
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object obj = ae.getSource();
            if (!(obj instanceof JCheckBox)) {
                return;
            }
            JCheckBox checkbox = (JCheckBox)obj;
            int pos = -1;
            int i = 0;
            while (i < MotorScanPanel.this.checkboxes.size()) {
                if (checkbox == MotorScanPanel.this.checkboxes.get(i)) {
                    pos = i;
                    break;
                }
                ++i;
            }
            if (pos == -1) {
                return;
            }
            Thread thread1 = new Thread(new BaseScanPanel.SetEnabled(MotorScanPanel.this, ((BaseScanPanel.ScanEntry)MotorScanPanel.this.scanEntries.get(pos)).getFirstField(), checkbox.isSelected()));
            Thread thread2 = new Thread(new BaseScanPanel.SetEnabled(MotorScanPanel.this, ((BaseScanPanel.ScanEntry)MotorScanPanel.this.scanEntries.get(pos)).getSecondField(), checkbox.isSelected()));
            SwingUtilities.invokeLater(thread1);
            SwingUtilities.invokeLater(thread2);
        }
    }
}

