/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Controller;
import ice.FileClassLoader;
import ice.IconManager;
import ice.communication.SendQueueManager;
import ice.data.InstalledDevice;
import ice.data.InstalledEnvDevice;
import ice.data.InstalledMagnetDevice;
import ice.data.InstalledTempDevice;
import ice.data.tas.bt7.Instrument;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.event.communication.UBCalcDestinationResponseEvent;
import ice.event.communication.UBCalcDestinationResponseListener;
import ice.exceptions.IcePanelException;
import ice.exceptions.IcePanelUncheckedException;
import ice.gui.core.IceViewPanel;
import ice.swing.Bag;
import ice.swing.DeviceFixCheckBox;
import ice.swing.DeviceNameLabel;
import ice.swing.DeviceValueLabel;
import ice.swing.RememberDecisionDialog;
import ice.swing.actions.IceMenuAction;
import ice.swing.buttons.ImageButton;
import ice.swing.buttons.TwoStateImageButton;
import ice.util.FileManager;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.PreferencesManager;
import ice.util.StructuredDeviceList.DeviceNode;
import ice.util.StructuredDeviceList.StructuredDeviceList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class DeviceMovePanel
extends IceViewPanel
implements DeviceListListener,
UBCalcDestinationResponseListener {
    private static Logger logger = Logger.getLogger("WidgetLogger.MoveLogger");
    private SendQueueManager sendManager;
    private ArrayList<InstalledDevice> allDevices;
    private LinkedHashMap<JPanel, ArrayList<DeviceNode>> groupList;
    private JTabbedPane mainPanel;
    private CustomizeAction customizeAction;
    private CustomizeWindow customizeWindow;
    private HashMap<String, IceMenuAction> actionList;
    private Instrument instrument;
    private DeviceRowPanel allPanel;
    private Controller controller;

    public DeviceMovePanel() throws IcePanelException {
        super("Device Move");
    }

    @Override
    protected void init() {
        this.controller = Controller.getReference();
        this.sendManager = this.controller.getSendManager();
        this.instrument = this.controller.getInstrument();
        StructuredDeviceList structuredDeviceList = StructuredDeviceList.getInstance();
        ArrayList<InstalledDevice> devices = new ArrayList<InstalledDevice>(this.controller.getDeviceList());
        this.groupList = new LinkedHashMap();
        this.allDevices = new ArrayList();
        this.setDevices(devices);
        TreeMap<String, ArrayList<InstalledDevice>> deviceGroups = this.createGroupList();
        this.createPanels(deviceGroups);
        this.customizeAction = new CustomizeAction("Customize...");
        this.actionList = new HashMap();
        this.actionList.put("Customize...", this.customizeAction);
        this.customizeWindow = new CustomizeWindow();
        this.mainPanel = new JTabbedPane();
        try {
            this.controller.getCommMgr().addUBCalcDestinationResponseListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("DeviceMovePanel.init could not add listener " + e);
        }
        this.controller.getDeviceListeners().add(this);
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add(this.mainPanel);
        for (JPanel panel : this.groupList.keySet()) {
            JScrollPane scrollPane = new JScrollPane(panel, 20, 30);
            scrollPane.getVerticalScrollBar().setUnitIncrement(7);
            this.mainPanel.add(panel.getName(), scrollPane);
        }
    }

    private TreeMap<String, ArrayList<InstalledDevice>> createGroupList() {
        logger.debug("Creating move device window.");
        try {
            FileManager fileManager = FileManager.getInstance();
            TreeMap<String, ArrayList<String>> groupList = fileManager.getMoveDevicesToDisplay();
            TreeMap<String, ArrayList<InstalledDevice>> newGroupList = new TreeMap<String, ArrayList<InstalledDevice>>();
            Set<String> groupNames = groupList.keySet();
            for (String groupName : groupNames) {
                ArrayList<String> deviceNames = groupList.get(groupName);
                ArrayList<InstalledDevice> group = new ArrayList<InstalledDevice>();
                int j = 0;
                while (j < deviceNames.size()) {
                    InstalledDevice device;
                    logger.debug("getting " + deviceNames.get(j));
                    String tmpDeviceName = deviceNames.get(j);
                    if (!(tmpDeviceName.equalsIgnoreCase("filtertrans") || tmpDeviceName.equalsIgnoreCase("premonocollimator") || tmpDeviceName.equalsIgnoreCase("pmcoll") || (device = this.controller.getFirstDevice(tmpDeviceName)) == null)) {
                        group.add(device);
                    }
                    ++j;
                }
                newGroupList.put(groupName, group);
            }
            return newGroupList;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IcePanelUncheckedException(ioe);
        }
    }

    private void createPanels(TreeMap<String, ArrayList<InstalledDevice>> deviceGroups) {
        Iterator<String> iterator = deviceGroups.keySet().iterator();
        StructuredDeviceList structuredDeviceList = null;
        ArrayList<DeviceNode> structuredDeviceNodeList = null;
        structuredDeviceList = StructuredDeviceList.getInstance();
        structuredDeviceNodeList = structuredDeviceList.getStructuredDeviceList();
        Iterator<InstalledDevice> allIterator = this.allDevices.iterator();
        ArrayList<DeviceNode> deviceNodes = new ArrayList<DeviceNode>();
        while (allIterator.hasNext()) {
            InstalledDevice installedDevice = null;
            String name = null;
            DeviceNode deviceNode = null;
            installedDevice = allIterator.next();
            name = installedDevice.getRealNameButReturnAliasIfCounter();
            deviceNode = structuredDeviceList.getNodeByName(name);
            deviceNodes.add(deviceNode);
        }
        this.allPanel = new DeviceRowPanel();
        this.allPanel.setVisible(true);
        this.allPanel.setName("All");
        this.buildStructuredDeviceListPanel(structuredDeviceNodeList, this.allPanel);
        this.allPanel.childPanel.setVisible(true);
        this.groupList.put(this.allPanel, deviceNodes);
        while (iterator.hasNext()) {
            String tabName = iterator.next();
            InstalledDevice device = null;
            Object deviceRow = null;
            DeviceNode deviceNode = null;
            String deviceName = null;
            structuredDeviceNodeList = new ArrayList();
            Iterator<InstalledDevice> deviceIterator = deviceGroups.get(tabName).iterator();
            while (deviceIterator.hasNext()) {
                boolean readOnlyDevice = false;
                device = deviceIterator.next();
                deviceName = device.getRealNameButReturnAliasIfCounter();
                deviceNode = structuredDeviceList.getNodeByName(deviceName);
                if (deviceNode == null) continue;
                structuredDeviceNodeList.add(deviceNode);
            }
            DeviceRowPanel panel = new DeviceRowPanel();
            panel.setVisible(true);
            panel.setName(tabName);
            this.buildStructuredDeviceListPanel(structuredDeviceNodeList, panel);
            panel.childPanel.setVisible(true);
            this.groupList.put(panel, structuredDeviceNodeList);
        }
    }

    private void buildStructuredDeviceListPanel(ArrayList<DeviceNode> deviceNodeList, DeviceRowPanel parentPanel) {
        block1: {
            int deviceNodeListSize = -1;
            if (deviceNodeList == null) break block1;
            DeviceNode currentNode = null;
            ArrayList<DeviceNode> currentNodeChildren = null;
            InstalledDevice currentInstalledDevice = null;
            DeviceRowPanel currentDevicePanel = null;
            DeviceRow currentDeviceRow = null;
            boolean visible = true;
            deviceNodeListSize = deviceNodeList.size();
            int i = 0;
            while (i < deviceNodeListSize) {
                block2: {
                    block4: {
                        block3: {
                            currentNode = deviceNodeList.get(i);
                            visible = currentNode.isVisible();
                            if (!visible) break block2;
                            currentInstalledDevice = currentNode.getInstalledDevice();
                            if (currentInstalledDevice == null) break block3;
                            InstalledDevice.Type installedDeviceType = InstalledDevice.Type.unknown;
                            boolean readOnlyDevice = false;
                            installedDeviceType = currentInstalledDevice.getType();
                            if (installedDeviceType == InstalledDevice.Type.counter) break block2;
                            readOnlyDevice = currentNode.isReadOnlyDevice();
                            currentDeviceRow = new DeviceRow(currentInstalledDevice);
                            currentDeviceRow.setReadOnlyDevice(readOnlyDevice);
                            currentDevicePanel = new DeviceRowPanel(currentDeviceRow);
                            break block4;
                        }
                        boolean isClientSideContianer = false;
                        isClientSideContianer = currentNode.isClientSideDeviceContainer();
                        String deviceName = null;
                        boolean isClientSideDeviceContainer = false;
                        isClientSideDeviceContainer = currentNode.isClientSideDeviceContainer();
                        deviceName = currentNode.getName();
                        currentDevicePanel = new DeviceRowPanel(deviceName, isClientSideDeviceContainer);
                    }
                    parentPanel.addChild(currentDevicePanel);
                    currentNodeChildren = currentNode.getChildren();
                    this.buildStructuredDeviceListPanel(currentNodeChildren, currentDevicePanel);
                }
                ++i;
            }
            parentPanel.showChildrenBasedOffOfSizePanelButton();
        }
    }

    private void setDevices(Collection<InstalledDevice> devices) {
        this.allDevices.clear();
        for (InstalledDevice device : devices) {
            if (device.getType() == InstalledDevice.Type.counter || device.getName().equalsIgnoreCase("filtertrans") || device.getName().equalsIgnoreCase("premonocollimator") || device.getName().equalsIgnoreCase("pmcoll")) continue;
            this.allDevices.add(device);
        }
    }

    private int createHeader(JPanel panel, Bag constraints, int y) {
        int x = 0;
        JLabel deviceLabel = new JLabel("<html><b>Device</b>");
        panel.add((Component)deviceLabel, constraints.cell(x, y));
        JLabel currPosLabel = new JLabel("<html><b>Current Position</b>");
        panel.add((Component)currPosLabel, constraints.cell(++x, y));
        JLabel targetPosLabel = new JLabel("<html><b>Target Position</b>");
        panel.add((Component)targetPosLabel, constraints.cell(++x, y));
        JLabel blankLabel = new JLabel("");
        panel.add((Component)blankLabel, constraints.cell(++x, y));
        JLabel jogLabel = new JLabel("<html><b>Jog Step</b>");
        jogLabel.setHorizontalAlignment(0);
        panel.add((Component)jogLabel, constraints.cell(++x, y));
        JLabel lockLabel = new JLabel("<html><b>Fix</b>");
        panel.add((Component)lockLabel, constraints.cell(++x, y));
        x = 0;
        return 1;
    }

    public TreeMap<String, ArrayList<String>> getDisplayedDeviceNames() {
        TreeMap<String, ArrayList<String>> layout = new TreeMap<String, ArrayList<String>>();
        for (JPanel panel : this.groupList.keySet()) {
            if (panel == this.allPanel) continue;
            String groupName = panel.getName();
            ArrayList<String> devices = new ArrayList<String>();
            ArrayList<DeviceNode> deviceNodes = this.groupList.get(panel);
            if (deviceNodes != null) {
                for (DeviceNode deviceNode : deviceNodes) {
                    InstalledDevice installedDevice = deviceNode.getInstalledDevice();
                    if (installedDevice != null) {
                        String name = installedDevice.getName();
                        if (name != null) {
                            devices.add(name);
                            continue;
                        }
                        logger.error("DeviceMovePanel.getDisplayedDeviceNames should of gotten name for installed device  " + installedDevice);
                        continue;
                    }
                    logger.error("DeviceMovePanel.getDisplayedDeviceNames should of gotten installed device for " + deviceNode);
                }
                layout.put(groupName, devices);
                continue;
            }
            logger.error("DeviceMovePanel.getDisplayedDeviceNames should of gotten device nodes for " + panel + " from group list");
        }
        return layout;
    }

    @Override
    public IceMenuAction getIceMenuAction(String actionName) {
        IceMenuAction action = this.actionList.get(actionName);
        if (action == null) {
            return new IceMenuAction(actionName);
        }
        return action;
    }

    public void loadConfigWindow() {
        if (!this.customizeWindow.isVisible()) {
            this.customizeWindow.setLocationRelativeTo(this.mainPanel);
            this.customizeWindow.setVisible(true);
        } else {
            this.customizeWindow.requestFocus();
        }
    }

    private boolean removePanel(JPanel panel) {
        int tabCount = this.mainPanel.getTabCount();
        int i = 0;
        while (i < tabCount) {
            JScrollPane scrollPane = (JScrollPane)this.mainPanel.getComponentAt(i);
            if (scrollPane.getViewport().getView() == panel) {
                this.mainPanel.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        devicesRemoved = dle.getDevicesRemoved();
        devicesAdded = dle.getDevicesAdded();
        structuredDeviceList = StructuredDeviceList.getInstance();
        deviceRowPanels = null;
        for (InstalledDevice deviceToRemove : devicesRemoved) {
            for (JPanel panel : this.groupList.keySet()) {
                panelName = panel.getName();
                deviceNodes = this.groupList.get(panel);
                deviceNodeIterator = deviceNodes.iterator();
                if (panelName.compareTo("All") != 0) ** GOTO lbl34
                while (deviceNodeIterator.hasNext()) {
                    deviceNode = deviceNodeIterator.next();
                    if (deviceToRemove != deviceNode.getInstalledDevice()) continue;
                    deviceName = deviceToRemove.getRealNameButReturnAliasIfCounter();
                    deviceNode = structuredDeviceList.getNodeByName(deviceName);
                    deviceNode.setInstalledDevice(null);
                    deviceRowPanels = new ArrayList<E>();
                    this.allPanel.findAnsestorsByName(deviceName, deviceRowPanels);
                    i = 0;
                    while (i < deviceRowPanels.size()) {
                        deviceRowPanel = deviceRowPanels.get(i);
                        deviceRowPanel.removeAll();
                        ++i;
                    }
                    deviceNodeIterator.remove();
                }
                this.groupList.put(this.allPanel, deviceNodes);
                continue;
lbl-1000:
                // 1 sources

                {
                    deviceNode = deviceNodeIterator.next();
                    if (deviceToRemove != deviceNode.getInstalledDevice()) continue;
                    deviceNodeIterator.remove();
                    this.rebuildPanel(panel, deviceNodes);
lbl34:
                    // 3 sources

                    ** while (deviceNodeIterator.hasNext())
                }
lbl35:
                // 1 sources

            }
        }
        this.customizeWindow.removeDevices(devicesRemoved);
        deviceNodes = this.groupList.get(this.allPanel);
        addIterator = devicesAdded.iterator();
        structuredDeviceList.fillInInstalledDevices(devicesAdded);
        while (addIterator.hasNext()) {
            deviceName = null;
            installedDevice = null;
            deviceRow = null;
            deviceNode = null;
            readOnlyDevice = false;
            installedDevice = addIterator.next();
            deviceName = installedDevice.getRealNameButReturnAliasIfCounter();
            deviceNode = structuredDeviceList.getNodeByName(deviceName);
            nodesDevice = deviceNode.getInstalledDevice();
            if (deviceNode == null) {
                addDevice = new ArrayList<InstalledDevice>();
                addDevice.add(installedDevice);
                structuredDeviceList.fillInInstalledDevices(addDevice);
                deviceNode = structuredDeviceList.getNodeByName(deviceName);
            }
            if (nodesDevice == null) {
                deviceNode.setInstalledDevice(installedDevice);
            } else if (installedDevice instanceof InstalledEnvDevice && (nodesDevice == null || !nodesDevice.equals(installedDevice))) {
                deviceNode.setInstalledDevice(installedDevice);
            }
            deviceRowPanels = new ArrayList<DeviceRowPanel>();
            this.allPanel.findAnsestorsByName(deviceName, deviceRowPanels);
            deviceNodeList = new ArrayList<DeviceNode>();
            deviceNodeList.add(deviceNode);
            readOnlyDevice = deviceNode.isReadOnlyDevice();
            if (deviceRowPanels.size() < 1) {
                deviceNodes.add(deviceNode);
                this.buildStructuredDeviceListPanel(deviceNodeList, this.allPanel);
                continue;
            }
            i = 0;
            while (i < deviceRowPanels.size()) {
                deviceRowPanels.get(i).reAddFromDeviceNode(deviceNode);
                deviceNodes.add(deviceNode);
                ++i;
            }
        }
        Collections.sort(deviceNodes);
        this.groupList.put(this.allPanel, deviceNodes);
        this.setDevices(dle.getNewList());
        this.customizeWindow.updateAllModel();
    }

    public void rebuildPanel(JPanel panel, ArrayList<DeviceNode> deviceNodes) {
        logger.debug("panel: " + panel.getName());
        Object device = null;
        Object deviceRow = null;
        Object deviceNode = null;
        Object deviceName = null;
        StructuredDeviceList structuredDeviceList = null;
        ArrayList<DeviceNode> structuredDeviceNodeList = null;
        structuredDeviceList = StructuredDeviceList.getInstance();
        structuredDeviceNodeList = new ArrayList<DeviceNode>();
        if (panel.getName().compareTo("All") != 0) {
            ((DeviceRowPanel)panel).removeControlPanel();
            ((DeviceRowPanel)panel).removeChildren();
            this.buildStructuredDeviceListPanel(structuredDeviceNodeList, (DeviceRowPanel)panel);
            this.groupList.put(panel, deviceNodes);
        }
    }

    @Override
    protected void updateLockState() {
        SwingUtilities.invokeLater(new LockToggleRunnable(this.locked));
    }

    @Override
    public void actionPerformed(UBCalcDestinationResponseEvent evt) {
        SetHKLFromUBCalcDestinationResponseEvent setHKLFromUBCalcDestinationResponseEvent = new SetHKLFromUBCalcDestinationResponseEvent(evt);
        SwingUtilities.invokeLater(setHKLFromUBCalcDestinationResponseEvent);
    }

    @Override
    public void saveSettings() throws IcePanelException {
        FileManager fileManager = FileManager.getInstance();
        try {
            fileManager.saveMoveDevices(this.getDisplayedDeviceNames());
        }
        catch (IOException e) {
            throw new IcePanelException(e);
        }
    }

    private class CustomizeAction
    extends IceMenuAction {
        public CustomizeAction(String actionName) {
            super(actionName);
            this.putValue("MnemonicKey", new Integer(85));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DeviceMovePanel.this.loadConfigWindow();
        }
    }

    private class CustomizeWindow
    extends JFrame
    implements WindowListener,
    ListSelectionListener {
        private JList currList;
        private DefaultListModel currModel = new DefaultListModel();
        private JScrollPane allScroller;
        private JList allList;
        private DefaultListModel allModel;
        private JButton newTabBtn;
        private JButton addBtn;
        private JButton removeBtn;
        private JButton moveUpBtn;
        private JButton moveDownBtn;
        private JButton closeBtn;
        private LoadNewTabAction loadNewTabAction;
        private LoadAddDeviceAction loadAddDeviceAction;
        private RemoveDeviceAction removeDeviceAction;
        private MoveUpAction moveUpAction;
        private MoveDownAction moveDownAction;
        private JPanel panel;
        private NewTabWindow ntw;
        private AddDeviceWindow adw;
        private CloseFramesAction cfa;

        public CustomizeWindow() {
            for (JPanel panel : DeviceMovePanel.this.groupList.keySet()) {
                if (panel == DeviceMovePanel.this.allPanel) continue;
                this.currModel.addElement(panel);
                ArrayList deviceNodes = (ArrayList)DeviceMovePanel.this.groupList.get(panel);
                if (deviceNodes != null) {
                    for (DeviceNode deviceNode : deviceNodes) {
                        InstalledDevice installedDevice = deviceNode.getInstalledDevice();
                        if (installedDevice != null) {
                            this.currModel.addElement(installedDevice);
                            continue;
                        }
                        logger.error("CustomizeWindow Could not get installed device for device node " + deviceNode);
                    }
                    continue;
                }
                logger.error("CustomizeWindow Could not get device nodes for panel " + panel);
            }
            this.currList = new JList(this.currModel);
            this.currList.setCellRenderer(new TabListCellRenderer());
            this.panel = (JPanel)this.getContentPane();
            this.panel.setLayout(new GridBagLayout());
            this.adw = new AddDeviceWindow();
            this.ntw = new NewTabWindow();
            this.loadNewTabAction = new LoadNewTabAction();
            this.loadAddDeviceAction = new LoadAddDeviceAction();
            this.removeDeviceAction = new RemoveDeviceAction();
            this.moveUpAction = new MoveUpAction();
            this.moveDownAction = new MoveDownAction();
            this.newTabBtn = new JButton(this.loadNewTabAction);
            this.addBtn = new JButton(this.loadAddDeviceAction);
            this.removeBtn = new JButton(this.removeDeviceAction);
            this.moveUpBtn = new JButton(this.moveUpAction);
            this.moveDownBtn = new JButton(this.moveDownAction);
            ArrayList<JFrame> frames = new ArrayList<JFrame>();
            frames.add(this.adw);
            frames.add(this.ntw);
            frames.add(this);
            this.cfa = new CloseFramesAction(frames);
            this.closeBtn = new JButton(this.cfa);
            this.currList.addListSelectionListener(this);
            this.buildGUI();
        }

        private void buildGUI() {
            this.setTitle("Customize Layout - Move Device");
            this.setName("Customize Layout - Move Device");
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(this);
            JScrollPane currScroller = new JScrollPane(this.currList, 22, 30);
            Bag constraints = new Bag();
            int x = 0;
            int y = 0;
            this.panel.add((Component)currScroller, constraints.cell(x, y).rowspan(6).fillboth());
            this.panel.add((Component)this.newTabBtn, constraints.cell(++x, y));
            this.panel.add((Component)this.addBtn, constraints.cell(x, ++y));
            this.panel.add((Component)this.removeBtn, constraints.cell(x, ++y));
            this.panel.add((Component)this.moveUpBtn, constraints.cell(x, ++y));
            this.panel.add((Component)this.moveDownBtn, constraints.cell(x, ++y));
            this.panel.add((Component)this.closeBtn, constraints.cell(x, ++y));
            this.panel.add((Component)new JLabel(""), constraints.cell(x, ++y));
            this.pack();
            if (this.allScroller.getSize().width > currScroller.getSize().width) {
                currScroller.setPreferredSize(new Dimension(this.allScroller.getSize().width, currScroller.getSize().height));
                this.pack();
            }
            this.initState();
        }

        private void initState() {
            this.moveUpAction.setEnabled(false);
            this.moveDownAction.setEnabled(false);
            this.removeDeviceAction.setEnabled(false);
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }

        @Override
        public void windowClosing(WindowEvent we) {
            this.cfa.actionPerformed(new ActionEvent(this, 0, "blah"));
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            boolean hasDevice = false;
            boolean hasPanel = false;
            Object[] selectedValues = this.currList.getSelectedValues();
            int length = selectedValues.length;
            int index = 0;
            while (!(index >= length || hasDevice && hasPanel)) {
                Object object = selectedValues[index];
                if (object instanceof InstalledDevice) {
                    hasDevice = true;
                } else if (object instanceof JPanel) {
                    hasPanel = true;
                }
                ++index;
            }
            boolean moveDownState = false;
            boolean moveUpState = false;
            boolean removeState = false;
            if (hasPanel && !hasDevice) {
                removeState = true;
            } else if (!hasPanel && hasDevice) {
                moveDownState = true;
                moveUpState = true;
                removeState = true;
            }
            this.moveDownAction.setEnabled(moveDownState);
            this.moveUpAction.setEnabled(moveUpState);
            this.removeDeviceAction.setEnabled(removeState);
        }

        public void updateAllModel() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustomizeWindow.this.allModel.clear();
                    Iterator iterator = DeviceMovePanel.this.allDevices.iterator();
                    while (iterator.hasNext()) {
                        CustomizeWindow.this.allModel.addElement(iterator.next());
                    }
                }
            });
        }

        public void removeDevices(List<InstalledDevice> devicesToRemove) {
            for (final InstalledDevice device : devicesToRemove) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        while (CustomizeWindow.this.currModel.removeElement(device)) {
                        }
                    }
                });
            }
        }

        private class AddDeviceWindow
        extends JFrame {
            private JButton addBtn;
            private JButton closeBtn;

            public AddDeviceWindow() {
                CustomizeWindow.this.allModel = new DefaultListModel();
                CustomizeWindow.this.updateAllModel();
                CustomizeWindow.this.allList = new JList(CustomizeWindow.this.allModel);
                CustomizeWindow.this.allScroller = new JScrollPane(CustomizeWindow.this.allList, 22, 30);
                this.addBtn = new JButton(new AddAction());
                this.addBtn.setHorizontalAlignment(0);
                ArrayList<JFrame> frames = new ArrayList<JFrame>();
                frames.add(this);
                this.closeBtn = new JButton(new CloseFramesAction(frames));
                this.buildGUI();
            }

            public void buildGUI() {
                this.setTitle("Add Device");
                this.setName("Add Device");
                this.setResizable(false);
                this.setDefaultCloseOperation(2);
                JPanel panel = (JPanel)this.getContentPane();
                panel.setLayout(new GridBagLayout());
                Bag constraints = new Bag();
                int x = 0;
                int y = 0;
                panel.add((Component)CustomizeWindow.this.allScroller, constraints.cell(x, y).rowspan(3).fillboth());
                panel.add((Component)this.addBtn, constraints.cell(++x, y));
                panel.add((Component)this.closeBtn, constraints.cell(x, ++y));
                panel.add((Component)new JLabel(""), constraints.cell(x, ++y).fillboth());
                this.pack();
            }

            private class AddAction
            extends AbstractAction {
                public AddAction() {
                    this.putValue("Name", "Add");
                }

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int i;
                    int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                    int[] indices = CustomizeWindow.this.allList.getSelectedIndices();
                    if (indices.length == 0) {
                        return;
                    }
                    int currIndex = -1;
                    if (currIndices.length != 0) {
                        currIndex = currIndices[currIndices.length - 1];
                    }
                    logger.debug("currIndex: " + currIndex);
                    Component panel = null;
                    int location = -1;
                    if (currIndex != -1) {
                        i = currIndex;
                        while (i >= 0) {
                            if (CustomizeWindow.this.currModel.getElementAt(i) instanceof JPanel) {
                                panel = (JPanel)CustomizeWindow.this.currModel.getElementAt(i);
                                location = i;
                                break;
                            }
                            --i;
                        }
                    } else {
                        i = CustomizeWindow.this.currModel.getSize() - 1;
                        while (i >= 0) {
                            if (CustomizeWindow.this.currModel.getElementAt(i) instanceof JPanel) {
                                panel = (JPanel)CustomizeWindow.this.currModel.getElementAt(i);
                                location = i;
                                break;
                            }
                            --i;
                        }
                    }
                    logger.debug("panel: " + panel.getName());
                    logger.debug("i: " + location);
                    ArrayList<InstalledDevice> devicesToAdd = new ArrayList<InstalledDevice>();
                    int i2 = 0;
                    while (i2 < indices.length) {
                        devicesToAdd.add((InstalledDevice)CustomizeWindow.this.allModel.getElementAt(indices[i2]));
                        ++i2;
                    }
                    this.addDevices((DeviceRowPanel)panel, (ArrayList)DeviceMovePanel.this.groupList.get(panel), devicesToAdd, currIndex, location);
                }

                private void addDevices(DeviceRowPanel panel, ArrayList<DeviceNode> deviceNodes, ArrayList<InstalledDevice> devicesToAdd, int currIndex, int location) {
                    String duplicationPref = PreferencesManager.getPreferenceString("moveDevice.allowDuplicateDevices");
                    if (!duplicationPref.equalsIgnoreCase("yes")) {
                        ArrayList<InstalledDevice> duplicateDevices = new ArrayList<InstalledDevice>();
                        for (DeviceNode deviceNode : deviceNodes) {
                            InstalledDevice installedDevice = deviceNode.getInstalledDevice();
                            if (installedDevice != null) {
                                if (!devicesToAdd.contains(installedDevice)) continue;
                                duplicateDevices.add(installedDevice);
                                continue;
                            }
                            logger.error("DeviceMovePanel-AddAction.addDevices could not get installed device for device node " + deviceNode);
                        }
                        if (duplicateDevices.size() > 0) {
                            if (duplicationPref.equalsIgnoreCase("no")) {
                                Iterator duplicateIterator = duplicateDevices.iterator();
                                while (duplicateIterator.hasNext()) {
                                    devicesToAdd.remove(duplicateIterator.next());
                                }
                            } else {
                                String body;
                                EnumSet<RememberDecisionDialog.Decision> decision;
                                String devices = "";
                                Iterator duplicateIterator = duplicateDevices.iterator();
                                while (duplicateIterator.hasNext()) {
                                    devices = String.valueOf(devices) + duplicateIterator.next() + ", ";
                                }
                                devices = devices.substring(0, devices.length() - 2);
                                String devicesToken = "Devices ";
                                String stativeVerbToken = " are ";
                                String articleToken = " them?";
                                if (duplicateDevices.size() == 1) {
                                    devicesToken = "Device ";
                                    stativeVerbToken = " is ";
                                    articleToken = " it?";
                                }
                                if ((decision = RememberDecisionDialog.showDialog(null, "Confirm Add", body = String.valueOf(devicesToken) + devices + stativeVerbToken + "already being displayed.  Do you want to add" + articleToken, RememberDecisionDialog.DialogType.YesNoCancel)).contains((Object)RememberDecisionDialog.Decision.Remember)) {
                                    try {
                                        if (decision.contains((Object)RememberDecisionDialog.Decision.Yes)) {
                                            PreferencesManager.setPreferenceString("moveDevice.allowDuplicateDevices", "yes");
                                        } else if (decision.contains((Object)RememberDecisionDialog.Decision.No)) {
                                            PreferencesManager.setPreferenceString("moveDevice.allowDuplicateDevices", "no");
                                        }
                                    }
                                    catch (IOException ioe) {
                                        logger.error("Unable to set user's preferences.", ioe);
                                    }
                                }
                                if (decision.contains((Object)RememberDecisionDialog.Decision.Cancel)) {
                                    return;
                                }
                                if (decision.contains((Object)RememberDecisionDialog.Decision.No)) {
                                    duplicateIterator = duplicateDevices.iterator();
                                    while (duplicateIterator.hasNext()) {
                                        devicesToAdd.remove(duplicateIterator.next());
                                    }
                                }
                            }
                        }
                    }
                    DeviceRow deviceRow = null;
                    StructuredDeviceList structuredDeviceList = StructuredDeviceList.getInstance();
                    int i = 0;
                    while (i < devicesToAdd.size()) {
                        InstalledDevice deviceToAdd = devicesToAdd.get(i);
                        String deviceName = null;
                        DeviceNode deviceNode = null;
                        boolean readOnlyDevice = false;
                        deviceName = deviceToAdd.getRealNameButReturnAliasIfCounter();
                        deviceNode = structuredDeviceList.getNodeByName(deviceName);
                        if (deviceNode != null) {
                            readOnlyDevice = deviceNode.isReadOnlyDevice();
                        }
                        if (currIndex != -1) {
                            CustomizeWindow.this.currModel.insertElementAt(deviceToAdd, i + currIndex + 1);
                            deviceRow = new DeviceRow(deviceToAdd);
                            deviceRow.setReadOnlyDevice(readOnlyDevice);
                            deviceNodes.add(currIndex + i - location, deviceNode);
                            panel.addChildAt(deviceRow, currIndex + i - location);
                        } else {
                            CustomizeWindow.this.currModel.addElement(deviceToAdd);
                            deviceRow = new DeviceRow(deviceToAdd);
                            deviceRow.setReadOnlyDevice(readOnlyDevice);
                            deviceNodes.add(deviceNode);
                            panel.addChildAt(deviceRow, 0);
                        }
                        panel.childPanel.setVisible(true);
                        ++i;
                    }
                }
            }
        }

        private class CloseFramesAction
        extends AbstractAction {
            private Collection<JFrame> frames;

            public CloseFramesAction(Collection<JFrame> frames) {
                this.frames = frames;
                this.putValue("Name", "Close");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                Iterator<JFrame> iterator = this.frames.iterator();
                while (iterator.hasNext()) {
                    iterator.next().dispose();
                }
            }
        }

        private class LoadAddDeviceAction
        extends AbstractAction {
            public LoadAddDeviceAction() {
                this.putValue("Name", "Add...");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (CustomizeWindow.this.adw == null) {
                    CustomizeWindow.this.adw = new AddDeviceWindow();
                }
                CustomizeWindow.this.adw.setLocationRelativeTo(CustomizeWindow.this);
                CustomizeWindow.this.adw.setVisible(true);
            }
        }

        private class LoadNewTabAction
        extends AbstractAction {
            public LoadNewTabAction() {
                this.putValue("Name", "New Tab...");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                CustomizeWindow.this.ntw.setVisible(true);
            }
        }

        private class MoveDownAction
        extends AbstractAction {
            public MoveDownAction() {
                this.putValue("Name", "Move Down");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int[] destinationIndices = new int[currIndices.length];
                int i = currIndices.length - 1;
                while (i >= 0) {
                    int currIndex = currIndices[i];
                    if (currIndex == CustomizeWindow.this.currModel.size() - 1) {
                        destinationIndices[i] = currIndices[i];
                    } else {
                        InstalledDevice device = (InstalledDevice)CustomizeWindow.this.currModel.getElementAt(currIndex);
                        DeviceRowPanel panel = null;
                        int location = -1;
                        int j = currIndex;
                        while (j >= 0) {
                            if (CustomizeWindow.this.currModel.getElementAt(j) instanceof JPanel) {
                                panel = (DeviceRowPanel)CustomizeWindow.this.currModel.getElementAt(j);
                                location = j;
                                break;
                            }
                            --j;
                        }
                        logger.debug("panel: " + panel.getName());
                        logger.debug("location: " + location);
                        ArrayList currentPanelNodes = (ArrayList)DeviceMovePanel.this.groupList.get(panel);
                        int destinationIndex = currIndex + 1;
                        int panelDestinationIndex = destinationIndex - 1 - location;
                        DeviceRowPanel destinationPanel = panel;
                        if (currIndex + 1 < CustomizeWindow.this.currModel.size() && CustomizeWindow.this.currModel.getElementAt(currIndex + 1) instanceof JPanel) {
                            panelDestinationIndex = 0;
                            destinationPanel = (DeviceRowPanel)CustomizeWindow.this.currModel.getElementAt(currIndex + 1);
                        }
                        CustomizeWindow.this.currModel.removeElementAt(currIndex);
                        DeviceNode node = (DeviceNode)currentPanelNodes.remove(currIndex - 1 - location);
                        InstalledDevice installedDevice = node.getInstalledDevice();
                        DeviceRow row = new DeviceRow(installedDevice);
                        CustomizeWindow.this.currModel.add(destinationIndex, device);
                        destinationIndices[i] = destinationIndex;
                        ((ArrayList)DeviceMovePanel.this.groupList.get(destinationPanel)).add(panelDestinationIndex, node);
                        String deviceRealName = null;
                        deviceRealName = device.getRealNameButReturnAliasIfCounter();
                        if (panel == destinationPanel) {
                            destinationPanel.moveChildDownOne(currIndex - 1);
                        } else {
                            int childToRemove = -1;
                            childToRemove = panel.getNumberOfChildren() - 1;
                            panel.removeChildFromPanel(childToRemove);
                            destinationPanel.addChildToTopOfChildPanel(row);
                        }
                    }
                    --i;
                }
                CustomizeWindow.this.currList.setSelectedIndices(destinationIndices);
                if (destinationIndices.length != 0) {
                    CustomizeWindow.this.currList.ensureIndexIsVisible(destinationIndices[destinationIndices.length - 1]);
                }
            }
        }

        private class MoveUpAction
        extends AbstractAction {
            public MoveUpAction() {
                this.putValue("Name", "Move Up");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int[] destinationIndices = new int[currIndices.length];
                int i = 0;
                while (i < currIndices.length) {
                    int currIndex = currIndices[i];
                    if (currIndex == 1) {
                        destinationIndices[i] = currIndices[i];
                    } else {
                        InstalledDevice device = (InstalledDevice)CustomizeWindow.this.currModel.getElementAt(currIndex);
                        Component panel = null;
                        int location = -1;
                        int j = currIndex;
                        while (j >= 0) {
                            if (CustomizeWindow.this.currModel.getElementAt(j) instanceof JPanel) {
                                panel = (JPanel)CustomizeWindow.this.currModel.getElementAt(j);
                                location = j;
                                break;
                            }
                            --j;
                        }
                        logger.debug("panel: " + panel.getName());
                        logger.debug("location: " + location);
                        ArrayList currentPanelNodes = (ArrayList)DeviceMovePanel.this.groupList.get(panel);
                        int destinationIndex = currIndex - 1;
                        int panelDestinationIndex = destinationIndex - 1 - location;
                        Component destinationPanel = panel;
                        if (destinationIndex > 0 && CustomizeWindow.this.currModel.getElementAt(destinationIndex) instanceof JPanel) {
                            int j2 = destinationIndex - 1;
                            while (j2 >= 0) {
                                if (CustomizeWindow.this.currModel.getElementAt(j2) instanceof JPanel) {
                                    destinationPanel = (JPanel)CustomizeWindow.this.currModel.getElementAt(j2);
                                    panelDestinationIndex = ((ArrayList)DeviceMovePanel.this.groupList.get(destinationPanel)).size();
                                    break;
                                }
                                --j2;
                            }
                        }
                        CustomizeWindow.this.currModel.removeElementAt(currIndex);
                        DeviceNode node = (DeviceNode)currentPanelNodes.remove(currIndex - 1 - location);
                        CustomizeWindow.this.currModel.add(destinationIndex, device);
                        destinationIndices[i] = destinationIndex;
                        ((ArrayList)DeviceMovePanel.this.groupList.get(destinationPanel)).add(panelDestinationIndex, node);
                        String deviceRealName = null;
                        deviceRealName = device.getRealNameButReturnAliasIfCounter();
                        if (panel == destinationPanel) {
                            ((DeviceRowPanel)destinationPanel).moveChildUpOne(currIndex - 1);
                        } else {
                            InstalledDevice installedDevice = node.getInstalledDevice();
                            DeviceRow deviceRow = new DeviceRow(installedDevice);
                            ((DeviceRowPanel)panel).removeChildFromPanel(0);
                            ((DeviceRowPanel)destinationPanel).addChildToBottomOfChildPanel(deviceRow);
                        }
                    }
                    ++i;
                }
                CustomizeWindow.this.currList.setSelectedIndices(destinationIndices);
                if (destinationIndices.length != 0) {
                    CustomizeWindow.this.currList.ensureIndexIsVisible(destinationIndices[0]);
                }
            }
        }

        private class NewTabWindow
        extends JFrame {
            private JTextField tabField;
            private JButton okBtn;
            private JButton cancelBtn;

            public NewTabWindow() {
                OKAction okAction = new OKAction(this);
                this.tabField = new JTextField(20);
                this.tabField.setAction(okAction);
                this.okBtn = new JButton(okAction);
                this.cancelBtn = new JButton(new CancelAction(this));
                this.buildGUI();
            }

            public void buildGUI() {
                this.setTitle("New Tab");
                this.setName("New Tab");
                this.setResizable(false);
                this.setDefaultCloseOperation(2);
                JPanel panel = (JPanel)this.getContentPane();
                panel.setLayout(new GridBagLayout());
                Bag constraints = new Bag();
                int x = 0;
                int y = 0;
                panel.add((Component)this.tabField, constraints.cell(x, y));
                panel.add((Component)this.okBtn, constraints.cell(++x, y));
                panel.add((Component)this.cancelBtn, constraints.cell(x, ++y));
                this.pack();
            }

            private class CancelAction
            extends AbstractAction {
                private JFrame frame;

                public CancelAction(JFrame frame) {
                    this.frame = frame;
                    this.putValue("Name", "Cancel");
                }

                @Override
                public void actionPerformed(ActionEvent ae) {
                    this.frame.dispose();
                }
            }

            private class OKAction
            extends AbstractAction {
                private JFrame frame;

                public OKAction(JFrame frame) {
                    this.frame = frame;
                    this.putValue("Name", "OK");
                }

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String newTab = NewTabWindow.this.tabField.getText().trim();
                    if (newTab.length() == 0) {
                        JOptionPane.showMessageDialog(null, "Tab name must contain at least one non-whitespace", "JICE - Error", 0);
                        return;
                    }
                    if (DeviceMovePanel.this.groupList.get(newTab) != null) {
                        JOptionPane.showMessageDialog(null, "Tab with this name already exists", "JICE - Error", 0);
                        return;
                    }
                    ArrayList deviceNodes = new ArrayList();
                    DeviceRowPanel newPanel = new DeviceRowPanel();
                    newPanel.setName(newTab);
                    newPanel.setVisible(true);
                    JScrollPane scrollPane = new JScrollPane(newPanel);
                    scrollPane.getVerticalScrollBar().setUnitIncrement(7);
                    DeviceMovePanel.this.mainPanel.add(newPanel.getName(), scrollPane);
                    this.frame.dispose();
                    DeviceMovePanel.this.groupList.put(newPanel, deviceNodes);
                    CustomizeWindow.this.currModel.addElement(newPanel);
                }
            }
        }

        private class RemoveDeviceAction
        extends AbstractAction {
            public RemoveDeviceAction() {
                this.putValue("Name", "Remove");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int[] currIndices = CustomizeWindow.this.currList.getSelectedIndices();
                int i = 0;
                while (i < currIndices.length) {
                    Object element = CustomizeWindow.this.currModel.getElementAt(currIndices[i]);
                    if (element instanceof JPanel) {
                        int endLocation = CustomizeWindow.this.currModel.size() - 1;
                        int j = currIndices[i] + 1;
                        while (j < CustomizeWindow.this.currModel.size()) {
                            if (CustomizeWindow.this.currModel.getElementAt(j) instanceof JPanel) {
                                endLocation = j - 1;
                                break;
                            }
                            ++j;
                        }
                        CustomizeWindow.this.currModel.removeRange(currIndices[i], endLocation);
                        DeviceMovePanel.this.removePanel((JPanel)element);
                        DeviceMovePanel.this.groupList.remove((JPanel)element);
                    } else if (element instanceof InstalledDevice) {
                        InstalledDevice device = (InstalledDevice)element;
                        DeviceRowPanel panel = null;
                        int location = -1;
                        int j = currIndices[i];
                        while (j >= 0) {
                            if (CustomizeWindow.this.currModel.getElementAt(j) instanceof JPanel) {
                                panel = (DeviceRowPanel)CustomizeWindow.this.currModel.getElementAt(j);
                                location = j;
                                break;
                            }
                            --j;
                        }
                        CustomizeWindow.this.currModel.remove(currIndices[i]);
                        ((ArrayList)DeviceMovePanel.this.groupList.get(panel)).remove(currIndices[i] - 1 - location);
                        panel.removeChildFromPanel(currIndices[i] - 1 - location);
                    }
                    ++i;
                }
            }
        }
    }

    public class DeviceRow
    implements DocumentListener,
    InstrumentValueChangedListener,
    Comparable {
        private InstalledDevice device;
        private DeviceNameLabel nameLabel;
        private DeviceValueLabel currPosLabel;
        private JTextField targetField;
        private GoButton goBtn;
        private MinusButton minusBtn;
        private JTextField jogField;
        private PlusButton plusBtn;
        private DeviceFixCheckBox fixCB;
        private JComboBox horizFocusCB;
        private JComboBox vertFocusCB;
        private JLabel currHorizFocus;
        private JLabel currVertFocus;
        private GoButton setHorizModeBtn;
        private GoButton setVertModeBtn;
        private JLabel calculatedValuesLabel;
        private JLabel calculatedA3Label;
        private JLabel calculatedA4Label;
        private JLabel calculatedUTiltLabel;
        private JLabel calculatedLTiltLabel;
        private JLabel calculatedA3ValueLabel;
        private JLabel calculatedA4ValueLabel;
        private JLabel calculatedLTiltValueLabel;
        private JLabel calculatedUTiltValueLabel;
        private JTextField toleranceField;
        private JTextField toleranceBandTimeField;
        private JTextField maxWaitTimeField;
        private ResetToDefaultButton resetToDefaultValuesButton;
        private GoButton tempGoButton;
        private GoButton magnetGoButton;
        private boolean readOnlyDevice = false;

        protected void enableEditableFields(boolean readOnly) {
            this.targetField.setEnabled(readOnly);
            this.goBtn.setEnabled(readOnly);
            this.minusBtn.setEnabled(readOnly);
            this.jogField.setEnabled(readOnly);
            this.plusBtn.setEnabled(readOnly);
            this.fixCB.setEnabled(readOnly);
            this.horizFocusCB.setEnabled(readOnly);
            this.setHorizModeBtn.setEnabled(readOnly);
            this.setVertModeBtn.setEnabled(readOnly);
            this.toleranceField.setEnabled(readOnly);
            this.toleranceBandTimeField.setEnabled(readOnly);
            this.maxWaitTimeField.setEnabled(readOnly);
            this.resetToDefaultValuesButton.setEnabled(readOnly);
            this.tempGoButton.setEnabled(readOnly);
            this.magnetGoButton.setEnabled(readOnly);
        }

        public DeviceRow(InstalledDevice device) {
            this.device = device;
            try {
                DeviceMovePanel.this.instrument.addPropertyChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e1) {
                logger.error("DeviceRow " + e1);
            }
            Font boldFont = null;
            String[] horizModes = new String[]{"flat", "energy", "venetian", "point"};
            String[] vertModes = new String[]{"flat", "sagittal"};
            this.horizFocusCB = new JComboBox<String>(horizModes);
            this.vertFocusCB = new JComboBox<String>(vertModes);
            this.currHorizFocus = new JLabel(DeviceMovePanel.this.instrument.getHorizontalFocusMode().toString());
            this.currHorizFocus.setHorizontalAlignment(0);
            this.currVertFocus = new JLabel(DeviceMovePanel.this.instrument.getVerticalFocusMode().toString());
            this.currVertFocus.setHorizontalAlignment(0);
            this.setHorizModeBtn = new GoButton();
            this.setHorizModeBtn.addActionListener(new AbstractAction("Go!"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceMovePanel.this.sendManager.addMessage("action horizfocus " + DeviceRow.this.horizFocusCB.getSelectedItem(), true);
                }
            });
            this.setVertModeBtn = new GoButton();
            this.setVertModeBtn.addActionListener(new AbstractAction("Go!"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DeviceMovePanel.this.sendManager.addMessage("action vertifocus " + DeviceRow.this.vertFocusCB.getSelectedItem(), true);
                }
            });
            this.horizFocusCB.setSelectedItem(this.currHorizFocus.getText());
            this.vertFocusCB.setSelectedItem(this.currVertFocus.getText());
            this.toleranceField = new JTextField(5);
            this.toleranceBandTimeField = new JTextField(5);
            this.maxWaitTimeField = new JTextField(5);
            this.resetToDefaultValuesButton = new ResetToDefaultButton();
            this.resetToDefaultValuesButton.setText(I18N.getString("sampleEnvironment.resetValues"));
            this.tempGoButton = new GoButton();
            this.tempGoButton.setText(I18N.getString("sampleEnvironment.go"));
            this.magnetGoButton = new GoButton();
            this.magnetGoButton.setText(I18N.getString("sampleEnvironment.go"));
            this.resetToDefaultValuesButton.addActionListener(new ResetToDefaultActionListener());
            this.tempGoButton.addActionListener(new TempGoActionListener());
            this.magnetGoButton.addActionListener(new MagnetGoActionListener());
            this.nameLabel = new DeviceNameLabel(device);
            this.currPosLabel = new DeviceValueLabel(device);
            this.currPosLabel.setHorizontalAlignment(2);
            this.targetField = new JTextField(8);
            this.targetField.getDocument().addDocumentListener(this);
            this.goBtn = new GoButton();
            this.goBtn.addActionListener(new GoAction());
            this.minusBtn = new MinusButton();
            this.minusBtn.addActionListener(new JogMinusAction());
            this.jogField = new JTextField(6);
            this.jogField.getDocument().addDocumentListener(this);
            if (device.getTolerance() != null) {
                this.jogField.setText(device.getTolerance().toString());
            } else {
                this.jogField.setText("0.1");
            }
            this.plusBtn = new PlusButton();
            this.plusBtn.addActionListener(new JogPlusAction());
            this.fixCB = new DeviceFixCheckBox(device, new FixDeviceAction());
            try {
                ResourceBundle rb = ResourceBundle.getBundle("preferences", Locale.getDefault(), new FileClassLoader());
                double decimalLength = Double.parseDouble(rb.getString("device.textField.decimalLength"));
                String format = "0.";
                int i = 0;
                while ((double)i < decimalLength) {
                    format = String.valueOf(format) + "0";
                    ++i;
                }
                if (format.endsWith(".")) {
                    format = format.substring(0, format.length() - 1);
                }
                DecimalFormat df = new DecimalFormat(format);
                this.targetField.setText(df.format(Double.parseDouble(device.getCurrValue())));
            }
            catch (NumberFormatException e) {
                this.targetField.setText(device.getCurrValue());
            }
            this.calculatedValuesLabel = new JLabel(I18N.getString("tas.core.moveDevicePanel.calculatedValues.label"));
            boldFont = this.calculatedValuesLabel.getFont();
            boldFont = boldFont.deriveFont(1);
            this.calculatedValuesLabel.setFont(boldFont);
            this.calculatedA3Label = new JLabel(I18N.getString("tas.core.moveDevicePanel.calculatedA3.label"));
            this.calculatedA3Label.setFont(boldFont);
            this.calculatedA4Label = new JLabel(I18N.getString("tas.core.moveDevicePanel.calculatedA4.label"));
            this.calculatedA4Label.setFont(boldFont);
            this.calculatedUTiltLabel = new JLabel(I18N.getString("tas.core.moveDevicePanel.calculatedUTilt.label"));
            this.calculatedUTiltLabel.setFont(boldFont);
            this.calculatedLTiltLabel = new JLabel(I18N.getString("tas.core.moveDevicePanel.calculatedLTilt.label"));
            this.calculatedLTiltLabel.setFont(boldFont);
            this.calculatedA3ValueLabel = new JLabel(I18N.getString("notAvailableMessage.short"));
            this.calculatedA4ValueLabel = new JLabel(I18N.getString("notAvailableMessage.short"));
            this.calculatedLTiltValueLabel = new JLabel(I18N.getString("notAvailableMessage.short"));
            this.calculatedUTiltValueLabel = new JLabel(I18N.getString("notAvailableMessage.short"));
        }

        public InstalledDevice getDevice() {
            return this.device;
        }

        public JCheckBox getFixCB() {
            return this.fixCB;
        }

        public GoButton getGoBtn() {
            return this.goBtn;
        }

        public JTextField getJogField() {
            return this.jogField;
        }

        public MinusButton getMinusBtn() {
            return this.minusBtn;
        }

        public DeviceNameLabel getNameLabel() {
            return this.nameLabel;
        }

        public PlusButton getPlusBtn() {
            return this.plusBtn;
        }

        public JTextField getTargetField() {
            return this.targetField;
        }

        public DeviceValueLabel getCurrPosLabel() {
            return this.currPosLabel;
        }

        public JTextField getToleranceField() {
            return this.toleranceField;
        }

        public JTextField getToleranceBandTimeField() {
            return this.toleranceBandTimeField;
        }

        public JTextField getmaxWaitTimeField() {
            return this.maxWaitTimeField;
        }

        public ResetToDefaultButton getResetToDefaultValuesButton() {
            return this.resetToDefaultValuesButton;
        }

        public GoButton getTempGoBtn() {
            return this.tempGoButton;
        }

        public GoButton getMagnetGoBtn() {
            return this.magnetGoButton;
        }

        public void setEnvironmentDefaultValues() {
            this.targetField.setText("");
            this.toleranceBandTimeField.setText(PreferencesManager.getPreferenceString("deviceMove.toleranceBandTime"));
            this.maxWaitTimeField.setText(PreferencesManager.getPreferenceString("deviceMove.maxWaitTime"));
            if (this.getDevice() instanceof InstalledTempDevice) {
                this.toleranceField.setText(PreferencesManager.getPreferenceString("deviceMove.toleranceTemp"));
            } else if (this.getDevice() instanceof InstalledMagnetDevice) {
                this.toleranceField.setText(PreferencesManager.getPreferenceString("deviceMove.toleranceBandTime"));
            }
        }

        private boolean CheckEnvironmentTempFields() {
            block15: {
                Double maxWaitTime;
                block14: {
                    Double toleranceBandTime;
                    block13: {
                        Double tolerance;
                        block12: {
                            Double target = 0.0;
                            tolerance = 0.0;
                            toleranceBandTime = 0.0;
                            maxWaitTime = 0.0;
                            Double initialHoldTime = 0.0;
                            try {
                                int targetLength = this.targetField.getText().trim().length();
                                if (targetLength != 0) {
                                    target = Double.valueOf(this.targetField.getText().trim());
                                    break block12;
                                }
                                DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.targetPositionWarning"));
                                return false;
                            }
                            catch (NumberFormatException nfe) {
                                DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.targetPositionWarning"));
                                return false;
                            }
                        }
                        try {
                            int toleranceLength = this.toleranceField.getText().trim().length();
                            if (toleranceLength != 0) {
                                tolerance = Double.valueOf(this.toleranceField.getText().trim());
                                break block13;
                            }
                            DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                            return false;
                        }
                        catch (NumberFormatException nfe) {
                            DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                            return false;
                        }
                    }
                    try {
                        int toleranceBandTimeLength = this.toleranceBandTimeField.getText().trim().length();
                        if (toleranceBandTimeLength != 0) {
                            toleranceBandTime = Double.valueOf(this.toleranceBandTimeField.getText().trim());
                            break block14;
                        }
                        DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceBandTimeWarning"));
                        return false;
                    }
                    catch (NumberFormatException nfe) {
                        DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceBandTimeWarning"));
                        return false;
                    }
                }
                try {
                    int maxWaitTimeLength = this.maxWaitTimeField.getText().trim().length();
                    if (maxWaitTimeLength != 0) {
                        maxWaitTime = Double.valueOf(this.maxWaitTimeField.getText().trim());
                        break block15;
                    }
                    DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.maxWaitTimeWarning"));
                    return false;
                }
                catch (NumberFormatException nfe) {
                    DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.maxWaitTimeWarning"));
                    return false;
                }
            }
            return true;
        }

        private boolean CheckEnvironmentMagnetFields() {
            block7: {
                Double tolerance;
                block6: {
                    Double target = 0.0;
                    tolerance = 0.0;
                    Double initialHoldTime = 0.0;
                    try {
                        int targetLength = this.targetField.getText().trim().length();
                        if (targetLength != 0) {
                            target = Double.valueOf(this.targetField.getText().trim());
                            break block6;
                        }
                        DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.targetPositionWarning"));
                        return false;
                    }
                    catch (NumberFormatException nfe) {
                        DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.targetPositionWarning"));
                        return false;
                    }
                }
                try {
                    int toleranceLength = this.toleranceField.getText().trim().length();
                    if (toleranceLength != 0) {
                        tolerance = Double.valueOf(this.toleranceField.getText().trim());
                        break block7;
                    }
                    DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                    return false;
                }
                catch (NumberFormatException nfe) {
                    DeviceMovePanel.this.throwErrorDialog("Input Error", I18N.getString("sampleEnvironment.toleranceWarning"));
                    return false;
                }
            }
            return true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent de) {
            this.checkTargetValue();
            this.checkJogValue();
        }

        @Override
        public void removeUpdate(DocumentEvent de) {
            this.checkTargetValue();
            this.checkJogValue();
        }

        private void checkTargetValue() {
            boolean errorFlag = false;
            String text = this.targetField.getText();
            if (this.device.isBroken().booleanValue()) {
                errorFlag = true;
                DeviceMovePanel.this.appendErrorMessage(this.targetField, String.valueOf(this.device.getName()) + "is broken");
                return;
            }
            if (text.length() != 0) {
                if (this.device.getName().equals("HKL")) {
                    String strippedText = text.trim();
                    int posOf = -1;
                    posOf = strippedText.indexOf(91);
                    if (posOf != -1 && posOf == 0) {
                        strippedText = strippedText.substring(1);
                    }
                    if ((posOf = strippedText.indexOf(93)) != -1 && posOf == strippedText.length() - 1) {
                        strippedText = strippedText.substring(0, strippedText.length() - 1);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(strippedText, ",");
                    try {
                        float h = Float.parseFloat(tokenizer.nextToken());
                        float k = Float.parseFloat(tokenizer.nextToken());
                        float l = Float.parseFloat(tokenizer.nextToken());
                        StringBuilder commandBuilder = new StringBuilder();
                        commandBuilder.append("ASK CALCA3A4FROMHKLUBMOVE ");
                        commandBuilder.append("ub calcdestination ");
                        commandBuilder.append(h);
                        commandBuilder.append(" ");
                        commandBuilder.append(k);
                        commandBuilder.append(" ");
                        commandBuilder.append(l);
                        DeviceMovePanel.this.sendManager.addMessage(commandBuilder.toString(), false);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                } else {
                    try {
                        double targetValue = Double.parseDouble(text);
                        if (targetValue < this.device.getLowerLimit() || targetValue > this.device.getUpperLimit()) {
                            errorFlag = true;
                            DeviceMovePanel.this.appendErrorMessage(this.targetField, "Target value outside of " + this.device.getName() + "'s limit range!");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        errorFlag = true;
                        DeviceMovePanel.this.appendErrorMessage(this.targetField, "Invalid value in " + this.device.getName() + "'s target field!");
                    }
                }
            }
            if (!errorFlag) {
                DeviceMovePanel.this.removeErrorMessage(this.targetField);
            }
        }

        private void checkJogValue() {
            boolean errorFlag = false;
            if (this.jogField.getText().length() != 0) {
                try {
                    Double.parseDouble(this.jogField.getText());
                }
                catch (NumberFormatException nfe) {
                    errorFlag = true;
                    DeviceMovePanel.this.appendErrorMessage(this.jogField, "Invalid value in " + this.device.getName() + "'s jog field!");
                }
            }
            if (!errorFlag) {
                DeviceMovePanel.this.removeErrorMessage(this.jogField);
            }
        }

        public JComboBox getHorizFocusCB() {
            return this.horizFocusCB;
        }

        public GoButton getSetHorizModeBtn() {
            return this.setHorizModeBtn;
        }

        public GoButton getSetVertModeBtn() {
            return this.setVertModeBtn;
        }

        public JComboBox getVertFocusCB() {
            return this.vertFocusCB;
        }

        @Override
        public void actionPerformed(InstrumentValueChangedEvent pce) {
            if (pce.getPropertyName().equals("horizontalFocusMode")) {
                this.currHorizFocus.setText(pce.getNewValue().toString());
            } else if (pce.getPropertyName().equals("verticalFocusMode")) {
                this.currVertFocus.setText(pce.getNewValue().toString());
            }
        }

        public JLabel getCurrHorizFocus() {
            return this.currHorizFocus;
        }

        public JLabel getCurrVertFocus() {
            return this.currVertFocus;
        }

        public int compareTo(Object object) {
            if (object instanceof DeviceRow) {
                return this.device.compareTo(((DeviceRow)object).getDevice());
            }
            throw new ClassCastException("Can't compare to this object.");
        }

        public JLabel getCalculatedA3Label() {
            return this.calculatedA3Label;
        }

        public JLabel getCalculatedA3ValueLabel() {
            return this.calculatedA3ValueLabel;
        }

        public JLabel getCalculatedA4Label() {
            return this.calculatedA4Label;
        }

        public JLabel getCalculatedA4ValueLabel() {
            return this.calculatedA4ValueLabel;
        }

        public JLabel getCalculatedLTiltLabel() {
            return this.calculatedLTiltLabel;
        }

        public JLabel getCalculatedLTiltValueLabel() {
            return this.calculatedLTiltValueLabel;
        }

        public JLabel getCalculatedUTiltLabel() {
            return this.calculatedUTiltLabel;
        }

        public JLabel getCalculatedUTiltValueLabel() {
            return this.calculatedUTiltValueLabel;
        }

        public JLabel getCalculatedValuesLabel() {
            return this.calculatedValuesLabel;
        }

        public boolean isReadOnlyDevice() {
            return this.readOnlyDevice;
        }

        public void setReadOnlyDevice(boolean readOnlyDevice) {
            this.readOnlyDevice = readOnlyDevice;
            this.enableEditableFields(!readOnlyDevice);
        }

        private class FixDeviceAction
        extends AbstractAction {
            public FixDeviceAction() {
                this.putValue("ShortDescription", "Check this box to prevent the device from being moved during a scan.  You can still move this device directly.");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String fixFreeMessage = "fix ";
                if (!DeviceRow.this.fixCB.isSelected()) {
                    fixFreeMessage = "free ";
                }
                DeviceMovePanel.this.sendManager.addMessage("device " + fixFreeMessage + DeviceRow.this.device.getName());
            }
        }

        private class GoAction
        extends AbstractAction {
            public GoAction() {
                super(I18N.getString("tas.core.moveDevicePanel.driveDeviceToDestination.button"));
                this.putValue("ShortDescription", "Moves the device to the specified location.");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                StringBuilder commandBuilder = new StringBuilder("move ");
                String deviceName = DeviceRow.this.device.getName();
                String targetPos = DeviceRow.this.targetField.getText().trim();
                commandBuilder.append(deviceName);
                commandBuilder.append(" ");
                if (deviceName.equals("HKL")) {
                    commandBuilder.append("\"[");
                    commandBuilder.append(targetPos);
                    commandBuilder.append("]\"");
                } else {
                    commandBuilder.append(targetPos);
                }
                DeviceMovePanel.this.sendManager.addMessage(commandBuilder.toString(), true);
            }
        }

        public class GoButton
        extends ImageButton {
            public GoButton() {
                super(IconManager.getIcon("goButton.normal"), IconManager.getIcon("goButton.rollover"), IconManager.getIcon("goButton.pressed"));
            }
        }

        private class JogMinusAction
        extends AbstractAction {
            public JogMinusAction() {
                this.putValue("Name", "-");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                logger.debug("jog minus");
                String jogStep = DeviceRow.this.jogField.getText().trim();
                DeviceMovePanel.this.sendManager.addMessage("move " + DeviceRow.this.device.getName() + " -" + jogStep + " -relative", true);
            }
        }

        private class JogPlusAction
        extends AbstractAction {
            public JogPlusAction() {
                this.putValue("Name", "+");
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String jogStep = DeviceRow.this.jogField.getText().trim();
                DeviceMovePanel.this.sendManager.addMessage("move " + DeviceRow.this.device.getName() + " " + jogStep + " -relative", true);
            }
        }

        private class MagnetGoActionListener
        implements ActionListener {
            private MagnetGoActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String targetPos = DeviceRow.this.targetField.getText().trim();
                String tolerance = DeviceRow.this.toleranceField.getText().trim();
                if (DeviceRow.this.CheckEnvironmentMagnetFields()) {
                    String message = "move -presetdevicesproperties \"" + DeviceRow.this.device.getName() + " tolerance " + tolerance + "\" " + DeviceRow.this.device.getName() + " " + targetPos;
                    DeviceMovePanel.this.sendManager.addMessage(message, true);
                }
            }
        }

        public class MinusButton
        extends ImageButton {
            public MinusButton() {
                super(IconManager.getIcon("minusButton.normal"), IconManager.getIcon("minusButton.rollover"), IconManager.getIcon("minusButton.pressed"));
            }
        }

        public class PlusButton
        extends ImageButton {
            public PlusButton() {
                super(IconManager.getIcon("plusButton.normal"), IconManager.getIcon("plusButton.rollover"), IconManager.getIcon("plusButton.pressed"));
            }
        }

        private class ResetToDefaultActionListener
        implements ActionListener {
            private ResetToDefaultActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                DeviceRow.this.setEnvironmentDefaultValues();
            }
        }

        public class ResetToDefaultButton
        extends ImageButton {
            public ResetToDefaultButton() {
                super(IconManager.getIcon("resetButton.normal"), IconManager.getIcon("resetButton.rollover"), IconManager.getIcon("resetButton.pressed"));
            }
        }

        private class TempGoActionListener
        implements ActionListener {
            private TempGoActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (DeviceRow.this.CheckEnvironmentTempFields()) {
                    String targetPos = DeviceRow.this.targetField.getText().trim();
                    String tolerance = DeviceRow.this.toleranceField.getText().trim();
                    Double toleranceBandTime = Double.valueOf(DeviceRow.this.toleranceBandTimeField.getText().trim()) * 60.0;
                    Double maxWaitTime = Double.valueOf(DeviceRow.this.maxWaitTimeField.getText().trim()) * 60.0;
                    String message = "move -presetdevicesproperties \"" + DeviceRow.this.device.getName() + " tolerance " + tolerance + ", toleranceDT " + toleranceBandTime + ", timeout " + maxWaitTime + "\" " + DeviceRow.this.device.getName() + " " + targetPos;
                    DeviceMovePanel.this.sendManager.addMessage(message, true);
                }
            }
        }
    }

    public class DeviceRowPanel
    extends JPanel
    implements ActionListener {
        protected String name;
        protected String alias;
        protected JPanel controlPanel;
        protected JPanel childPanel;
        protected GridBagConstraints childPanelGridBagConstraints;
        protected DeviceRow theDeviceRow;
        protected boolean isClientSideDeviceContainer;
        private SizePanelButton shadeButton;
        protected static final String REVMOVE_EVENT_COMMAND = "RemoveEvent";
        protected ArrayList<ActionListener> actionListeners;

        public DeviceRowPanel() {
            this.name = null;
            this.alias = null;
            this.controlPanel = null;
            this.childPanel = null;
            this.childPanelGridBagConstraints = null;
            this.theDeviceRow = null;
            this.isClientSideDeviceContainer = false;
            this.shadeButton = null;
            this.actionListeners = new ArrayList();
            this.init(null);
        }

        public DeviceRowPanel(String deviceName, boolean isClientSideDeviceContainer) {
            this.name = null;
            this.alias = null;
            this.controlPanel = null;
            this.childPanel = null;
            this.childPanelGridBagConstraints = null;
            this.theDeviceRow = null;
            this.isClientSideDeviceContainer = false;
            this.shadeButton = null;
            this.actionListeners = new ArrayList();
            this.setName(deviceName);
            this.isClientSideDeviceContainer = isClientSideDeviceContainer;
            this.init(null);
        }

        private DeviceRowPanel(boolean isDoubleBuffered) {
            super(isDoubleBuffered);
            this.name = null;
            this.alias = null;
            this.controlPanel = null;
            this.childPanel = null;
            this.childPanelGridBagConstraints = null;
            this.theDeviceRow = null;
            this.isClientSideDeviceContainer = false;
            this.shadeButton = null;
            this.actionListeners = new ArrayList();
        }

        public DeviceRowPanel(DeviceRow theDeviceRow) {
            this.name = null;
            this.alias = null;
            this.controlPanel = null;
            this.childPanel = null;
            this.childPanelGridBagConstraints = null;
            this.theDeviceRow = null;
            this.isClientSideDeviceContainer = false;
            this.shadeButton = null;
            this.actionListeners = new ArrayList();
            this.init(theDeviceRow);
        }

        public DeviceRowPanel(DeviceNode deviceNode) {
            this.name = null;
            this.alias = null;
            this.controlPanel = null;
            this.childPanel = null;
            this.childPanelGridBagConstraints = null;
            this.theDeviceRow = null;
            this.isClientSideDeviceContainer = false;
            this.shadeButton = null;
            this.actionListeners = new ArrayList();
            InstalledDevice installedDevice = null;
            DeviceRow deviceRow = null;
            ArrayList<DeviceNode> deviceNodes = null;
            Object theDeviceRowPanel = null;
            boolean readOnlyDevice = false;
            if (deviceNode != null) {
                installedDevice = deviceNode.getInstalledDevice();
                readOnlyDevice = deviceNode.isReadOnlyDevice();
                deviceRow = new DeviceRow(installedDevice);
                deviceRow.setReadOnlyDevice(readOnlyDevice);
                this.init(deviceRow);
                deviceNodes = deviceNode.getChildren();
                this.controlPanel.setVisible(true);
                if (deviceNodes.size() > 0) {
                    this.childPanel.setVisible(true);
                    int i = 0;
                    while (i < deviceNodes.size()) {
                        DeviceNode childNode = null;
                        DeviceRowPanel childPanel = null;
                        childNode = deviceNodes.get(i);
                        childPanel = new DeviceRowPanel(childNode);
                        this.addChild(childPanel);
                        ++i;
                    }
                }
            }
        }

        public DeviceRowPanel(DeviceRow theDeviceRow, boolean isDoubleBuffered) {
            super(isDoubleBuffered);
            this.name = null;
            this.alias = null;
            this.controlPanel = null;
            this.childPanel = null;
            this.childPanelGridBagConstraints = null;
            this.theDeviceRow = null;
            this.isClientSideDeviceContainer = false;
            this.shadeButton = null;
            this.actionListeners = new ArrayList();
            this.init(theDeviceRow);
        }

        @Override
        public String toString() {
            String returnValue = null;
            returnValue = super.toString();
            return returnValue;
        }

        private void init(DeviceRow theDeviceRow) {
            GridBagConstraints gridBagConstraints = null;
            GridBagLayout gridBagLayout = null;
            String tempName = null;
            gridBagConstraints = new GridBagConstraints();
            gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.LIGHT_GRAY));
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weighty = 0.9;
            gridBagConstraints.weightx = 100.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            this.controlPanel = new JPanel();
            gridBagLayout = new GridBagLayout();
            this.controlPanel.setLayout(gridBagLayout);
            this.add((Component)this.controlPanel, gridBagConstraints);
            gridBagConstraints.gridy = 1;
            this.childPanel = new JPanel();
            gridBagLayout = new GridBagLayout();
            this.childPanel.setLayout(gridBagLayout);
            this.add((Component)this.childPanel, gridBagConstraints);
            this.childPanelGridBagConstraints = new GridBagConstraints();
            this.childPanelGridBagConstraints.anchor = 18;
            this.childPanelGridBagConstraints.gridx = 0;
            this.childPanelGridBagConstraints.gridy = -1;
            this.childPanelGridBagConstraints.insets = new Insets(1, 25, 1, 5);
            this.childPanelGridBagConstraints.fill = 1;
            this.childPanelGridBagConstraints.weightx = 100.0;
            this.childPanelGridBagConstraints.weighty = 0.0;
            this.setVisible(false);
            this.childPanel.setVisible(false);
            this.controlPanel.setVisible(false);
            if (theDeviceRow != null || this.isClientSideDeviceContainer) {
                this.buildGUI(theDeviceRow);
                this.childPanel.setVisible(false);
                if (theDeviceRow != null) {
                    this.name = tempName = theDeviceRow.getDevice().getRealNameButReturnAliasIfCounter();
                }
            }
        }

        public void findAnsestorsByName(String name, ArrayList<DeviceRowPanel> ansestors) {
            DeviceRowPanel temp = null;
            String tempsName = null;
            Component[] children = null;
            children = this.childPanel.getComponents();
            int i = 0;
            while (i < children.length) {
                temp = (DeviceRowPanel)children[i];
                tempsName = temp.getName();
                if (tempsName.compareTo(name) == 0) {
                    ansestors.add(temp);
                } else {
                    temp.findAnsestorsByName(name, ansestors);
                }
                ++i;
            }
        }

        public DeviceRowPanel findChildByName(String name) {
            DeviceRowPanel theChild = null;
            DeviceRowPanel temp = null;
            String tempsName = null;
            Component[] children = null;
            children = this.childPanel.getComponents();
            int i = 0;
            while (i < children.length) {
                temp = (DeviceRowPanel)children[i];
                tempsName = temp.getName();
                if (tempsName.compareTo(name) == 0) {
                    theChild = temp;
                    break;
                }
                ++i;
            }
            return theChild;
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListeners.add(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.actionListeners.remove(actionListener);
        }

        public void notifyOfRemoveOrAdd() {
            ActionEvent theEvent = null;
            ActionListener actionListener = null;
            theEvent = new ActionEvent(this, -1, REVMOVE_EVENT_COMMAND);
            int i = 0;
            while (i < this.actionListeners.size()) {
                actionListener = this.actionListeners.get(i);
                actionListener.actionPerformed(theEvent);
                ++i;
            }
        }

        protected void showChildrenBasedOffOfSizePanelButton() {
            if (this.shadeButton != null) {
                TwoStateImageButton.StateEnum theState = null;
                boolean viewChildren = false;
                theState = this.shadeButton.getState();
                viewChildren = theState != TwoStateImageButton.StateEnum.STATEONE;
                this.childPanel.setVisible(viewChildren);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = null;
            boolean viewChildren = false;
            source = e.getSource();
            if (source instanceof DeviceRowPanel) {
                String theCommand = null;
                theCommand = e.getActionCommand();
                if (theCommand.compareTo(REVMOVE_EVENT_COMMAND) == 0) {
                    this.handleRemoveEventFromChild(e);
                }
            }
        }

        protected void handleRemoveEventFromChild(ActionEvent event) {
            Component[] childrensComponents = null;
            boolean showShade = false;
            childrensComponents = this.childPanel.getComponents();
            int i = 0;
            while (i < childrensComponents.length) {
                Component aComponent = null;
                aComponent = childrensComponents[i];
                if (aComponent instanceof DeviceRowPanel) {
                    boolean isControlPanelVisible = false;
                    boolean bl = isControlPanelVisible = ((DeviceRowPanel)aComponent).controlPanel.getComponentCount() > 0;
                    if (isControlPanelVisible) {
                        showShade = true;
                        break;
                    }
                }
                ++i;
            }
            if (showShade) {
                this.activateShade();
            } else {
                this.deactivateShade();
            }
        }

        protected void activateShade() {
            if (this.shadeButton != null) {
                this.shadeButton.setEnabled(true);
                this.showChildrenBasedOffOfSizePanelButton();
            }
        }

        protected void deactivateShade() {
            if (this.shadeButton != null) {
                this.shadeButton.setEnabled(false);
            }
        }

        @Override
        public void removeAll() {
            this.removeChildren();
            this.removeControlPanel();
        }

        public void removeChildren() {
            Component[] children = null;
            this.childPanelGridBagConstraints.gridy = -1;
            children = this.childPanel.getComponents();
            int i = 0;
            while (i < children.length) {
                Component aChild = null;
                aChild = children[i];
                if (aChild instanceof DeviceRowPanel) {
                    DeviceRow deviceRow = ((DeviceRowPanel)aChild).getTheDeviceRow();
                    DeviceMovePanel.this.instrument.removePropertyChangeListener(deviceRow);
                    System.out.println("removed listener ...");
                    ((DeviceRowPanel)aChild).removeAll();
                } else {
                    this.childPanel.remove(aChild);
                }
                ++i;
            }
            this.childPanel.setVisible(false);
            this.notifyOfRemoveOrAdd();
        }

        public int getNumberOfChildren() {
            int returnValue = -1;
            Component[] components = null;
            components = this.childPanel.getComponents();
            returnValue = components.length;
            return returnValue;
        }

        public void removeChildFromPanel(int index) {
            Component[] components = null;
            components = this.childPanel.getComponents();
            if (components != null && index > -1 && index < components.length) {
                DeviceRowPanel deviceToRemove = null;
                deviceToRemove = this.findChildByIndex(index);
                if (deviceToRemove != null) {
                    DeviceRowPanel deviceRowPanel = null;
                    GridBagConstraints gridBagConstraints = null;
                    GridBagLayout gridBagLayout = null;
                    gridBagLayout = (GridBagLayout)this.childPanel.getLayout();
                    gridBagConstraints = gridBagLayout.getConstraints(deviceToRemove);
                    int i = 0;
                    while (i < components.length) {
                        deviceRowPanel = (DeviceRowPanel)components[i];
                        gridBagConstraints = gridBagLayout.getConstraints(deviceRowPanel);
                        if (gridBagConstraints.gridy > index) {
                            --gridBagConstraints.gridy;
                            gridBagLayout.setConstraints(deviceRowPanel, gridBagConstraints);
                        }
                        ++i;
                    }
                    DeviceRow deviceRow = deviceToRemove.getTheDeviceRow();
                    DeviceMovePanel.this.instrument.removePropertyChangeListener(deviceRow);
                    System.out.println("removed listener ...");
                    this.childPanel.remove(deviceToRemove);
                    this.grabFocus();
                    this.childPanel.repaint();
                    --this.childPanelGridBagConstraints.gridy;
                }
            }
        }

        public void addChild(DeviceRowPanel child) {
            boolean isControlPanelVisible = false;
            ++this.childPanelGridBagConstraints.gridy;
            this.childPanel.add((Component)child, this.childPanelGridBagConstraints);
            this.childPanel.setVisible(true);
            boolean bl = isControlPanelVisible = child.controlPanel.getComponentCount() > 0;
            if (isControlPanelVisible) {
                this.activateShade();
            }
            child.addActionListener(this);
        }

        public void addChildToTopOfChildPanel(DeviceRow theDeviceToAdd) {
            if (theDeviceToAdd != null) {
                Component[] components = null;
                GridBagConstraints gridBagConstraints = null;
                DeviceRowPanel aDevicePanel = null;
                GridBagLayout gridBagLayout = null;
                DeviceRowPanel deviceRowPanel = null;
                components = this.childPanel.getComponents();
                gridBagLayout = (GridBagLayout)this.childPanel.getLayout();
                int i = 0;
                while (i < components.length) {
                    aDevicePanel = (DeviceRowPanel)components[i];
                    gridBagConstraints = gridBagLayout.getConstraints(aDevicePanel);
                    ++gridBagConstraints.gridy;
                    gridBagLayout.setConstraints(aDevicePanel, gridBagConstraints);
                    ++i;
                }
                ++this.childPanelGridBagConstraints.gridy;
                gridBagConstraints = (GridBagConstraints)this.childPanelGridBagConstraints.clone();
                gridBagConstraints.gridy = 0;
                deviceRowPanel = new DeviceRowPanel(theDeviceToAdd);
                this.childPanel.setVisible(true);
                this.childPanel.add((Component)deviceRowPanel, gridBagConstraints);
            }
        }

        public void addChildToBottomOfChildPanel(DeviceRow deviceRow) {
            if (deviceRow != null) {
                DeviceRowPanel deviceRowPanel = null;
                deviceRowPanel = new DeviceRowPanel(deviceRow);
                this.addChildToBottomOfChildPanel(deviceRowPanel);
            }
        }

        public void addChildToBottomOfChildPanel(DeviceRowPanel theDeviceToAdd) {
            this.addChild(theDeviceToAdd);
        }

        public void addChildAt(DeviceRow deviceRow, int index) {
            if (deviceRow != null) {
                DeviceRowPanel deviceRowPanel = null;
                StructuredDeviceList structuredDeviceList = null;
                DeviceNode deviceNode = null;
                String deviceName = null;
                InstalledDevice installedDevice = null;
                if (deviceRow != null && (installedDevice = deviceRow.getDevice()) != null) {
                    deviceName = installedDevice.getRealNameButReturnAliasIfCounter();
                    structuredDeviceList = StructuredDeviceList.getInstance();
                    deviceNode = structuredDeviceList.getNodeByName(deviceName);
                    deviceRowPanel = new DeviceRowPanel(deviceNode);
                    this.addChildAt(deviceRowPanel, index);
                }
            }
        }

        public void addChildAt(DeviceRowPanel theDeviceToAdd, int index) {
            if (theDeviceToAdd != null) {
                Component[] components = null;
                components = this.childPanel.getComponents();
                if (components != null && index > -1 && index < components.length) {
                    DeviceRowPanel aDevicePanel = null;
                    GridBagLayout gridBagLayout = null;
                    GridBagConstraints gridBagConstraints = null;
                    gridBagLayout = (GridBagLayout)this.childPanel.getLayout();
                    int i = 0;
                    while (i < components.length) {
                        aDevicePanel = (DeviceRowPanel)components[i];
                        gridBagConstraints = gridBagLayout.getConstraints(aDevicePanel);
                        if (gridBagConstraints.gridy >= index) {
                            ++gridBagConstraints.gridy;
                            gridBagLayout.setConstraints(aDevicePanel, gridBagConstraints);
                        }
                        ++i;
                    }
                    gridBagConstraints.gridy = index;
                    this.childPanel.setVisible(true);
                    this.childPanel.add((Component)theDeviceToAdd, gridBagConstraints);
                    ++this.childPanelGridBagConstraints.gridy;
                } else {
                    this.addChildToBottomOfChildPanel(theDeviceToAdd);
                }
            }
        }

        public DeviceRowPanel findChildByIndex(int index) {
            DeviceRowPanel thePanel = null;
            Component[] components = null;
            components = this.childPanel.getComponents();
            if (index > -1 && index < components.length) {
                GridBagLayout gridBagLayout = null;
                DeviceRowPanel tempPanel = null;
                GridBagConstraints gridBagConstraints = null;
                gridBagLayout = (GridBagLayout)this.childPanel.getLayout();
                int i = 0;
                while (i < components.length) {
                    tempPanel = (DeviceRowPanel)components[i];
                    gridBagConstraints = gridBagLayout.getConstraints(tempPanel);
                    if (gridBagConstraints.gridy == index) {
                        thePanel = tempPanel;
                        break;
                    }
                    ++i;
                }
            }
            return thePanel;
        }

        public void moveChildUpOne(int index) {
            Component[] components = null;
            components = this.childPanel.getComponents();
            if (components.length > 0 && index > 0 && index < components.length) {
                DeviceRowPanel panelToMoveUp = null;
                DeviceRowPanel panelToMoveDown = null;
                GridBagLayout gridBagLayout = null;
                GridBagConstraints constraintsToMoveUp = null;
                GridBagConstraints constraintsToMoveDown = null;
                panelToMoveUp = this.findChildByIndex(index);
                if (panelToMoveUp != null && (panelToMoveDown = this.findChildByIndex(index - 1)) != null) {
                    gridBagLayout = (GridBagLayout)this.childPanel.getLayout();
                    constraintsToMoveUp = gridBagLayout.getConstraints(panelToMoveUp);
                    --constraintsToMoveUp.gridy;
                    constraintsToMoveDown = gridBagLayout.getConstraints(panelToMoveDown);
                    ++constraintsToMoveDown.gridy;
                    this.childPanel.remove(panelToMoveUp);
                    this.childPanel.remove(panelToMoveDown);
                    this.childPanel.add((Component)panelToMoveUp, constraintsToMoveUp);
                    this.childPanel.add((Component)panelToMoveDown, constraintsToMoveDown);
                }
            }
        }

        public void moveChildDownOne(int index) {
            Component[] components = null;
            components = this.childPanel.getComponents();
            if (components.length > 0 && index > -1 && index < components.length - 1) {
                DeviceRowPanel panelToMoveUp = null;
                DeviceRowPanel panelToMoveDown = null;
                GridBagLayout gridBagLayout = null;
                GridBagConstraints constraintsToMoveUp = null;
                GridBagConstraints constraintsToMoveDown = null;
                panelToMoveUp = this.findChildByIndex(index + 1);
                if (panelToMoveUp != null && (panelToMoveDown = this.findChildByIndex(index)) != null) {
                    gridBagLayout = (GridBagLayout)this.childPanel.getLayout();
                    constraintsToMoveUp = gridBagLayout.getConstraints(panelToMoveUp);
                    --constraintsToMoveUp.gridy;
                    constraintsToMoveDown = gridBagLayout.getConstraints(panelToMoveDown);
                    ++constraintsToMoveDown.gridy;
                    this.childPanel.remove(panelToMoveUp);
                    this.childPanel.remove(panelToMoveDown);
                    this.childPanel.add((Component)panelToMoveUp, constraintsToMoveUp);
                    this.childPanel.add((Component)panelToMoveDown, constraintsToMoveDown);
                }
            }
        }

        public void removeControlPanel() {
            this.setVisible(false);
            this.controlPanel.removeAll();
            this.controlPanel.setVisible(false);
            this.notifyOfRemoveOrAdd();
        }

        public void reAddFromDeviceNode(DeviceNode deviceNode) {
            InstalledDevice installedDevice = null;
            DeviceRow deviceRow = null;
            ArrayList<DeviceNode> deviceNodes = null;
            if (deviceNode != null) {
                boolean readOnlyDevice = false;
                installedDevice = deviceNode.getInstalledDevice();
                readOnlyDevice = deviceNode.isReadOnlyDevice();
                deviceRow = new DeviceRow(installedDevice);
                deviceRow.setReadOnlyDevice(readOnlyDevice);
                this.buildGUI(deviceRow);
                deviceNodes = deviceNode.getChildren();
                this.controlPanel.setVisible(true);
                if (deviceNodes.size() > 0) {
                    this.childPanel.setVisible(true);
                    int i = 0;
                    while (i < deviceNodes.size()) {
                        DeviceNode childNode = null;
                        DeviceRowPanel childPanel = null;
                        String deviceName = null;
                        childNode = deviceNodes.get(i);
                        deviceName = childNode.getName();
                        childPanel = this.findChildByName(deviceName);
                        childPanel.reAddFromDeviceNode(childNode);
                        ++i;
                    }
                }
                this.notifyOfRemoveOrAdd();
            }
        }

        private void buildGUI(DeviceRow theDeviceRow) {
            GridBagConstraints gridBagConstraints = null;
            SizePanelButton sizePanelButton = null;
            JPanel tempBorderPanel = null;
            Insets insets = null;
            Insets subInsets = null;
            InstalledDevice installedDevice = null;
            this.setVisible(true);
            this.controlPanel.setVisible(true);
            this.theDeviceRow = theDeviceRow;
            insets = new Insets(0, 5, 0, 5);
            subInsets = new Insets(0, 1, 0, 1);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            sizePanelButton = new SizePanelButton();
            this.controlPanel.add((Component)sizePanelButton, gridBagConstraints);
            sizePanelButton.addActionListener(this);
            this.shadeButton = sizePanelButton;
            if (!this.isClientSideDeviceContainer) {
                boolean readOnlyDevice = false;
                installedDevice = theDeviceRow.getDevice();
                readOnlyDevice = theDeviceRow.isReadOnlyDevice();
                this.alias = installedDevice.getAlias();
                gridBagConstraints.gridx = 1;
                this.controlPanel.add((Component)theDeviceRow.getNameLabel(), gridBagConstraints);
                gridBagConstraints.gridx = 2;
                this.controlPanel.add((Component)theDeviceRow.getCurrPosLabel(), gridBagConstraints);
                if (!readOnlyDevice) {
                    JPanel propertiesPanel;
                    tempBorderPanel = new JPanel();
                    tempBorderPanel.setLayout(new GridBagLayout());
                    tempBorderPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(176, 196, 222)), "Target Position:"));
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.insets = subInsets;
                    tempBorderPanel.add((Component)theDeviceRow.getTargetField(), gridBagConstraints);
                    gridBagConstraints.gridx = 1;
                    if (theDeviceRow.getDevice() instanceof InstalledTempDevice || theDeviceRow.getDevice() instanceof InstalledMagnetDevice) {
                        tempBorderPanel.add((Component)new JLabel(), gridBagConstraints);
                    } else {
                        tempBorderPanel.add((Component)theDeviceRow.getGoBtn(), gridBagConstraints);
                    }
                    gridBagConstraints.insets = insets;
                    gridBagConstraints.gridx = 3;
                    this.controlPanel.add((Component)tempBorderPanel, gridBagConstraints);
                    if (!theDeviceRow.getDevice().getName().equals("HKL")) {
                        JPanel subPanel = new JPanel(new GridBagLayout());
                        subPanel.setName(this.controlPanel.getName());
                        subPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(176, 196, 222)), "Jog:"));
                        gridBagConstraints.gridy = 0;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.insets = subInsets;
                        subPanel.add((Component)theDeviceRow.getMinusBtn(), gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        subPanel.add((Component)theDeviceRow.getJogField(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        subPanel.add((Component)theDeviceRow.getPlusBtn(), gridBagConstraints);
                        gridBagConstraints.insets = insets;
                        gridBagConstraints.gridx = 4;
                        this.controlPanel.add((Component)subPanel, gridBagConstraints);
                        gridBagConstraints.gridx = 5;
                        this.controlPanel.add((Component)theDeviceRow.getFixCB(), gridBagConstraints);
                    }
                    gridBagConstraints.gridy = 1;
                    gridBagConstraints.gridx = 0;
                    if (theDeviceRow.getDevice().getName().equals("A1")) {
                        propertiesPanel = new JPanel(new GridBagLayout());
                        Font boldFont = null;
                        JLabel tempLabel = null;
                        gridBagConstraints.gridy = 0;
                        gridBagConstraints.gridx = 0;
                        tempLabel = new JLabel("Horizontal Focus:");
                        boldFont = tempLabel.getFont().deriveFont(1);
                        tempLabel.setFont(boldFont);
                        propertiesPanel.add((Component)tempLabel, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel.add((Component)theDeviceRow.getCurrHorizFocus(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel.add((Component)theDeviceRow.getHorizFocusCB(), gridBagConstraints);
                        gridBagConstraints.gridx = 3;
                        propertiesPanel.add((Component)theDeviceRow.getSetHorizModeBtn(), gridBagConstraints);
                        gridBagConstraints.gridy = 2;
                        gridBagConstraints.gridx = 0;
                        tempLabel = new JLabel("Vertical Focus:");
                        propertiesPanel.add((Component)tempLabel, gridBagConstraints);
                        tempLabel.setFont(boldFont);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel.add((Component)theDeviceRow.getCurrVertFocus(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel.add((Component)theDeviceRow.getVertFocusCB(), gridBagConstraints);
                        gridBagConstraints.gridx = 3;
                        propertiesPanel.add((Component)theDeviceRow.getSetVertModeBtn(), gridBagConstraints);
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.gridwidth = 0;
                        this.controlPanel.add((Component)propertiesPanel, gridBagConstraints);
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridwidth = 1;
                    } else if (theDeviceRow.getDevice().getName().equals("HKL")) {
                        JPanel calculatedValuesPanel = new JPanel();
                        calculatedValuesPanel.setLayout(new BoxLayout(calculatedValuesPanel, 0));
                        calculatedValuesPanel.add(Box.createHorizontalStrut(15));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedValuesLabel());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(50));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedA3Label());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(2));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedA3ValueLabel());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(10));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedA4Label());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(2));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedA4ValueLabel());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(10));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedLTiltLabel());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(2));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedLTiltValueLabel());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(10));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedUTiltLabel());
                        calculatedValuesPanel.add(Box.createHorizontalStrut(2));
                        calculatedValuesPanel.add(theDeviceRow.getCalculatedUTiltValueLabel());
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.gridwidth = 0;
                        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
                        this.controlPanel.add((Component)calculatedValuesPanel, gridBagConstraints);
                        gridBagConstraints.insets = insets;
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridwidth = 1;
                    } else if (theDeviceRow.getDevice() instanceof InstalledTempDevice) {
                        propertiesPanel = new JPanel(new GridBagLayout());
                        Font boldFont = null;
                        JLabel tempLabel = null;
                        gridBagConstraints.gridy = 0;
                        gridBagConstraints.gridx = 0;
                        tempLabel = new JLabel("Tolerance(" + theDeviceRow.getDevice().getUnits() + "):");
                        boldFont = tempLabel.getFont().deriveFont(1);
                        tempLabel.setFont(boldFont);
                        propertiesPanel.add((Component)tempLabel, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel.add((Component)theDeviceRow.getToleranceField(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 3;
                        tempLabel = new JLabel("Tolerance Band Time(minutes):");
                        tempLabel.setFont(boldFont);
                        propertiesPanel.add((Component)tempLabel, gridBagConstraints);
                        gridBagConstraints.gridx = 4;
                        propertiesPanel.add((Component)theDeviceRow.getToleranceBandTimeField(), gridBagConstraints);
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridx = 0;
                        tempLabel = new JLabel("Max Wait Time(minutes):");
                        tempLabel.setFont(boldFont);
                        propertiesPanel.add((Component)tempLabel, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel.add((Component)theDeviceRow.getmaxWaitTimeField(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 3;
                        gridBagConstraints.gridy = 2;
                        gridBagConstraints.gridx = 0;
                        propertiesPanel.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 3;
                        propertiesPanel.add((Component)theDeviceRow.getResetToDefaultValuesButton(), gridBagConstraints);
                        gridBagConstraints.gridx = 4;
                        propertiesPanel.add((Component)theDeviceRow.getTempGoBtn(), gridBagConstraints);
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.gridwidth = 0;
                        this.controlPanel.add((Component)propertiesPanel, gridBagConstraints);
                        gridBagConstraints.gridx = 0;
                        gridBagConstraints.gridwidth = 1;
                        theDeviceRow.setEnvironmentDefaultValues();
                    } else if (theDeviceRow.getDevice() instanceof InstalledMagnetDevice) {
                        Font boldFont = null;
                        JLabel tempLabel = null;
                        JPanel propertiesPanel2 = new JPanel(new GridBagLayout());
                        gridBagConstraints.gridy = 0;
                        gridBagConstraints.gridx = 0;
                        tempLabel = new JLabel("Tolerance(" + theDeviceRow.getDevice().getUnits() + "):");
                        boldFont = tempLabel.getFont().deriveFont(1);
                        tempLabel.setFont(boldFont);
                        propertiesPanel2.add((Component)tempLabel, gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel2.add((Component)theDeviceRow.getToleranceField(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel2.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridx = 0;
                        propertiesPanel2.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 1;
                        propertiesPanel2.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 2;
                        propertiesPanel2.add((Component)new JLabel(), gridBagConstraints);
                        gridBagConstraints.gridx = 3;
                        propertiesPanel2.add((Component)theDeviceRow.getResetToDefaultValuesButton(), gridBagConstraints);
                        gridBagConstraints.gridx = 4;
                        propertiesPanel2.add((Component)theDeviceRow.getMagnetGoBtn(), gridBagConstraints);
                        gridBagConstraints.gridy = 1;
                        gridBagConstraints.gridx = 1;
                        gridBagConstraints.gridwidth = 7;
                        this.controlPanel.add((Component)propertiesPanel2, gridBagConstraints);
                        gridBagConstraints.gridwidth = 1;
                        theDeviceRow.setEnvironmentDefaultValues();
                    }
                }
            } else {
                JLabel nameLabel = null;
                Font font = null;
                Font boldFont = null;
                gridBagConstraints.gridx = 1;
                nameLabel = new JLabel(this.name);
                font = nameLabel.getFont();
                boldFont = font.deriveFont(1);
                nameLabel.setFont(boldFont);
                this.controlPanel.add((Component)nameLabel, gridBagConstraints);
            }
            this.setVisible(true);
        }

        public DeviceRow getTheDeviceRow() {
            return this.theDeviceRow;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        public class SizePanelButton
        extends TwoStateImageButton {
            private static final long serialVersionUID = 1L;
            protected ImageIcon deativatedImage;

            public SizePanelButton() {
                super(IconManager.getIcon("downShade.normal"), IconManager.getIcon("downShade.rollover"), IconManager.getIcon("downShade.pressed"), IconManager.getIcon("upShade.normal"), IconManager.getIcon("upShade.rollover"), IconManager.getIcon("upShade.pressed"));
                this.deativatedImage = null;
                this.setEnabled(false);
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.activeImage = enabled ? this.normalImage : this.deativatedImage;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                TwoStateImageButton.StateEnum theState = null;
                boolean viewChildren = false;
                theState = this.getState();
                viewChildren = theState != TwoStateImageButton.StateEnum.STATEONE;
                DeviceRowPanel.this.childPanel.setVisible(viewChildren);
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mouseEntered(me);
                }
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                if (this.isEnabled()) {
                    super.mouseExited(arg0);
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mouseMoved(me);
                }
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mousePressed(me);
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (this.isEnabled()) {
                    super.mouseReleased(me);
                }
            }
        }
    }

    private class LockToggleRunnable
    implements Runnable {
        private boolean locked;

        public LockToggleRunnable(boolean locked) {
            this.locked = locked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void toggle(JPanel panel) {
            Component[] components;
            DeviceRow deviceRow;
            boolean returnValue = false;
            if (panel instanceof DeviceRowPanel && (deviceRow = ((DeviceRowPanel)panel).getTheDeviceRow()) != null) {
                deviceRow.getGoBtn().setEnabled(!this.locked);
                deviceRow.getMinusBtn().setEnabled(!this.locked);
                deviceRow.getPlusBtn().setEnabled(!this.locked);
                deviceRow.getFixCB().setEnabled(!this.locked);
                deviceRow.getSetHorizModeBtn().setEnabled(!this.locked);
                deviceRow.getSetVertModeBtn().setEnabled(!this.locked);
            }
            Component[] componentArray = components = panel.getComponents();
            synchronized (components) {
                if (components != null) {
                    Component[] componentArray2 = components;
                    int n = components.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component component = componentArray2[n2];
                        if (component instanceof JPanel) {
                            this.toggle((JPanel)component);
                        }
                        ++n2;
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedHashMap linkedHashMap = DeviceMovePanel.this.groupList;
            synchronized (linkedHashMap) {
                Set panels = DeviceMovePanel.this.groupList.keySet();
                for (JPanel aPanel : panels) {
                    if (!(aPanel instanceof DeviceRowPanel)) continue;
                    this.toggle((DeviceRowPanel)aPanel);
                }
            }
        }
    }

    public class SetHKLFromUBCalcDestinationResponseEvent
    implements Runnable {
        protected String a3;
        protected String a4;
        protected String lTilt;
        protected String uTilt;

        public SetHKLFromUBCalcDestinationResponseEvent(UBCalcDestinationResponseEvent evt) {
            this.a3 = String.valueOf(evt.getA3());
            this.a4 = String.valueOf(evt.getA4());
            this.lTilt = String.valueOf(evt.getLTilt());
            this.uTilt = String.valueOf(evt.getUTilt());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean findAndSetHKL(JPanel panel) {
            InstalledDevice installedDevice;
            String deviceName;
            DeviceRowPanel deviceRowPanel;
            DeviceRow deviceRow;
            boolean returnValue = false;
            Component[] components = null;
            if (panel instanceof DeviceRowPanel && (deviceRow = (deviceRowPanel = (DeviceRowPanel)panel).getTheDeviceRow()) != null && (deviceName = (installedDevice = deviceRow.getDevice()).getName()).equalsIgnoreCase("HKL")) {
                deviceRow.getCalculatedA3ValueLabel().setText(this.a3);
                deviceRow.getCalculatedA4ValueLabel().setText(this.a4);
                deviceRow.getCalculatedLTiltValueLabel().setText(this.lTilt);
                deviceRow.getCalculatedUTiltValueLabel().setText(this.uTilt);
                return true;
            }
            Component[] componentArray = components = panel.getComponents();
            synchronized (components) {
                if (components != null) {
                    Component[] componentArray2 = components;
                    int n = components.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component component = componentArray2[n2];
                        if (component instanceof JPanel && (returnValue = this.findAndSetHKL((JPanel)component))) break;
                        ++n2;
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return returnValue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedHashMap linkedHashMap = DeviceMovePanel.this.groupList;
            synchronized (linkedHashMap) {
                Set panels = DeviceMovePanel.this.groupList.keySet();
                for (JPanel aPanel : panels) {
                    if (!(aPanel instanceof DeviceRowPanel)) continue;
                    this.findAndSetHKL((DeviceRowPanel)aPanel);
                }
            }
        }
    }

    private class TabListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private TabListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setOpaque(true);
            if (value instanceof JPanel) {
                this.setForeground(isSelected ? list.getSelectionForeground() : Color.blue);
                this.setText(((JPanel)value).getName());
            } else {
                this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
                this.setText(value.toString());
            }
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this;
        }
    }
}

