/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.panel;

import ice.Global;
import ice.data.BaseScan;
import ice.data.IceFileType;
import ice.data.Resource;
import ice.exceptions.IcePanelException;
import ice.gui.tas.bt7.scan.BaseScanPanel;
import ice.swing.Bag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class AngleScanPanel
extends BaseScanPanel {
    JRadioButton scanModeThetaRB;
    JRadioButton scanModeTwoThetaRB;
    JRadioButton scanModeThetaTwoThetaRB;
    ButtonGroup buttonGrp;

    public AngleScanPanel(Resource scan) throws IcePanelException {
        super((BaseScan)scan);
        logger.debug("Editing angle scan");
    }

    @Override
    protected void init() {
        this.scanModeThetaRB = new JRadioButton(new ScanA3Action());
        this.scanModeTwoThetaRB = new JRadioButton(new ScanA4Action());
        this.scanModeThetaTwoThetaRB = new JRadioButton(new ScanA3A4Action());
        this.buttonGrp = new ButtonGroup();
        this.buttonGrp.add(this.scanModeThetaRB);
        this.buttonGrp.add(this.scanModeTwoThetaRB);
        this.buttonGrp.add(this.scanModeThetaTwoThetaRB);
        this.scanModeThetaRB.setSelected(true);
        this.createPanels();
    }

    @Override
    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        Bag constraints = new Bag();
        int x = 0;
        int y = 0;
        JLabel instructionsLabel = new JLabel("<html>Setup for an angular scan (theta, two-theta, theta/two-theta).</html>");
        this.add((Component)instructionsLabel, constraints.cell(x, y));
        this.add((Component)this.instrumentPanel, constraints.cell(x, ++y));
        this.add((Component)this.envPanel, constraints.cell(x, ++y));
        constraints.fill = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        this.add((Component)this.descrPanel, constraints.cellWithoutReset(x, ++y));
        this.add((Component)this.btnPanel, constraints.cell(x, ++y));
    }

    @Override
    public void loadResource() {
        if (this.resource != null && this.resource instanceof BaseScan) {
            this.loadPanels((BaseScan)this.resource);
        }
    }

    @Override
    public void updateAdditionalDevices() {
        this.instrumentPanel = this.createInstrumentPanel();
        this.removeAll();
        this.buildGUI();
        this.invalidate();
    }

    public static IceFileType[] getSupportedFileTypes() {
        IceFileType[] fileTypes = new IceFileType[]{IceFileType.angleScan};
        return fileTypes;
    }

    @Override
    protected JPanel createInstrumentPanel() {
        this.addSingleDeviceEditable("A3", Global.degreeSign(), true);
        this.addSingleDeviceEditable("A4", Global.degreeSign(), false);
        JLabel leftSpacer = new JLabel("");
        JLabel rightSpacer = new JLabel("");
        int x = 0;
        int y = 0;
        JPanel instrumentPanel = new JPanel(new GridBagLayout());
        instrumentPanel.setBorder(BorderFactory.createTitledBorder("Instrument"));
        Bag instrumentConstraints = new Bag();
        int maxCols = 8;
        instrumentPanel.add((Component)leftSpacer, instrumentConstraints.cell(x, y).fillx(1.0));
        instrumentPanel.add((Component)this.modePanel, instrumentConstraints.cell(++x, y).colspan(maxCols));
        instrumentPanel.add((Component)rightSpacer, instrumentConstraints.cell(x += maxCols, y).fillx(1.0));
        x = 1;
        ++y;
        JLabel spacer = new JLabel("");
        Dimension d = spacer.getPreferredSize();
        double height = d.getHeight();
        d.setSize(135.0, height);
        spacer.setPreferredSize(d);
        instrumentPanel.add((Component)spacer, instrumentConstraints.cell(x, y));
        instrumentPanel.add((Component)this.column1Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column2Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column3Label, instrumentConstraints.cell(++x, y));
        instrumentPanel.add((Component)this.column4Label, instrumentConstraints.cell(++x, y));
        JLabel unitLabel = this.createLabel("Units    ", 2);
        instrumentPanel.add((Component)unitLabel, instrumentConstraints.cell(++x, y));
        JLabel spacer2 = new JLabel("");
        d = spacer2.getPreferredSize();
        height = d.getHeight();
        d.setSize(40.0, height);
        spacer2.setPreferredSize(d);
        instrumentPanel.add((Component)spacer2, instrumentConstraints.cell(++x, y));
        x = 1;
        Insets defaultInsets = new Insets(instrumentConstraints.insets.top, instrumentConstraints.insets.left, instrumentConstraints.insets.bottom, instrumentConstraints.insets.right);
        Insets unitInsets = new Insets(defaultInsets.top, 0, defaultInsets.bottom, defaultInsets.right);
        instrumentPanel.add((Component)this.scanModeThetaRB, instrumentConstraints.cell(x, ++y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        x = 1;
        instrumentPanel.add((Component)this.scanModeTwoThetaRB, instrumentConstraints.cell(x, ++y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        instrumentPanel.add((Component)((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
        x = 1;
        instrumentPanel.add((Component)this.scanModeThetaTwoThetaRB, instrumentConstraints.cell(x, ++y).inset(defaultInsets));
        x = 0;
        instrumentConstraints.inset(defaultInsets);
        int size = this.scanEntries_add.size();
        instrumentPanel.add((Component)new JSeparator(), instrumentConstraints.cell(x, ++y).colspan(maxCols));
        instrumentPanel.add((Component)this.createLabel("Additional Devices", 2), instrumentConstraints.cell(x, ++y).colspan(maxCols));
        ++y;
        x = 1;
        for (BaseScanPanel.ScanEntry entry : this.scanEntries_add) {
            instrumentPanel.add((Component)entry.getComboBox(), instrumentConstraints.cell(x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getFirstField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getSecondField(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getInfoLabel1(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getInfoLabel2(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getUnitLabel(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            instrumentPanel.add((Component)entry.getDeleteButton(), instrumentConstraints.cell(++x, y).inset(defaultInsets));
            ++x;
            ++y;
            x = 1;
        }
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new BoxLayout(subPanel, 2));
        subPanel.add(new JButton(new AddDeviceAction()));
        instrumentConstraints.inset(defaultInsets);
        instrumentPanel.add((Component)subPanel, instrumentConstraints.cell(x, y).colspan(maxCols));
        x = 0;
        instrumentPanel.add((Component)this.parameterPanel, instrumentConstraints.cell(x, ++y).colspan(maxCols + 2));
        return instrumentPanel;
    }

    @Override
    protected void loadInstrumentPanel(BaseScan input) {
        HashMap<String, BaseScan.Range> devHash = input.getDeviceRanges();
        Set<String> ranges = devHash.keySet();
        boolean foundA3 = false;
        boolean foundA4 = false;
        Iterator<String> riter = ranges.iterator();
        while (riter.hasNext()) {
            boolean skipit = false;
            String dev = riter.next();
            for (BaseScanPanel.ScanEntry entry : this.scanEntries) {
                if (dev.compareToIgnoreCase(entry.getName()) != 0) continue;
                entry.getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
                entry.getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
                skipit = true;
                if (dev.compareToIgnoreCase("A3") == 0) {
                    foundA3 = true;
                    continue;
                }
                if (dev.compareToIgnoreCase("A4") != 0) continue;
                foundA4 = true;
            }
            if (skipit) continue;
            this.createAdditionalDevice();
            boolean found = false;
            int size = this.scanEntries_add.size();
            int j = 0;
            while (j < ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().getItemCount()) {
                if (dev.compareToIgnoreCase(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().getItemAt(j).toString()) == 0) {
                    ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getComboBox().setSelectedIndex(j);
                    found = true;
                }
                ++j;
            }
            if (!found) {
                BaseScanPanel.RemoveAdditionalItem action = new BaseScanPanel.RemoveAdditionalItem(this, size - 1);
                action.run();
                continue;
            }
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getFirstField().setText(new Double(devHash.get(dev).getFirstValue()).toString());
            ((BaseScanPanel.ScanEntry)this.scanEntries_add.get(size - 1)).getSecondField().setText(new Double(devHash.get(dev).getSecondValue()).toString());
        }
        if (foundA3 && foundA4) {
            this.scanModeThetaTwoThetaRB.setSelected(true);
            new ScanA3A4Action().actionPerformed(null);
        } else if (foundA3) {
            this.scanModeThetaRB.setSelected(true);
            new ScanA3Action().actionPerformed(null);
        } else if (foundA4) {
            this.scanModeTwoThetaRB.setSelected(true);
            new ScanA4Action().actionPerformed(null);
        }
        this.instrumentPanel = this.createInstrumentPanel();
    }

    @Override
    protected void clearFields() {
        this.clearScanDescriptionPanel();
        this.clearParameterPanel();
        this.clearEnvironmentPanel();
        int i = 0;
        while (i < this.scanEntries.size()) {
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getFirstField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getSecondField().setText("");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getInfoLabel1().setText("N/A");
            ((BaseScanPanel.ScanEntry)this.scanEntries.get(i)).getInfoLabel2().setText("N/A");
            ++i;
        }
    }

    @Override
    protected String getDescr() {
        int i;
        ArrayList<Double> secondList;
        ArrayList<Double> firstList;
        ArrayList<String> nameList;
        String tag;
        String scanDescr;
        String comments;
        block17: {
            String envProperties = this.getEnvironmentDescr();
            String scanName = this.scanNameField.getText().trim();
            if (scanName.length() == 0) {
                logger.debug("No scan name entered.  Save cancelled.");
                this.throwErrorDialog("Incomplete Description", "Please specify a scan name.");
                return "";
            }
            comments = this.commentsTextArea.getText();
            String prefix = this.prefixField.getText();
            String params = this.getParamDescr();
            if (params == null) {
                return "";
            }
            scanDescr = "Scan:SubID=" + this.exptID + ":JType=ANGLE";
            scanDescr = scanDescr.concat(params);
            if (prefix.length() > 0) {
                scanDescr = scanDescr.concat(":Filename=" + prefix);
            }
            tag = "";
            if (this.mode == 0) {
                tag = " s";
            } else if (this.mode == 1) {
                tag = " i";
            }
            if (envProperties.equals("")) {
                return "";
            }
            if (!envProperties.equals("noSetPoint")) {
                scanDescr = scanDescr.concat(envProperties);
            }
            nameList = new ArrayList<String>();
            firstList = new ArrayList<Double>();
            secondList = new ArrayList<Double>();
            if (this.scanModeThetaRB.isSelected()) {
                nameList.add("A3");
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getSecondField().getText().trim()));
                break block17;
            }
            if (this.scanModeTwoThetaRB.isSelected()) {
                nameList.add("A4");
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getSecondField().getText().trim()));
                break block17;
            }
            if (this.scanModeThetaTwoThetaRB.isSelected()) {
                nameList.add("A3");
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(0)).getSecondField().getText().trim()));
                nameList.add("A4");
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries.get(1)).getSecondField().getText().trim()));
                break block17;
            }
            logger.debug("No scan type (radio button) was selected.  Save cancelled: ");
            this.throwErrorDialog("Incomplete Description", "Please select a scan type.");
            return "";
        }
        try {
            i = 0;
            while (i < this.scanEntries_add.size()) {
                nameList.add(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getComboBox().getSelectedItem().toString());
                firstList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getFirstField().getText().trim()));
                secondList.add(Double.valueOf(((BaseScanPanel.ScanEntry)this.scanEntries_add.get(i)).getSecondField().getText().trim()));
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            logger.debug("Invalid number in device ranges.  Save cancelled: ");
            logger.debug(nfe.getMessage());
            this.throwErrorDialog("Input Error", "Please specify valid numbers for device ranges.");
            return "";
        }
        i = 0;
        while (i < nameList.size()) {
            scanDescr = scanDescr.concat(":Range=" + (String)nameList.get(i) + "=" + firstList.get(i) + " " + secondList.get(i) + tag);
            logger.debug(firstList.get(i) + " " + secondList.get(i) + tag);
            ++i;
        }
        if (comments.length() != 0) {
            scanDescr = scanDescr.concat(":Comment=" + this.getComments(comments));
        }
        return scanDescr;
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    protected class AddDeviceAction
    extends AbstractAction {
        public AddDeviceAction() {
            this.putValue("Name", "Include Another Device in Scan");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("Trying to add a new device");
            AngleScanPanel.this.createAdditionalDevice();
            AngleScanPanel.this.instrumentPanel = AngleScanPanel.this.createInstrumentPanel();
            AngleScanPanel.this.removeAll();
            AngleScanPanel.this.buildGUI();
            AngleScanPanel.this.invalidate();
        }
    }

    protected class ScanA3A4Action
    extends AbstractAction {
        public ScanA3A4Action() {
            this.putValue("Name", "A3/A4");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("A3/A4 scan!");
            Thread thread1 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(0)).getFirstField(), true));
            Thread thread2 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(0)).getSecondField(), true));
            SwingUtilities.invokeLater(thread1);
            SwingUtilities.invokeLater(thread2);
            Thread thread3 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(1)).getFirstField(), true));
            Thread thread4 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(1)).getSecondField(), true));
            SwingUtilities.invokeLater(thread3);
            SwingUtilities.invokeLater(thread4);
        }
    }

    protected class ScanA3Action
    extends AbstractAction {
        public ScanA3Action() {
            this.putValue("Name", "A3");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("A3 scan!");
            Thread thread1 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(0)).getFirstField(), true));
            Thread thread2 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(0)).getSecondField(), true));
            SwingUtilities.invokeLater(thread1);
            SwingUtilities.invokeLater(thread2);
            Thread thread3 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(1)).getFirstField(), false));
            Thread thread4 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(1)).getSecondField(), false));
            SwingUtilities.invokeLater(thread3);
            SwingUtilities.invokeLater(thread4);
        }
    }

    protected class ScanA4Action
    extends AbstractAction {
        public ScanA4Action() {
            this.putValue("Name", "A4");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("A4 scan!");
            Thread thread1 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(0)).getFirstField(), false));
            Thread thread2 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(0)).getSecondField(), false));
            SwingUtilities.invokeLater(thread1);
            SwingUtilities.invokeLater(thread2);
            Thread thread3 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(1)).getFirstField(), true));
            Thread thread4 = new Thread(new BaseScanPanel.SetEditable(AngleScanPanel.this, ((BaseScanPanel.ScanEntry)AngleScanPanel.this.scanEntries.get(1)).getSecondField(), true));
            SwingUtilities.invokeLater(thread3);
            SwingUtilities.invokeLater(thread4);
        }
    }
}

