/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.reportBugDialog;

import ice.gui.core.IceDialog;
import ice.gui.core.reportBugDialog.ControlsPanel;
import ice.gui.core.reportBugDialog.FieldsPanel;
import ice.gui.core.reportBugDialog.exceptions.FieldsPanelUnsuportedInputType;
import ice.swing.exceptions.EmptyRequiredFieldsException;
import ice.util.BugEmailer;
import ice.util.I18N;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.mail.MessagingException;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class ReportBugDialog
extends IceDialog
implements ActionListener {
    private static final String TITLE_KEY = "ice.gui.core.reportBugDialog.title";
    protected static final String SUBMISSION_ERROR_TITLE_KEY = "ice.gui.core.reportBugDialog.submisionError.title";
    protected static final String SUBMISSSION_ERROR_MESSAGE = "ice.gui.core.reportBugDialog.submisionError.message";
    protected static final String INCOMPLETE_FORM_TITLE = "ice.gui.core.reportBugDialog.incompleteFromError.title";
    private static final long serialVersionUID = 1L;
    private static ReportBugDialog instance = null;
    private ControlsPanel controlPanel = null;
    private FieldsPanel fieldsPanel = null;

    private ReportBugDialog() throws HeadlessException {
        this.init();
    }

    private ReportBugDialog(Frame arg0) throws HeadlessException {
        super(arg0);
        this.init();
    }

    private ReportBugDialog(Dialog arg0) throws HeadlessException {
        super(arg0);
        this.init();
    }

    private ReportBugDialog(Frame arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.init();
    }

    private ReportBugDialog(Frame arg0, String arg1) throws HeadlessException {
        super(arg0, arg1);
        this.init();
    }

    private ReportBugDialog(Dialog arg0, boolean arg1) throws HeadlessException {
        super(arg0, arg1);
        this.init();
    }

    private ReportBugDialog(Dialog arg0, String arg1) throws HeadlessException {
        super(arg0, arg1);
        this.init();
    }

    private ReportBugDialog(Frame arg0, String arg1, boolean arg2) throws HeadlessException {
        super(arg0, arg1, arg2);
    }

    private ReportBugDialog(Dialog arg0, String arg1, boolean arg2) throws HeadlessException {
        super(arg0, arg1, arg2);
    }

    private ReportBugDialog(Frame arg0, String arg1, boolean arg2, GraphicsConfiguration arg3) {
        super(arg0, arg1, arg2, arg3);
    }

    private ReportBugDialog(Dialog arg0, String arg1, boolean arg2, GraphicsConfiguration arg3) throws HeadlessException {
        super(arg0, arg1, arg2, arg3);
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstrants = new GridBagConstraints();
        Insets insets = null;
        String string = null;
        this.setLayout(gridBagLayout);
        insets = new Insets(10, 0, 0, 0);
        gridBagConstrants = new GridBagConstraints();
        gridBagConstrants.fill = 1;
        gridBagConstrants.anchor = 17;
        gridBagConstrants.weightx = 1.0;
        gridBagConstrants.weighty = 1.0;
        gridBagConstrants.insets = insets;
        string = I18N.getString(TITLE_KEY);
        this.setTitle(string);
        this.fieldsPanel = new FieldsPanel();
        gridBagConstrants.gridx = 0;
        gridBagConstrants.gridy = 0;
        gridBagConstrants.anchor = 18;
        this.add((Component)this.fieldsPanel, gridBagConstrants);
        this.controlPanel = new ControlsPanel(this);
        insets.top = 0;
        insets.bottom = 10;
        gridBagConstrants.gridx = 0;
        gridBagConstrants.gridy = 1;
        gridBagConstrants.anchor = 14;
        gridBagConstrants.fill = 2;
        gridBagConstrants.weighty = 0.0;
        this.add((Component)this.controlPanel, gridBagConstrants);
        this.pack();
        this.setResizable(false);
    }

    protected void sendRequest() throws EmptyRequiredFieldsException {
        try {
            String headline = null;
            String submitterEmail = null;
            String affectedInstrument = null;
            String obsInstrument = null;
            String description = null;
            BugEmailer bugEmailer = null;
            headline = this.fieldsPanel.getHeadline();
            submitterEmail = this.fieldsPanel.getSubmitterEmail();
            affectedInstrument = this.fieldsPanel.getAffectedInstrument();
            description = this.fieldsPanel.getDescription();
            obsInstrument = this.fieldsPanel.getObservedInstrument();
            boolean isEnhancement = this.fieldsPanel.isEnhancement();
            bugEmailer = BugEmailer.getReference();
            bugEmailer.emailBug(headline, submitterEmail, isEnhancement, obsInstrument, affectedInstrument, description);
        }
        catch (FieldsPanelUnsuportedInputType e) {
            String title = null;
            String message = null;
            title = I18N.getString("ice.gui.core.reportBugDialog.exceptions.fieldsPanelUnsuportedInputType.title");
            message = e.getMessage();
            this.throwErrorDialog(title, message);
        }
        catch (MessagingException mex) {
            String title = null;
            String message = null;
            title = I18N.getString(SUBMISSION_ERROR_TITLE_KEY);
            message = I18N.getString(SUBMISSSION_ERROR_MESSAGE);
            this.throwErrorDialog(title, message);
        }
    }

    protected void processSubmit() {
        try {
            this.sendRequest();
            this.closeDialog();
        }
        catch (EmptyRequiredFieldsException e) {
            JComponent missingFieldComponent = null;
            String title = null;
            title = I18N.getString(SUBMISSION_ERROR_TITLE_KEY);
            this.throwErrorDialog(title, e.toString());
            missingFieldComponent = e.getRequiredComponent();
            missingFieldComponent.grabFocus();
        }
    }

    protected void processCancel() {
        this.closeDialog();
    }

    protected void closeDialog() {
        this.dispose();
        instance = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String theActionCommand = null;
        String submitAction = null;
        String cancelAction = null;
        submitAction = I18N.getString("ice.gui.core.reportBugDialog.controlsPanel.submitButton.title");
        cancelAction = I18N.getString("ice.gui.core.reportBugDialog.controlsPanel.cancelButton.title");
        theActionCommand = actionEvent.getActionCommand();
        if (theActionCommand != null) {
            if (theActionCommand.compareTo(submitAction) == 0) {
                this.processSubmit();
            } else if (theActionCommand.compareTo(cancelAction) == 0) {
                this.processCancel();
            }
        }
    }

    public static ReportBugDialog getInstance(JFrame parent) {
        if (instance == null) {
            instance = new ReportBugDialog(parent);
            instance.setDefaultCloseOperation(2);
            instance.centerOnParent();
        }
        instance.setVisible(true);
        return instance;
    }
}

