/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.rangeClasses;

import ice.gui.core.rangeClasses.DeviceValue.DeviceValue;
import ice.gui.core.rangeClasses.DeviceValue.DoubleDeviceValue;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DeviceRange {
    private static Logger logger = Logger.getLogger("ScanOperation.DeviceRange");
    private DeviceValue startValue;
    private DeviceValue stopValue;
    private DeviceValue centerValue;
    private DeviceValue increment;
    private RangeTypes type;
    private String device;

    public DeviceRange(String typeString, String device) {
        this.type = this.parseRangeType(typeString);
        this.device = device;
    }

    public DeviceRange() {
        this.type = RangeTypes.CENTERSTEP;
        this.device = null;
    }

    public RangeTypes parseRangeType(String rangeTypeText) {
        if (rangeTypeText.compareToIgnoreCase("s") == 0) {
            return RangeTypes.INITIALFINAL;
        }
        if (rangeTypeText.compareToIgnoreCase("i") == 0) {
            return RangeTypes.INITIALFINAL;
        }
        if (rangeTypeText.compareToIgnoreCase("") == 0) {
            return RangeTypes.CENTERSTEP;
        }
        logger.debug("Range type does not match.  Returning null range type.");
        return null;
    }

    public DeviceValue getFirstValue() {
        if (this.type == RangeTypes.INITIALFINAL || this.type == RangeTypes.INITIALSTEP) {
            return this.startValue;
        }
        if (this.type == RangeTypes.CENTERSTEP) {
            return this.centerValue;
        }
        return null;
    }

    public boolean setFirstValue(DeviceValue firstValue) {
        if (this.type == RangeTypes.INITIALFINAL || this.type == RangeTypes.INITIALSTEP) {
            this.startValue = firstValue;
            return true;
        }
        if (this.type == RangeTypes.CENTERSTEP) {
            this.centerValue = firstValue;
            return true;
        }
        return false;
    }

    public boolean setFirstValue(String firstValue) {
        DeviceValue firstDeviceValue = DeviceValue.getDeviceValueFromString(firstValue);
        if (!firstDeviceValue.validateData()) {
            return false;
        }
        return this.setFirstValue(firstDeviceValue);
    }

    public DeviceValue getSecondValue() {
        if (this.type == RangeTypes.INITIALFINAL) {
            return this.stopValue;
        }
        if (this.type == RangeTypes.CENTERSTEP || this.type == RangeTypes.INITIALSTEP) {
            return this.increment;
        }
        return null;
    }

    public boolean setSecondValue(DeviceValue secondValue) {
        if (this.type == RangeTypes.INITIALFINAL) {
            this.stopValue = secondValue;
            return true;
        }
        if (this.type == RangeTypes.CENTERSTEP || this.type == RangeTypes.INITIALSTEP) {
            this.increment = secondValue;
            return true;
        }
        return false;
    }

    public boolean setSecondValue(String secondValue) {
        DeviceValue firstDeviceValue = DeviceValue.getDeviceValueFromString(secondValue);
        if (!firstDeviceValue.validateData()) {
            return false;
        }
        return this.setFirstValue(firstDeviceValue);
    }

    public DeviceValue getStartValue() {
        if (this.type == RangeTypes.INITIALFINAL || this.type == RangeTypes.INITIALSTEP) {
            return this.startValue;
        }
        return null;
    }

    public boolean setStartValue(DeviceValue startValue) {
        if (this.type == RangeTypes.INITIALFINAL || this.type == RangeTypes.INITIALSTEP) {
            this.startValue = startValue;
            return true;
        }
        return false;
    }

    public DeviceValue getStopValue() {
        if (this.type == RangeTypes.INITIALFINAL) {
            return this.stopValue;
        }
        return null;
    }

    public boolean setStopValue(DeviceValue stopValue) {
        if (this.type == RangeTypes.INITIALFINAL) {
            this.stopValue = stopValue;
            return true;
        }
        return false;
    }

    public DeviceValue getCenterValue() {
        if (this.type == RangeTypes.CENTERSTEP) {
            return this.centerValue;
        }
        return null;
    }

    public boolean setCenterValue(DeviceValue centerValue) {
        if (this.type == RangeTypes.CENTERSTEP) {
            this.centerValue = centerValue;
            return true;
        }
        return false;
    }

    public DeviceValue getIncrement() {
        if (this.type == RangeTypes.INITIALSTEP || this.type == RangeTypes.CENTERSTEP) {
            return this.increment;
        }
        return null;
    }

    public boolean setincrement(double increment) {
        if (this.type == RangeTypes.INITIALSTEP || this.type == RangeTypes.CENTERSTEP) {
            this.increment = new DoubleDeviceValue(increment);
            return true;
        }
        return false;
    }

    public boolean setDevice(String device) {
        this.device = device;
        return true;
    }

    public String getDevice() {
        return this.device;
    }

    public JComponent getControl() {
        return null;
    }

    public static enum RangeTypes {
        INITIALFINAL,
        CENTERSTEP,
        INITIALSTEP;

    }
}

