/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.controlPanel;

import ice.IconManager;
import ice.communication.SendQueueManager;
import ice.data.InstalledDevice;
import ice.data.tas.bt7.Instrument;
import ice.event.DeviceListEvent;
import ice.event.DeviceListListener;
import ice.event.communication.DeviceValueChangedEvent;
import ice.event.communication.DeviceValueChangedListener;
import ice.event.communication.InstrumentValueChangedEvent;
import ice.event.communication.InstrumentValueChangedListener;
import ice.gui.core.controlPanel.ControlPanelFactory;
import ice.gui.core.controlPanel.InstrumentStatusPanel;
import ice.gui.core.controlPanel.InstrumentTitleBorder;
import ice.swing.buttons.PausePlayButton;
import ice.swing.buttons.StopButton;
import ice.swing.threadedUpdaters.UpdateLabel;
import ice.swing.threadedUpdaters.UpdateTitleBorderTitle;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public class ControlPanel
extends JWindow
implements InstrumentValueChangedListener,
DeviceListListener {
    protected static String ICE_ICON_KEY = "iceIcon.normal";
    private static final Logger logger = Logger.getLogger("WidgetLogger.ControlLogger");
    private static final String CONTROL_PANEL_TITLE = "ICE - Control";
    protected StopButton stopBtn = null;
    protected PausePlayButton pauseBtn = null;
    private Instrument instrument;
    private SendQueueManager sendManager;
    private InstrumentTitleBorder instrumentPanelTitledBorder = null;
    private JLabel stateLabel;
    private InstrumentStatusPanel instStatPanel;
    private ArrayList<InstalledDevice> allDevices;
    private DevicePropertyListener dpl;
    private boolean isEnabled = true;

    public ControlPanel(Instrument instrument, SendQueueManager sendManager, ArrayList<InstalledDevice> allDevices) {
        this.instrument = instrument;
        this.sendManager = sendManager;
        this.allDevices = allDevices;
        try {
            instrument.addPropertyChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("ControlPanel " + e);
        }
        this.dpl = new DevicePropertyListener();
        this.isEnabled = ControlPanelFactory.isEnabled(instrument);
        this.buildGUI();
    }

    private void buildGUI() {
        this.setName("JICE");
        this.setContentPane(this.createContentPanel());
        this.setAlwaysOnTop(true);
        if (this.isEnabled) {
            this.pack();
        }
    }

    private JPanel createContentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.instStatPanel = new InstrumentStatusPanel(this.instrument);
        panel.add((Component)this.instStatPanel, gridBagConstraints);
        this.updateInstrumentStatusPanel();
        this.updateDevices();
        gridBagConstraints.gridx = 1;
        panel.add((Component)this.createBtnPanel(), gridBagConstraints);
        return panel;
    }

    private JPanel createStatePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        boolean x = false;
        boolean y = false;
        JLabel icon = new JLabel(IconManager.getIcon(ICE_ICON_KEY));
        panel.add(icon);
        icon.setBackground(Color.LIGHT_GRAY);
        return panel;
    }

    private JPanel createBtnPanel() {
        JPanel statusPanel = null;
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = null;
        GridBagLayout statusPanelLayout = null;
        this.stateLabel = new JLabel(this.instrument.getState().getName().toUpperCase());
        this.instrumentPanelTitledBorder = new InstrumentTitleBorder("");
        panel.setBorder(this.instrumentPanelTitledBorder);
        gridBagConstraints = new GridBagConstraints();
        statusPanelLayout = new GridBagLayout();
        statusPanel = new JPanel();
        statusPanel.setLayout(statusPanelLayout);
        statusPanel.setBorder(new BevelBorder(1));
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.stateLabel.setBackground(Color.BLACK);
        this.stateLabel.setForeground(Color.GREEN);
        this.stateLabel.setOpaque(true);
        statusPanel.add((Component)this.stateLabel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        panel.add((Component)statusPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        this.stopBtn = new StopButton(this.sendManager);
        panel.add((Component)this.stopBtn, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.pauseBtn = new PausePlayButton(this.instrument, this.sendManager);
        panel.add((Component)this.pauseBtn, gridBagConstraints);
        SwingUtilities.invokeLater(new UpdateTitleBorderTitle(this.instrumentPanelTitledBorder, this.instrument.getName()));
        return panel;
    }

    @Override
    public void actionPerformed(InstrumentValueChangedEvent pce) {
        String propertyName = pce.getPropertyName();
        if ("state".equals(propertyName)) {
            SwingUtilities.invokeLater(new UpdateLabel(this.stateLabel, this.instrument.getState().getName().toUpperCase()));
        } else if ("name".equals(propertyName)) {
            SwingUtilities.invokeLater(new UpdateTitleBorderTitle(this.instrumentPanelTitledBorder, this.instrument.getName()));
        } else {
            this.updateInstrumentProperty(propertyName);
        }
    }

    public void setLocked(boolean locked) {
        SwingUtilities.invokeLater(new LockToggleRunnable(locked));
    }

    @Override
    public void deviceListUpdated(DeviceListEvent dle) {
        this.allDevices = dle.getNewList();
        this.updateDevices();
    }

    private void updateDevices() {
        TreeMap<String, String> displayMap = ControlPanelFactory.getPropertyMap(this.instrument);
        if (displayMap != null) {
            Set<String> keys = displayMap.keySet();
            for (String propertyName : keys) {
                for (InstalledDevice device : this.allDevices) {
                    if (device.getName() == null || !device.getName().equalsIgnoreCase(propertyName)) continue;
                    try {
                        device.addValueChangeListener(this.dpl);
                    }
                    catch (ICEListenerListExceptionBase e) {
                        logger.error("ControlPanel.updateDevice " + e);
                    }
                    SwingUtilities.invokeLater(new UpdateLabel(this.instStatPanel.getPropertyLabel(propertyName), device.getCurrValue()));
                }
            }
        }
    }

    private void updateInstrumentStatusPanel() {
        TreeMap<String, String> displayMap = ControlPanelFactory.getPropertyMap(this.instrument);
        if (displayMap != null) {
            Set<String> keys = displayMap.keySet();
            for (String propertyName : keys) {
                this.updateInstrumentProperty(propertyName);
            }
        }
    }

    private void updateInstrumentProperty(String propertyName) {
        JLabel updateLabel = this.instStatPanel.getPropertyLabel(propertyName);
        if (updateLabel == null) {
            return;
        }
        String propertyValue = "none";
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = this.instrument.getClass().getMethod(methodName, null);
            propertyValue = method.invoke((Object)this.instrument, null).toString();
            SwingUtilities.invokeLater(new UpdateLabel(updateLabel, propertyValue));
            logger.debug(method);
        }
        catch (Exception e) {
            logger.error("Introspection: Unable to find appropriate method", e);
        }
    }

    protected class DevicePropertyListener
    implements DeviceValueChangedListener {
        protected DevicePropertyListener() {
        }

        @Override
        public void actionPerformed(DeviceValueChangedEvent evt) {
            if (!(evt.getSource() instanceof InstalledDevice)) {
                return;
            }
            InstalledDevice changedDevice = (InstalledDevice)evt.getSource();
            TreeMap<String, String> displayMap = ControlPanelFactory.getPropertyMap(ControlPanel.this.instrument);
            Set<String> keys = displayMap.keySet();
            for (String propertyName : keys) {
                if (!changedDevice.getName().equalsIgnoreCase(propertyName) || !evt.getPropertyName().equalsIgnoreCase("currValue")) continue;
                SwingUtilities.invokeLater(new UpdateLabel(ControlPanel.this.instStatPanel.getPropertyLabel(propertyName), changedDevice.getCurrValue()));
            }
        }
    }

    private class LockToggleRunnable
    implements Runnable {
        private boolean locked;

        public LockToggleRunnable(boolean locked) {
            this.locked = locked;
        }

        @Override
        public void run() {
            ControlPanel.this.stopBtn.setEnabled(!this.locked);
            ControlPanel.this.pauseBtn.setEnabled(!this.locked);
            if (this.locked) {
                ControlPanel.this.stateLabel.setForeground(Color.GRAY);
            } else {
                ControlPanel.this.stateLabel.setForeground(Color.BLACK);
            }
        }
    }
}

