/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core.config;

import ice.communication.SendQueueManager;
import ice.event.ModifyEvent;
import ice.event.ModifyListener;
import ice.gui.core.config.BaseConfigWindow;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class BaseConfigPanel
extends JPanel {
    private boolean modified = false;
    private boolean isCommitting = false;
    private boolean modifiedDialogActive = false;
    private ArrayList<ModifyListener> modifyListeners;
    protected BaseConfigWindow realParent;

    public void addModifyListener(ModifyListener ml) {
        this.modifyListeners.add(ml);
    }

    public void removeModifyListener(ModifyListener ml) {
        this.modifyListeners.remove(ml);
    }

    private void notifyModifyListeners() {
        Iterator<ModifyListener> iterator = this.modifyListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateModified(new ModifyEvent(this, this.modified));
        }
    }

    public BaseConfigPanel(BaseConfigWindow realParent) {
        this.realParent = realParent;
        this.modified = false;
        this.modifyListeners = new ArrayList();
    }

    protected void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            this.notifyModifyListeners();
        }
    }

    protected boolean getModified() {
        return this.modified;
    }

    public boolean isCommitting() {
        return this.isCommitting;
    }

    public void setCommitting(boolean isCommitting) {
        this.isCommitting = isCommitting;
    }

    public JLabel createLabel(String name) {
        JLabel label = new JLabel(name);
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(2);
        return label;
    }

    public JLabel createLabel(String name, boolean required) {
        JLabel label = new JLabel(name);
        if (required) {
            label.setForeground(new Color(200, 0, 0));
        }
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(2);
        return label;
    }

    protected abstract boolean isCompleted();

    protected abstract String getCompletionErrorString();

    protected abstract boolean commitChanges(SendQueueManager var1);

    protected void processIncomingChanges() {
        SwingUtilities.invokeLater(new ProcessIncomingChangesLater());
    }

    private synchronized boolean checkDialogActive() {
        if (!this.modifiedDialogActive) {
            this.modifiedDialogActive = true;
            return false;
        }
        return true;
    }

    protected abstract void reload();

    private class ProcessIncomingChangesLater
    implements Runnable {
        private ProcessIncomingChangesLater() {
        }

        @Override
        public void run() {
            if (BaseConfigPanel.this.isVisible() && !BaseConfigPanel.this.isCommitting()) {
                if (BaseConfigPanel.this.getModified()) {
                    if (!BaseConfigPanel.this.checkDialogActive()) {
                        int answer = JOptionPane.showConfirmDialog(BaseConfigPanel.this.realParent, "New experiment information has just been saved.\nWould you like to reload this information? \n(reloading will clear any changes you have made)", "Reload?", 0);
                        if (answer == 0) {
                            BaseConfigPanel.this.reload();
                            BaseConfigPanel.this.modified = false;
                        }
                        BaseConfigPanel.this.modifiedDialogActive = false;
                    }
                } else {
                    BaseConfigPanel.this.reload();
                    BaseConfigPanel.this.modified = false;
                }
            } else {
                BaseConfigPanel.this.reload();
                BaseConfigPanel.this.modified = false;
            }
        }
    }
}

