/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.IconManager;
import ice.data.Server;
import ice.event.InstrumentSelectionEvent;
import ice.event.InstrumentSelectionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import org.apache.log4j.Logger;

public class InstrumentSelectionWindow {
    public static Logger logger = Logger.getLogger("WidgetLogger");
    private TreeMap<String, Server> serverMap;
    private JFrame frame;
    private JPanel parentPanel;
    private JComboBox instrumentList;
    private JButton okBtn;
    private JButton cancelBtn;
    private JLabel statusLabel;
    private String address;
    private ArrayList<InstrumentSelectionListener> instrumementSelectionListeners = new ArrayList();

    public InstrumentSelectionWindow(TreeMap<String, Server> serverMap) {
        this.serverMap = serverMap;
        this.frame = new JFrame("JICE - Instrument Selector");
        this.setIcon();
        this.frame.setResizable(false);
        this.frame.setDefaultCloseOperation(3);
        this.parentPanel = (JPanel)this.frame.getContentPane();
        this.parentPanel.setLayout(new BorderLayout());
        this.parentPanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CloseWindow");
        this.parentPanel.getActionMap().put("CloseWindow", new CloseWindowAction());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints mainConstraints = new GridBagConstraints();
        mainConstraints.gridx = 0;
        mainConstraints.gridy = 0;
        mainConstraints.fill = 1;
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        descriptionPanel.setBackground(Color.WHITE);
        GridBagConstraints descriptionConstraints = new GridBagConstraints();
        descriptionConstraints.gridx = 0;
        descriptionConstraints.gridy = 0;
        descriptionConstraints.insets = new Insets(5, 15, 20, 20);
        String labelContent = "<html>\n<h3>Select an Instrument</h3>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Please select the instrument you will be <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;running your experiment on.";
        JLabel label = new JLabel(labelContent);
        label.setFont(new Font("Arial", 0, 12));
        descriptionPanel.add((Component)label, descriptionConstraints);
        JPanel instrumentPanel = new JPanel(new FlowLayout(3));
        label = new JLabel("<html><b>Instrument:</b> ");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        Iterator<String> nameIterator = serverMap.keySet().iterator();
        while (nameIterator.hasNext()) {
            model.addElement(nameIterator.next());
        }
        this.instrumentList = new JComboBox(model);
        this.instrumentList.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "Connect");
        this.instrumentList.getActionMap().put("Connect", new ConnectToInstrumentAction());
        instrumentPanel.add(label);
        instrumentPanel.add(this.instrumentList);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        this.okBtn = new JButton(new ConnectToInstrumentAction());
        this.cancelBtn = new JButton(new CloseWindowAction());
        buttonPanel.add(this.okBtn);
        buttonPanel.add(this.cancelBtn);
        mainPanel.add((Component)descriptionPanel, mainConstraints);
        ++mainConstraints.gridy;
        mainPanel.add((Component)instrumentPanel, mainConstraints);
        ++mainConstraints.gridy;
        mainPanel.add((Component)buttonPanel, mainConstraints);
        this.parentPanel.add((Component)mainPanel, "Center");
        this.addStatusBar();
    }

    private void setIcon() {
        try {
            this.frame.setIconImage(IconManager.getIcon("default").getImage());
        }
        catch (NullPointerException npe) {
            logger.error("Unable to load default icon!  THIS SHOULDN'T HAPPEN!", npe);
        }
    }

    public void addStatusBar() {
        JPanel statusBar = new JPanel();
        statusBar.setLayout(new BorderLayout());
        this.statusLabel = new JLabel(" ");
        statusBar.add((Component)this.statusLabel, "Center");
        statusBar.setBorder(new BevelBorder(1));
        this.parentPanel.add((Component)statusBar, "South");
    }

    public void createAndShowGUI() {
        this.frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = new Double((double)(screenSize.width / 2) - this.frame.getSize().getWidth() / 2.0).intValue();
        int y = new Double((double)(screenSize.height / 2) - this.frame.getSize().getHeight() / 2.0).intValue();
        this.frame.setLocation(x, y);
        this.frame.setVisible(true);
    }

    public void listenToOK(InstrumentSelectionListener isl) {
        this.instrumementSelectionListeners.add(isl);
    }

    public Server getSelectedServer() {
        return this.serverMap.get(this.instrumentList.getSelectedItem());
    }

    public void connectionSuccessful() {
        this.statusLabel.setText("Connected!");
    }

    public void connecting() {
        this.statusLabel.setText("Connecting...");
    }

    public void connectionFailed() {
        this.statusLabel.setText("Unable to connect to server.");
    }

    public void killWindow() {
        this.frame.dispose();
    }

    public void notifyISListeners() {
        int size = this.instrumementSelectionListeners.size();
        int i = 0;
        while (i < size) {
            this.instrumementSelectionListeners.get(i).instrumentSelected(new InstrumentSelectionEvent(this.getSelectedServer()));
            ++i;
        }
    }

    private class CloseWindowAction
    extends AbstractAction {
        public CloseWindowAction() {
            this.putValue("Name", "Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("Cancelled.  Closing.");
            InstrumentSelectionWindow.this.killWindow();
            System.exit(0);
        }
    }

    private class ConnectToInstrumentAction
    extends AbstractAction {
        public ConnectToInstrumentAction() {
            this.putValue("Name", "OK");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            logger.debug("instrument selected: " + InstrumentSelectionWindow.this.instrumentList.getSelectedItem());
            InstrumentSelectionWindow.this.notifyISListeners();
        }
    }

    private class EditServersAction
    extends AbstractAction {
        public EditServersAction() {
            this.putValue("Name", "Add/Remove Servers...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

