/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.data.IceFileType;
import ice.data.Resource;
import ice.event.NameChangeEvent;
import ice.event.NameChangeListener;
import ice.exceptions.IcePanelException;
import ice.gui.core.GenericIcePanel;
import java.awt.datatransfer.ClipboardOwner;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public abstract class IceEditPanel
extends GenericIcePanel
implements ClipboardOwner {
    protected ArrayList<NameChangeListener> nameChangeListeners;
    protected Resource resource;
    public static final String DEFAULT_FILE_TYPE = "UNKNOWN";

    public IceEditPanel() throws IcePanelException {
        this.initSaveableIcePanel(null);
        this.processIcePanel();
    }

    public IceEditPanel(String panelName, Resource file) throws IcePanelException {
        super(panelName);
        this.initSaveableIcePanel(file);
        this.processIcePanel();
    }

    public void processIcePanel() throws IcePanelException {
        try {
            this.init();
            this.buildGUI();
            this.loadResource();
        }
        catch (Exception e) {
            this.handleIcePanelException(this.getName(), e);
        }
    }

    protected abstract void buildGUI();

    protected abstract void init();

    protected abstract void loadResource();

    public Resource getResource() {
        return this.resource;
    }

    public void addNameChangeListener(NameChangeListener ncl) {
        this.nameChangeListeners.add(ncl);
    }

    public void removeNameChangeListener(NameChangeListener ncl) {
        this.nameChangeListeners.remove(ncl);
    }

    public void notifyNameChangeListeners(String newName, String oldName) {
        NameChangeEvent nce = new NameChangeEvent(this, newName, oldName);
        for (NameChangeListener ncl : this.nameChangeListeners) {
            try {
                ncl.nameChanged(nce);
            }
            catch (Exception e) {
                Logger.getLogger("ErrorLogger").error("IceEditPanel.notifyNameChangeListeners " + e);
            }
        }
    }

    private void initSaveableIcePanel(Resource file) {
        this.resource = file;
        this.nameChangeListeners = new ArrayList();
    }

    public static IceFileType[] getSupportedFileTypes() {
        System.out.println("getSuppoertedFileTypes");
        IceFileType[] fileTypes = new IceFileType[]{IceFileType.unknown};
        return fileTypes;
    }

    public static IceFileType getFileType() {
        System.out.println("static getFileType");
        return IceFileType.unknown;
    }
}

