/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.core;

import ice.Controller;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import org.apache.log4j.Logger;

public class ExperimentIDDialogFactory {
    private static final String BUNDLE_NAME = "ice.panel";
    private static final ResourceBundle rb = ResourceBundle.getBundle("ice.panel");
    private static final Logger logger = Logger.getLogger("WidgetLogger.LiveDataLogger");
    private static ArrayList<String> list = null;
    private static Controller controller = Controller.getReference();
    private static final String experiment_input_key = ".experiment.input";
    private static JDialog dialog;

    public static JDialog getChangeExperimentIDDialog() {
        if (dialog != null) {
            return dialog;
        }
        String instrumentName = controller.getInstrument().getName();
        String key = String.valueOf(instrumentName) + experiment_input_key;
        String location = ExperimentIDDialogFactory.getValue(key);
        if (location == null) {
            logger.error("Could not load experiment id input dialog ");
        } else {
            try {
                Class<?> inputDialog = Class.forName(location);
                Constructor<?> constructor = inputDialog.getConstructor(new Class[0]);
                dialog = (JDialog)constructor.newInstance(new Object[0]);
                dialog.pack();
            }
            catch (SecurityException e) {
                logger.error(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                logger.error(e.getMessage());
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                logger.error(e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage());
            }
        }
        return dialog;
    }

    public static String getValue(String key) {
        String location = null;
        try {
            location = rb.getString(key);
        }
        catch (MissingResourceException mre) {
            logger.error("Unable to find resource." + mre.getMessage());
        }
        catch (NullPointerException npe) {
            logger.error("The key is null." + npe.getMessage());
        }
        return location;
    }

    public static ArrayList<String> getValues(String key) {
        if (list == null) {
            list = new ArrayList();
            int i = 0;
            String counterName = null;
            do {
                if ((counterName = ExperimentIDDialogFactory.getValue(String.valueOf(key) + i++)) == null) continue;
                list.add(counterName);
            } while (counterName != null);
        }
        return list;
    }
}

