/*
 * Decompiled with CFR 0.152.
 */
package ice.event.communication;

import ice.util.ICEListenerList.ICEEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class DataMessageEvent
extends ICEEvent {
    private static Logger logger = Logger.getLogger("Ice.dataEvent");
    private String message;
    private boolean validParse = false;
    private String instrumentName;
    private boolean newStart = false;
    private int numPoints = -1;
    private String filename;
    private ArrayList<String> devices;
    private int pointNum = -1;
    private Map<String, Double> pointMap;
    private ScanType scanType = ScanType.UNKNOWN;
    private boolean hasFitData;
    private boolean hasFinished = false;
    private ArrayList<Double> fitPoints;
    private Date timestamp;
    private int commandId = 0;
    private int startPoint = 1;

    public DataMessageEvent(String message) {
        this(null, message, new Date());
    }

    public DataMessageEvent(String message, Date timestamp) {
        this(null, message, timestamp);
    }

    public DataMessageEvent(Object source, String message, Date timestamp) {
        super(source);
        this.message = message;
        this.timestamp = timestamp;
        StringTokenizer outerTokenizer = new StringTokenizer(message);
        String firstToken = outerTokenizer.nextToken("\t");
        if (firstToken.contains("START")) {
            this.newStart = true;
            this.filename = "N/A";
            this.devices = new ArrayList();
            this.instrumentName = firstToken.split(":", 2)[0];
            this.numPoints = -1;
            this.scanType = ScanType.UNKNOWN;
            while (outerTokenizer.hasMoreTokens()) {
                String nextToken = outerTokenizer.nextToken();
                if (nextToken.startsWith("FILE=")) {
                    this.filename = nextToken.substring(5);
                    continue;
                }
                if (nextToken.startsWith("VARY=")) {
                    String devicesString = nextToken.substring(5);
                    StringTokenizer innerTokenizer = new StringTokenizer(devicesString, " ");
                    while (innerTokenizer.hasMoreTokens()) {
                        this.devices.add(innerTokenizer.nextToken());
                    }
                    continue;
                }
                if (nextToken.startsWith("NPTS=")) {
                    try {
                        this.numPoints = Integer.parseInt(nextToken.substring(5));
                    }
                    catch (NumberFormatException nfe) {
                        logger.error("Invalid number for number of points.  Ignoring.", nfe);
                    }
                    continue;
                }
                if (nextToken.startsWith("TYPE=")) {
                    String type = nextToken.substring(5).toUpperCase();
                    if (type.equals("SCAN")) {
                        this.scanType = ScanType.SCAN;
                        continue;
                    }
                    if (!type.equals("PEAKSCAN")) continue;
                    this.scanType = ScanType.FINDPEAK;
                    continue;
                }
                if (!nextToken.startsWith("COMMAND=")) continue;
                try {
                    this.commandId = Integer.valueOf(nextToken.substring("COMMAND=".length()));
                }
                catch (NumberFormatException nfe) {
                    this.commandId = 0;
                }
            }
            this.validParse = true;
            this.hasFinished = false;
            return;
        }
        if (!firstToken.contains("END") && !firstToken.contains("FINISH")) {
            this.instrumentName = firstToken.split(":", 2)[0];
            this.pointNum = -1;
            this.pointMap = new TreeMap<String, Double>();
            String tokenLabel = null;
            String tokenValue = null;
            while (outerTokenizer.hasMoreTokens()) {
                try {
                    String nextToken = outerTokenizer.nextToken("\t");
                    StringTokenizer innerTokenizer = new StringTokenizer(nextToken);
                    tokenLabel = innerTokenizer.nextToken("=");
                    tokenValue = innerTokenizer.nextToken("=");
                    tokenLabel = tokenLabel.trim();
                    if (tokenLabel.equalsIgnoreCase("PT")) {
                        this.pointNum = Integer.parseInt(tokenValue);
                        continue;
                    }
                    if (tokenLabel.equalsIgnoreCase("COMMAND")) {
                        try {
                            this.commandId = Integer.valueOf(tokenValue);
                        }
                        catch (NumberFormatException nfe) {
                            this.commandId = 0;
                        }
                        continue;
                    }
                    try {
                        this.pointMap.put(tokenLabel, Double.valueOf(tokenValue));
                    }
                    catch (NumberFormatException e) {
                        this.pointMap.put(tokenLabel, null);
                    }
                }
                catch (Exception e) {
                    logger.error("No such number in a data message", e);
                }
            }
            if (this.pointNum == -1) {
                this.validParse = false;
                return;
            }
            this.validParse = true;
            return;
        }
        if (firstToken.contains("FINISH")) {
            this.hasFinished = true;
            try {
                while (outerTokenizer.hasMoreTokens()) {
                    String nextToken = outerTokenizer.nextToken("\t");
                    StringTokenizer innerTokenizer = new StringTokenizer(nextToken);
                    String tokenLabel = innerTokenizer.nextToken("=");
                    String tokenValue = innerTokenizer.nextToken("=");
                    if (!tokenLabel.equalsIgnoreCase("COMMAND")) continue;
                    this.commandId = Integer.valueOf(tokenValue);
                }
            }
            catch (NumberFormatException nfe) {
                this.commandId = 0;
            }
        } else if (firstToken.contains("END")) {
            outerTokenizer.nextToken();
            try {
                this.fitPoints = new ArrayList();
                this.fitPoints.add(Double.valueOf(outerTokenizer.nextToken().substring(7).trim()));
                this.fitPoints.add(Double.valueOf(outerTokenizer.nextToken().substring(7).trim()));
                this.fitPoints.add(Double.valueOf(outerTokenizer.nextToken().substring(7).trim()));
                this.fitPoints.add(Double.valueOf(outerTokenizer.nextToken().substring(7).trim()));
                this.fitPoints.add(Double.valueOf(outerTokenizer.nextToken().substring(7).trim()));
                this.fitPoints.add(Double.valueOf(outerTokenizer.nextToken().substring(7).trim()));
                this.hasFitData = true;
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid fit point number.  Aborting.", nfe);
                this.validParse = false;
                return;
            }
            try {
                String nextToken = outerTokenizer.nextToken();
                StringTokenizer innerTokenizer = new StringTokenizer(nextToken);
                String tokenLabel = innerTokenizer.nextToken("=");
                String tokenValue = innerTokenizer.nextToken("=");
                if (tokenLabel.equalsIgnoreCase("COMMAND")) {
                    this.commandId = Integer.valueOf(tokenValue);
                    this.commandId = 0;
                }
            }
            catch (NumberFormatException nfe) {
                this.commandId = 0;
            }
        } else {
            this.validParse = false;
            return;
        }
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getInstrumentName() {
        return this.instrumentName;
    }

    public boolean isNewStart() {
        return this.newStart;
    }

    public Map<String, Double> getPointMap() {
        return this.pointMap;
    }

    public int getPointNum() {
        return this.pointNum;
    }

    public ArrayList<String> getDevices() {
        return this.devices;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public void setNumPoints(int numPoints) {
        this.numPoints = numPoints;
    }

    public ArrayList<Double> getFitPoints() {
        return this.fitPoints;
    }

    public boolean hasFitData() {
        return this.hasFitData;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    public ScanType getScanType() {
        return this.scanType;
    }

    public boolean isValidParse() {
        return this.validParse;
    }

    public int getCommandId() {
        return this.commandId;
    }

    public int getStartPoint() {
        return this.startPoint;
    }

    public void setFakeStartData() {
        this.newStart = true;
        this.filename = "N/A";
        this.devices = this.pointMap != null ? new ArrayList<String>(this.pointMap.keySet()) : new ArrayList();
        this.scanType = ScanType.UNKNOWN;
        this.numPoints = this.pointNum;
        this.validParse = true;
        this.hasFinished = this.hasFinished();
        this.startPoint = this.pointNum;
    }

    public static enum ScanType {
        SCAN,
        FINDPEAK,
        UNKNOWN;

    }
}

