/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.IceFileType;
import ice.event.ResourcePropertyChangedEvent;
import ice.event.ResourcePropertyChangedListener;
import ice.util.ICEListenerList.ICEListenerList;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import org.apache.log4j.Logger;

public abstract class Resource {
    public static final String NameFieldName = "Name";
    public static final String FileTypeFieldName = "Type";
    public static final String ExtensionFieldName = "Extension";
    public static final String ContentsFieldName = "Contents";
    private String name;
    private String contents;
    private IceFileType fileType;
    private ICEListenerList<ResourcePropertyChangedListener, ResourcePropertyChangedEvent> changeListeners = new ICEListenerList();

    public Resource(String name, String contents, IceFileType fileType) {
        this.name = name == null ? "" : name;
        this.contents = null;
        this.fileType = fileType == null ? IceFileType.unknown : fileType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = name;
        this.name = name;
        this.notifyPropertyChangeListeners(NameFieldName, oldName, this.name);
    }

    public String getExtension() {
        String extension = "";
        if (this.fileType != null) {
            extension = this.fileType.getExtension();
        }
        return extension;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        String oldContents = this.contents;
        this.contents = contents;
        this.notifyPropertyChangeListeners(ContentsFieldName, oldContents, this.contents);
    }

    public IceFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(IceFileType fileType) {
        String oldExtension = this.fileType.getExtension();
        IceFileType oldFileType = this.fileType;
        this.notifyPropertyChangeListeners(ExtensionFieldName, oldExtension, this.fileType.getExtension());
        this.fileType = fileType;
        this.notifyPropertyChangeListeners(FileTypeFieldName, (Object)oldFileType, (Object)this.fileType);
    }

    public void addPropertyChangeListener(ResourcePropertyChangedListener pcl) throws ICEListenerListExceptionBase {
        this.changeListeners.addListener(pcl);
    }

    public void removePropertyChangeListener(ResourcePropertyChangedListener pcl) {
        this.changeListeners.removeListener(pcl);
    }

    public void notifyPropertyChangeListeners(String propertyName, Object oldValue, Object newValue) {
        ResourcePropertyChangedEvent pce = new ResourcePropertyChangedEvent(this, propertyName, oldValue, newValue);
        this.changeListeners.notifyListeners(pce);
    }

    public int compareTo(Object obj) {
        return this.name.compareTo(((Resource)obj).getName());
    }

    public String toString() {
        return this.name;
    }

    public IceFileType getType() {
        return this.fileType;
    }

    public Object cloneWithNewListeners() {
        Object o = null;
        try {
            o = super.clone();
            ((Resource)o).changeListeners = new ICEListenerList();
        }
        catch (Exception e) {
            Logger.getLogger("ErrorLogger").error("ResourceEditorPanel.clone " + e);
        }
        return o;
    }
}

