/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.IcePanelManager;
import ice.data.Device;
import ice.event.IceClientInfoEvent;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class InstalledDevice
extends Device {
    public static final String justBrokeFieldName = "justBroke";
    public static final String justFixedFieldName = "justFixed";
    public static final String brokenFieldName = "broken";
    public static final String workingFieldName = "working";
    public static final String hardwareValueFieldName = "hardwareValue";
    public static final String aliasFieldName = "alias";
    public static final String currentValueFieldName = "currValue";
    public static final String typeFieldName = "type";
    public static final String upperLimitFieldName = "upperLimit";
    public static final String lowerLimitFieldName = "lowerLimit";
    public static final String statusFieldName = "status";
    public static final String fixedFieldName = "fixed";
    public static final String undefinedFieldName = "undefined";
    public static final String busyFieldName = "busy";
    public static final String toleranceFieldName = "tolerance";
    public static final String channelFieldName = "channel";
    public static final String additionalPropertiesFieldName = "extras";
    private static final Logger logger = Logger.getLogger("RootLogger.InstalledDevice");
    protected String alias;
    private Integer channel;
    private String currValue;
    private String hardwareValue;
    private Double tolerance;
    private Type type;
    private Double upperLimit;
    private Double lowerLimit;
    private Status status;
    private boolean fixed;
    private boolean undefined;
    private boolean busy;
    private HashMap<String, String> extras;
    private boolean brokenState;
    private boolean oldBrokenState;

    public InstalledDevice(String newName, String newUnits, String alias2, Integer channel, String currValue, String hardwareValue, Double tolerance, Type type, Double upperLimit, Double lowerLimit, Status status, boolean fixed, boolean undefined, boolean busy, boolean brokenState, boolean oldBrokenState, HashMap<String, String> extras) {
        super(newName, newUnits);
        this.alias = alias2;
        this.channel = channel;
        this.currValue = currValue;
        this.hardwareValue = hardwareValue;
        this.tolerance = tolerance;
        this.type = type;
        this.upperLimit = upperLimit;
        this.lowerLimit = lowerLimit;
        this.status = status;
        this.fixed = fixed;
        this.undefined = undefined;
        this.busy = busy;
        this.brokenState = brokenState;
        this.oldBrokenState = oldBrokenState;
        this.extras = extras;
    }

    public InstalledDevice(String newName, String newUnits, String currValue) {
        this(newName, newUnits, null, null, currValue, null, null, Type.unknown, null, null, Status.normal, false, false, false, false, false, null);
    }

    public InstalledDevice(String newName, String newUnits, String currValue, Integer channel) {
        this(newName, newUnits, null, channel, currValue, null, null, Type.unknown, null, null, Status.normal, false, false, false, false, false, null);
    }

    public InstalledDevice(String newName, String newUnits, String currValue, Integer channel, Type newType) {
        this(newName, newUnits, null, channel, currValue, null, null, newType, null, null, Status.normal, false, false, false, false, false, null);
    }

    @Override
    public String getName() {
        if (this.alias != null) {
            return this.alias;
        }
        return super.getName();
    }

    public String getRealName() {
        return this.name;
    }

    public String getRealNameButReturnAliasIfCounter() {
        String returnValue = null;
        if (this.type == Type.counter) {
            returnValue = this.getAlias();
            if (returnValue == null) {
                returnValue = this.getRealName();
            }
        } else {
            returnValue = this.getRealName();
        }
        return returnValue;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias2) {
        String oldAlias = this.alias;
        this.alias = alias2;
        this.notifyValueChangeListeners(aliasFieldName, oldAlias, this.alias);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public String getCurrValue() {
        if (this.undefined || this.currValue == null) {
            return "N/A";
        }
        return this.currValue;
    }

    public void setCurrValue(String currValue) {
        String oldCurrValue = this.currValue;
        this.currValue = currValue;
        this.notifyValueChangeListeners(currentValueFieldName, oldCurrValue, this.currValue);
    }

    public Double getLowerLimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(Double lowerLimit) {
        Double oldLowerLimit = this.lowerLimit;
        this.lowerLimit = lowerLimit;
        this.notifyValueChangeListeners(lowerLimitFieldName, oldLowerLimit, this.lowerLimit);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        Status oldStatus = this.status;
        this.status = status;
        this.notifyValueChangeListeners(statusFieldName, (Object)oldStatus, (Object)this.status);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        this.notifyValueChangeListeners(typeFieldName, (Object)oldType, (Object)this.type);
    }

    public Double getUpperLimit() {
        return this.upperLimit;
    }

    public void setUpperLimit(Double upperLimit) {
        Double oldUpperLimit = this.upperLimit;
        this.upperLimit = upperLimit;
        this.notifyValueChangeListeners(upperLimitFieldName, oldUpperLimit, this.upperLimit);
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public void setUndefined(boolean undefined) {
        boolean oldUndefined = this.undefined;
        this.undefined = undefined;
        this.notifyValueChangeListeners(undefinedFieldName, oldUndefined, this.undefined);
    }

    @Override
    public String getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(String units) {
        String oldUnits = this.units;
        if (units == null) {
            units = "None";
        }
        this.units = units;
        this.notifyValueChangeListeners(unitsFieldName, oldUnits, this.units);
    }

    public boolean isBusy() {
        return this.busy;
    }

    public void setBusy(boolean busy) {
        boolean oldBusy = this.busy;
        this.busy = busy;
        this.notifyValueChangeListeners(busyFieldName, oldBusy, this.busy);
    }

    public void setFixed(boolean fixed) {
        boolean oldFixed = this.fixed;
        this.fixed = fixed;
        this.notifyValueChangeListeners(fixedFieldName, oldFixed, this.fixed);
    }

    public String getHardwareValue() {
        return this.hardwareValue;
    }

    public void setHardwareValue(String hardwareValue) {
        String oldHardwareValue = this.hardwareValue;
        this.hardwareValue = hardwareValue;
        this.notifyValueChangeListeners(hardwareValueFieldName, oldHardwareValue, this.hardwareValue);
    }

    public Double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(Double tolerance) {
        Double oldTolerance = this.tolerance;
        this.tolerance = tolerance;
        this.notifyValueChangeListeners(toleranceFieldName, oldTolerance, this.tolerance);
    }

    public Integer getChannel() {
        return this.channel;
    }

    public void setChannel(Integer channel) {
        Integer oldChannel = this.channel;
        this.channel = channel;
        this.notifyValueChangeListeners(channelFieldName, oldChannel, this.channel);
    }

    public void setAdditionalProperties(HashMap<String, String> extras) {
        HashMap<String, String> oldExtras = this.extras;
        this.extras = extras;
        this.notifyValueChangeListeners(additionalPropertiesFieldName, oldExtras, this.extras);
    }

    public void updateAdditionalProperties(HashMap<String, String> newExtras) {
        HashMap<String, String> oldExtras = new HashMap<String, String>();
        if (this.extras == null) {
            this.extras = newExtras;
        } else {
            Set<String> propertyNames = this.extras.keySet();
            for (String propName : propertyNames) {
                String value = this.extras.get(propName);
                oldExtras.put(propName, value);
            }
            Set<String> newPropertyNames = newExtras.keySet();
            for (String propName : newPropertyNames) {
                String value = newExtras.get(propName);
                this.extras.put(propName, value);
            }
        }
        this.notifyValueChangeListeners(additionalPropertiesFieldName, oldExtras, this.extras);
    }

    public HashMap<String, String> getAdditionalProperties() {
        return this.extras;
    }

    public String getAdditionalPropertyValue(String propertyName) {
        String value = null;
        value = this.extras.get(propertyName);
        if (value == null) {
            value = this.extras.get(propertyName.toUpperCase());
        }
        return value;
    }

    public Boolean isBroken() {
        return this.brokenState;
    }

    public void setBrokenState(boolean newBroken, boolean oldBroken) {
        if (this.brokenState == newBroken && this.oldBrokenState == oldBroken) {
            return;
        }
        if (this.brokenState != oldBroken) {
            logger.error("The Client's device status is out of sinc with the server");
            this.brokenState = newBroken;
            this.oldBrokenState = oldBroken;
            if (!newBroken && !oldBroken) {
                this.notifyValueChangeListeners(workingFieldName, this.brokenState, this.oldBrokenState);
            } else if (newBroken && oldBroken) {
                this.notifyValueChangeListeners(brokenFieldName, this.brokenState, this.oldBrokenState);
            }
            return;
        }
        this.brokenState = newBroken;
        this.oldBrokenState = oldBroken;
        if (newBroken && !oldBroken) {
            this.notifyValueChangeListeners(justBrokeFieldName, newBroken, oldBroken);
            String message = "IceServer is experiencing communication problems with Device: " + this.getName() + ". IceServer will attempt to reestablish communication" + " automatically.  You will be notified when this device is working again.";
            IceClientInfoEvent event = new IceClientInfoEvent(this, message);
            IcePanelManager panelManager = IcePanelManager.getReference();
            panelManager.notifyIceClientInfoListeners(event);
        } else if (!newBroken && oldBroken) {
            this.notifyValueChangeListeners(justFixedFieldName, this.brokenState, this.oldBrokenState);
            String message = "IceServer has reestablished communication with Device: " + this.getName() + " This device is now working.";
            IceClientInfoEvent event = new IceClientInfoEvent(this, message);
            IcePanelManager panelManager = IcePanelManager.getReference();
            panelManager.notifyIceClientInfoListeners(event);
        }
    }

    public String getPropertyValue(String propertyType, String propertyName) {
        String value = null;
        if (propertyType.equals(additionalPropertiesFieldName)) {
            value = this.getAdditionalPropertyValue(propertyName);
        } else if (propertyType.equals(currentValueFieldName)) {
            value = this.getCurrValue();
        }
        return value;
    }

    public static enum Status {
        normal,
        error,
        countingForever,
        atLimit;

    }

    public static enum Type {
        alias,
        counter,
        environment,
        motor,
        switchType,
        virtual,
        unknown;

    }
}

