/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.DeviceProperty;
import ice.data.IceFileType;
import ice.data.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class BaseScan
extends Resource {
    public static int CENTER_STEP = 40;
    public static int INITIAL_STEP = 41;
    public static int INITIAL_FINAL = 42;
    private String prefix = null;
    private String comments = null;
    private ScanType type;
    private String submissionID;
    private long numPoints;
    private double prefactor;
    private double baseCount;
    private DataOfInterest dataOfInterest;
    private CountType countType;
    private Double countTimeout;
    private FixedEnergy fixedEnergyDevice;
    private Double fixedEnergy;
    private Double pointHold;
    private Double preScanHold;
    private Double tempSetPoint;
    private Double tempTolerance;
    private Double tempToleranceBT;
    private Double tempMaxWaitTime;
    private Double magSetPoint;
    private Double magTolerance;
    private HashMap<String, Range> deviceRanges;
    private int rangeMode;
    private ArrayList<DeviceProperty> presetProperties;

    public BaseScan(ScanType type, String submissionID) {
        super("", "", IceFileType.scan);
        this.type = type;
        this.submissionID = submissionID;
        this.numPoints = -1L;
        this.prefactor = 1.0;
        this.baseCount = -1.0;
        this.dataOfInterest = DataOfInterest.detector;
        this.countType = CountType.monitor;
        this.countTimeout = null;
        this.fixedEnergyDevice = FixedEnergy.nothing;
        this.fixedEnergy = null;
        this.pointHold = null;
        this.preScanHold = null;
        this.tempSetPoint = null;
        this.tempTolerance = null;
        this.tempToleranceBT = null;
        this.tempMaxWaitTime = null;
        this.magSetPoint = null;
        this.magTolerance = null;
        this.deviceRanges = new HashMap();
        this.setFileType(IceFileType.valueOf(type.toString()));
        this.presetProperties = new ArrayList();
    }

    public boolean addDeviceRange(String deviceToAdd, double firstValue, double secondValue) {
        if (this.deviceRanges.get(deviceToAdd) == null) {
            this.deviceRanges.put(deviceToAdd, new Range(firstValue, secondValue));
            return true;
        }
        return false;
    }

    public boolean removeDeviceRange(String deviceToRemove) {
        return this.deviceRanges.remove(deviceToRemove) != null;
    }

    public double getBaseCount() {
        return this.baseCount;
    }

    public void setBaseCount(double baseCount) {
        this.baseCount = baseCount;
    }

    public String getComments() {
        if (this.comments == null) {
            return this.comments;
        }
        try {
            if (this.comments.startsWith("\"") && this.comments.endsWith("\"") && this.comments.length() > 2) {
                return this.comments.substring(1, this.comments.length() - 1).replaceAll("\\\\\"", "\"");
            }
            return this.comments.replaceAll("\\\\\"", "\"");
        }
        catch (Exception e) {
            return this.comments;
        }
    }

    public void setComments(String comments) {
        this.comments = comments;
        if (this.comments == null) {
            return;
        }
        try {
            this.comments = this.comments.trim();
            this.comments = this.comments.replaceAll("\r\n", " ");
            this.comments = this.comments.replaceAll("\n", " ");
            if (this.comments.startsWith("\"")) {
                if (this.comments.endsWith("\"")) {
                    if (this.comments.length() > 2) {
                        this.comments = "\"" + this.comments.substring(1, this.comments.length() - 1).replaceAll("[^\\\\]\"", "\\\\\"") + "\"";
                    }
                } else {
                    this.comments = "\"" + this.comments.substring(1, this.comments.length()).replaceAll("[^\\\\]\"", "\\\\\"") + "\"";
                }
            } else if (this.comments.length() > 0) {
                this.comments = "\"" + this.comments.replaceAll("\"", "\\\\\"") + "\"";
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void appendComments(String comments) {
        if (comments == null) {
            return;
        }
        try {
            if (this.comments == null) {
                this.comments = "";
            }
            comments = comments.trim();
            comments = comments.replaceAll("\r\n", " ");
            comments = comments.replaceAll("\n", " ");
            if (this.comments.startsWith("\"")) {
                if (this.comments.endsWith("\"") && this.comments.length() > 1 && this.comments.charAt(this.comments.length() - 2) != '\\') {
                    this.comments = this.comments.substring(0, this.comments.length() - 1);
                }
                if (comments.endsWith("\"")) {
                    comments = comments.substring(0, comments.length() - 1);
                }
                this.comments = String.valueOf(this.comments) + comments.replaceAll("[^\\\\]\"", "\\\\\"") + "\"";
            } else if (this.comments.length() > 0 || comments.length() > 0) {
                this.comments = "\"" + this.comments + comments.replaceAll("[^\\\\]\"", "\\\\\"") + "\"";
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public Double getCountTimeout() {
        return this.countTimeout;
    }

    public void setCountTimeout(Double countTimeout) {
        this.countTimeout = countTimeout;
    }

    public CountType getCountType() {
        return this.countType;
    }

    public void setCountType(CountType countType) {
        this.countType = countType;
    }

    public DataOfInterest getDataOfInterest() {
        return this.dataOfInterest;
    }

    public void setDataOfInterest(DataOfInterest dataOfInterest) {
        this.dataOfInterest = dataOfInterest;
    }

    public long getNumPoints() {
        return this.numPoints;
    }

    public void setNumPoints(long numPoints) {
        this.numPoints = numPoints;
    }

    public double getPrefactor() {
        return this.prefactor;
    }

    public void setPrefactor(double prefactor) {
        this.prefactor = prefactor;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSubmissionID() {
        return this.submissionID;
    }

    public void setSubmissionID(String submissionID) {
        this.submissionID = submissionID;
    }

    public ScanType getScanType() {
        return this.type;
    }

    public void setScanType(ScanType type) {
        this.type = type;
    }

    public Double getFixedEnergy() {
        return this.fixedEnergy;
    }

    public void setFixedEnergy(Double fixedEnergy) {
        this.fixedEnergy = fixedEnergy;
    }

    public FixedEnergy getFixedEnergyDevice() {
        return this.fixedEnergyDevice;
    }

    public void setFixedEnergyDevice(FixedEnergy fixedEnergyDevice) {
        this.fixedEnergyDevice = fixedEnergyDevice;
    }

    public Double getPointHold() {
        return this.pointHold;
    }

    public void setPointHold(Double pointHold) {
        this.pointHold = pointHold;
    }

    public Double getPreScanHold() {
        return this.preScanHold;
    }

    public void setPreScanHold(Double preHold) {
        this.preScanHold = preHold;
    }

    public Double gettempSetPoint() {
        return this.tempSetPoint;
    }

    public void settempSetPoint(Double tempSetPoint) {
        this.tempSetPoint = tempSetPoint;
    }

    public Double gettempTolerance() {
        return this.tempTolerance;
    }

    public void settempTolerance(Double tempTolerance) {
        this.tempTolerance = tempTolerance;
    }

    public Double gettempToleranceBT() {
        return this.tempToleranceBT;
    }

    public void settempToleranceBT(Double tempToleranceBT) {
        this.tempToleranceBT = tempToleranceBT;
    }

    public Double gettempMaxWaitTime() {
        return this.tempMaxWaitTime;
    }

    public void settempMaxWaitTime(Double tempMaxWaitTime) {
        this.tempMaxWaitTime = tempMaxWaitTime;
    }

    public Double getmagSetPoint() {
        return this.magSetPoint;
    }

    public void setmagSetPoint(Double magSetPoint) {
        this.magSetPoint = magSetPoint;
    }

    public Double getmagTolerance() {
        return this.magTolerance;
    }

    public void setmagTolerance(Double magTolerance) {
        this.magTolerance = magTolerance;
    }

    public int getRangeMode() {
        return this.rangeMode;
    }

    public void setRangeMode(int rangeMode) {
        this.rangeMode = rangeMode;
    }

    @Override
    public String getContents() {
        String contents = " Scan";
        contents = String.valueOf(contents) + ":Title=" + this.getName();
        contents = String.valueOf(contents) + ":SubID=" + this.getSubmissionID();
        contents = String.valueOf(contents) + ":JTYPE=" + this.getScanType().getName();
        if (this.getFixedEnergyDevice() == FixedEnergy.monochromator) {
            contents = String.valueOf(contents) + ":FIXED=0";
        } else if (this.getFixedEnergyDevice() == FixedEnergy.analyzer) {
            contents = String.valueOf(contents) + ":FIXED=1";
        }
        if (this.getFixedEnergy() != null) {
            contents = String.valueOf(contents) + ":FIXEDE=" + this.getFixedEnergy();
        }
        if (this.getPrefix() != null) {
            contents = String.valueOf(contents) + ":Filename=" + this.getPrefix();
        }
        contents = String.valueOf(contents) + ":Npts=" + this.getNumPoints();
        contents = String.valueOf(contents) + ":Counts=" + this.getBaseCount();
        contents = String.valueOf(contents) + ":Prefac=" + this.getPrefactor();
        contents = String.valueOf(contents) + ":DetectorType=" + (Object)((Object)this.getDataOfInterest());
        contents = String.valueOf(contents) + ":CountType=" + (Object)((Object)this.getCountType());
        if (this.getCountTimeout() != null) {
            contents = String.valueOf(contents) + ":Timeout=" + this.getCountTimeout();
        }
        if (this.getPreScanHold() != null) {
            contents = String.valueOf(contents) + ":HoldScan=" + this.getPreScanHold();
        }
        if (this.getPointHold() != null) {
            contents = String.valueOf(contents) + ":HoldPoint=" + this.getPointHold();
        }
        String modestr = "";
        if (this.getRangeMode() == INITIAL_STEP) {
            modestr = "I";
        } else if (this.getRangeMode() == INITIAL_FINAL) {
            modestr = "S";
        }
        HashMap<String, Range> ranges = this.getDeviceRanges();
        Set<String> devnames = ranges.keySet();
        Double h1 = null;
        Double k1 = null;
        Double l1 = null;
        Double h2 = null;
        Double k2 = null;
        Double l2 = null;
        Iterator<String> riter = devnames.iterator();
        while (riter.hasNext()) {
            String containsPreset;
            String dev = riter.next();
            if (dev.compareToIgnoreCase("H") == 0) {
                h1 = new Double(ranges.get(dev).getFirstValue());
                h2 = new Double(ranges.get(dev).getSecondValue());
                continue;
            }
            if (dev.compareToIgnoreCase("K") == 0) {
                k1 = new Double(ranges.get(dev).getFirstValue());
                k2 = new Double(ranges.get(dev).getSecondValue());
                continue;
            }
            if (dev.compareToIgnoreCase("L") == 0) {
                l1 = new Double(ranges.get(dev).getFirstValue());
                l2 = new Double(ranges.get(dev).getSecondValue());
                continue;
            }
            contents = String.valueOf(contents) + ":Range=" + dev + "=" + ranges.get(dev).getFirstValue() + " " + ranges.get(dev).getSecondValue() + " " + modestr;
            if (!dev.toUpperCase().equals("DUMMYTEMP") && !dev.toUpperCase().equals("LAKESHORE331") && !dev.toUpperCase().equals("LAKESHORE340") && !dev.toUpperCase().equals("OXFORDTEMP") && !dev.toUpperCase().equals("EUROFURNACE") && !dev.toUpperCase().equals("FURNACE") && !dev.toUpperCase().equals("TEMP") && !dev.toUpperCase().equals("LAKESHORE7T") && !dev.toUpperCase().equals("LAKESHORE7SHORT") && !dev.toUpperCase().equals("OXFORD11T") && !dev.toUpperCase().equals("OXFORD7T") && !dev.toUpperCase().equals("OXFORD11TEST") && !dev.toUpperCase().equals("OXFORD11SHORT") && !dev.toUpperCase().equals("MAGFIELD")) continue;
            boolean oneEnvDevice = true;
            Iterator<String> anotherEnvDevice = riter;
            while (anotherEnvDevice.hasNext()) {
                String dev2 = anotherEnvDevice.next();
                if (dev2.toUpperCase().equals("DUMMYTEMP") || dev2.toUpperCase().equals("LAKESHORE331") || dev2.toUpperCase().equals("LAKESHORE340") || dev2.toUpperCase().equals("OXFORDTEMP") || dev2.toUpperCase().equals("EUROFURNACE") || dev2.toUpperCase().equals("FURNACE") || dev2.toUpperCase().equals("TEMP")) {
                    if (this.gettempTolerance() == null || this.gettempToleranceBT() == null || this.gettempMaxWaitTime() == null || this.getmagTolerance() == null) continue;
                    contents = String.valueOf(contents) + ":Range=" + dev2 + "=" + ranges.get(dev2).getFirstValue() + " " + ranges.get(dev2).getSecondValue() + " " + modestr;
                    contents = String.valueOf(contents) + ":presetdevicesproperties=" + dev2 + " " + "tolerance " + this.gettempTolerance() + " " + "toleranceDT " + this.gettempToleranceBT() + " " + "timeout " + this.gettempMaxWaitTime() + "|" + dev + " " + "tolerance " + this.getmagTolerance();
                    oneEnvDevice = false;
                    break;
                }
                if (!dev2.toUpperCase().equals("LAKESHORE7T") && !dev2.toUpperCase().equals("LAKESHORE7SHORT") && !dev2.toUpperCase().equals("OXFORD11T") && !dev2.toUpperCase().equals("OXFORD7T") && !dev2.toUpperCase().equals("OXFORD11TEST") && !dev2.toUpperCase().equals("OXFORD11SHORT") && !dev2.toUpperCase().equals("MAGFIELD") || this.gettempTolerance() == null || this.gettempToleranceBT() == null || this.gettempMaxWaitTime() == null || this.getmagTolerance() == null) continue;
                contents = String.valueOf(contents) + ":Range=" + dev2 + "=" + ranges.get(dev2).getFirstValue() + " " + ranges.get(dev2).getSecondValue() + " " + modestr;
                contents = String.valueOf(contents) + ":presetdevicesproperties=" + dev2 + " " + "tolerance " + this.gettempTolerance() + " " + "toleranceDT " + this.gettempToleranceBT() + " " + "timeout " + this.gettempMaxWaitTime() + "|" + dev + " " + "tolerance " + this.getmagTolerance();
                oneEnvDevice = false;
                break;
            }
            if (this.gettempTolerance() != null && this.gettempToleranceBT() != null && this.gettempMaxWaitTime() != null && oneEnvDevice && this.getmagTolerance() == null) {
                if (dev.toUpperCase().equals("MAGFIELD")) {
                    contents = String.valueOf(contents) + ":presetdevicesproperties=Temp tolerance " + this.gettempTolerance() + " " + "toleranceDT " + this.gettempToleranceBT() + " " + "timeout " + this.gettempMaxWaitTime();
                    continue;
                }
                contents = String.valueOf(contents) + ":presetdevicesproperties=" + dev + " " + "tolerance " + this.gettempTolerance() + " " + "toleranceDT " + this.gettempToleranceBT() + " " + "timeout " + this.gettempMaxWaitTime();
                continue;
            }
            if (this.getmagTolerance() != null && oneEnvDevice && this.gettempTolerance() == null && this.gettempToleranceBT() == null && this.gettempMaxWaitTime() == null) {
                if (dev.toUpperCase().equals("TEMP")) {
                    contents = String.valueOf(contents) + ":presetdevicesproperties=MagField tolerance " + this.getmagTolerance();
                    continue;
                }
                contents = String.valueOf(contents) + ":presetdevicesproperties=" + dev + " " + "tolerance " + this.getmagTolerance();
                continue;
            }
            if (this.gettempTolerance() == null || this.getmagTolerance() == null || contents.contains(containsPreset = "presetdevicesproperties")) continue;
            contents = String.valueOf(contents) + ":presetdevicesproperties=Temp tolerance " + this.gettempTolerance() + " " + "toleranceDT " + this.gettempToleranceBT() + " " + "timeout " + this.gettempMaxWaitTime() + "|" + "MagField" + " " + "tolerance " + this.getmagTolerance();
        }
        if (h1 != null && k1 != null && l1 != null && h2 != null && k2 != null && l2 != null) {
            contents = String.valueOf(contents) + ":Range=Q=" + h1 + "~" + k1 + "~" + l1 + " " + h2 + "~" + k2 + "~" + l2 + " " + modestr;
        }
        if (this.getComments() != null) {
            contents = String.valueOf(contents) + ":Comment=" + this.getComments();
        }
        return contents;
    }

    @Override
    public String getExtension() {
        return null;
    }

    @Override
    public IceFileType getFileType() {
        return IceFileType.valueOf(this.type.toString());
    }

    public HashMap<String, Range> getDeviceRanges() {
        return this.deviceRanges;
    }

    public void setDeviceRanges(HashMap<String, Range> deviceRanges) {
        this.deviceRanges = deviceRanges;
    }

    @Override
    public IceFileType getType() {
        return IceFileType.valueOf(this.type.toString());
    }

    public void addPresetDeviceProperty(String device, String property, String value) {
        DeviceProperty pair = new DeviceProperty(device, property, value);
        this.presetProperties.add(pair);
    }

    public DeviceProperty getPresetDeviceProperty(String device, String prop) {
        DeviceProperty devProperty = null;
        for (DeviceProperty property : this.presetProperties) {
            String deviceName = property.getDeviceName();
            String propName = property.getPropertyName();
            if (!deviceName.equalsIgnoreCase(device) || !propName.equalsIgnoreCase(prop)) continue;
            devProperty = property;
            break;
        }
        return devProperty;
    }

    public String getPresetDevicePropertyValue(String device, String prop) {
        String value = "N/A";
        DeviceProperty devProperty = this.getPresetDeviceProperty(device, prop);
        if (devProperty != null) {
            value = devProperty.getValue();
        }
        return value;
    }

    public ArrayList<DeviceProperty> getPresetDeviceProperties() {
        return this.presetProperties;
    }

    public void updatePresetDeviceProperties(ArrayList<DeviceProperty> presetDeviceProperties) {
        this.presetProperties.clear();
        for (DeviceProperty property : presetDeviceProperties) {
            String deviceName = property.getDeviceName();
            String propertyName = property.getPropertyName();
            String value = property.getValue();
            DeviceProperty newProperty = new DeviceProperty(deviceName, propertyName, value);
            this.presetProperties.add(newProperty);
        }
    }

    public static enum CountType {
        monitor,
        time,
        unknown;

    }

    public static enum DataOfInterest {
        detector,
        monitor,
        time,
        unknown;

    }

    public static enum FixedEnergy {
        monochromator,
        analyzer,
        nothing;

    }

    public class Range {
        private double firstValue;
        private double secondValue;

        public Range(double firstValue, double secondValue) {
            this.firstValue = firstValue;
            this.secondValue = secondValue;
        }

        public Range() {
        }

        public double getFirstValue() {
            return this.firstValue;
        }

        public void setFirstValue(double firstValue) {
            this.firstValue = firstValue;
        }

        public double getSecondValue() {
            return this.secondValue;
        }

        public void setSecondValue(double secondValue) {
            this.secondValue = secondValue;
        }
    }

    public static enum ScanType {
        angleScan("ANGLE"),
        environmentScan("ENV"),
        motorScan("MOTOR"),
        vectorScan("VECTOR"),
        sansScan("SANS"),
        sansAutoScan("SANSAUTO"),
        unknownScan("UNKNOWN");

        private String name;

        private ScanType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

