/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.AvailableEnvDevice;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AvailableMagnetDevice
extends AvailableEnvDevice {
    public static final String maxUpperTiltFieldName = "maxUpperTilt";
    public static final String maxLowerTiltFieldName = "maxLowerTilt";
    public static final String persistenceModeFieldName = "persistenceMode";
    private static Logger logger = Logger.getLogger("ice.ServerModel.AvailableMagnetDevice");
    protected double maxUpperTilt;
    protected double maxLowerTilt;
    protected boolean persistenceMode;

    public static List<AvailableMagnetDevice> parseXmlList(Node listNode) {
        ArrayList<AvailableMagnetDevice> deviceList = new ArrayList<AvailableMagnetDevice>();
        NodeList deviceNodes = listNode.getChildNodes();
        int i = 0;
        while (i < deviceNodes.getLength()) {
            Node deviceNode = deviceNodes.item(i);
            if (1 == deviceNode.getNodeType()) {
                String units = null;
                Double maxUpperTilt = null;
                Double maxLowerTilt = null;
                Boolean persistenceMode = null;
                String deviceName = deviceNode.getNodeName();
                NodeList deviceProperties = deviceNode.getChildNodes();
                int j = 0;
                while (j < deviceProperties.getLength()) {
                    Node devicePropertyNode = deviceProperties.item(j);
                    if (1 == devicePropertyNode.getNodeType()) {
                        String devicePropertyName = devicePropertyNode.getNodeName();
                        if ("units".equals(devicePropertyName)) {
                            logger.debug("units");
                            units = devicePropertyNode.getFirstChild().getNodeValue().trim();
                        } else if ("lowerTiltLimit".equals(devicePropertyName)) {
                            logger.debug("lower tilt");
                            try {
                                maxLowerTilt = Double.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException nfe) {
                                logger.error("Invalid max lower tilt.  This shouldn't happen.  Ignoring.", nfe);
                            }
                        } else if ("upperTiltLimit".equals(devicePropertyName)) {
                            logger.debug("upper tilt");
                            try {
                                maxUpperTilt = Double.valueOf(devicePropertyNode.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException nfe) {
                                logger.error("Invalid max upper tilt.  This shouldn't happen.  Ignoring.", nfe);
                            }
                        } else if ("persistenceFlag".equals(devicePropertyName)) {
                            String value = devicePropertyNode.getFirstChild().getNodeValue().trim();
                            if ("0".equals(value)) {
                                persistenceMode = false;
                            } else if ("1".equals(value)) {
                                persistenceMode = true;
                            }
                        }
                    }
                    ++j;
                }
                AvailableMagnetDevice device = new AvailableMagnetDevice(deviceName, units, maxUpperTilt, maxLowerTilt, persistenceMode);
                deviceList.add(device);
            }
            ++i;
        }
        return deviceList;
    }

    public AvailableMagnetDevice(String name, String units, double maxUpperTilt, double maxLowerTilt, boolean persistenceMode) {
        super(name, units);
        this.maxUpperTilt = maxUpperTilt;
        this.maxLowerTilt = maxLowerTilt;
        this.persistenceMode = persistenceMode;
    }

    public double getMaxLowerTilt() {
        return this.maxLowerTilt;
    }

    public void setMaxLowerTilt(double newMaxLowerTilt) {
        double oldMaxLowerTilt = this.maxLowerTilt;
        this.maxLowerTilt = newMaxLowerTilt;
        this.notifyValueChangeListeners(maxLowerTiltFieldName, oldMaxLowerTilt, this.maxLowerTilt);
    }

    public double getMaxUpperTilt() {
        return this.maxUpperTilt;
    }

    public void setMaxUpperTilt(double newMaxUpperTilt) {
        double oldMaxUpperTilt = this.maxUpperTilt;
        this.maxUpperTilt = newMaxUpperTilt;
        this.notifyValueChangeListeners(maxUpperTiltFieldName, oldMaxUpperTilt, this.maxUpperTilt);
    }

    public boolean isPersistenceMode() {
        return this.persistenceMode;
    }

    public void setPersistenceMode(boolean newPersistenceMode) {
        boolean oldPersistenceMode = this.persistenceMode;
        this.persistenceMode = newPersistenceMode;
        this.notifyValueChangeListeners(persistenceModeFieldName, oldPersistenceMode, this.persistenceMode);
    }
}

