/*
 * Decompiled with CFR 0.152.
 */
package ice.data;

import ice.data.AvailableEnvDevice;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AvailableElectromagnetDevice
extends AvailableEnvDevice {
    public static final String PROPERTY_LAST_MAGNET_CURRENT = "lastMagnetCurrent";
    public static final String PROPERTY_VOLTAGE_CONVERSION = "voltageConversion";
    public static final String PROPERTY_CURRENT_CONVERSION = "currentConversion";
    public static final String PROPERTY_SET_POINT = "setPoint";
    public static final String PROPERTY_SET_CURRENT = "setcurrent";
    public static final String PROPERTY_CURRENT_LIMIT = "currentLimit";
    public static final String PROPERTY_SET_VOLTAGE = "setVoltage";
    public static final String PROPERTY_NEG_SOFT_LIMIT = "negSoftLimit";
    public static final String PROPERTY_POS_SOFT_LIMIT = "posSoftLimit";
    public static final String PROPERTY_UNITS = "units";
    public static final String PROPERTY_VOLTAGE_LIMIT = "voltageLimit";
    protected String name;
    protected Double lastMagnetCurrent = null;
    protected Double voltageConversion = null;
    protected Double currentConversion = null;
    protected Double setPoint = null;
    protected Double setCurrent = null;
    protected Double currentLimit = null;
    protected Double setVoltage = null;
    protected Double voltageLimit = null;
    protected Double negSoftLimit = null;
    protected Double posSoftLimit = null;
    protected String units = null;
    private static Logger logger = Logger.getLogger("ice.ServerModel.AvailableElectromagnetDevice");

    public static List<AvailableElectromagnetDevice> parseXmlList(Node listNode) {
        ArrayList<AvailableElectromagnetDevice> electromagList = new ArrayList<AvailableElectromagnetDevice>();
        String name = null;
        String units = null;
        Double lastMagnetCurrent = null;
        Double voltageConversion = null;
        Double currentConversion = null;
        Double setPoint = null;
        Double setCurrent = null;
        Double currentLimit = null;
        Double setVoltage = null;
        Double voltageLimit = null;
        Double negSoftLimit = null;
        Double posSoftLimit = null;
        try {
            NodeList xmlDeviceList = listNode.getChildNodes();
            int nodeNum = 0;
            while (nodeNum < xmlDeviceList.getLength()) {
                try {
                    name = xmlDeviceList.item(nodeNum).getNodeName();
                    Element deviceElement = (Element)xmlDeviceList.item(nodeNum);
                    units = AvailableElectromagnetDevice.getPropertyFromDeviceXml(deviceElement, PROPERTY_UNITS);
                    lastMagnetCurrent = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_LAST_MAGNET_CURRENT);
                    voltageConversion = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_VOLTAGE_CONVERSION);
                    currentConversion = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_CURRENT_CONVERSION);
                    setPoint = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_SET_POINT);
                    setCurrent = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_SET_CURRENT);
                    currentLimit = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_CURRENT_LIMIT);
                    setVoltage = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_SET_VOLTAGE);
                    voltageLimit = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_VOLTAGE_LIMIT);
                    posSoftLimit = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_POS_SOFT_LIMIT);
                    negSoftLimit = AvailableElectromagnetDevice.getPropertyDoubleFromDeviceXml(deviceElement, PROPERTY_NEG_SOFT_LIMIT);
                    electromagList.add(new AvailableElectromagnetDevice(name, units, setPoint, setCurrent, currentLimit, currentConversion, lastMagnetCurrent, negSoftLimit, posSoftLimit, setVoltage, voltageConversion, voltageLimit));
                }
                catch (Exception e) {
                    logger.error("Error creating AvailableElectromagnetDevice from xml.", e);
                }
                ++nodeNum;
            }
        }
        catch (Exception e) {
            logger.error("Error parsing available electromagnet devices.", e);
        }
        return electromagList;
    }

    protected static String getPropertyFromDeviceXml(Element deviceElement, String propertyName) {
        String property = null;
        try {
            property = deviceElement.getElementsByTagName(propertyName).item(0).getTextContent();
        }
        catch (DOMException e1) {
            if (propertyName == null) {
                propertyName = "";
            }
            logger.error("Error parsing AvailableElectromagnet " + propertyName, e1);
            return null;
        }
        catch (Exception e) {
            if (propertyName == null) {
                propertyName = "";
            }
            logger.error("Error parsing AvailableElectromagnet " + propertyName, e);
            return null;
        }
        return property;
    }

    protected static Double getPropertyDoubleFromDeviceXml(Element deviceElement, String propertyName) {
        String val = AvailableElectromagnetDevice.getPropertyFromDeviceXml(deviceElement, propertyName);
        if (val == null) {
            return null;
        }
        try {
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            if (propertyName == null) {
                propertyName = "";
            }
            logger.error("Error parsing property " + propertyName + ".  " + val + " is not a valid double.", e.getCause());
            return null;
        }
    }

    public AvailableElectromagnetDevice(String name, String units, Double setPoint, Double setCurrent, Double currentLimit, Double currentConversion, Double lastMagnetCurrent, Double negSoftLimit, Double posSoftLimit, Double setVoltage, Double voltageConversion, Double voltageLimit) {
        super(name, units);
        this.currentConversion = currentConversion;
        this.currentLimit = currentLimit;
        this.lastMagnetCurrent = lastMagnetCurrent;
        this.negSoftLimit = negSoftLimit;
        this.posSoftLimit = posSoftLimit;
        this.setCurrent = setCurrent;
        this.setPoint = setPoint;
        this.setVoltage = setVoltage;
        this.voltageConversion = voltageConversion;
        this.voltageLimit = voltageLimit;
    }

    @Override
    public void setUnits(String units) {
        this.units = units;
    }

    public void setLastMagnetCurrent(Double lastMagnetCurrent) {
        this.lastMagnetCurrent = lastMagnetCurrent;
    }

    public void setVoltageConversion(Double voltageConversion) {
        this.voltageConversion = voltageConversion;
    }

    public void setCurrentConversion(Double currentConversion) {
        this.currentConversion = currentConversion;
    }

    public void setSetPoint(Double setPoint) {
        this.setPoint = setPoint;
    }

    public void setSetCurrent(Double setCurrent) {
        this.setCurrent = setCurrent;
    }

    public void setCurrentLimit(Double currentLimit) {
        this.currentLimit = currentLimit;
    }

    public void setSetVoltage(Double setVoltage) {
        this.setVoltage = setVoltage;
    }

    public void setNegSoftLimit(Double negSoftLimit) {
        this.negSoftLimit = negSoftLimit;
    }

    public void setPosSoftLimit(Double posSoftLimit) {
        this.posSoftLimit = posSoftLimit;
    }

    public Double getVoltageLimit() {
        return this.voltageLimit;
    }
}

