/*
 * Decompiled with CFR 0.152.
 */
package ice.communication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;
import org.apache.log4j.Logger;

public class DispatcherConnection {
    private static Logger logger = Logger.getLogger("NetworkLogger");
    private static final int tagFieldLen = 8;
    private static final int lenFieldLen = 4;
    private int port = 5553;
    private static String DispID;
    private static String user;
    private static String hostname;
    private static String display;
    private static int PID;
    private static boolean debug;
    public static final int DEFAULTPORT = 5553;
    private Socket s;
    private InputStream in;
    private OutputStream out;
    private int inp_datalen = -1;
    private byte[] prefix = new byte[12];

    static {
        debug = false;
    }

    public DispatcherConnection(String newUser, String newDisplay) {
        user = newUser;
        display = newDisplay;
        Random r = new Random();
        PID = r.nextInt(999);
        int stringLength = 4;
        if (user.length() < stringLength) {
            stringLength = user.length();
        }
        DispID = String.valueOf(user.toUpperCase().substring(0, stringLength)) + PID;
        logger.debug("DispID: " + DispID);
    }

    public boolean connected() {
        return this.s != null;
    }

    public synchronized void connect(String disphost) throws IOException, UnknownHostException, SocketException {
        this.disconnect();
        this.s = new Socket(disphost, this.port);
        this.in = this.s.getInputStream();
        this.out = this.s.getOutputStream();
        logger.debug("s: " + this.s);
        logger.debug("in: " + this.in);
        logger.debug("out: " + this.out);
    }

    public synchronized void connect(String disphost, int timeout) throws IOException, UnknownHostException, SocketException {
        this.disconnect();
        InetSocketAddress address = new InetSocketAddress(disphost, this.port);
        this.s = new Socket();
        this.s.connect(address, timeout);
        this.in = this.s.getInputStream();
        this.out = this.s.getOutputStream();
        logger.debug("s: " + this.s);
        logger.debug("in: " + this.in);
        logger.debug("out: " + this.out);
    }

    public synchronized void reconnect() throws IOException, UnknownHostException, SocketException {
        this.s = new Socket(this.s.getInetAddress(), this.port);
        this.in = this.s.getInputStream();
        this.out = this.s.getOutputStream();
    }

    public synchronized void disconnect() {
        if (this.connected()) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.in = null;
            try {
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out = null;
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.s = null;
        }
    }

    public void send(String tag, String data) throws IOException {
        byte[] bdata = data.getBytes();
        boolean isOutputShutDown = this.s.isOutputShutdown();
        boolean isClosed = this.s.isClosed();
        boolean isConnected = this.s.isConnected();
        boolean isBound = this.s.isBound();
        DispatcherConnection.send(this.out, tag, bdata, bdata.length);
    }

    public void send(String tag, byte[] data, int datalen) throws IOException {
        DispatcherConnection.send(this.out, tag, data, datalen);
    }

    public synchronized ServerMessage getMessage() throws IOException {
        ServerMessage serverMessage = null;
        String tag = null;
        byte[] messageBuffer = null;
        tag = this.get_tag();
        messageBuffer = this.get_data();
        serverMessage = new ServerMessage(tag, messageBuffer);
        return serverMessage;
    }

    private synchronized String get_tag() throws IOException {
        String returnValue = "";
        if (this.inp_datalen > 0) {
            throw new IOException("Trying to get the tag while data is not received yet");
        }
        int rc = 0;
        int pos = 0;
        int i = 0;
        while (i < this.prefix.length) {
            this.prefix[i] = 0;
            ++i;
        }
        pos = 0;
        while (pos < this.prefix.length) {
            rc = this.in.read(this.prefix, pos, this.prefix.length - pos);
            if (rc < 0) {
                throw new IOException("DispatcherConnection.get_tag Could not read in the entire prefix");
            }
            pos += rc;
        }
        i = 0;
        this.inp_datalen = 0;
        i = 8;
        while (i < 12) {
            this.inp_datalen <<= 8;
            this.inp_datalen += this.prefix[i] & 0xFF;
            ++i;
        }
        if (this.inp_datalen < 0) {
            this.disconnect();
            throw new IOException("Wrong data len arrived");
        }
        i = 0;
        while (i < 8 && this.prefix[i] != 0) {
            ++i;
        }
        returnValue = new String(this.prefix, 0, i);
        return returnValue;
    }

    private synchronized byte[] get_data() throws IOException {
        if (this.inp_datalen < 0) {
            throw new IOException("Trying to get the data while tag is not received yet," + this.inp_datalen);
        }
        if (this.inp_datalen == 0) {
            this.inp_datalen = -1;
            return new byte[0];
        }
        byte[] res = new byte[this.inp_datalen];
        int pos = 0;
        while (pos < this.inp_datalen) {
            int rc = this.in.read(res, pos, this.inp_datalen - pos);
            if (rc < 0) {
                this.inp_datalen = -1;
                throw new IOException("Incomplete data block on input");
            }
            pos += rc;
        }
        this.inp_datalen = -1;
        return res;
    }

    public void always() throws IOException {
        this.send("Always", "");
    }

    public void gime() throws IOException {
        this.send("Gime", "");
    }

    public void myid(String id) throws IOException {
        this.send("MyId", id);
    }

    public String my_id() {
        return new String(DispID);
    }

    public void subscribe(String subscr) throws IOException {
        this.send("Subscribe", subscr);
    }

    public void trace(boolean dotrace) {
        debug = dotrace;
    }

    public String whereis(String disphost, String clientid) throws IOException, UnknownHostException, SocketException {
        int pos;
        Socket disp = new Socket(disphost, this.port);
        disp.setTcpNoDelay(false);
        InputStream inp = disp.getInputStream();
        OutputStream out = disp.getOutputStream();
        byte[] bid = clientid.getBytes();
        DispatcherConnection.send(out, "WhereIs", bid, bid.length);
        String res = "";
        byte[] buffer = new byte[100];
        do {
            pos = 0;
            while (pos < buffer.length) {
                int rc = inp.read(buffer, pos, buffer.length - pos);
                if (rc < 0) break;
                pos += rc;
            }
            res = String.valueOf(res) + new String(buffer, 0, pos);
        } while (pos == buffer.length);
        out.close();
        inp.close();
        disp.close();
        return res;
    }

    protected void finalize() {
        this.disconnect();
    }

    protected static synchronized void send(OutputStream out, String tag, byte[] data, int datalen) throws IOException {
        if (datalen < 0) {
            throw new IOException("Wrong data length");
        }
        byte[] btag = tag.getBytes();
        int L2 = btag.length;
        byte[] prefix = new byte[12];
        int i = 0;
        while (i < L2 && i < 8) {
            prefix[i] = btag[i];
            ++i;
        }
        while (i < 8) {
            prefix[i] = 0;
            ++i;
        }
        L2 = datalen;
        i = 11;
        while (i >= 8) {
            prefix[i] = (byte)L2;
            L2 >>= 8;
            --i;
        }
        out.write(prefix);
        out.write(data, 0, datalen);
        out.flush();
    }

    public void register() throws IOException, UnknownHostException {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException uhe) {
            logger.error("Unable to get local hostname.", uhe);
            throw uhe;
        }
        String regmsg = String.valueOf(DispID) + " Register " + user + " " + hostname + " " + display + " " + PID;
        logger.debug("Registration message: " + regmsg);
        this.send("CONTROL", regmsg);
    }

    public static String getDispID() {
        return DispID;
    }

    public class ServerMessage {
        private String tag;
        private byte[] messageBuffer;

        ServerMessage(String tag, byte[] messageBuffer) {
            this.tag = tag;
            this.messageBuffer = messageBuffer;
        }

        public String getTag() {
            return this.tag;
        }

        public byte[] getMessageBuffer() {
            return this.messageBuffer;
        }
    }
}

