/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class UpdateDeviceBrokenStateCommand
extends ImmediateCommand {
    private static final String command = "UPDATEDEVICEBROKENSTATE";
    private String deviceName = null;

    public UpdateDeviceBrokenStateCommand() throws NoClientAPIInstanceException {
    }

    public UpdateDeviceBrokenStateCommand(String deviceName) throws NoClientAPIInstanceException {
        super("UPDATEDEVICEBROKENSTATE " + deviceName);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public UpdateDeviceBrokenStateCommand(String deviceName, ClientAPI clientApiRef) {
        super("UPDATEDEVICEBROKENSTATE " + deviceName, clientApiRef);
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString("UPDATEDEVICEBROKENSTATE " + this.deviceName);
        return "UPDATEDEVICEBROKENSTATE " + this.deviceName;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        String expectedResponse;
        String response = this.getResponse();
        if (response.equals(expectedResponse = "The broken state of device " + this.deviceName + " is being updated.")) {
            this.setSuccess(true);
            this.setError(false);
        } else {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return "UPDATEDEVICEBROKENSTATE " + this.deviceName;
    }
}

