/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class SetDeviceLockIDCommand
extends ImmediateCommand {
    private static final String command = "SETDEVICELOCKID";
    private String lockID = "0";
    private String deviceName = null;

    public SetDeviceLockIDCommand() throws NoClientAPIInstanceException {
    }

    public SetDeviceLockIDCommand(String deviceName, String lockID) throws NoClientAPIInstanceException {
        super("SETDEVICELOCKID " + deviceName + " " + lockID);
        this.deviceName = deviceName;
        this.lockID = lockID;
        this.generateCommandString();
    }

    public SetDeviceLockIDCommand(String deviceName, String lockID, ClientAPI clientApiRef) {
        super("SETDEVICELOCKID " + deviceName + " " + lockID, clientApiRef);
        this.deviceName = deviceName;
        this.lockID = lockID;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString("SETDEVICELOCKID " + this.deviceName + " " + this.lockID);
        return "SETDEVICELOCKID " + this.deviceName + " " + this.lockID;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        String expectedResponse;
        String response = this.getResponse();
        if (response.equals(expectedResponse = "Set lockID of device " + this.deviceName + " to " + this.lockID)) {
            this.setSuccess(true);
            this.setError(false);
        } else {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public String getLockID() {
        return this.lockID;
    }

    public void setLockID(String lockID) {
        this.lockID = lockID;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return "SETDEVICELOCKID " + this.deviceName + " " + this.lockID;
    }
}

