/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.IceServerException;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.Command;
import ice.communication.messageHandlers.serverExceptions.IceServerExceptionQueue;
import ice.event.communication.ResponseMessageEvent;
import ice.event.communication.ResponseMessageListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class ImmediateCommand
extends Command
implements ResponseMessageListener {
    private String label;

    public ImmediateCommand(String command) throws NoClientAPIInstanceException {
        this.setCommandString(command);
    }

    public ImmediateCommand(String command, ClientAPI clientApiRef) {
        super(clientApiRef);
        this.setCommandString(command);
    }

    protected ImmediateCommand() throws NoClientAPIInstanceException {
    }

    protected ImmediateCommand(ClientAPI clientApiRef) {
        super(clientApiRef);
    }

    @Override
    protected boolean issueAsynchronous() {
        this.setIssueType(Command.IssueTypes.asynchronous);
        boolean success = this.getClientApiRef().sendMessage(this.getCommandString());
        this.setIssuedTimestamp(new Date());
        IceServerExceptionQueue.removeListenerFromAll(this);
        this.commandExceptions = null;
        return success;
    }

    @Override
    protected synchronized boolean issueSynchronous() throws ICEListenerListExceptionBase {
        this.setIssueType(Command.IssueTypes.synchronous);
        IceServerExceptionQueue.removeListenerFromAll(this);
        this.commandExceptions = new Vector();
        this.getClientApiRef().addResponseMessageListener(this, this.generateLabel());
        IceServerExceptionQueue.addListenerGeneral(this);
        if (!this.getClientApiRef().sendMessage("ASK " + this.getLabel() + " " + this.getCommandString())) {
            this.setError(true);
            this.setResponseString("Error sending command: ASK " + this.getLabel() + " " + this.getCommandString());
            IceServerExceptionQueue.removeListenerFromAll(this);
            return false;
        }
        try {
            this.setIssuedTimestamp(new Date());
            this.wait();
            IceServerExceptionQueue.removeListenerFromAll(this);
            this.getClientApiRef().removeResponseMessageListener(this);
        }
        catch (InterruptedException ie) {
            this.setResponseString("Error: interrupted while waiting for response.");
            this.setError(true);
            this.getClientApiRef().removeResponseMessageListener(this);
            IceServerExceptionQueue.removeListenerFromAll(this);
            return false;
        }
        return true;
    }

    @Override
    public synchronized String generateCommandString() {
        return this.getCommandString();
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
    }

    @Override
    protected synchronized void parseAsynchronousResponse() {
    }

    @Override
    public void run() throws ICEListenerListExceptionBase {
        this.runSynchronous();
    }

    @Override
    public synchronized void actionPerformed(ResponseMessageEvent rme) {
        this.setResponseString(rme.getMesage().substring(rme.getLabel().length() + 1));
        this.setResponseTimestamp(new Date());
        this.notifyAll();
    }

    protected String generateLabel() {
        Random r = new Random();
        this.label = "CR" + String.valueOf(r.nextInt());
        return this.label;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public void receiveServerException(IceServerException e) {
        this.commandExceptions.add(e);
    }
}

