/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;

public class DeviceSetLowerLimitCommand
extends ImmediateCommand {
    private static final String command = "DEVICE SETLOWERLIMIT ";
    private double lowerLimit = 0.0;
    private String deviceName = null;

    public DeviceSetLowerLimitCommand() throws NoClientAPIInstanceException {
    }

    public DeviceSetLowerLimitCommand(String deviceName, double lowerLimit) throws NoClientAPIInstanceException {
        super(command + deviceName + " " + lowerLimit);
        this.deviceName = deviceName;
        this.lowerLimit = lowerLimit;
        this.generateCommandString();
    }

    public DeviceSetLowerLimitCommand(String deviceName, double lowerLimit, ClientAPI clientApiRef) {
        super(command + deviceName + " " + lowerLimit, clientApiRef);
        this.deviceName = deviceName;
        this.lowerLimit = lowerLimit;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName + " " + this.lowerLimit);
        return command + this.deviceName + " " + this.lowerLimit;
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        try {
            String lowerLimitStr = this.getResponse();
            int openBracketIndex = lowerLimitStr.lastIndexOf("[") + 1;
            int closedBracketIndex = lowerLimitStr.lastIndexOf("]");
            lowerLimitStr = lowerLimitStr.substring(openBracketIndex, closedBracketIndex);
            double lowerLimitDbl = Double.parseDouble(lowerLimitStr);
            this.setSuccess(true);
            this.setError(false);
        }
        catch (NumberFormatException notDouble) {
            this.setSuccess(false);
            this.setError(true);
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public double getLowerlimit() {
        return this.lowerLimit;
    }

    public void setLowerLimit(double lowerLimit) {
        this.lowerLimit = lowerLimit;
        this.generateCommandString();
    }

    public String getImmediateCommandString() {
        return command + this.deviceName + " " + this.lowerLimit;
    }
}

