/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.ImmediateCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceGetPropertyCommand
extends ImmediateCommand {
    private static String command = "Device GetProperty";
    protected ErrorType errorType = ErrorType.UNKNOWN;
    protected String deviceName;
    protected String propertyName;

    public DeviceGetPropertyCommand() throws NoClientAPIInstanceException {
    }

    public DeviceGetPropertyCommand(String deviceName, String propertyName, ClientAPI clientApiRef) {
        super("", clientApiRef);
        this.deviceName = deviceName;
        this.propertyName = propertyName;
        this.generateCommandString();
    }

    public DeviceGetPropertyCommand(String deviceName, String propertyName) throws NoClientAPIInstanceException {
        this.deviceName = deviceName;
        this.propertyName = propertyName;
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(String.valueOf(command) + " " + this.deviceName + " " + this.propertyName);
        return this.getCommandString();
    }

    @Override
    protected void parseSynchronousResponse() {
        if (this.isError()) {
            String response = this.getResponse();
            Pattern getpropertyRegEx = Pattern.compile("([^= ]+) = (.+)");
            Matcher matcher = getpropertyRegEx.matcher(response);
            if (!matcher.matches()) {
                this.setError(true);
                this.setSuccess(false);
                this.errorType = ErrorType.UNKNOWN;
                return;
            }
            if (matcher.group(1).compareToIgnoreCase(this.propertyName) != 0) {
                this.setError(true);
                this.setSuccess(false);
                this.errorType = ErrorType.INVALID_SERVER_RESPONSE;
                return;
            }
            this.setResponseString(matcher.group(2));
        }
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    private static enum ErrorType {
        UNKNOWN,
        INVALID_SERVER_RESPONSE;

    }
}

