/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.IceServerException;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.Command;
import ice.commands.ImmediateCommand;
import ice.commands.exceptions.CommandException;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import org.apache.log4j.Logger;

public class DeviceGetParent
extends ImmediateCommand {
    private static final String CMD_TXT = "Device GetParent ";
    static final String NO_DEVICEERROR_MSG_LEGACY = "'NoneType' object has no attribute 'getParent'";
    static final String NO_DEVICEERROR_MSG = "Part not found";
    static final String ERROR_MSG = "Error finding parent";
    static final String NO_PARENT_RESPONSE = "None";
    public GetParentResultTypes resultType = GetParentResultTypes.NOTRUN;
    private String deviceParentName = null;

    public DeviceGetParent(String deviceName) throws NoClientAPIInstanceException {
        super(CMD_TXT + deviceName);
    }

    public DeviceGetParent(String deviceName, ClientAPI clientApiRef) {
        super(CMD_TXT + deviceName, clientApiRef);
    }

    @Override
    protected synchronized void parseSynchronousResponse() {
        String cmdResponse = this.getResponse();
        if (cmdResponse.startsWith(ERROR_MSG)) {
            this.setError(true);
            this.setSuccess(false);
            this.deviceParentName = null;
            this.resultType = GetParentResultTypes.ERROR;
        } else if (cmdResponse.startsWith(NO_DEVICEERROR_MSG) || cmdResponse.startsWith(NO_DEVICEERROR_MSG_LEGACY)) {
            this.setError(true);
            this.setSuccess(false);
            this.deviceParentName = null;
            this.resultType = GetParentResultTypes.DEVICENOTFOUND;
        } else if (cmdResponse.equals(NO_PARENT_RESPONSE)) {
            this.setError(false);
            this.setSuccess(false);
            this.deviceParentName = null;
            this.resultType = GetParentResultTypes.NOPARENT;
        } else {
            this.setError(false);
            this.setSuccess(true);
            this.deviceParentName = cmdResponse.trim();
            this.resultType = GetParentResultTypes.PARENTFOUND;
        }
    }

    public String getDeviceParentName() {
        return this.deviceParentName;
    }

    @Override
    public String runAndRespond() throws IceServerException, CommandException {
        String returnValue = null;
        try {
            this.runSynchronous();
            returnValue = this.getDeviceParentName();
        }
        catch (ICEListenerListExceptionBase e) {
            returnValue = null;
            Logger.getLogger("ErrorLogger").error("DeviceGetParent " + e);
            throw new CommandException((Command)this, "ICEListListener error encountered.", e);
        }
        return returnValue;
    }

    public GetParentResultTypes getResultType() {
        return this.resultType;
    }

    public static enum GetParentResultTypes {
        NOTRUN,
        PARENTFOUND,
        NOPARENT,
        DEVICENOTFOUND,
        ERROR;

    }
}

