/*
 * Decompiled with CFR 0.152.
 */
package ice.commands;

import ice.ClientAPI;
import ice.clientAPI.exceptions.NoClientAPIInstanceException;
import ice.commands.QueuedCommand;

public class CountCommand
extends QueuedCommand {
    private static final String command = "COUNT ";
    private String deviceName = null;
    private int counter = 0;
    private long commandID = 0L;

    public CountCommand() throws NoClientAPIInstanceException {
    }

    public CountCommand(String deviceName, int counter) throws NoClientAPIInstanceException {
        super(command + deviceName + " " + counter);
        this.deviceName = deviceName;
        this.counter = counter;
        this.commandID = this.getCommandId();
        this.generateCommandString();
    }

    public CountCommand(String deviceName, int counter, ClientAPI clientApiRef) {
        super(command + deviceName + " " + counter, clientApiRef);
        this.deviceName = deviceName;
        this.counter = counter;
        this.commandID = this.getCommandId();
        this.generateCommandString();
    }

    @Override
    public synchronized String generateCommandString() {
        this.setCommandString(command + this.deviceName + " " + this.counter);
        return command + this.deviceName + " " + this.counter;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        this.generateCommandString();
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
        this.generateCommandString();
    }

    public void setCommandID(long id) {
        this.commandID = id;
        this.setCommandId(id);
        this.generateCommandString();
    }

    public String getQueueCommandString() {
        return command + this.deviceName + " " + this.counter;
    }
}

