/*
 * Decompiled with CFR 0.152.
 */
package ice.clientAPI;

import ice.data.DataSet;
import java.util.Date;
import java.util.Random;

public class CommandResponse {
    protected String label;
    protected String responseString;
    protected String errorString;
    protected boolean success;
    protected boolean error;
    private Date commandIssuedTimestamp;
    private Date responseReceivedTimeStamp;
    private DataSet dataSet = null;
    protected CommandTypes commandType;
    protected String commandString;
    private long commandID = 0L;

    public long getCommandID() {
        return this.commandID;
    }

    public void setCommandID(long commandID) {
        this.commandID = commandID;
    }

    public CommandResponse(String commandString) {
        this(commandString, CommandTypes.UNKNOWN, new Date());
    }

    public CommandResponse(String commandString, CommandTypes type) {
        this(commandString, type, new Date());
    }

    public CommandResponse(String commandString, CommandTypes type, Date issuedTimestamp) {
        this.commandString = commandString;
        this.commandIssuedTimestamp = issuedTimestamp;
        this.commandType = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getResponseString() {
        return this.responseString;
    }

    public void setResponseString(String responseString) {
        this.responseString = responseString;
        this.responseReceivedTimeStamp = new Date();
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setSuccess() {
        this.success = true;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setError() {
        this.error = true;
    }

    public Date getCommandIssuedTimestamp() {
        return this.commandIssuedTimestamp;
    }

    public void setCommandIssuedTimestamp(Date commandIssuedTimestamp) {
        this.commandIssuedTimestamp = commandIssuedTimestamp;
    }

    public Date getResponseReceivedTimeStamp() {
        return this.responseReceivedTimeStamp;
    }

    public CommandTypes getCommandType() {
        return this.commandType;
    }

    public void setCommandType(CommandTypes commandType) {
        this.commandType = commandType;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public String generateLabel() {
        Random r = new Random();
        this.label = "CR" + String.valueOf(r.nextInt());
        return this.label;
    }

    public void setDataSet(DataSet ds) {
        this.dataSet = ds;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public static enum CommandTypes {
        UNKNOWN,
        IMMEDIATE,
        MOVE,
        QUEUED,
        READ;

    }
}

