/*
 * Decompiled with CFR 0.152.
 */
package ice;

import ice.Controller;
import ice.IceClientNotifier;
import ice.JavaClassLoader;
import ice.PythonClassLoader;
import ice.data.BaseScan;
import ice.data.IceFile;
import ice.data.IceFileType;
import ice.data.IcePanelInfo;
import ice.data.IceWindowInfo;
import ice.data.Resource;
import ice.data.ScanList;
import ice.event.IceClientErrorEvent;
import ice.event.IceClientErrorListener;
import ice.event.IceClientInfoEvent;
import ice.event.IceClientInfoListener;
import ice.event.IcePanelDragListener;
import ice.event.IceWindowCloseListener;
import ice.event.IceWindowEvent;
import ice.event.LoadIcePanelEvent;
import ice.event.LoadIcePanelListener;
import ice.event.LoadSaveableIcePanelEvent;
import ice.event.LoadSaveableIcePanelListener;
import ice.event.StartUpEvent;
import ice.event.communication.PythonResetEvent;
import ice.event.communication.PythonResetListener;
import ice.event.request.ChangeExpReqListener;
import ice.event.request.ExitReqListener;
import ice.event.request.IcePanelCloseListener;
import ice.event.request.IceWindowRequest;
import ice.event.request.LoadExpConfigReqListener;
import ice.event.request.PanelCloseEvent;
import ice.exceptions.IcePanelException;
import ice.gui.core.ExperimentIDDialogFactory;
import ice.gui.core.GenericIcePanel;
import ice.gui.core.IceDialog;
import ice.gui.core.IceEditPanel;
import ice.gui.core.IceWindow;
import ice.gui.core.startup.StartUpWindow;
import ice.gui.panel.ConsolePanel;
import ice.gui.tas.bt7.config.ExpConfigWindow;
import ice.jython.management.PythonPanelManager;
import ice.rubberband.RubberBand;
import ice.rubberband.Win32RubberBand;
import ice.rubberband.XlibRubberBand;
import ice.util.I18N;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import ice.util.IcePanelXMLPropertyParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.python.core.PyObject;

public class IcePanelManager
implements LoadIcePanelListener,
LoadSaveableIcePanelListener,
IceWindowCloseListener,
LoadExpConfigReqListener,
ExitReqListener,
IcePanelCloseListener,
ChangeExpReqListener,
PythonResetListener,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger("ErrorLogger");
    private static IcePanelManager reference;
    private HashMap<IceWindow, ArrayList<GenericIcePanel>> windowMap;
    private IcePanelDragListener dragListener;
    private RubberBand rubberBand;
    private Controller controller;
    private HashMap<String, Boolean> dynamicMenuInfo;
    private HashMap<String, ArrayList<String>> windowMenuInfo;
    private HashMap<IceFileType, String> classToLoad;
    private ArrayList<IceClientInfoListener> infoListeners;
    private ArrayList<IceClientErrorListener> errorListeners;
    private static final String resourceClassLocation = "ice.gui.panel.resourceFile";

    public static IcePanelManager getReference() {
        if (reference == null) {
            reference = new IcePanelManager();
        }
        return reference;
    }

    private IcePanelManager() {
        this.init();
    }

    private void init() {
        this.windowMap = new HashMap();
        this.controller = Controller.getReference();
        PythonPanelManager pythonPanelManger = PythonPanelManager.getReference();
        try {
            pythonPanelManger.addPythonResetListener(this);
        }
        catch (ICEListenerListExceptionBase e1) {
            logger.error("Could not add listener", e1);
        }
        String os2 = System.getProperty("os.name");
        try {
            if (os2.equalsIgnoreCase("Windows XP") || os2.equalsIgnoreCase("Windows 2000")) {
                this.rubberBand = new Win32RubberBand();
            } else if (os2.equalsIgnoreCase("Linux")) {
                this.rubberBand = new XlibRubberBand();
            }
        }
        catch (Throwable e) {
            logger.error("Could not load rubber band code", e);
        }
        this.dragListener = new IcePanelDragListener(this.rubberBand);
        this.errorListeners = new ArrayList();
        this.infoListeners = new ArrayList();
        IceClientNotifier clientNotifier = IceClientNotifier.getReference();
        this.addIceClientErrorListener(clientNotifier);
        this.addIceClientInfoListener(clientNotifier);
        this.dynamicMenuInfo = new HashMap();
        this.windowMenuInfo = new HashMap();
    }

    @Override
    public void actionPerformed(PythonResetEvent ace) {
        JavaClassLoader classReader = JavaClassLoader.getReference();
        PythonPanelManager pythonPanelManager = PythonPanelManager.getReference();
        HashMap<String, Class<?>> loadedClasses = null;
        Class<?> aClass = null;
        HashMap<String, Class<?>> loadedPythonClasses = null;
        Set<String> keys = null;
        loadedClasses = classReader.getLoadedJavaClasses();
        if (loadedClasses.size() != 0) {
            keys = loadedClasses.keySet();
            for (String aKey : keys) {
                IceWindow iceWindow;
                aClass = loadedClasses.get(aKey);
                if (aClass != PyObject.class) continue;
                Boolean saveable = this.dynamicMenuInfo.remove(aKey);
                GenericIcePanel aPanel = this.findOpenPanelByName(aKey);
                if (aPanel != null && (iceWindow = aPanel.getIceWindowParent()) != null) {
                    iceWindow.closePanel(aPanel);
                }
                this.removeDynamicIceMenu(aKey, saveable);
            }
        }
        loadedPythonClasses = pythonPanelManager.getLoadedPythonPanelClasses();
        loadedClasses.putAll(loadedPythonClasses);
        keys = loadedPythonClasses.keySet();
        for (String aKey : keys) {
            this.addDynamicIceMenu(aKey, false);
        }
    }

    public void loadJavaClasses() {
        JavaClassLoader classReader = JavaClassLoader.getReference();
        classReader.loadJavaClasses();
        this.classToLoad = classReader.getSaveableIcePanelFileTypes();
    }

    public void loadPythonClasses() {
        PythonClassLoader pythonClassLoader = null;
        pythonClassLoader = PythonClassLoader.getReference();
        pythonClassLoader.loadPythonClasses();
    }

    public void updateWindows(IceWindow parent, GenericIcePanel panel, boolean withscrollbar) {
        ArrayList<GenericIcePanel> panelList = this.windowMap.get(parent);
        if (panelList == null) {
            panelList = new ArrayList();
            if (panel != null) {
                panelList.add(panel);
            }
            this.windowMap.put(parent, panelList);
        } else {
            panelList.add(panel);
        }
    }

    public IceWindow getFirstIceWindow() {
        Set<IceWindow> windowSet = this.windowMap.keySet();
        Iterator<IceWindow> iterator = windowSet.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public ArrayList<GenericIcePanel> getPanelList(IceWindow window) {
        return this.windowMap.get(window);
    }

    @Override
    public void instantiateIcePanel(LoadIcePanelEvent lipe) {
        String panelName = lipe.getPanelName();
        IceWindow parent = (IceWindow)lipe.getSource();
        String trimedPanelName = panelName.trim();
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            ArrayList<GenericIcePanel> panelList = this.windowMap.get(window);
            for (GenericIcePanel aPanel : panelList) {
                String aPanelName = aPanel.getName();
                if (aPanelName == null || !(aPanelName = aPanelName.trim()).equals(trimedPanelName)) continue;
                window.setExtendedState(0);
                window.giveFocus(aPanel);
                window.requestFocus();
                window.toFront();
                return;
            }
        }
        this.createIcePanel(parent, panelName);
    }

    private void createIcePanel(IceWindow parent, String panelName) {
        JavaClassLoader classReader = JavaClassLoader.getReference();
        HashMap<String, Class<?>> loadedClasses = null;
        loadedClasses = classReader.getLoadedJavaClasses();
        if (loadedClasses.size() == 0) {
            String message = "There are no available panels to load";
            IceClientInfoEvent event = new IceClientInfoEvent(this, message);
            this.notifyIceClientInfoListeners(event);
            return;
        }
        Class<?> javaClass = loadedClasses.get(panelName);
        if (javaClass != null) {
            try {
                ArrayList<String> items;
                GenericIcePanel panel = null;
                if (javaClass == PyObject.class) {
                    PythonPanelManager pythonContainer = null;
                    pythonContainer = PythonPanelManager.getReference();
                    panel = pythonContainer.openPanel(panelName);
                } else {
                    Constructor<?> constructor = javaClass.getConstructor(new Class[0]);
                    panel = (GenericIcePanel)constructor.newInstance(new Object[0]);
                }
                this.updateWindows(parent, panel, true);
                parent.addPanelTab(panel);
                String parentName = parent.getTitle();
                if (parentName == null || parentName.equals("")) {
                    parentName = parent.getName();
                }
                if ((items = this.windowMenuInfo.get(parentName)) != null) {
                    items.add(panel.getName());
                    this.windowMenuInfo.put(parentName, items);
                    this.updateIceWindowMenus();
                }
            }
            catch (Exception e) {
                IceClientErrorEvent event = new IceClientErrorEvent(this, e);
                this.notifyIceClientErrorListeners(event);
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void instantiateSaveableIcePanel(LoadSaveableIcePanelEvent lipe) {
        IceWindow parent = (IceWindow)lipe.getSource();
        Resource savedResource = lipe.getResource();
        String panelName = lipe.getPanelName();
        boolean forceAsText = false;
        forceAsText = lipe.isForceAsText();
        this.createSaveableIcePanel(parent, savedResource, panelName, forceAsText);
    }

    public boolean doIHaveAnEditorForThisType(IceFileType resourceType) {
        boolean returnValue = false;
        returnValue = this.classToLoad.containsKey((Object)resourceType);
        return returnValue;
    }

    private void createSaveableIcePanel(IceWindow parent, Resource savedResource, String panelName) {
        this.createSaveableIcePanel(parent, savedResource, panelName, false);
    }

    private void createSaveableIcePanel(IceWindow parent, Resource savedResource, String panelName, boolean forceAsText) {
        if (savedResource != null) {
            GenericIcePanel allReadyOpen = null;
            String resourceName = null;
            resourceName = savedResource.getName();
            allReadyOpen = this.findOpenPanelByName(resourceName);
            if (allReadyOpen != null) {
                allReadyOpen.bringPanelToFront();
                return;
            }
            IceFileType resourceType = savedResource.getFileType();
            if (this.doIHaveAnEditorForThisType(resourceType) && !forceAsText) {
                panelName = this.classToLoad.get((Object)resourceType);
            }
            if (panelName == null) {
                panelName = "Resource Editor";
            }
        }
        JavaClassLoader classReader = JavaClassLoader.getReference();
        HashMap<String, Class<?>> loadedClasses = null;
        loadedClasses = classReader.getLoadedJavaClasses();
        if (loadedClasses.size() == 0) {
            String message = "There are no available panels to load";
            IceClientInfoEvent event = new IceClientInfoEvent(this, message);
            this.notifyIceClientInfoListeners(event);
            return;
        }
        Class<?> javaClass = loadedClasses.get(panelName);
        if (javaClass != null) {
            Class[] argType = new Class[]{Resource.class};
            Object[] arg = new Object[]{savedResource};
            try {
                Constructor<?> constructor = javaClass.getConstructor(argType);
                IceEditPanel panel = (IceEditPanel)constructor.newInstance(arg);
                this.updateWindows(parent, panel, true);
                parent.addPanelTab(panel);
                ArrayList<String> items = this.windowMenuInfo.get(parent.getTitle());
                items.add(panel.getName());
            }
            catch (Exception e) {
                IceClientErrorEvent event = new IceClientErrorEvent(this, e);
                this.notifyIceClientErrorListeners(event);
                logger.error(e);
            }
            this.updateIceWindowMenus();
        }
    }

    public void rebuildDynamicIceMenu() {
    }

    public void buildDynamicIceMenu() {
        JavaClassLoader classReader = JavaClassLoader.getReference();
        HashMap<String, Class<Object>> loadedClasses = null;
        PythonClassLoader pythonClassLoader = null;
        HashMap<String, Class<?>> loadedPythonClasses = null;
        loadedClasses = classReader.getLoadedJavaClasses();
        if (loadedClasses == null) {
            loadedClasses = new HashMap();
        }
        if ((loadedPythonClasses = (pythonClassLoader = PythonClassLoader.getReference()).getLoadedClasses()) != null) {
            loadedClasses.putAll(loadedPythonClasses);
        }
        if (loadedClasses.size() == 0) {
            String message = "Cannot build dynamic menu: Did not load any files";
            IceClientInfoEvent event = new IceClientInfoEvent(this, message);
            this.notifyIceClientInfoListeners(event);
            return;
        }
        Set<Map.Entry<String, Class<Object>>> classSet = loadedClasses.entrySet();
        for (Map.Entry<String, Class<Object>> entry : classSet) {
            String className = entry.getKey();
            Class<Object> javaClass = entry.getValue();
            try {
                Constructor<?>[] clist = javaClass.getDeclaredConstructors();
                int i = 0;
                while (i < clist.length) {
                    Constructor<?> ct = clist[i];
                    Class<?>[] pTypes = ct.getParameterTypes();
                    if (pTypes.length == 0) {
                        this.addDynamicIceMenu(className, false);
                        this.dynamicMenuInfo.put(className, false);
                    } else {
                        int j = 0;
                        while (j < pTypes.length) {
                            Class<?> paramType = pTypes[j];
                            String resourcePath = I18N.getString(resourceClassLocation);
                            if (paramType.getName().equals(resourcePath)) {
                                this.addDynamicIceMenu(className, true);
                                this.dynamicMenuInfo.put(className, true);
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error(e);
                IceClientErrorEvent event = new IceClientErrorEvent(this, e);
                this.notifyIceClientErrorListeners(event);
            }
        }
    }

    protected void saveApplicationSettings() {
        ArrayList<IceWindowInfo> infoList = new ArrayList<IceWindowInfo>();
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            Point location = window.getLocationOnScreen();
            if (location.x < 0) {
                location.x = 0;
            }
            if (location.y < 0) {
                location.y = 0;
            }
            Dimension size = window.getSize();
            ArrayList<GenericIcePanel> panels = this.windowMap.get(window);
            for (GenericIcePanel panel : panels) {
                try {
                    panel.saveSettings();
                }
                catch (IcePanelException e) {
                    logger.error("unable to save settings");
                }
            }
            IceWindowInfo info = new IceWindowInfo(location, size, panels);
            infoList.add(info);
        }
        IcePanelXMLPropertyParser.writeXmlSessionFile(infoList);
    }

    @Override
    public void windowClosing(IceWindowEvent mwe) {
        IceWindow window = mwe.getIceWindow();
        if (this.windowMap.size() == 1) {
            System.out.println("Saving application settings...");
            this.saveApplicationSettings();
        }
        if (this.windowMap.containsKey(window)) {
            ArrayList<GenericIcePanel> panels = this.windowMap.get(window);
            for (GenericIcePanel panel : panels) {
                try {
                    panel.saveSettings();
                }
                catch (IcePanelException e) {
                    logger.error("unable to save panel settings");
                }
            }
            this.windowMap.remove(window);
            this.removeIceWindowFromMenus(window);
            window.dispose();
            if (this.windowMap.size() == 0) {
                this.disconnect();
            }
        } else {
            IceDialog iceDialog = null;
            String message = null;
            String format = null;
            MessageFormat messageFormat = null;
            String[] messageArgs = new String[1];
            String errorTitle = null;
            messageArgs[0] = window.getTitle();
            format = I18N.getString("ice.Controller.closingWindowNotInList");
            messageFormat = new MessageFormat(format);
            message = messageFormat.format(messageArgs);
            errorTitle = I18N.getString("ice.Controller.errorDialogTitle");
            logger.error(message);
            iceDialog = new IceDialog();
            iceDialog.throwErrorDialog(errorTitle, message);
        }
    }

    protected void loadApplicationSettings() {
        ArrayList<IceWindowInfo> windowInfoList = IcePanelXMLPropertyParser.readXMLSessionFile();
        if (windowInfoList != null) {
            for (IceWindowInfo windowInfo : windowInfoList) {
                IceWindow window = this.createNewWindow();
                Point location = windowInfo.getPosition();
                window.setIceWindowLocation(location);
                Dimension size = windowInfo.getDimension();
                window.setIceWindowSize(size);
                ArrayList newItems = new ArrayList();
                this.windowMenuInfo.put(window.getTitle(), newItems);
                this.updateIceWindowMenus();
                ArrayList<IcePanelInfo> panelInfoList = windowInfo.getIcePanelInfoList();
                for (IcePanelInfo panelInfo : panelInfoList) {
                    IceFileType fileType = panelInfo.getFileType();
                    String panelName = panelInfo.getPanelName();
                    String parentName = panelInfo.getParentName();
                    Resource resource = null;
                    if (fileType == IceFileType.unknown) {
                        this.createIcePanel(window, panelName);
                        continue;
                    }
                    boolean isAScanType = false;
                    isAScanType = fileType.isAScanType();
                    if (!isAScanType) {
                        IceFile root = null;
                        root = parentName.compareTo("EXPT") == 0 ? this.controller.getExpFolder() : (parentName.compareTo("USER") == 0 ? this.controller.getUserFolder() : (parentName.compareTo("COMM") == 0 ? this.controller.getCommonFolder() : this.controller.getExpFolder()));
                        ArrayList<IceFile> fileList = root.getChildren();
                        for (IceFile file : fileList) {
                            String fileName = file.getName();
                            if (!fileName.equals(panelInfo.getFileName())) continue;
                            resource = file;
                            break;
                        }
                    } else {
                        ScanList scanList = this.controller.getServerScanList();
                        ArrayList<BaseScan> scans = scanList.getScanList();
                        for (BaseScan scan : scans) {
                            String scanName = scan.getName();
                            IceFileType scanType = scan.getType();
                            if (!scanName.equals(panelInfo.getFileName()) || scanType != panelInfo.getFileType()) continue;
                            resource = scan;
                            break;
                        }
                    }
                    this.createSaveableIcePanel(window, resource, null);
                }
            }
        }
        if (this.windowMap == null || this.windowMap.size() == 0) {
            try {
                ConsolePanel consolePanel = new ConsolePanel();
                IceWindow defaultWindow = this.createNewWindow();
                this.updateWindows(defaultWindow, consolePanel, true);
                ArrayList<String> items = new ArrayList<String>();
                items.add(consolePanel.getName());
                this.windowMenuInfo.put(defaultWindow.getName(), items);
                this.updateIceWindowMenus();
                defaultWindow.addPanelTab(consolePanel);
            }
            catch (Exception e) {
                IceClientErrorEvent event = new IceClientErrorEvent(this, e);
                this.notifyIceClientErrorListeners(event);
                logger.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private IceWindow createNewWindow() {
        IceWindow defaultWindow = new IceWindow();
        defaultWindow.addLoadIcePanelListener(this);
        defaultWindow.addLoadSaveableIcePanelListener(this);
        defaultWindow.addIceWindowCloseListener(this);
        defaultWindow.addLoadExpConfigReqListener(this);
        defaultWindow.addExitReqListener(this);
        defaultWindow.addPanelCloseListener(this);
        defaultWindow.addTabbedMouseListener(this.dragListener);
        defaultWindow.addTabbedMouseMotionListener(this.dragListener);
        defaultWindow.addChangeExpReqListener(this);
        defaultWindow.addPropertyChangeListener(this);
        return defaultWindow;
    }

    private IceWindow createNewWindow(Point offset) {
        IceWindow defaultWindow = new IceWindow(offset);
        defaultWindow.addLoadIcePanelListener(this);
        defaultWindow.addLoadSaveableIcePanelListener(this);
        defaultWindow.addIceWindowCloseListener(this);
        defaultWindow.addLoadExpConfigReqListener(this);
        defaultWindow.addExitReqListener(this);
        defaultWindow.addPanelCloseListener(this);
        defaultWindow.addTabbedMouseListener(this.dragListener);
        defaultWindow.addTabbedMouseMotionListener(this.dragListener);
        defaultWindow.addChangeExpReqListener(this);
        defaultWindow.addPropertyChangeListener(this);
        return defaultWindow;
    }

    public void showGUI() {
        this.loadJavaClasses();
        this.loadPythonClasses();
        this.loadApplicationSettings();
        this.buildDynamicIceMenu();
        this.createExpConfigWindow();
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            window.showGUI();
        }
        StartUpEvent stop = new StartUpEvent((Object)this, StartUpEvent.MessageType.KILL);
        this.controller.notifyStartUpListeners(stop);
        StartUpWindow startUp = StartUpWindow.getInstance();
        this.controller.removeStartUpListener(startUp);
    }

    public void removeDynamicIceMenu(String className, boolean saveable) {
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            window.removeMenuItem(className, saveable);
        }
    }

    public void addDynamicIceMenu(String className, boolean saveable) {
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            JMenuItem item = new JMenuItem(className);
            window.addMenuItem(item, saveable);
        }
    }

    @Override
    public void requestLoadExpConfig(IceWindowRequest mwr) {
        this.showExpConfigWindow(mwr.getSource());
    }

    @Override
    public void requestExit() {
        this.saveApplicationSettings();
        this.disconnect();
    }

    public void disconnect() {
        logger.debug("Disconnecting from the server...");
        this.controller.getCommMgr().disconnect();
        logger.debug("Exit Application");
        System.exit(0);
    }

    public Set<IceWindow> getWindowSet() {
        return this.windowMap.keySet();
    }

    @Override
    public void panelClosed(PanelCloseEvent pce) {
        GenericIcePanel panel = pce.getPanel();
        IceWindow window = pce.getSource();
        if (this.windowMap.containsKey(window)) {
            ArrayList<GenericIcePanel> panelList = this.windowMap.get(window);
            panelList.remove(panel);
            try {
                panel.saveSettings();
            }
            catch (IcePanelException e) {
                logger.error("unable to save panel settings");
            }
            if (panelList.size() == 0) {
                this.windowMap.remove(window);
                window.dispose();
            }
        }
        if (this.windowMap.size() == 0) {
            this.requestExit();
        }
    }

    public void createExpConfigWindow() {
        ExpConfigWindow configWindow = ExpConfigWindow.getReference();
        this.controller.addExpChangeListener(configWindow.getExpDetailsPanel());
        try {
            this.controller.getCommMgr().addAvailableDeviceListListener(configWindow.getSampleEnvironmentPanel());
        }
        catch (ICEListenerListExceptionBase e) {
            logger.error("IcePanelManager.createExpConfigWindow  " + e);
        }
    }

    public void showExpConfigWindow(Component parent) {
        logger.debug("opening exp config window");
        ExpConfigWindow configWindow = ExpConfigWindow.getReference();
        configWindow.setLocationRelativeTo(parent);
        configWindow.setVisible(true);
    }

    public HashMap<String, Boolean> getDynamicMenuInfo() {
        return this.dynamicMenuInfo;
    }

    public void createNewIceWindow(IcePanelDragListener dragListener, Component comp, Point offsetPoint, IceWindow oldParent) {
        ArrayList<GenericIcePanel> oldPanelList;
        if (oldParent == null) {
            logger.error("Window does not exist");
            return;
        }
        if (oldParent.getTabCount() == 1) {
            return;
        }
        GenericIcePanel panel = null;
        panel = comp instanceof JScrollPane ? (GenericIcePanel)((JScrollPane)comp).getViewport().getView() : (GenericIcePanel)comp;
        IceWindow newWindow = this.createNewWindow(offsetPoint);
        newWindow.buildDynamicWindowMenu(this.dynamicMenuInfo);
        this.updateWindows(newWindow, panel, true);
        String panelName = panel.getName();
        ArrayList<String> items = this.windowMenuInfo.get(oldParent.getTitle());
        if (items != null) {
            if (items.contains(panelName)) {
                items.remove(panelName);
            }
            ArrayList<String> newItems = new ArrayList<String>();
            newItems.add(panelName);
            this.windowMenuInfo.put(newWindow.getTitle(), newItems);
            this.updateIceWindowMenus();
        }
        if ((oldPanelList = this.windowMap.get(oldParent)) != null && oldPanelList.contains(panel)) {
            oldPanelList.remove(panel);
        }
        oldParent.removeTab(comp);
        newWindow.addPropertyChangeListener(this);
        newWindow.addPanelTab(panel);
        newWindow.showGUI();
    }

    private void updateIceWindowMenus() {
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            window.updateIceWindowMenu(this.windowMenuInfo);
        }
    }

    public void updateIceWindowMenus(String windowName, String newPanelName, String oldPanelName) {
        ArrayList<String> panelNames = this.windowMenuInfo.get(windowName);
        if (panelNames.contains(oldPanelName)) {
            panelNames.remove(oldPanelName);
            panelNames.add(newPanelName);
        }
        this.updateIceWindowMenus();
    }

    public void updateIceWindowMenus(IceWindow oldParent, IceWindow newParent, GenericIcePanel panel) {
        String panelName;
        ArrayList<String> items = this.windowMenuInfo.get(oldParent.getTitle());
        if (items.contains(panelName = panel.getName())) {
            items.remove(panelName);
        }
        ArrayList<String> newItems = this.windowMenuInfo.get(newParent.getTitle());
        newItems.add(panelName);
        this.windowMenuInfo.put(newParent.getTitle(), newItems);
        this.updateIceWindowMenus();
    }

    public void updateIceWindows(IceWindow oldParent, IceWindow newParent, GenericIcePanel panel) {
        ArrayList<GenericIcePanel> oldPanelList = this.getPanelList(oldParent);
        if (oldPanelList != null) {
            oldPanelList.remove(panel);
        } else {
            logger.error("old panel list is null");
        }
        ArrayList<GenericIcePanel> newPanelList = this.getPanelList(newParent);
        if (newPanelList != null) {
            newPanelList.add(panel);
        } else {
            logger.error("new panel list is null");
        }
    }

    public void removeIceWindowFromMenus(IceWindow window) {
        String windowName = window.getTitle();
        if (this.windowMenuInfo.containsKey(windowName)) {
            this.windowMenuInfo.remove(windowName);
            this.updateIceWindowMenus();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName;
        Object source = evt.getSource();
        if (source instanceof IceWindow && (propertyName = evt.getPropertyName()).equals("title")) {
            this.updateWindowTitleInWindowMenu(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWindowTitleInWindowMenu(PropertyChangeEvent evt) {
        HashMap<String, ArrayList<String>> hashMap = this.windowMenuInfo;
        synchronized (hashMap) {
            IceWindow iceWindow = (IceWindow)evt.getSource();
            String windowName = iceWindow.getName();
            String oldTitle = (String)evt.getOldValue();
            String theKey = "";
            if (this.windowMenuInfo.containsKey(windowName)) {
                theKey = windowName;
            } else if (this.windowMenuInfo.containsKey(oldTitle)) {
                theKey = oldTitle;
            }
            ArrayList<String> info = this.windowMenuInfo.get(theKey);
            if (info != null) {
                this.windowMenuInfo.remove(theKey);
                String newTitle = (String)evt.getNewValue();
                this.windowMenuInfo.put(newTitle, info);
                this.updateIceWindowMenus();
            }
        }
    }

    @Override
    public void requestChangeExperiment(IceWindowRequest mwr) {
        this.ChangeExpDialog(mwr.getSource());
    }

    private void ChangeExpDialog(Component parent) {
        IceDialog inputDialog = (IceDialog)ExperimentIDDialogFactory.getChangeExperimentIDDialog();
        inputDialog.setLocationRelativeTo(parent);
        inputDialog.setVisible(true);
        String expID = inputDialog.getUserSelection();
        if (expID != null && expID.length() > 0) {
            try {
                String expNum = String.valueOf(expID);
                this.controller.getCommMgr().sendMessage("expt set " + expNum, true);
            }
            catch (NumberFormatException nfe) {
                logger.error("Invalid number entered.  The experiment will not be changed.");
            }
            catch (IOException ioe) {
                logger.error("IOException sending exp change message.  Probably lost connection to dispatcher:", ioe);
                logger.error("Unable to talk to server.  Please try reconnecting.");
            }
        }
    }

    public IceWindow getIceWindow(GenericIcePanel panel) {
        IceWindow parent = null;
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            ArrayList<GenericIcePanel> panelList = this.windowMap.get(window);
            if (!panelList.contains(panel)) continue;
            parent = window;
            break;
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericIcePanel findOpenPanelByName(String panelName) {
        Set<IceWindow> windowSet;
        GenericIcePanel returnValue = null;
        Set<IceWindow> set = windowSet = this.windowMap.keySet();
        synchronized (set) {
            for (IceWindow window : windowSet) {
                ArrayList<GenericIcePanel> panelList;
                ArrayList<GenericIcePanel> arrayList = panelList = this.windowMap.get(window);
                synchronized (arrayList) {
                    for (GenericIcePanel aPanel : panelList) {
                        String aPanelsName = null;
                        aPanelsName = aPanel.getName();
                        if (aPanelsName.startsWith("*")) {
                            aPanelsName = aPanelsName.substring(1);
                        }
                        if (!aPanelsName.equalsIgnoreCase(panelName)) continue;
                        returnValue = aPanel;
                        break;
                    }
                }
            }
        }
        return returnValue;
    }

    public void addIceClientErrorListener(IceClientErrorListener ipel) {
        this.errorListeners.add(ipel);
    }

    public void removeIceClientErrorListener(IceClientErrorListener ipel) {
        this.errorListeners.remove(ipel);
    }

    public void notifyIceClientErrorListeners(IceClientErrorEvent event) {
        for (IceClientErrorListener errorListener : this.errorListeners) {
            errorListener.errorOccured(event);
        }
    }

    public void addIceClientInfoListener(IceClientInfoListener ipel) {
        this.infoListeners.add(ipel);
    }

    public void removeIceClientInfoListener(IceClientInfoListener ipel) {
        this.infoListeners.remove(ipel);
    }

    public void notifyIceClientInfoListeners(IceClientInfoEvent event) {
        for (IceClientInfoListener infoListener : this.infoListeners) {
            infoListener.messageOccured(event);
        }
    }

    public IceWindow getFocusedIceWindow() {
        IceWindow window = null;
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow win : windowSet) {
            if (!win.isFocused()) continue;
            window = win;
            break;
        }
        return window;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAllPanels(boolean lock) {
        Set<IceWindow> windowSet = this.windowMap.keySet();
        for (IceWindow window : windowSet) {
            ArrayList<GenericIcePanel> panelList;
            ArrayList<GenericIcePanel> arrayList = panelList = this.windowMap.get(window);
            synchronized (arrayList) {
                for (GenericIcePanel aPanel : panelList) {
                    aPanel.setLocked(lock);
                }
            }
        }
    }
}

