/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClass;
import hep.io.root.RootFileReader;
import hep.io.root.RootMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.NameMangler;
import hep.io.root.core.RootClassFactory;
import hep.io.root.interfaces.TStreamerInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class InterfaceBuilder {
    private File base;
    private NameMangler nameMangler = NameMangler.instance();

    public InterfaceBuilder(File dir) {
        this.base = dir;
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            InterfaceBuilder.usage();
        }
        RootFileReader rfr = new RootFileReader(argv[0]);
        RootClassFactory rcf = rfr.getFactory();
        InterfaceBuilder ib = new InterfaceBuilder(new File("."));
        if (argv.length > 1) {
            BasicRootClass rc = rcf.create(argv[1]);
            File f = ib.write(rc);
            System.out.println("Created " + f.getPath());
        } else {
            List list = rfr.streamerInfo();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                TStreamerInfo info = (TStreamerInfo)i.next();
                String name = info.getName();
                try {
                    Class<?> k = Class.forName("hep.io.root.interfaces." + name);
                    System.out.println("Skipping " + name);
                }
                catch (ClassNotFoundException x) {
                    BasicRootClass rc = rcf.create(name);
                    File f = ib.write(rc);
                    System.out.println("Created " + f.getPath());
                }
            }
        }
    }

    public File write(RootClass klass) throws IOException {
        String klassPath = this.nameMangler.mangleClass(klass.getClassName());
        StringBuffer packidge = new StringBuffer();
        File file = this.base;
        StringTokenizer t = new StringTokenizer(klassPath, ".");
        int count = t.countTokens() - 1;
        for (int i = 0; i < count; ++i) {
            String token = t.nextToken();
            file = new File(file, token);
            if (i > 0) {
                packidge.append('.');
            }
            packidge.append(token);
        }
        String klassName = t.nextToken();
        file.mkdirs();
        file = new File(file, klassName + ".java");
        PrintWriter out = new PrintWriter(new FileOutputStream(file));
        out.println("/*");
        out.println(" * Interface created by InterfaceBuilder. Do not modify.");
        out.println(" *");
        out.println(" * Created on " + new Date());
        out.println(" */");
        out.println();
        out.println("package " + packidge + ";");
        if (!packidge.toString().equals("hep.io.root.interfaces")) {
            out.println("import hep.io.root.interfaces.*;");
        }
        out.println();
        out.print("public interface " + klassName + " extends hep.io.root.RootObject");
        RootClass[] superClasses = klass.getSuperClasses();
        for (int i = 0; i < superClasses.length; ++i) {
            out.print(", " + this.nameMangler.mangleClass(superClasses[i].getClassName()));
        }
        out.println();
        out.println("{");
        RootMember[] members = klass.getMembers();
        for (int i = 0; i < members.length; ++i) {
            RootClass type;
            String comment = members[i].getComment();
            if (comment != null && comment.length() > 0) {
                out.println("\t/** " + comment + " */");
            }
            if ((type = members[i].getType()) == null) continue;
            StringBuffer jType = new StringBuffer(type.getJavaClass().getName());
            for (int j = 0; j < members[i].getArrayDim(); ++j) {
                jType.append("[]");
            }
            String name = this.nameMangler.mangleMember(members[i].getName());
            out.println("\t" + jType + " " + name + "();");
        }
        int version = klass.getVersion();
        int checkSum = klass.getCheckSum();
        if (version > 0 || checkSum > 0) {
            out.println();
        }
        if (version > 0) {
            out.println("\tpublic final static int rootIOVersion=" + version + ";");
        }
        if (checkSum > 0) {
            out.println("\tpublic final static int rootCheckSum=" + checkSum + ";");
        }
        out.println("}");
        out.close();
        return file;
    }

    private static void usage() {
        System.out.println("java RootObjectBrowser <file> [<class>]");
        System.exit(0);
    }
}

