/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LineNumberGen;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TABLESWITCH;
import org.apache.bcel.util.ClassPath;

public class JasminVisitor
extends EmptyVisitor {
    private JavaClass clazz;
    private PrintWriter out;
    private String class_name;
    private ConstantPoolGen cp;
    private Method method;
    private Hashtable map;

    public JasminVisitor(JavaClass clazz, OutputStream out) {
        this.clazz = clazz;
        this.out = new PrintWriter(out);
        this.class_name = clazz.getClassName();
        this.cp = new ConstantPoolGen(clazz.getConstantPool());
    }

    public void disassemble() {
        new DescendingVisitor(this.clazz, this).visit();
        this.out.close();
    }

    public void visitJavaClass(JavaClass clazz) {
        this.out.println(";; Produced by JasminVisitor (BCEL)");
        this.out.println(";; http://bcel.sourceforge.net/");
        this.out.println(";; " + new Date() + "\n");
        this.out.println(".source " + clazz.getSourceFileName());
        this.out.println("." + Utility.classOrInterface(clazz.getAccessFlags()) + " " + Utility.accessToString(clazz.getAccessFlags(), true) + " " + clazz.getClassName().replace('.', '/'));
        this.out.println(".super " + clazz.getSuperclassName().replace('.', '/'));
        String[] interfaces = clazz.getInterfaceNames();
        for (int i = 0; i < interfaces.length; ++i) {
            this.out.println(".implements " + interfaces[i].replace('.', '/'));
        }
        this.out.print("\n");
    }

    public void visitField(Field field) {
        this.out.print(".field " + Utility.accessToString(field.getAccessFlags()) + " " + field.getName() + " " + field.getSignature());
        if (field.getAttributes().length == 0) {
            this.out.print("\n");
        }
    }

    public void visitConstantValue(ConstantValue cv) {
        this.out.println(" = " + cv);
    }

    private final void printEndMethod(Attribute attr) {
        Attribute[] attributes = this.method.getAttributes();
        if (attr == attributes[attributes.length - 1]) {
            this.out.println(".end method");
        }
    }

    public void visitDeprecated(Deprecated attribute) {
        this.printEndMethod(attribute);
    }

    public void visitSynthetic(Synthetic attribute) {
        this.printEndMethod(attribute);
    }

    public void visitMethod(Method method) {
        this.out.println("\n.method " + Utility.accessToString(method.getAccessFlags()) + " " + method.getName() + method.getSignature());
        this.method = method;
        Attribute[] attributes = method.getAttributes();
        if (attributes == null || attributes.length == 0) {
            this.out.println(".end method");
        }
    }

    public void visitExceptionTable(ExceptionTable e) {
        String[] names = e.getExceptionNames();
        for (int i = 0; i < names.length; ++i) {
            this.out.println(".throws " + names[i].replace('.', '/'));
        }
        this.printEndMethod(e);
    }

    public void visitCode(Code code) {
        int i;
        InstructionHandle ih;
        InstructionHandle ih2;
        int label_counter = 0;
        this.out.println(".limit stack " + code.getMaxStack());
        this.out.println(".limit locals " + code.getMaxLocals());
        MethodGen mg = new MethodGen(this.method, this.class_name, this.cp);
        InstructionList il = mg.getInstructionList();
        InstructionHandle[] ihs = il.getInstructionHandles();
        this.map = new Hashtable();
        for (int i2 = 0; i2 < ihs.length; ++i2) {
            if (!(ihs[i2] instanceof BranchHandle)) continue;
            BranchInstruction bi = (BranchInstruction)ihs[i2].getInstruction();
            if (bi instanceof Select) {
                InstructionHandle[] targets = ((Select)bi).getTargets();
                for (int j = 0; j < targets.length; ++j) {
                    this.put(targets[j], "Label" + label_counter++ + ":");
                }
            }
            ih2 = bi.getTarget();
            this.put(ih2, "Label" + label_counter++ + ":");
        }
        LocalVariableGen[] lvs = mg.getLocalVariables();
        for (int i3 = 0; i3 < lvs.length; ++i3) {
            ih2 = lvs[i3].getStart();
            this.put(ih2, "Label" + label_counter++ + ":");
            ih2 = lvs[i3].getEnd();
            this.put(ih2, "Label" + label_counter++ + ":");
        }
        CodeExceptionGen[] ehs = mg.getExceptionHandlers();
        for (int i4 = 0; i4 < ehs.length; ++i4) {
            CodeExceptionGen c = ehs[i4];
            ih = c.getStartPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = c.getEndPC();
            this.put(ih, "Label" + label_counter++ + ":");
            ih = c.getHandlerPC();
            this.put(ih, "Label" + label_counter++ + ":");
        }
        LineNumberGen[] lns = mg.getLineNumbers();
        for (i = 0; i < lns.length; ++i) {
            ih = lns[i].getInstruction();
            this.put(ih, ".line " + lns[i].getSourceLine());
        }
        for (i = 0; i < lvs.length; ++i) {
            LocalVariableGen l = lvs[i];
            this.out.println(".var " + l.getIndex() + " is " + l.getName() + " " + l.getType().getSignature() + " from " + this.get(l.getStart()) + " to " + this.get(l.getEnd()));
        }
        this.out.print("\n");
        for (i = 0; i < ihs.length; ++i) {
            ih = ihs[i];
            Instruction inst = ih.getInstruction();
            String str = (String)this.map.get(ih);
            if (str != null) {
                this.out.println(str);
            }
            if (inst instanceof BranchInstruction) {
                if (inst instanceof Select) {
                    int j;
                    Select s = (Select)inst;
                    int[] matchs = s.getMatchs();
                    InstructionHandle[] targets = s.getTargets();
                    if (s instanceof TABLESWITCH) {
                        this.out.println("\ttableswitch " + matchs[0] + " " + matchs[matchs.length - 1]);
                        for (j = 0; j < targets.length; ++j) {
                            this.out.println("\t\t" + this.get(targets[j]));
                        }
                    } else {
                        this.out.println("\tlookupswitch ");
                        for (j = 0; j < targets.length; ++j) {
                            this.out.println("\t\t" + matchs[j] + " : " + this.get(targets[j]));
                        }
                    }
                    this.out.println("\t\tdefault: " + this.get(s.getTarget()));
                    continue;
                }
                BranchInstruction bi = (BranchInstruction)inst;
                ih = bi.getTarget();
                str = this.get(ih);
                this.out.println("\t" + Constants.OPCODE_NAMES[bi.getOpcode()] + " " + str);
                continue;
            }
            this.out.println("\t" + inst.toString(this.cp.getConstantPool()));
        }
        this.out.print("\n");
        for (i = 0; i < ehs.length; ++i) {
            CodeExceptionGen c = ehs[i];
            ObjectType caught = c.getCatchType();
            String class_name = caught == null ? "all" : caught.getClassName().replace('.', '/');
            this.out.println(".catch " + class_name + " from " + this.get(c.getStartPC()) + " to " + this.get(c.getEndPC()) + " using " + this.get(c.getHandlerPC()));
        }
        this.printEndMethod(code);
    }

    private final String get(InstructionHandle ih) {
        String str = new StringTokenizer((String)this.map.get(ih), "\n").nextToken();
        return str.substring(0, str.length() - 1);
    }

    private final void put(InstructionHandle ih, String line) {
        String str = (String)this.map.get(ih);
        if (str == null) {
            this.map.put(ih, line);
        } else {
            if (line.startsWith("Label") || str.endsWith(line)) {
                return;
            }
            this.map.put(ih, str + "\n" + line);
        }
    }

    public static void main(String[] argv) {
        ClassParser parser = null;
        ClassPath class_path = ClassPath.SYSTEM_CLASS_PATH;
        try {
            if (argv.length == 0) {
                System.err.println("disassemble: No input files specified");
            } else {
                for (int i = 0; i < argv.length; ++i) {
                    if (argv[i].endsWith(".class")) {
                        parser = new ClassParser(argv[i]);
                    } else {
                        InputStream is = class_path.getInputStream(argv[i]);
                        String name = argv[i].replace('.', '/') + ".class";
                        parser = new ClassParser(is, name);
                    }
                    JavaClass java_class = parser.parse();
                    String class_name = java_class.getClassName();
                    int index = class_name.lastIndexOf(46);
                    String path = class_name.substring(0, index + 1).replace('.', File.separatorChar);
                    class_name = class_name.substring(index + 1);
                    if (!path.equals("")) {
                        File f = new File(path);
                        f.mkdirs();
                    }
                    FileOutputStream out = new FileOutputStream(path + class_name + ".j");
                    new JasminVisitor(java_class, out).disassemble();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

