/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.ColumnwiseBlock;
import hep.io.hbook.ColumnwiseTuple;
import hep.io.hbook.Hbook;
import hep.io.hbook.PawArray;
import hep.io.hbook.PawBooleanArray;
import hep.io.hbook.PawDoubleArray;
import hep.io.hbook.PawIntegerArray;
import hep.io.hbook.PawStringArray;
import hep.io.hbook.TupleColumn;
import java.util.StringTokenizer;

public class ColumnwiseTupleColumn
extends TupleColumn {
    private PawArray array;
    private String full;
    private ColumnwiseBlock block;
    private int nsub;
    private int size;
    private int elem;
    int offset;
    private int[] dimension;
    private int column;
    private int fixed;
    ColumnwiseTupleColumn index;
    private double min = 0.0;
    private double max = 0.0;
    private boolean minMaxKnown = false;
    boolean isMapped = false;
    private static final Class[] classes = new Class[]{null, Double.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, String.class};
    private static final Class[] arrayClasses = new Class[]{null, PawDoubleArray.class, PawIntegerArray.class, PawIntegerArray.class, PawBooleanArray.class, PawStringArray.class};

    ColumnwiseTupleColumn(ColumnwiseTuple parent, String name, String full, String block, int column, int nsub, int type, int size, int elem) {
        super(parent, name);
        this.column = column;
        this.full = full;
        this.nsub = nsub;
        this.size = size;
        this.elem = elem;
        this.block = parent.getBlock(block);
        this.offset = this.block.allocSpace(this, size * elem);
        this.fixed = 1;
        this.type = type;
        if (nsub > 0) {
            this.dimension = new int[nsub];
            StringTokenizer t = new StringTokenizer(full, "[]", false);
            t.nextToken();
            for (int i = 0; i < nsub; ++i) {
                String token = t.nextToken();
                if (token == null) {
                    throw new RuntimeException("Paw columnwise tuple parse failure " + full);
                }
                try {
                    this.dimension[i] = Integer.parseInt(token);
                    this.fixed *= this.dimension[i];
                    continue;
                }
                catch (NumberFormatException x) {
                    ColumnwiseTupleColumn field = (ColumnwiseTupleColumn)parent.getChild(token);
                    if (field == null) {
                        throw new RuntimeException("Paw columnwise tuple parse failure " + full);
                    }
                    this.dimension[i] = -field.column;
                    this.index = field;
                }
            }
        }
    }

    public String toString() {
        String result = "CW Tuple Field: (" + this.getColumnClass().getName() + ") " + this.full;
        if (this.minMaxKnown) {
            result = result + " (min=" + this.min + " max=" + this.max + ")";
        }
        return result;
    }

    public double getDouble() {
        if (this.type == 2 || this.type == 3) {
            return this.getInt();
        }
        if (this.type != 1) {
            throw new RuntimeException("getDouble called for non-float data: " + this.getName());
        }
        if (this.elem > 1) {
            throw new RuntimeException("getDouble called for array data: " + this.getName());
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataDouble(this.block.getBuffer(), this.offset, this.size);
    }

    public int getInt() {
        if (this.type != 2 && this.type != 3) {
            throw new RuntimeException("getInt called for non-integer data: " + this.getName());
        }
        if (this.elem > 1) {
            throw new RuntimeException("getInt called for array data: " + this.getName());
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataInt(this.block.getBuffer(), this.offset, this.size);
    }

    public boolean getBoolean() {
        if (this.type != 4) {
            throw new RuntimeException("getBoolean called for non-boolean data: " + this.getName());
        }
        if (this.elem > 1) {
            throw new RuntimeException("getBoolean called for array data: " + this.getName());
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataBoolean(this.block.getBuffer(), this.offset, this.size);
    }

    public String getString() {
        if (this.type != 5) {
            throw new RuntimeException("getString called for non-string data: " + this.getName());
        }
        if (this.elem > 1) {
            throw new RuntimeException("getString called for array data: " + this.getName());
        }
        if (!this.isMapped) {
            this.block.map(this);
        }
        return Hbook.getCWDataString(this.block.getBuffer(), this.offset, this.size);
    }

    public PawArray getObject() {
        if (this.array == null) {
            this.array = this.type == 1 ? new DoubleArray() : (this.type == 4 ? new BooleanArray() : (this.type == 5 ? new StringArray() : new IntegerArray()));
        }
        return this.array;
    }

    public Class getColumnClass() {
        if (this.elem > 1) {
            return arrayClasses[this.type];
        }
        return classes[this.type];
    }

    public double getMin() {
        if (!this.minMaxKnown) {
            this.getMinMax();
        }
        return this.min;
    }

    public double getMax() {
        if (!this.minMaxKnown) {
            this.getMinMax();
        }
        return this.max;
    }

    private void getMinMax() {
        ColumnwiseTuple parent = (ColumnwiseTuple)this.getParent();
        int id = parent.getID();
        this.block.map(this);
        double[] mm = Hbook.CWgetMinMax(id, this.block.getBuffer(), this.offset, this.type, this.size, this.fixed, this.index != null ? this.index.offset : -1);
        this.min = mm[0];
        this.max = mm[1];
        this.minMaxKnown = true;
    }

    private class BooleanArray
    extends Array
    implements PawBooleanArray {
        private BooleanArray() {
        }

        public boolean getBoolean(int i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public boolean getBoolean(int i, int j) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j), ColumnwiseTupleColumn.this.size);
        }

        public boolean getBoolean(int i, int j, int k) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j, k), ColumnwiseTupleColumn.this.size);
        }

        public boolean getBoolean(int[] i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataBoolean(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public boolean[] getAsJavaArray() {
            boolean[] result = new boolean[this.calcSize()];
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            int off = ColumnwiseTupleColumn.this.offset;
            for (int i = 0; i < result.length; ++i) {
                result[i] = Hbook.getCWDataBoolean(ColumnwiseTupleColumn.this.block.getBuffer(), off, ColumnwiseTupleColumn.this.size);
                off += ColumnwiseTupleColumn.this.size;
            }
            return result;
        }
    }

    private class StringArray
    extends Array
    implements PawStringArray {
        private StringArray() {
        }

        public String getString(int i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public String getString(int i, int j) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j), ColumnwiseTupleColumn.this.size);
        }

        public String getString(int i, int j, int k) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j, k), ColumnwiseTupleColumn.this.size);
        }

        public String getString(int[] i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataString(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public String[] getAsJavaArray() {
            String[] result = new String[this.calcSize()];
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            int off = ColumnwiseTupleColumn.this.offset;
            for (int i = 0; i < result.length; ++i) {
                result[i] = Hbook.getCWDataString(ColumnwiseTupleColumn.this.block.getBuffer(), off, ColumnwiseTupleColumn.this.size);
                off += ColumnwiseTupleColumn.this.size;
            }
            return result;
        }
    }

    private class IntegerArray
    extends Array
    implements PawIntegerArray {
        private IntegerArray() {
        }

        public int getInt(int i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public int getInt(int i, int j) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j), ColumnwiseTupleColumn.this.size);
        }

        public int getInt(int i, int j, int k) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j, k), ColumnwiseTupleColumn.this.size);
        }

        public int getInt(int[] i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataInt(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public int[] getAsJavaArray() {
            int[] result = new int[this.calcSize()];
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            int off = ColumnwiseTupleColumn.this.offset;
            for (int i = 0; i < result.length; ++i) {
                result[i] = Hbook.getCWDataInt(ColumnwiseTupleColumn.this.block.getBuffer(), off, ColumnwiseTupleColumn.this.size);
                off += ColumnwiseTupleColumn.this.size;
            }
            return result;
        }
    }

    private class DoubleArray
    extends Array
    implements PawDoubleArray {
        private DoubleArray() {
        }

        public double getDouble(int i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public double getDouble(int i, int j) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j), ColumnwiseTupleColumn.this.size);
        }

        public double getDouble(int i, int j, int k) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i, j, k), ColumnwiseTupleColumn.this.size);
        }

        public double getDouble(int[] i) {
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            return Hbook.getCWDataDouble(ColumnwiseTupleColumn.this.block.getBuffer(), this.calcOffset(i), ColumnwiseTupleColumn.this.size);
        }

        public double[] getAsJavaArray() {
            double[] result = new double[this.calcSize()];
            if (!ColumnwiseTupleColumn.this.isMapped) {
                ColumnwiseTupleColumn.this.block.map(ColumnwiseTupleColumn.this);
            }
            int off = ColumnwiseTupleColumn.this.offset;
            for (int i = 0; i < result.length; ++i) {
                result[i] = Hbook.getCWDataDouble(ColumnwiseTupleColumn.this.block.getBuffer(), off, ColumnwiseTupleColumn.this.size);
                off += ColumnwiseTupleColumn.this.size;
            }
            return result;
        }
    }

    private class Array
    implements PawArray {
        private Array() {
        }

        public int getNDimensions() {
            return ColumnwiseTupleColumn.this.nsub;
        }

        public int getDimension(int x) {
            int n = ColumnwiseTupleColumn.this.dimension[x];
            if (n < 0) {
                n = ColumnwiseTupleColumn.this.index.getInt();
            }
            return n;
        }

        int calcOffset(int i) {
            int[] ii = new int[]{i};
            return this.calcOffset(ii);
        }

        int calcOffset(int i, int j) {
            int[] ii = new int[]{i, j};
            return this.calcOffset(ii);
        }

        int calcOffset(int i, int j, int k) {
            int[] ii = new int[]{i, j, k};
            return this.calcOffset(ii);
        }

        int calcOffset(int[] i) {
            if (ColumnwiseTupleColumn.this.nsub != i.length) {
                throw new RuntimeException("Wrong number of subscripts for PawArray: " + ColumnwiseTupleColumn.this.getName());
            }
            int off = ColumnwiseTupleColumn.this.offset;
            int siz = ColumnwiseTupleColumn.this.size;
            for (int j = 0; j < ColumnwiseTupleColumn.this.nsub; ++j) {
                int index = i[j];
                int d = this.getDimension(j);
                if (index < 1 || index > d) {
                    throw new RuntimeException("PawArray index out of range: " + ColumnwiseTupleColumn.this.getName() + " index=" + index);
                }
                off += (index - 1) * siz;
                siz *= d;
            }
            return off;
        }

        int calcSize() {
            int siz = 1;
            for (int j = 0; j < ColumnwiseTupleColumn.this.nsub; ++j) {
                siz *= this.getDimension(j);
            }
            return siz;
        }
    }
}

