/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.ColumnwiseTuple;
import hep.io.hbook.ColumnwiseTupleColumn;
import hep.io.hbook.Hbook;
import java.util.Enumeration;
import java.util.Vector;

class ColumnwiseBlock {
    private Vector children = new Vector();
    private int id;
    private String name;
    private long buffer = 0L;
    private int size = 0;
    private ColumnwiseTuple owner;

    ColumnwiseBlock(int id, String name, ColumnwiseTuple owner) {
        this.name = name;
        this.id = id;
        this.owner = owner;
    }

    int allocSpace(ColumnwiseTupleColumn field, int space) {
        this.children.addElement(field);
        int oldSize = this.size;
        this.size += space;
        return oldSize;
    }

    void clearMap() {
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            ColumnwiseTupleColumn field = (ColumnwiseTupleColumn)e.nextElement();
            field.isMapped = false;
        }
        if (this.buffer != 0L) {
            Hbook.CWClearMap(this.id, this.name, this.buffer);
        }
    }

    void map(ColumnwiseTupleColumn field) {
        if (!field.isMapped) {
            String setName;
            int offset;
            ColumnwiseTupleColumn index;
            if (this.buffer == 0L) {
                this.getBuffer();
            }
            if ((index = field.index) != null && !index.isMapped) {
                offset = index.offset;
                setName = "$SET:" + index.getName();
                Hbook.CWMap(this.id, this.name, this.buffer, setName, offset, index.type);
                index.isMapped = true;
            }
            offset = field.offset;
            setName = "$SET:" + field.getName();
            Hbook.CWMap(this.id, this.name, this.buffer, setName, offset, field.type);
            Hbook.setCWEvent(this.id, this.owner.ievent);
            field.isMapped = true;
            ++this.owner.mapCount;
        }
    }

    long getBuffer() {
        if (this.buffer == 0L) {
            this.buffer = Hbook.allocBuffer(this.size);
            if (this.owner.mapCount == 0) {
                Hbook.CWClearMap(this.id, this.name, this.buffer);
            }
        }
        return this.buffer;
    }

    public void close() {
        if (this.buffer != 0L) {
            Hbook.freeBuffer(this.buffer);
        }
    }
}

