/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.test;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.IEvaluator;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.test.AidaTestCase;
import hep.aida.test.TestUtils;
import java.io.IOException;
import java.util.BitSet;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Assert;

public class TestTuple
extends AidaTestCase {
    private String[] allColNames = new String[]{"col1_Int= 1", " col2_Short=2", "col3_Long = 5", "col4_Float   =0.3", " col5_Double =-0.5", "   col6_Boolean=true", "col7_Byte   =23", "col8_Character=f   ", "col9_String = de", "col10_Object", " col11_ITuple = { double px = .2, py = 3., pz = 0., ITuple xyz = {int x,y,z}, float ipx, ipy,ipz, int track=-1}"};
    private Class[] allColClasses = new Class[]{Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, class$java$lang$String == null ? (class$java$lang$String = TestTuple.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = TestTuple.class$("java.lang.Object")) : class$java$lang$Object, class$hep$aida$ITuple == null ? (class$hep$aida$ITuple = TestTuple.class$("hep.aida.ITuple")) : class$hep$aida$ITuple};
    private String columnString = "int col1_Int =1,  short col2_Short=2;long col3_Long  =5  ,  float col4_Float = 0.3 ,double col5_Double=-0.5,boolean col6_Boolean=true,byte col7_Byte=23,char col8_Character=f, string    col9_String=de;  java.lang.Object col10_Object, ITuple  col11_ITuple = { double px = .2, py = 3., pz = 0., ITuple xyz = {int x,y,z}, float ipx, ipy, ipz, int track=-1}";
    String tupleName = "myTupleName";
    String tupleTitle = "mytupleTitle";
    String tuple1Opts = "These= are; options = for; the, first= tuple";
    String tuple2Opts = " These = are,  options =For; the, second= tuple";
    private int columns;
    private int rows = 5;
    private String outputName = TestUtils.getFullPath("testTuple.aida");
    private String options = "compress=no";
    private Random r;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$hep$aida$ITuple;

    public TestTuple(String name) {
        super(name);
    }

    public void testCreateTuple() {
        this.r = this.getRandomNumberGenerator();
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITupleFactory tupleFactory = analysisFactory.createTupleFactory(analysisFactory.createTreeFactory().create());
        Assert.assertEquals(this.allColNames.length, this.allColClasses.length);
        ITuple t1 = tupleFactory.create(this.tupleName, this.tupleTitle, this.allColNames, this.allColClasses, this.tuple1Opts);
        ITuple t2 = tupleFactory.create(this.tupleName, this.tupleTitle, this.columnString, this.tuple2Opts);
        Assert.assertEquals(this.allColNames.length, t1.columns());
        Assert.assertEquals(0, t1.rows());
        if (t1 instanceof IManagedObject) {
            Assert.assertEquals(this.tupleName, ((IManagedObject)((Object)t1)).name());
        }
        Assert.assertEquals(this.tupleTitle, t1.title());
        for (int i = 0; i < t1.columns(); ++i) {
            String colName = this.allColNames[i];
            int pos = colName.indexOf(")");
            if (pos > 0) {
                colName = colName.substring(pos + 1).trim();
            }
            StringTokenizer tt = new StringTokenizer(colName, "=");
            String name = tt.nextToken().trim();
            Assert.assertEquals(name, t1.columnName(i));
            Assert.assertEquals(this.allColClasses[i], t1.columnType(i));
        }
        AidaTestCase.assertEquals(t1, t2);
        ITuple t = tupleFactory.create("t", "t test", "ITuple p = {double y}, double x", "");
        ITuple a = tupleFactory.create("a", "a test", "ITuple p = {double y, int k = 0}, double x", "");
    }

    public void testFillTuple() {
        this.r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        ITupleFactory tupleFactory = af.createTupleFactory(tree);
        ITuple tuple = tupleFactory.create(this.tupleName, this.tupleTitle, this.allColNames, this.allColClasses, this.tuple1Opts);
        ITuple tuple2 = tupleFactory.create(this.tupleName, this.tupleTitle, this.columnString, this.tuple2Opts);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        ICloud1D clInt = hf.createCloud1D("Int", "Int", 100000, "");
        ICloud1D clShort = hf.createCloud1D("Short", "Short", 100000, "");
        ICloud1D clLong = hf.createCloud1D("Long", "Long", 100000, "");
        ICloud1D clFloat = hf.createCloud1D("Float", "Float", 100000, "");
        ICloud1D clDouble = hf.createCloud1D("Double", "Double", 100000, "");
        ICloud1D clByte = hf.createCloud1D("Byte", "Byte", 100000, "");
        int totalInt = 0;
        short totalShort = 0;
        long totalLong = 0L;
        float totalFloat = 0.0f;
        double totalDouble = 0.0;
        BitSet totalBoolean = new BitSet(this.rows);
        byte totalByte = 0;
        int totalChar = 0;
        int totalString = 0;
        double momSum = 0.0;
        float ipSum = 0.0f;
        int trackSum = 0;
        int xyzSum = 0;
        int[] checkRows = new int[this.rows];
        int rowCount = 0;
        for (int i = 0; i < this.rows; ++i) {
            boolean reset;
            boolean bl = reset = !(this.r.nextDouble() < 0.99);
            if (!reset) {
                ++rowCount;
            }
            if (this.r.nextDouble() < 0.1) {
                int rndInt = this.r.nextInt(20);
                if (!reset) {
                    totalInt += rndInt;
                    clInt.fill(rndInt);
                }
                tuple.fill(0, rndInt);
                tuple2.fill(0, rndInt);
            } else if (!reset) {
                ++totalInt;
                clInt.fill(1.0);
            }
            if (this.r.nextDouble() < 0.1) {
                short rndShort = (short)this.r.nextInt(20);
                if (!reset) {
                    totalShort = (short)(totalShort + rndShort);
                    clShort.fill(rndShort);
                }
                tuple.fill(1, rndShort);
                tuple2.fill(1, rndShort);
            } else if (!reset) {
                totalShort = (short)(totalShort + 2);
                clShort.fill(2.0);
            }
            if (this.r.nextDouble() < 0.1) {
                long rndLong = this.r.nextLong();
                if (!reset) {
                    totalLong += rndLong;
                    clLong.fill(rndLong);
                }
                tuple.fill(2, rndLong);
                tuple2.fill(2, rndLong);
            } else if (!reset) {
                totalLong += 5L;
                clLong.fill(5.0);
            }
            if (this.r.nextDouble() < 0.1) {
                float rndFloat = this.r.nextFloat();
                if (!reset) {
                    totalFloat += rndFloat;
                    clFloat.fill(rndFloat);
                }
                tuple.fill(3, rndFloat);
                tuple2.fill(3, rndFloat);
            } else if (!reset) {
                totalFloat = (float)((double)totalFloat + 0.3);
                clFloat.fill(0.3f);
            }
            if (this.r.nextDouble() < 0.1) {
                double rndDouble = this.r.nextDouble();
                if (!reset) {
                    totalDouble += rndDouble;
                    clDouble.fill(rndDouble);
                }
                tuple.fill(4, rndDouble);
                tuple2.fill(4, rndDouble);
            } else if (!reset) {
                totalDouble += -0.5;
                clDouble.fill(-0.5);
            }
            if (this.r.nextDouble() < 0.1) {
                boolean rndBoolean = this.r.nextBoolean();
                if (rndBoolean && !reset) {
                    totalBoolean.set(rowCount - 1);
                }
                tuple.fill(5, rndBoolean);
                tuple2.fill(5, rndBoolean);
            } else if (Boolean.valueOf("true").booleanValue() && !reset) {
                totalBoolean.set(rowCount - 1);
            }
            if (this.r.nextDouble() < 0.1) {
                byte[] b = new byte[1];
                this.r.nextBytes(b);
                if (!reset) {
                    totalByte = (byte)(totalByte + b[0]);
                    clByte.fill(b[0]);
                }
                tuple.fill(6, b[0]);
                tuple2.fill(6, b[0]);
            } else if (!reset) {
                totalByte = (byte)(totalByte + 23);
                clByte.fill(23.0);
            }
            if (this.r.nextDouble() < 0.1) {
                int rndCharDig = this.r.nextInt(36);
                char rndChar = Character.forDigit(rndCharDig, 36);
                if (!reset) {
                    totalChar += rndCharDig;
                }
                tuple.fill(7, rndChar);
                tuple2.fill(7, rndChar);
            } else if (!reset) {
                totalChar += Character.digit('f', 36);
            }
            int rndStringDig1 = this.r.nextInt(36);
            int rndStringDig2 = this.r.nextInt(36);
            String rndString = String.valueOf(Character.forDigit(rndStringDig1, 36)) + String.valueOf(Character.forDigit(rndStringDig2, 36));
            if (this.r.nextDouble() < 0.1) {
                if (!reset) {
                    totalString += rndStringDig1 + rndStringDig2;
                }
                tuple.fill(8, rndString);
                tuple2.fill(8, rndString);
            } else if (!reset) {
                totalString += Character.digit('d', 36) + Character.digit('e', 36);
            }
            tuple.fill(9, (Object)rndString);
            tuple2.fill(9, (Object)rndString);
            ITuple folder = tuple.getTuple(10);
            ITuple folder2 = tuple2.getTuple(10);
            int folderrows = this.r.nextInt(12);
            if (!reset) {
                checkRows[rowCount - 1] = folderrows;
            }
            for (int j = 0; j < folderrows; ++j) {
                if (this.r.nextDouble() < 0.4) {
                    double px = this.r.nextDouble();
                    double py = this.r.nextDouble();
                    double pz = this.r.nextDouble();
                    if (!reset) {
                        momSum += px + py + pz;
                    }
                    folder.fill(0, px);
                    folder2.fill(0, px);
                    folder.fill(1, py);
                    folder2.fill(1, py);
                    folder.fill(2, pz);
                    folder2.fill(2, pz);
                } else if (!reset) {
                    momSum += 3.2;
                }
                int track = this.r.nextInt(23);
                if (!reset) {
                    trackSum += track;
                }
                float ipx = this.r.nextFloat();
                float ipy = this.r.nextFloat();
                float ipz = this.r.nextFloat();
                if (!reset) {
                    ipSum += ipx + ipy + ipz;
                }
                ITuple xyzfolder = folder.getTuple(3);
                ITuple xyzfolder2 = folder2.getTuple(3);
                int xyzrows = 3;
                for (int k = 0; k < xyzrows; ++k) {
                    int x = this.r.nextInt(234);
                    int y = this.r.nextInt(234);
                    int z = this.r.nextInt(234);
                    if (!reset) {
                        xyzSum += x + y + z;
                    }
                    xyzfolder.fill(0, x);
                    xyzfolder.fill(1, y);
                    xyzfolder.fill(2, z);
                    xyzfolder2.fill(0, x);
                    xyzfolder2.fill(1, y);
                    xyzfolder2.fill(2, z);
                    xyzfolder.addRow();
                    xyzfolder2.addRow();
                }
                Assert.assertEquals(xyzrows, xyzfolder.rows());
                Assert.assertEquals(xyzrows, xyzfolder2.rows());
                folder.fill(4, ipx);
                folder2.fill(4, ipx);
                folder.fill(5, ipy);
                folder2.fill(5, ipy);
                folder.fill(6, ipz);
                folder2.fill(6, ipz);
                folder.fill(7, track);
                folder2.fill(7, track);
                folder.addRow();
                folder2.addRow();
            }
            if (!reset) {
                tuple.addRow();
                tuple2.addRow();
                continue;
            }
            tuple.resetRow();
            tuple2.resetRow();
        }
        Assert.assertEquals(rowCount, tuple.rows());
        int totalIntNew = 0;
        short totalShortNew = 0;
        long totalLongNew = 0L;
        float totalFloatNew = 0.0f;
        double totalDoubleNew = 0.0;
        BitSet totalBooleanNew = new BitSet(this.rows);
        byte totalByteNew = 0;
        int totalCharNew = 0;
        int totalStringNew = 0;
        double momSumNew = 0.0;
        float ipSumNew = 0.0f;
        int trackSumNew = 0;
        int xyzSumNew = 0;
        tuple.start();
        int row = -1;
        while (tuple.next()) {
            ++row;
            totalIntNew += tuple.getInt(0);
            totalShortNew = (short)(totalShortNew + tuple.getShort(1));
            totalLongNew += tuple.getLong(2);
            totalFloatNew += tuple.getFloat(3);
            totalDoubleNew += tuple.getDouble(4);
            if (tuple.getBoolean(5)) {
                totalBooleanNew.set(row);
            }
            totalByteNew = (byte)(totalByteNew + tuple.getByte(6));
            totalCharNew += Character.digit(tuple.getChar(7), 36);
            String str = tuple.getString(8);
            totalStringNew += Character.digit(str.charAt(0), 36) + Character.digit(str.charAt(1), 36);
            ITuple folder = (ITuple)tuple.getObject(10);
            folder.start();
            Assert.assertEquals(checkRows[row], folder.rows());
            while (folder.next()) {
                momSumNew += folder.getDouble(0) + folder.getDouble(1) + folder.getDouble(2);
                ipSumNew += folder.getFloat(4) + folder.getFloat(5) + folder.getFloat(6);
                trackSumNew += folder.getInt(7);
                ITuple xyzFolder = (ITuple)folder.getObject(3);
                xyzFolder.start();
                while (xyzFolder.next()) {
                    xyzSumNew += xyzFolder.getInt(0) + xyzFolder.getInt(1) + xyzFolder.getInt(2);
                }
            }
        }
        Assert.assertEquals(totalInt, totalIntNew);
        Assert.assertEquals(totalShort, totalShortNew);
        Assert.assertEquals(totalLong, totalLongNew);
        AidaTestCase.assertEqualsFloat(totalFloat, totalFloatNew, 1.0f, tuple.rows());
        AidaTestCase.assertEqualsDouble(totalDouble, totalDoubleNew, 1.0, tuple.rows());
        Assert.assertTrue(totalBoolean.equals(totalBooleanNew));
        Assert.assertEquals(totalByte, totalByteNew);
        Assert.assertEquals(totalChar, totalCharNew);
        Assert.assertEquals(totalString, totalStringNew);
        AidaTestCase.assertEqualsDouble(momSum, momSumNew, 1.0, tuple.rows());
        AidaTestCase.assertEqualsDouble(trackSum, trackSumNew, 1.0, tuple.rows());
        AidaTestCase.assertEqualsFloat(ipSum, ipSumNew, 1.0f, tuple.rows());
        AidaTestCase.assertEqualsDouble(xyzSum, xyzSumNew, 1.0, tuple.rows());
        if (rowCount > 0) {
            AidaTestCase.assertEqualsDouble(tuple.columnMin(0), clInt.lowerEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMax(0), clInt.upperEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMean(0), clInt.mean(), tuple.columnRms(0), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnRms(0), clInt.rms(), tuple.columnRms(0), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnMin(1), clShort.lowerEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMax(1), clShort.upperEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMean(1), clShort.mean(), tuple.columnRms(1), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnRms(1), clShort.rms(), tuple.columnRms(1), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnMin(2), clLong.lowerEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMax(2), clLong.upperEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMean(2), clLong.mean(), tuple.columnRms(2), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnRms(2), clLong.rms(), tuple.columnRms(2), tuple.rows());
            AidaTestCase.assertEqualsFloat((float)tuple.columnMin(3), (float)clFloat.lowerEdge(), 1.0f);
            AidaTestCase.assertEqualsFloat((float)tuple.columnMax(3), (float)clFloat.upperEdge(), 1.0f);
            AidaTestCase.assertEqualsFloat((float)tuple.columnMean(3), (float)clFloat.mean(), (float)tuple.columnRms(3), tuple.rows());
            AidaTestCase.assertEqualsFloat((float)tuple.columnRms(3), (float)clFloat.rms(), (float)tuple.columnRms(3), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnMin(4), clDouble.lowerEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMax(4), clDouble.upperEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMean(4), clDouble.mean(), tuple.columnRms(4), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnRms(4), clDouble.rms(), tuple.columnRms(4), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnMin(6), clByte.lowerEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMax(6), clByte.upperEdge(), 1.0);
            AidaTestCase.assertEqualsDouble(tuple.columnMean(6), clByte.mean(), tuple.columnRms(6), tuple.rows());
            AidaTestCase.assertEqualsDouble(tuple.columnRms(6), clByte.rms(), tuple.columnRms(6), tuple.rows());
        }
        AidaTestCase.assertEquals(tuple, tuple2);
    }

    public void testTupleProject() {
        this.r = this.getRandomNumberGenerator();
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        ITupleFactory tf = af.createTupleFactory(tree);
        ITuple tuple = tf.create(this.tupleName, this.tupleTitle, this.allColNames, this.allColClasses, this.tuple1Opts);
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IHistogram1D h1a = hf.createHistogram1D("h1a", 10, -3.0, 3.0);
        IHistogram2D h2a = hf.createHistogram2D("h2a", 10, -3.0, 3.0, 5, -5.0, 5.0);
        IHistogram3D h3a = hf.createHistogram3D("h3a", 10, -3.0, 3.0, 5, -5.0, 5.0, 4, -1.0, 1.0);
        IHistogram1D h1b = hf.createHistogram1D("h1b", 10, -3.0, 3.0);
        IHistogram2D h2b = hf.createHistogram2D("h2b", 10, -3.0, 3.0, 5, -5.0, 5.0);
        IHistogram3D h3b = hf.createHistogram3D("h3b", 10, -3.0, 3.0, 5, -5.0, 5.0, 4, -1.0, 1.0);
        IHistogram1D h1aProj = hf.createHistogram1D("h1a", 10, -3.0, 3.0);
        IHistogram2D h2aProj = hf.createHistogram2D("h2a", 10, -3.0, 3.0, 5, -5.0, 5.0);
        IHistogram3D h3aProj = hf.createHistogram3D("h3a", 10, -3.0, 3.0, 5, -5.0, 5.0, 4, -1.0, 1.0);
        IHistogram1D h1bProj = hf.createHistogram1D("h1b", 10, -3.0, 3.0);
        IHistogram2D h2bProj = hf.createHistogram2D("h2b", 10, -3.0, 3.0, 5, -5.0, 5.0);
        IHistogram3D h3bProj = hf.createHistogram3D("h3b", 10, -3.0, 3.0, 5, -5.0, 5.0, 4, -1.0, 1.0);
        IEvaluator evXa = tf.createEvaluator(tuple.columnName(0));
        IEvaluator evYa = tf.createEvaluator(tuple.columnName(1));
        IEvaluator evZa = tf.createEvaluator(tuple.columnName(2));
        IEvaluator evXb = tf.createEvaluator(tuple.columnName(3));
        IEvaluator evYb = tf.createEvaluator(tuple.columnName(4));
        IEvaluator evZb = tf.createEvaluator(tuple.columnName(6));
        for (int i = 0; i < this.rows; ++i) {
            int rndInt = this.r.nextInt(20);
            tuple.fill(0, rndInt);
            h1a.fill(rndInt);
            short rndShort = (short)this.r.nextInt(20);
            tuple.fill(1, rndShort);
            h2a.fill(rndInt, rndShort);
            long rndLong = this.r.nextLong();
            tuple.fill(2, rndLong);
            h3a.fill(rndInt, rndShort, rndLong);
            float rndFloat = this.r.nextFloat();
            tuple.fill(3, rndFloat);
            h1b.fill(rndFloat);
            double rndDouble = this.r.nextDouble();
            tuple.fill(4, rndDouble);
            h2b.fill(rndFloat, rndDouble);
            byte[] b = new byte[1];
            this.r.nextBytes(b);
            tuple.fill(6, b[0]);
            h3b.fill(rndFloat, rndDouble, b[0]);
            tuple.addRow();
        }
        tuple.project(h1aProj, evXa);
        tuple.project(h2aProj, evXa, evYa);
        tuple.project(h3aProj, evXa, evYa, evZa);
        tuple.project(h1bProj, evXb);
        tuple.project(h2bProj, evXb, evYb);
        tuple.project(h3bProj, evXb, evYb, evZb);
        AidaTestCase.assertEquals(h1a, h1aProj);
        AidaTestCase.assertEquals(h2a, h2aProj);
        AidaTestCase.assertEquals(h3a, h3aProj);
        AidaTestCase.assertEquals(h1b, h1bProj);
        AidaTestCase.assertEquals(h2b, h2bProj);
        AidaTestCase.assertEquals(h3b, h3bProj);
    }

    public void testTupleCopy() throws IOException {
        this.r = this.getRandomNumberGenerator();
        String[] allColNames2 = new String[]{"col1_Int= 1", " col2_Short=2", "col3_Long = 5", "col4_Float   =0.3", " col5_Double =-0.5", "   col6_Boolean=true", "col7_Byte   =23", "col8_Character=f   ", "col9_String = de", "col10_Object", " col11_ITuple = { double px = .2, py = 3., pz = 0., ITuple xyz = {int x,y,z}, float ipx, ipy,ipz, int track=-1}"};
        Class[] allColClasses2 = new Class[]{Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, class$java$lang$String == null ? (class$java$lang$String = TestTuple.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = TestTuple.class$("java.lang.Object")) : class$java$lang$Object, class$hep$aida$ITuple == null ? (class$hep$aida$ITuple = TestTuple.class$("hep.aida.ITuple")) : class$hep$aida$ITuple};
        String columnString2 = "int col1_Int =1,  short col2_Short=2;long col3_Long  =5  ,  float col4_Float = 0.3 ,double col5_Double=-0.5,boolean col6_Boolean=true,byte col7_Byte=23,char col8_Character=f, string    col9_String=de;  java.lang.Object col10_Object, ITuple  col11_ITuple = { double px = .2, py = 3., pz = 0., ITuple xyz = {int x,y,z}, float ipx, ipy, ipz, int track=-1}";
        String tupleName = "myTupleName";
        String tupleTitle = "mytupleTitle";
        String tuple1Opts = "These= are; options = for; the, first= tuple";
        String tuple2Opts = " These = are,  options =For; the, second= tuple";
        this.rows = 100;
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create(this.outputName, null, false, true, this.options);
        ITupleFactory tupleFactory = analysisFactory.createTupleFactory(tree);
        ITuple tuple = tupleFactory.create(tupleName, tupleTitle, allColNames2, allColClasses2, tuple1Opts);
        double minFloat = Double.NaN;
        double minDouble = Double.NaN;
        for (int i = 0; i < this.rows; ++i) {
            tuple.fill(0, this.r.nextInt(20));
            tuple.fill(1, (short)this.r.nextInt(20));
            tuple.fill(2, this.r.nextLong());
            float tmpFloat = this.r.nextFloat();
            double tmpDouble = this.r.nextDouble();
            if (Double.isNaN(minFloat) || (double)tmpFloat < minFloat) {
                minFloat = tmpFloat;
            }
            if (Double.isNaN(minDouble) || tmpDouble < minDouble) {
                minDouble = tmpDouble;
            }
            tuple.fill(3, tmpFloat);
            tuple.fill(4, tmpDouble);
            tuple.fill(5, this.r.nextBoolean());
            byte[] b = new byte[1];
            this.r.nextBytes(b);
            tuple.fill(6, b[0]);
            tuple.fill(7, Character.forDigit(this.r.nextInt(36), 36));
            String rndString = String.valueOf(Character.forDigit(this.r.nextInt(36), 36)) + String.valueOf(Character.forDigit(this.r.nextInt(36), 36));
            tuple.fill(8, rndString);
            tuple.fill(9, (Object)rndString);
            ITuple folder = tuple.getTuple(10);
            int folderrows = this.r.nextInt(2);
            for (int j = 0; j < folderrows; ++j) {
                folder.fill(0, this.r.nextDouble());
                folder.fill(1, this.r.nextDouble());
                folder.fill(2, this.r.nextDouble());
                ITuple xyzfolder = folder.getTuple(3);
                int xyzrows = this.r.nextInt(3);
                for (int k = 0; k < xyzrows; ++k) {
                    xyzfolder.fill(0, this.r.nextInt(234));
                    xyzfolder.fill(1, this.r.nextInt(234));
                    xyzfolder.fill(2, this.r.nextInt(234));
                    xyzfolder.addRow();
                }
                folder.fill(4, this.r.nextFloat());
                folder.fill(5, this.r.nextFloat());
                folder.fill(6, this.r.nextFloat());
                folder.fill(7, this.r.nextInt(23));
                folder.addRow();
            }
            tuple.addRow();
        }
    }

    public void testTupleChain() throws IOException {
        this.r = this.getRandomNumberGenerator();
        String[] allColNames2 = new String[]{"col1_Int= 1", " col2_Short=2", "col3_Long = 5", "col4_Float   =0.3", " col5_Double =-0.5", "   col6_Boolean=true", "col7_Byte   =23", "col8_Character=f   ", "col9_String = de", "col10_Object"};
        Class[] allColClasses2 = new Class[]{Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Byte.TYPE, Character.TYPE, class$java$lang$String == null ? (class$java$lang$String = TestTuple.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = TestTuple.class$("java.lang.Object")) : class$java$lang$Object};
        String columnString2 = "int col1_Int =1,  short col2_Short=2;long col3_Long  =5  ,  float col4_Float = 0.3 ,double col5_Double=-0.5,boolean col6_Boolean=true,byte col7_Byte=23,char col8_Character=f, string    col9_String=de;  java.lang.Object col10_Object";
        String tupleName = "myTupleName";
        String tupleTitle = "mytupleTitle";
        String tuple1Opts = "These= are; options = for; the, first= tuple";
        String tuple2Opts = " These = are,  options =For; the, second= tuple";
        IAnalysisFactory analysisFactory = IAnalysisFactory.create();
        ITreeFactory treeFactory = analysisFactory.createTreeFactory();
        ITree tree = treeFactory.create(this.outputName, null, false, true, this.options);
        ITupleFactory tupleFactory = analysisFactory.createTupleFactory(tree);
        ITuple tupleAll = tupleFactory.create(tupleName, tupleTitle, allColNames2, allColClasses2, tuple1Opts);
        ITuple tuple1 = tupleFactory.create("tuple1", "tuple1", allColNames2, allColClasses2, tuple1Opts);
        ITuple tuple2 = tupleFactory.create("tuple2", "tuple2", allColNames2, allColClasses2, tuple1Opts);
        ITuple tuple3 = tupleFactory.create("tuple3", "tuple3", allColNames2, allColClasses2, tuple1Opts);
        ITuple tuple4 = tupleFactory.create("tuple4", "tuple4", allColNames2, allColClasses2, tuple1Opts);
        ITuple tuple5 = tupleFactory.create("tuple5", "tuple5", allColNames2, allColClasses2, tuple1Opts);
        this.rows = 113;
        this.fillTwoTuples(tupleAll, tuple1);
        this.rows = 1;
        this.fillTwoTuples(tupleAll, tuple2);
        this.rows = 173;
        this.fillTwoTuples(tupleAll, tuple3);
        this.rows = 0;
        this.fillTwoTuples(tupleAll, tuple4);
        this.rows = 61;
        this.fillTwoTuples(tupleAll, tuple5);
        ITuple tupleChain = tupleFactory.createChained(tupleName, tupleTitle, new ITuple[]{tuple1, tuple2, tuple3, tuple4, tuple5});
        tupleAll.start();
        tuple1.start();
        AidaTestCase.assertEquals(tupleAll, tupleChain);
    }

    private void fillTwoTuples(ITuple tuple1, ITuple tuple2) {
        for (int i = 0; i < this.rows; ++i) {
            int in = this.r.nextInt(20);
            int s = this.r.nextInt(20);
            long l = this.r.nextLong();
            float f = this.r.nextFloat();
            double d = this.r.nextDouble();
            boolean boo = this.r.nextBoolean();
            byte[] b = new byte[1];
            this.r.nextBytes(b);
            char c = Character.forDigit(this.r.nextInt(36), 36);
            String rndString = String.valueOf(Character.forDigit(this.r.nextInt(36), 36)) + String.valueOf(Character.forDigit(this.r.nextInt(36), 36));
            tuple1.fill(0, in);
            tuple1.fill(1, (short)s);
            tuple1.fill(2, l);
            tuple1.fill(3, f);
            tuple1.fill(4, d);
            tuple1.fill(5, boo);
            tuple1.fill(6, b[0]);
            tuple1.fill(7, c);
            tuple1.fill(8, rndString);
            tuple1.fill(9, (Object)rndString);
            tuple2.fill(0, in);
            tuple2.fill(1, (short)s);
            tuple2.fill(2, l);
            tuple2.fill(3, f);
            tuple2.fill(4, d);
            tuple2.fill(5, boo);
            tuple2.fill(6, b[0]);
            tuple2.fill(7, c);
            tuple2.fill(8, rndString);
            tuple2.fill(9, (Object)rndString);
            tuple1.addRow();
            tuple2.addRow();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

