/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml.converters;

import hep.aida.ref.xml.ascii.AidaAsciiXMLWriter;
import hep.aida.ref.xml.binary.AidaWBXML;
import hep.aida.ref.xml.binary.AidaWBXMLLookup;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.freehep.wbxml.Attributes;
import org.freehep.wbxml.ContentHandler;
import org.freehep.wbxml.EntityResolver;
import org.freehep.wbxml.WBXMLParser;
import org.freehep.wbxml.WBXMLTagWriter;
import org.freehep.wbxml.WBXMLWriter;
import org.xml.sax.SAXException;

public class FromBinaryHandler
implements ContentHandler,
EntityResolver {
    private WBXMLTagWriter writer;

    void convert(InputStream in, OutputStream out, boolean binary) throws IOException, SAXException {
        this.writer = binary ? new WBXMLWriter(out, AidaWBXML.attributes.length - 1) : new AidaAsciiXMLWriter(new BufferedWriter(new OutputStreamWriter(out)));
        WBXMLParser p = new WBXMLParser(this);
        p.setEntityResolver(this);
        p.parse(in);
    }

    public InputStream resolveEntity(String name, String publidId, String systemId) throws SAXException, IOException {
        this.writer.referToDTD(name, systemId);
        return null;
    }

    public void characters(char[] chars, int start, int len) throws SAXException {
        try {
            String s = new String(chars);
            this.writer.print(s.substring(start, start + len));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.writer.closeDoc();
            this.writer.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(int tagID) throws SAXException {
        try {
            this.writer.closeTag();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.writer.openDoc();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(int tag, Attributes attr, boolean empty) throws SAXException {
        try {
            int[] atts = attr.getTags();
            block13: for (int i = 0; i < atts.length; ++i) {
                int att = atts[i];
                int type = attr.getType(att);
                switch (type) {
                    case 0: {
                        boolean value = attr.getBooleanValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 1: {
                        byte value = attr.getByteValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 2: {
                        char value = attr.getCharValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 3: {
                        double value = attr.getDoubleValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 4: {
                        float value = attr.getFloatValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 5: {
                        int value = attr.getIntValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 6: {
                        long value = attr.getLongValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 7: {
                        short value = attr.getShortValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    case 8: {
                        String value = attr.getStringValue(att);
                        this.writer.setAttribute(att, value);
                        continue block13;
                    }
                    default: {
                        throw new SAXException("Type '" + type + "' not handled for attribute '" + AidaWBXMLLookup.getAttributeName(att) + "' in tag '" + AidaWBXMLLookup.getTagName(tag) + "'");
                    }
                }
            }
            if (empty) {
                this.writer.printTag(tag);
            } else {
                this.writer.openTag(tag);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

