/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IEvaluator;
import hep.aida.IFilter;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.tree.Tree;
import hep.aida.ref.tuple.AbstractTuple;
import hep.aida.ref.tuple.ChainedTuple;
import hep.aida.ref.tuple.Evaluator;
import hep.aida.ref.tuple.Filter;
import hep.aida.ref.tuple.Tuple;

public class TupleFactory
implements ITupleFactory {
    private Tree tree;
    private static final char separatorChar = '/';
    static /* synthetic */ Class class$hep$aida$ITuple;

    private String nameInPath(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(index + 1);
    }

    private String parentPath(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return path.substring(0, index);
    }

    public TupleFactory(ITree tree) {
        this.tree = tree instanceof Tree ? (Tree)tree : null;
    }

    public ITuple create(String path, String title, String[] columnName, Class[] columnType, String options) {
        Tuple tuple = new Tuple(this.nameInPath(path), title, columnName, columnType, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), tuple);
        }
        return tuple;
    }

    public ITuple create(String path, String title, String[] columnName, Class[] columnType) {
        return this.create(path, title, columnName, columnType, "");
    }

    public ITuple create(String path, String title, String columns, String options) {
        Tuple tuple = new Tuple(this.nameInPath(path), title, columns, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), tuple);
        }
        return tuple;
    }

    public ITuple create(String path, String title, String columns) {
        return this.create(path, title, columns, "");
    }

    public ITuple createChained(String path, String title, ITuple[] set) {
        ChainedTuple tuple = new ChainedTuple(this.nameInPath(path), title, set);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), tuple);
        }
        return tuple;
    }

    public ITuple createChained(String path, String title, String[] setName) {
        if (this.tree == null) {
            throw new IllegalArgumentException("This TupleFactory does not have a Tree. Can not find Tuple by name.");
        }
        ITuple[] tupleSet = new ITuple[setName.length];
        for (int i = 0; i < setName.length; ++i) {
            IManagedObject t = this.tree.find(setName[i]);
            if (!(t instanceof ITuple)) {
                throw new IllegalArgumentException("ManagedObject \"" + setName[i] + "\" is not an ITuple");
            }
            tupleSet[i] = (ITuple)((Object)t);
        }
        return this.createChained(path, title, tupleSet);
    }

    public ITuple createFiltered(String path, ITuple tuple, IFilter filter) {
        int nColumns = tuple.columns();
        String[] columnNames = new String[nColumns];
        for (int i = 0; i < nColumns; ++i) {
            columnNames[i] = tuple.columnName(i);
        }
        return this.createFiltered(path, tuple, filter, columnNames);
    }

    public ITuple createFiltered(String path, ITuple tuple, IFilter filter, String[] columns) {
        int nColumns = columns.length;
        if (nColumns > tuple.columns()) {
            throw new IllegalArgumentException("Original ITuple has less columns (" + tuple.columns() + ") than requested for copy (" + nColumns + ")");
        }
        int[] columnId = new int[nColumns];
        String[] fullColumnNames = new String[nColumns];
        Class[] columnTypes = new Class[nColumns];
        AbstractTuple cdsTuple = null;
        if (tuple instanceof Tuple) {
            cdsTuple = (AbstractTuple)tuple;
        }
        for (int i = 0; i < nColumns; ++i) {
            columnId[i] = tuple.findColumn(columns[i]);
            columnTypes[i] = tuple.columnType(columnId[i]);
            fullColumnNames[i] = null;
            if (cdsTuple != null) {
                fullColumnNames[i] = cdsTuple.columnDefaultString(columnId[i]);
            } else if (tuple.columnType(i) != (class$hep$aida$ITuple == null ? TupleFactory.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                fullColumnNames[i] = tuple.columnDefaultValue(i).toString();
            } else {
                ITuple tup = tuple.findTuple(i);
                if (tup != null) {
                    String tupName = "";
                    tupName = tup instanceof IManagedObject ? ((IManagedObject)((Object)tup)).name() : tup.title();
                    String tmpColumnsString = "";
                    int nCol = tup.columns();
                    for (int j = 0; j < nCol; ++j) {
                        Class colType = tup.columnType(j);
                        String colName = tup.columnName(j);
                        tmpColumnsString = tmpColumnsString + colType + " " + colName;
                        if (i >= nCol) continue;
                        tmpColumnsString = tmpColumnsString + ";";
                    }
                    fullColumnNames[i] = tupName + " = {" + tmpColumnsString + "}";
                } else {
                    fullColumnNames[i] = "null";
                }
            }
            if (columnTypes[i] == (class$hep$aida$ITuple == null ? TupleFactory.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) continue;
            fullColumnNames[i] = columns[i] + " = " + fullColumnNames[i];
        }
        String title = tuple.title();
        Tuple newTuple = new Tuple(this.nameInPath(path), title, fullColumnNames, columnTypes, null);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), newTuple);
        }
        this.copyTuple(tuple, newTuple, filter);
        return newTuple;
    }

    public ITuple createCopy(String path, ITuple tuple) throws IllegalArgumentException {
        return this.createFiltered(path, tuple, null);
    }

    private void copyTuple(ITuple tuple, ITuple newTuple, IFilter filter) {
        if (tuple.rows() > 0) {
            int i;
            int nColumns = newTuple.columns();
            int[] columnId = new int[nColumns];
            Class[] columnTypes = new Class[nColumns];
            for (i = 0; i < nColumns; ++i) {
                columnId[i] = tuple.findColumn(newTuple.columnName(i));
                columnTypes[i] = newTuple.columnType(i);
            }
            tuple.start();
            if (filter != null) {
                filter.initialize(tuple);
            }
            while (tuple.next()) {
                if (filter != null && !filter.accept()) continue;
                for (i = 0; i < nColumns; ++i) {
                    int j = columnId[i];
                    if (columnTypes[i] == Integer.TYPE) {
                        newTuple.fill(i, tuple.getInt(j));
                        continue;
                    }
                    if (columnTypes[i] == Short.TYPE) {
                        newTuple.fill(i, tuple.getShort(j));
                        continue;
                    }
                    if (columnTypes[i] == Long.TYPE) {
                        newTuple.fill(i, tuple.getLong(j));
                        continue;
                    }
                    if (columnTypes[i] == Float.TYPE) {
                        newTuple.fill(i, tuple.getFloat(j));
                        continue;
                    }
                    if (columnTypes[i] == Double.TYPE) {
                        newTuple.fill(i, tuple.getDouble(j));
                        continue;
                    }
                    if (columnTypes[i] == Boolean.TYPE) {
                        newTuple.fill(i, tuple.getBoolean(j));
                        continue;
                    }
                    if (columnTypes[i] == Byte.TYPE) {
                        newTuple.fill(i, tuple.getByte(j));
                        continue;
                    }
                    if (columnTypes[i] == Character.TYPE) {
                        newTuple.fill(i, tuple.getChar(j));
                        continue;
                    }
                    if (columnTypes[i] == (class$hep$aida$ITuple == null ? TupleFactory.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                        ITuple tOld = (ITuple)tuple.getObject(j);
                        ITuple tNew = newTuple.getTuple(i);
                        this.copyTuple(tOld, tNew, null);
                        continue;
                    }
                    newTuple.fill(i, tuple.getObject(j));
                }
                newTuple.addRow();
            }
        }
    }

    public IFilter createFilter(String expression) {
        return new Filter(expression);
    }

    public IFilter createFilter(String expression, int rowsToProcess, int startingRow) {
        return new Filter(expression, rowsToProcess, startingRow);
    }

    public IFilter createFilter(String expression, int rowsToProcess) {
        return new Filter(expression, rowsToProcess, 0);
    }

    public IEvaluator createEvaluator(String expression) {
        return new Evaluator(expression);
    }
}

