/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.ref.plotter.style.registry.IPlotterState;
import hep.aida.ref.plotter.style.registry.IStyleRule;
import hep.aida.ref.plotter.style.registry.JELRuleCompiledExpression;

public class JELRule
implements IStyleRule {
    private String description;
    private String type;
    private JELRuleCompiledExpression compiledExpression;

    public JELRule() {
        this("");
    }

    public JELRule(String description) {
        this(description, null);
    }

    public JELRule(String description, String type) {
        this.description = description;
        this.type = type;
        if (description != null) {
            this.recompile();
        }
    }

    void recompile() {
        this.compiledExpression = this.description == null || this.description.trim().equals("") ? null : new JELRuleCompiledExpression(this.description);
    }

    public void setType(String d) {
        this.type = d;
    }

    public String getType() {
        return this.type;
    }

    public void setDescription(String d) {
        String tmp = this.description;
        this.description = d;
        try {
            this.recompile();
        }
        catch (RuntimeException e1) {
            this.description = tmp;
            throw e1;
        }
        catch (Exception e2) {
            this.description = tmp;
            throw new RuntimeException("Can not set Description for JELRule: \n\t" + d, e2);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean ruleApplies(IPlotterState state) {
        if (this.compiledExpression == null) {
            return true;
        }
        return this.compiledExpression.evaluate(state);
    }
}

