/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.editor;

import java.awt.Color;
import org.freehep.swing.ColorConverter;

public class StylePropertyState {
    Class type = null;
    int currentIndex = -1;
    int defaultIndex = -1;
    Object currentValue = null;
    Object defaultValue = null;
    Object[] values = null;

    StylePropertyState() {
    }

    StylePropertyState(Object cv, Object[] st) {
        this.currentValue = cv;
        this.values = st;
        this.setIndex();
    }

    StylePropertyState(int ci, Object cv, Object[] st) {
        this(ci, cv, st, -1, null);
    }

    StylePropertyState(int ci, Object cv, Object[] st, int di, Object dv) {
        this(ci, cv, st, di, dv, null);
    }

    StylePropertyState(int ci, Object cv, Object[] st, int di, Object dv, Class t) {
        this.type = t;
        this.currentIndex = ci;
        this.defaultIndex = di;
        this.currentValue = cv;
        this.defaultValue = dv;
        this.values = st;
    }

    StylePropertyState(StylePropertyState state) {
        this.type = state.type;
        this.currentIndex = state.currentIndex;
        this.defaultIndex = state.defaultIndex;
        this.currentValue = state.currentValue;
        this.defaultValue = state.defaultValue;
        this.values = state.values;
    }

    void setIndex() {
        int ci = -1;
        int di = -1;
        if (this.values != null && this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.currentValue != null && this.currentValue == this.values[i]) {
                    ci = i;
                }
                if (this.defaultValue == null || this.defaultValue != this.values[i]) continue;
                di = i;
            }
        }
        this.currentIndex = ci;
        this.defaultIndex = di;
    }

    public void clear() {
        this.type = null;
        this.currentIndex = -1;
        this.defaultIndex = -1;
        this.currentValue = null;
        this.defaultValue = null;
        this.values = null;
    }

    public boolean equals(Object state) {
        if (state == null) {
            return false;
        }
        if (this == state) {
            return true;
        }
        if (state instanceof StylePropertyState) {
            return this.toString(true).equals(((StylePropertyState)state).toString(true));
        }
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean detailed) {
        String tmp = "";
        if (!detailed) {
            Object obj = this.currentValue;
            if (this.currentValue == null && this.defaultValue != null) {
                obj = this.defaultValue;
            }
            if (obj instanceof String) {
                tmp = (String)obj;
            } else if (obj instanceof Color) {
                tmp = ColorConverter.get((Color)obj);
            } else if (obj != null) {
                tmp = obj.toString();
            }
            return tmp;
        }
        tmp = tmp + "StylePropertyState: type=" + this.type + "\n";
        tmp = tmp + "\tCurrentIndex=" + this.currentIndex + "\t DefaultIndex=" + this.defaultIndex + "\n";
        tmp = tmp + "\tCurrentValue=" + this.currentValue + "\t DefaultValue=" + this.defaultValue + "\n";
        if (this.values == null || this.values.length == 0) {
            tmp = tmp + "\t\tValue is Empty\n";
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                tmp = tmp + "\t\tValue " + i + "\t" + this.values[i] + "\n";
            }
        }
        return tmp;
    }
}

