/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.optimizer.jminuit;

import hep.aida.ext.IVariableSettings;
import hep.aida.ref.optimizer.AbstractOptimizer;
import hep.aida.ref.optimizer.OptimizerResult;
import hep.aida.ref.optimizer.jminuit.FunctionWrapper;
import hep.aida.ref.optimizer.jminuit.JMinuitConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.MnContours;
import org.freehep.math.minuit.MnMigrad;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.Point;

class JMinuitOptimizer
extends AbstractOptimizer {
    private FunctionMinimum min;
    private FCNBase fcn;
    private MnUserParameters upar;
    private MnMigrad migrad;
    private ArrayList pars;

    JMinuitOptimizer() {
        this.result = new OptimizerResult();
        this.setConfiguration(new JMinuitConfiguration());
    }

    public void optimize() {
        double[][] cov;
        this.pars = new ArrayList();
        if (this.function == null) {
            throw new IllegalArgumentException("Cannot optimize!! The function was not set correctly!");
        }
        String[] variableNames = this.function.variableNames();
        if (variableNames == null || variableNames.length == 0) {
            throw new IllegalArgumentException("Cannot optimize!! There are no variable parameters in this function!");
        }
        this.upar = new MnUserParameters();
        for (int i = 0; i < variableNames.length; ++i) {
            String varName = variableNames[i];
            IVariableSettings varSet = this.variableSettings(varName);
            double value = varSet.value();
            if (Double.isNaN(value)) {
                throw new IllegalArgumentException("No initial value set for variable " + varName);
            }
            if (varSet.isBound()) {
                this.upar.add(varName, value, varSet.stepSize(), varSet.lowerBound(), varSet.upperBound());
            } else {
                this.upar.add(varName, value, varSet.stepSize());
            }
            if (varSet.isFixed()) {
                this.upar.fix(varName);
                continue;
            }
            this.pars.add(varName);
        }
        if (this.upar.variableParameters() == 0) {
            throw new IllegalArgumentException("Cannot optimize!! There are no free variable registered in Minuit!");
        }
        this.fcn = FunctionWrapper.create(this.function);
        this.migrad = new MnMigrad(this.fcn, this.upar);
        this.migrad.setErrorDef(((JMinuitConfiguration)this.configuration).errorDef());
        this.migrad.setUseAnalyticalDerivatives(this.configuration.useFunctionGradient());
        this.min = this.migrad.minimize();
        if (this.configuration().printLevel() <= -2) {
            System.out.println(this.min.toString());
        }
        double[] parameterVals = new double[variableNames.length];
        for (int i = 0; i < parameterVals.length; ++i) {
            parameterVals[i] = this.min.userParameters().value(i);
        }
        this.result.setParameters(parameterVals);
        this.result.setOptimizationStatus(this.min.isValid() ? 3 : 6);
        if (this.min.isValid()) {
            for (int i = 0; i < variableNames.length; ++i) {
                String varName = variableNames[i];
                IVariableSettings varSet = this.variableSettings(varName);
                if (varSet.isFixed()) continue;
                varSet.setValue(this.min.userParameters().value(varName));
                double err = this.min.userParameters().error(varName);
                if (Double.isNaN(err)) continue;
                varSet.setStepSize(this.min.userParameters().error(varName));
            }
            MnUserCovariance mat = this.min.userCovariance();
            if (this.configuration().printLevel() <= -2) {
                System.out.println(mat.toString());
            }
            cov = new double[mat.nrow()][mat.nrow()];
            for (int i = 0; i < mat.nrow(); ++i) {
                for (int j = 0; j < mat.nrow(); ++j) {
                    cov[i][j] = mat.get(i, j);
                }
            }
        } else {
            cov = new double[this.pars.size()][this.pars.size()];
        }
        this.result.setCovarianceMatrix(cov);
    }

    public boolean acceptsConstraints() {
        return true;
    }

    public boolean canCalculateContours() {
        return true;
    }

    public double[][] calculateContour(String par1, String par2, int npts, double nSigmas) {
        this.optimize();
        MnContours contour = new MnContours(this.fcn, this.min);
        int px = -1;
        int py = -1;
        if (!this.pars.contains(par1)) {
            throw new IllegalArgumentException("Parameter " + par1 + " was not part of the fit.");
        }
        px = this.pars.indexOf(par1);
        if (!this.pars.contains(par2)) {
            throw new IllegalArgumentException("Parameter " + par2 + " was not part of the fit.");
        }
        py = this.pars.indexOf(par2);
        List points = contour.points(px, py, nSigmas, npts);
        double[][] result = new double[2][npts];
        for (int i = 0; i < points.size(); ++i) {
            Point p = (Point)points.get(i);
            result[0][i] = p.first;
            result[1][i] = p.second;
        }
        return result;
    }

    public void reset() {
        this.migrad = null;
    }
}

