/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.JIDLComponentListener;
import com.idl.javaidl.JIDLCursorSupport;
import com.idl.javaidl.JIDLEventExtra;
import com.idl.javaidl.JIDLException;
import com.idl.javaidl.JIDLJAWT;
import com.idl.javaidl.JIDLKeyEventExtra;
import com.idl.javaidl.JIDLKeyListener;
import com.idl.javaidl.JIDLMouseListener;
import com.idl.javaidl.JIDLMouseMotionListener;
import com.idl.javaidl.JIDLMouseWheelListener;
import com.idl.javaidl.JIDLNotifyListener;
import com.idl.javaidl.JIDLObjectI;
import com.idl.javaidl.JIDLOutputListener;
import com.idl.javaidl.JIDLPAL;
import com.idl.javaidl.JIDLPlatform;
import com.idl.javaidl.JIDLProcessInitializer;
import com.idl.javaidl.JIDLX11SunJDKReflection;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.JPopupMenu;

public abstract class JIDLCanvas
extends Canvas
implements JIDLObjectI,
ComponentListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
JIDLMouseListener,
JIDLMouseMotionListener,
JIDLMouseWheelListener,
JIDLKeyListener,
JIDLComponentListener,
JIDLCursorSupport {
    public static final int OPENGL_RENDERER = 0;
    public static final int IDL_SOFTWARE_RENDERER = 1;
    private JIDLPAL m_interface;
    private String m_sClass;
    private JIDLJAWT m_jawt;
    private long m_hwnd;
    private boolean m_bObjCreated;
    private boolean m_isDestroyed;
    protected String m_keywords;
    private Vector m_IDLComponentListeners;
    private Vector m_IDLMouseListeners;
    private Vector m_IDLMouseWheelListeners;
    private Vector m_IDLMouseMotionListeners;
    private Vector m_IDLKeyListeners;
    private int m_lastX;
    private int m_lastY;

    private static GraphicsConfiguration chooseGC(int iRenderer, String sProcessName) {
        JIDLPAL jpal = new JIDLPAL(null, "IDL$GCCHOOSER");
        if (jpal.computeGCData()) {
            int i;
            long reqid;
            long reqdepth;
            if (iRenderer == 0) {
                reqdepth = jpal.getGCData(1L);
                reqid = jpal.getGCData(3L);
            } else {
                reqdepth = jpal.getGCData(2L);
                reqid = jpal.getGCData(4L);
            }
            GraphicsDevice dev = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration[] gc = dev.getConfigurations();
            for (i = 0; i < gc.length; ++i) {
                long visid;
                block7: {
                    visid = 0L;
                    try {
                        visid = JIDLX11SunJDKReflection.graphicsConfigurationGetVisualID(gc[i]);
                    }
                    catch (Throwable t) {
                        InvocationTargetException ite;
                        if (!(t instanceof InvocationTargetException) || !((ite = (InvocationTargetException)t).getCause() instanceof UnsatisfiedLinkError) || JIDLPlatform.platformSupportsGraphics()) break block7;
                        return null;
                    }
                }
                if (visid != reqid) continue;
                return gc[i];
            }
            for (i = 0; i < gc.length; ++i) {
                int bpp = gc[i].getColorModel().getPixelSize();
                if ((long)bpp != reqdepth) continue;
                return gc[i];
            }
        }
        return null;
    }

    public JIDLCanvas(String sClass, String sProcessName, int iRenderer) {
        super(JIDLCanvas.chooseGC(sProcessName == "" ? iRenderer : 1, sProcessName));
        if (!JIDLPlatform.platformSupportsGraphics()) {
            throw new JIDLException(-1L, "JIDLCanvas is not supported on this platform.");
        }
        if (sProcessName != "") {
            iRenderer = 1;
            if (!JIDLPlatform.platformSupportsOutOfProcessGraphics()) {
                throw new JIDLException(-1L, "JIDLCanvas is not supported on this platform.");
            }
        }
        this.m_sClass = sClass;
        this.m_jawt = null;
        this.m_hwnd = 0L;
        this.m_bObjCreated = false;
        this.m_isDestroyed = false;
        this.m_IDLKeyListeners = null;
        this.m_IDLMouseListeners = null;
        this.m_IDLMouseWheelListeners = null;
        this.m_IDLMouseMotionListeners = null;
        this.m_lastX = 0;
        this.m_lastY = 0;
        this.m_keywords = "RENDERER=" + Integer.toString(iRenderer).trim();
        this.m_interface = new JIDLPAL(this, sProcessName);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    public JIDLCanvas(String sClass, String sProcessName) {
        this(sClass, sProcessName, 1);
    }

    public JIDLCanvas(String sClass, int iOPSFlags, String sProcessName) {
        this(sClass, sProcessName);
    }

    public void createObject() {
        this.createObject(0, null, null, null);
    }

    public void createObject(JIDLProcessInitializer initializer) {
        this.createObject(0, null, null, initializer);
    }

    public void createObject(int argc, Object[] argv, int[] argpal) {
        this.createObject(argc, argv, argpal, null);
    }

    @Override
    public synchronized void createObject(int argc, Object[] argv, int[] argpal, JIDLProcessInitializer initializer) {
        if (this.m_isDestroyed) {
            throw new JIDLException(-1L, "Wrapper has been destroyed.");
        }
        if (this.m_interface != null) {
            this.m_jawt = new JIDLJAWT(this);
            if (this.m_jawt != null) {
                this.m_hwnd = this.m_jawt.getWindowHandle();
            }
            if (this.m_hwnd <= 0L) {
                this.m_hwnd = 0L;
                this.m_jawt = null;
                throw new JIDLException(-1L, "Unable to acquire native display area for use by JIDLCanvas");
            }
            try {
                this.m_interface.createObject(this.m_sClass, argc, argv, argpal, initializer, this.m_hwnd, this.m_keywords);
                this.initListeners();
                this.addKeyListener(this);
                this.addMouseListener(this);
                this.addMouseWheelListener(this);
                this.addMouseMotionListener(this);
                this.addComponentListener(this);
                this.repaint();
            }
            catch (JIDLException e) {
                this.m_hwnd = 0L;
                this.m_jawt = null;
                this.m_bObjCreated = false;
                throw e;
            }
            this.m_bObjCreated = true;
        }
    }

    @Override
    public void initListeners() {
        this.addIDLComponentListener(this);
        this.addIDLKeyListener(this);
        this.addIDLMouseWheelListener(this);
        this.addIDLMouseListener(this);
        this.addIDLMouseMotionListener(this);
    }

    @Override
    public synchronized void destroyObject() {
        this.m_jawt = null;
        this.m_hwnd = 0L;
        if (this.m_bObjCreated && this.m_interface != null) {
            this.m_interface.destroyObject();
        }
        this.removeNotify();
        this.m_interface = null;
        this.m_isDestroyed = true;
        this.m_bObjCreated = false;
    }

    @Override
    public boolean isObjectCreated() {
        return this.m_bObjCreated;
    }

    @Override
    public boolean isObjectDisplayable() {
        return true;
    }

    public boolean isObjCreated() {
        return this.isObjectCreated();
    }

    @Override
    public void abort() {
        if (this.m_interface != null) {
            this.m_interface.abort();
        }
    }

    @Override
    public long getCookie() {
        long cookie = -1L;
        if (this.m_interface != null) {
            cookie = this.m_interface.getCookie();
        }
        return cookie;
    }

    @Override
    public String getProcessName() {
        if (this.m_interface != null) {
            return this.m_interface.getProcessName();
        }
        return "";
    }

    @Override
    public void setProcessName(String process) {
        if (this.m_interface != null) {
            this.m_interface.setProcessName(process);
        }
    }

    @Override
    public String getIDLObjectClassName() {
        return this.m_sClass;
    }

    public String getClassName() {
        return this.getIDLObjectClassName();
    }

    public void callProcedure(String sMethodName) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(sMethodName, 0, null, null);
        }
    }

    @Override
    public void callProcedure(String sMethodName, int argc, Object[] argv, int[] argpal) {
        if (this.m_interface != null) {
            this.m_interface.callProcedure(sMethodName, argc, argv, argpal);
        }
    }

    public Object callFunction(String sMethodName, int iPalFlag) {
        return this.callFunction(sMethodName, 0, null, null, iPalFlag);
    }

    @Override
    public Object callFunction(String sMethodName, int argc, Object[] argv, int[] argpal, int iPalFlag) {
        Object result = null;
        if (this.m_interface != null) {
            result = this.m_interface.callFunction(sMethodName, argc, argv, argpal, iPalFlag);
        }
        return result;
    }

    @Override
    public Object getProperty(String sProperty, int iPalFlag) {
        Object result = null;
        if (this.m_interface != null) {
            result = this.m_interface.getProperty(sProperty, iPalFlag);
        }
        return result;
    }

    @Override
    public void setProperty(String sProperty, Object obj, int iPalFlag) {
        if (this.m_interface != null) {
            this.m_interface.setProperty(sProperty, obj, iPalFlag);
        }
    }

    public String getObjVariableName() {
        return this.getIDLObjectVariableName();
    }

    @Override
    public String getIDLObjectVariableName() {
        String result = "";
        if (this.m_interface != null) {
            result = this.m_interface.getIDLObjectVariableName();
        }
        return result;
    }

    @Override
    public Object getIDLVariable(String sVar) {
        Object result = null;
        if (this.m_interface != null) {
            result = this.m_interface.getIDLVariable(sVar);
        }
        return result;
    }

    @Override
    public void setIDLVariable(String sVar, Object obj) {
        if (this.m_interface != null) {
            this.m_interface.setIDLVariable(sVar, obj);
        }
    }

    @Override
    public void executeString(String sCmd) {
        if (this.m_interface != null) {
            this.m_interface.executeString(sCmd);
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public synchronized void draw() {
        if (this.m_bObjCreated && this.m_hwnd > 0L && this.m_jawt != null && this.m_interface != null) {
            if (this.m_IDLComponentListeners != null) {
                JIDLComponentListener listener = null;
                for (int i = 0; i < this.m_IDLComponentListeners.size(); ++i) {
                    listener = (JIDLComponentListener)this.m_IDLComponentListeners.elementAt(i);
                    listener.IDLcomponentExposed(this);
                }
            } else {
                this.IDLcomponentExposed(this);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        this.draw();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public final void componentResized(ComponentEvent e) {
        if (this.m_IDLComponentListeners != null) {
            JIDLComponentListener listener = null;
            for (int i = 0; i < this.m_IDLComponentListeners.size(); ++i) {
                listener = (JIDLComponentListener)this.m_IDLComponentListeners.elementAt(i);
                listener.IDLcomponentResized(this, e);
            }
        } else {
            this.IDLcomponentResized(this, e);
        }
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener listener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                listener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                listener.IDLmousePressed(this, e);
            }
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener listener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                listener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                listener.IDLmouseReleased(this, e);
            }
        }
    }

    @Override
    public final void mouseEntered(MouseEvent e) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener listener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                listener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                listener.IDLmouseEntered(this, e);
            }
        }
        if (this.m_IDLKeyListeners != null) {
            this.requestFocus();
        }
    }

    @Override
    public final void mouseExited(MouseEvent e) {
        if (this.m_IDLMouseListeners != null) {
            JIDLMouseListener listener = null;
            for (int i = 0; i < this.m_IDLMouseListeners.size(); ++i) {
                listener = (JIDLMouseListener)this.m_IDLMouseListeners.elementAt(i);
                listener.IDLmouseExited(this, e);
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.m_lastX = e.getX();
        this.m_lastY = e.getY();
        if (this.m_IDLMouseWheelListeners != null) {
            JIDLMouseWheelListener listener = null;
            for (int i = 0; i < this.m_IDLMouseWheelListeners.size(); ++i) {
                listener = (JIDLMouseWheelListener)this.m_IDLMouseWheelListeners.elementAt(i);
                listener.IDLmouseWheelMoved(this, e);
            }
        }
    }

    @Override
    public final void mouseMoved(MouseEvent e) {
        this.m_lastX = e.getX();
        this.m_lastY = e.getY();
        if (this.m_IDLMouseMotionListeners != null) {
            JIDLMouseMotionListener listener = null;
            for (int i = 0; i < this.m_IDLMouseMotionListeners.size(); ++i) {
                listener = (JIDLMouseMotionListener)this.m_IDLMouseMotionListeners.elementAt(i);
                listener.IDLmouseMoved(this, e);
            }
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        this.m_lastX = e.getX();
        this.m_lastY = e.getY();
        if (this.m_IDLMouseMotionListeners != null) {
            JIDLMouseMotionListener listener = null;
            for (int i = 0; i < this.m_IDLMouseMotionListeners.size(); ++i) {
                listener = (JIDLMouseMotionListener)this.m_IDLMouseMotionListeners.elementAt(i);
                listener.IDLmouseDragged(this, e);
            }
        }
    }

    @Override
    public final void keyPressed(KeyEvent e) {
        if (this.m_IDLKeyListeners != null) {
            JIDLKeyListener listener = null;
            for (int i = 0; i < this.m_IDLKeyListeners.size(); ++i) {
                listener = (JIDLKeyListener)this.m_IDLKeyListeners.elementAt(i);
                listener.IDLkeyPressed(this, e, this.m_lastX, this.m_lastY);
            }
        }
    }

    @Override
    public final void keyReleased(KeyEvent e) {
        if (this.m_IDLKeyListeners != null) {
            JIDLKeyListener listener = null;
            for (int i = 0; i < this.m_IDLKeyListeners.size(); ++i) {
                listener = (JIDLKeyListener)this.m_IDLKeyListeners.elementAt(i);
                listener.IDLkeyReleased(this, e, this.m_lastX, this.m_lastY);
            }
        }
    }

    public void postIDLEventOnInterface(ComponentEvent e, JIDLEventExtra extra) {
        if (this.m_interface != null && e != null) {
            this.m_interface.OnEvent(e, extra);
        }
    }

    protected void postIDLEvent(ComponentEvent e, JIDLEventExtra extra) {
        this.postIDLEventOnInterface(e, extra);
    }

    public void addIDLComponentListener(JIDLComponentListener listener) {
        if (listener != null) {
            if (this.m_IDLComponentListeners == null) {
                this.m_IDLComponentListeners = new Vector(1);
            }
            if (!this.m_IDLComponentListeners.contains(listener)) {
                this.m_IDLComponentListeners.add(listener);
            }
        }
    }

    public void removeIDLComponentListener(JIDLComponentListener listener) {
        if (this.m_IDLComponentListeners != null && listener != null) {
            this.m_IDLComponentListeners.remove(listener);
        }
    }

    @Override
    public synchronized void IDLcomponentExposed(JIDLObjectI obj) {
        this.IDLcomponentExposedOnInterface(obj);
    }

    public synchronized void IDLcomponentExposedOnInterface(JIDLObjectI obj) {
        long ds;
        if (this.m_bObjCreated && this.m_hwnd > 0L && this.m_jawt != null && this.m_interface != null && (ds = this.m_jawt.lock()) != 0L) {
            this.m_interface.OnExpose(this);
            this.m_jawt.unlock();
        }
    }

    @Override
    public synchronized void IDLcomponentResized(JIDLObjectI obj, ComponentEvent e) {
        if (this.m_bObjCreated) {
            this.postIDLEvent(e, null);
        }
    }

    public void addIDLKeyListener(JIDLKeyListener listener) {
        if (listener != null) {
            if (this.m_IDLKeyListeners == null) {
                this.m_IDLKeyListeners = new Vector(1);
            }
            if (!this.m_IDLKeyListeners.contains(listener)) {
                this.m_IDLKeyListeners.add(listener);
            }
        }
    }

    public void removeIDLKeyListener(JIDLKeyListener listener) {
        if (this.m_IDLKeyListeners != null && listener != null) {
            this.m_IDLKeyListeners.remove(listener);
        }
    }

    @Override
    public void IDLkeyPressed(JIDLObjectI obj, KeyEvent e, int x, int y) {
        this.postIDLEvent(e, new JIDLKeyEventExtra(x, y));
    }

    protected boolean isCapsLocked() {
        boolean capsLocked = false;
        capsLocked = this.getToolkit().getLockingKeyState(20);
        return capsLocked;
    }

    @Override
    public void IDLkeyReleased(JIDLObjectI obj, KeyEvent e, int x, int y) {
        this.postIDLEvent(e, new JIDLKeyEventExtra(x, y));
    }

    public void addIDLMouseWheelListener(JIDLMouseWheelListener listener) {
        if (listener != null) {
            if (this.m_IDLMouseWheelListeners == null) {
                this.m_IDLMouseWheelListeners = new Vector(1);
            }
            if (!this.m_IDLMouseWheelListeners.contains(listener)) {
                this.m_IDLMouseWheelListeners.add(listener);
            }
        }
    }

    public void removeIDLMouseWheelListener(JIDLMouseWheelListener listener) {
        if (this.m_IDLMouseWheelListeners != null && listener != null) {
            this.m_IDLMouseWheelListeners.remove(listener);
        }
    }

    @Override
    public void IDLmouseWheelMoved(JIDLObjectI obj, MouseWheelEvent e) {
        this.postIDLEvent(e, null);
    }

    public void addIDLMouseListener(JIDLMouseListener listener) {
        if (listener != null) {
            if (this.m_IDLMouseListeners == null) {
                this.m_IDLMouseListeners = new Vector(1);
            }
            if (!this.m_IDLMouseListeners.contains(listener)) {
                this.m_IDLMouseListeners.add(listener);
            }
        }
    }

    public void removeIDLMouseListener(JIDLMouseListener listener) {
        if (this.m_IDLMouseListeners != null && listener != null) {
            this.m_IDLMouseListeners.remove(listener);
        }
    }

    @Override
    public void IDLmousePressed(JIDLObjectI obj, MouseEvent e) {
        this.postIDLEvent(e, null);
    }

    @Override
    public void IDLmouseReleased(JIDLObjectI obj, MouseEvent e) {
        this.postIDLEvent(e, null);
    }

    @Override
    public void IDLmouseEntered(JIDLObjectI obj, MouseEvent e) {
        this.postIDLEvent(e, null);
    }

    @Override
    public void IDLmouseExited(JIDLObjectI obj, MouseEvent e) {
        this.postIDLEvent(e, null);
    }

    public void addIDLMouseMotionListener(JIDLMouseMotionListener listener) {
        if (listener != null) {
            if (this.m_IDLMouseMotionListeners == null) {
                this.m_IDLMouseMotionListeners = new Vector(1);
            }
            if (!this.m_IDLMouseMotionListeners.contains(listener)) {
                this.m_IDLMouseMotionListeners.add(listener);
            }
        }
    }

    public void removeIDLMouseMotionListener(JIDLMouseMotionListener listener) {
        if (this.m_IDLMouseMotionListeners != null && listener != null) {
            this.m_IDLMouseMotionListeners.remove(listener);
        }
    }

    @Override
    public void IDLmouseDragged(JIDLObjectI obj, MouseEvent e) {
        this.postIDLEvent(e, null);
    }

    @Override
    public void IDLmouseMoved(JIDLObjectI obj, MouseEvent e) {
        this.postIDLEvent(e, null);
    }

    @Override
    public void addIDLOutputListener(JIDLOutputListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.addIDLOutputListener(listener);
        }
    }

    @Override
    public void removeIDLOutputListener(JIDLOutputListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.removeIDLOutputListener(listener);
        }
    }

    @Override
    public void addIDLNotifyListener(JIDLNotifyListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.addIDLNotifyListener(listener);
        }
    }

    @Override
    public void removeIDLNotifyListener(JIDLNotifyListener listener) {
        if (this.m_interface != null && listener != null) {
            this.m_interface.removeIDLNotifyListener(listener);
        }
    }

    @Override
    public int mapIDLCursorToJavaCursor(String idlCursor) {
        if (idlCursor.equals("ARROW") || idlCursor.equals("UP_ARROW")) {
            return 0;
        }
        if (idlCursor.equals("IBEAM") || idlCursor.equals("ICON")) {
            return 2;
        }
        if (idlCursor.equals("CROSSHAIR") || idlCursor.equals("ORIGINAL")) {
            return 1;
        }
        if (idlCursor.equals("HOURGLASS")) {
            return 3;
        }
        if (idlCursor.equals("MOVE")) {
            return 13;
        }
        if (idlCursor.equals("SIZE_NW")) {
            return 6;
        }
        if (idlCursor.equals("SIZE_SE")) {
            return 5;
        }
        if (idlCursor.equals("SIZE_NE")) {
            return 7;
        }
        if (idlCursor.equals("SIZE_SW")) {
            return 4;
        }
        if (idlCursor.equals("SIZE_EW")) {
            return 11;
        }
        if (idlCursor.equals("SIZE_NS")) {
            return 8;
        }
        return 0;
    }

    @Override
    public void setCursor(String idlCursor) {
        int cursor = this.mapIDLCursorToJavaCursor(idlCursor);
        super.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    @Override
    public String toString() {
        if (this.isObjectCreated()) {
            return this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", process=" + this.getProcessName() + ", HWND=" + this.m_hwnd + "]";
        }
        return this.getClass().getName() + "[class=" + this.m_sClass + ", cookie=" + this.getCookie() + ", Object not created.]";
    }
}

