pro get_xye,x=x,y=y,dy=dy
    n = 1e8                        ;# of scattered points
    seed = -121147L                ;For consistency
    x = RANDOMU(seed, n);,/double)
    y = sin(x*360*!dtor)
    dy = 0.02*y
end

pro get_xye1,x=x,y=y,dy=dy
    n = 1e8                        ;# of scattered points
    seed = -121147L                ;For consistency
    x = RANDOMU(seed, n);,/double)
    y = sin(x*360*!dtor)
    dy = 0.1*y
    x = fix(x*100)*0.35 
end

pro test_dm_step_bin,obj=obj,extlib=extlib
    if (n_elements(extlib) eq 0) then extlib=0
    current = systime(/sec)
    get_xye,x=x,y=y,dy=dy
    print,'get data in ',systime(/sec)-current, ' secs'
    help,x,y,dy
    dm_step_bin,0.01,x,ydat=y,yerr=dy, extlib=extlib,avgsum=0,/debug;,/const,uniq_v = indgen(100)*0.35
    
    if obj_valid(obj) then obj->add_plot,x,y,yerr=dy,color='red',psym='circle',linestyle='no line' $
    else obj = obj_new('dm_plot',x,y,yerr=dy,color='green',psym='filled circle',linestyle='no line') 
    obj->draw
;    print,y & help,y
;    print,dy & help,dy
end

;extlib = 0 , old
;step_bin finished in        141.49200 secs.
;      0.00000000      0.34999999      0.69999999       1.0500000       1.4000000       1.7500000       2.0999999       2.4500000       2.8000000       3.1499999
;X               DOUBLE    = Array[10]
;      0.30394656      0.79569937      0.98362953      0.79578290      0.30393205     -0.30394849     -0.79573922     -0.98363061     -0.79577242     -0.30389862
;Y               DOUBLE    = Array[10]
;  2.2050736e-006  5.0777563e-006  6.2202605e-006  5.0765877e-006  2.2056492e-006  2.2050329e-006  5.0780645e-006  6.2231541e-006  5.0770852e-006  2.2049774e-006
;DY              DOUBLE    = Array[10]

;extlib = 0, new
;step_bin finished in        6.3020000 secs.
;     0.000000     0.350000     0.700000      1.05000      1.40000      1.75000      2.10000      2.45000      2.80000      3.15000
;X               FLOAT     = Array[10]
;      0.30394655      0.79569936      0.98362952      0.79578292      0.30393204     -0.30394849     -0.79573917     -0.98363060     -0.79577237     -0.30389863
;Y               DOUBLE    = Array[10]
;  2.2050738e-006  5.0777562e-006  6.2202603e-006  5.0765880e-006  2.2056493e-006  2.2050328e-006  5.0780645e-006  6.2231538e-006  5.0770855e-006  2.2049774e-006
;DY              DOUBLE    = Array[10]

