; Copyright (c)  NV5 Geospatial Solutions, Inc. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;+
; CLASS_NAME:
;    ASDF_File
;
; PURPOSE:
;    The ASDF_File class is used to create an ASDF file object
;    consisting of an ASDF header.
;
; CATEGORY:
;    Datatypes
;
;-
;---------------------------------------------------------------------------
function ASDF_File::Init, k1, v1, k2, v2, k3, v3, k4, v4, $
  k5, v5, k6, v6, k7, v7, k8, v8, SKIP_HEADER=skipHeader
  compile_opt idl2, hidden

  !null = self.YAML_Stream_Map::Init()
  if (~keyword_set(skipHeader)) then begin
    yaml = $
`#ASDF 1.0.0
#ASDF_STANDARD 1.5.0
%YAML 1.1
%TAG ! tag:stsci.edu:asdf/
--- !core/asdf-1.1.0
asdf_library: !core/software-1.0.0 {author: The ASDF Developers, homepage: 'http://github.com/asdf-format/asdf',
  name: asdf, version: 2.14.3}
history:
  extensions:
  - !core/extension_metadata-1.0.0
    extension_class: asdf.extension.BuiltinExtension
    software: !core/software-1.0.0 {name: IDL, version: ${!version.release}}`
    header = YAML_Parse(yaml)
    self.SetProperty, comments=header.comments, $
      global_tags=header.global_tags, tag=header.tag
    ; ASDF outputs these software tags in "flow" { } format.
    (header['asdf_library']).style = 'flow'
    (header['history', 'extensions', 0, 'software']).style = 'flow'
    foreach tag, header, key do begin
      self[key] = tag
    endforeach
  endif

  if (isa(k1)) then self.Set, k1, v1
  if (isa(k2)) then self.Set, k2, v2
  if (isa(k3)) then self.Set, k3, v3
  if (isa(k4)) then self.Set, k4, v4
  if (isa(k5)) then self.Set, k5, v5
  if (isa(k6)) then self.Set, k6, v6
  if (isa(k7)) then self.Set, k7, v7
  if (isa(k8)) then self.Set, k8, v8
  return, 1
end

;----------------------------------------------------------------------------
; Walk through the input data and convert any IDL arrays (2+ elements)
; to ASDF_NDArrays.
;
pro ASDF_File::ConvertArrays, value
  compile_opt idl2, hidden

  if (isa(value, 'ASDF_NDArray')) then return

  if (isa(value, 'list') || isa(value, 'hash')) then begin
    foreach item, value, key do begin
      if (isa(item, /number) && item.length gt 1) then begin
        value[key] = ASDF_NDArray(item)
      endif else begin
        self.ConvertArrays, item
      endelse
    endforeach
  endif else if (isa(value, /number) && value.length gt 1) then begin
    value = ASDF_NDArray(value)
  endif
end

;---------------------------------------------------------------------------
pro ASDF_File::Set, key, valueIn
  compile_opt idl2, hidden

  if (~isa(valueIn) && ~isa(valueIn, /null)) then return

  value = valueIn
  if (~isa(valueIn, 'ASDF_NDArray')) then begin
    self.ConvertArrays, value
  endif
  self.YAML_Stream_Map::Set, key, value
end

;---------------------------------------------------------------------------
pro ASDF_File__DEFINE
  compile_opt idl2, hidden
  void = {ASDF_File, $
    inherits YAML_Stream_Map}
end
