/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class RSIImageArea
extends JComponent {
    protected BufferedImage m_img;

    public RSIImageArea(String imgFile, Dimension dim) {
        this.loadImage(imgFile);
        this.setPreferredSize(dim);
        this.setSize(dim);
    }

    public BufferedImage getImageObj() {
        return this.m_img;
    }

    @Override
    public int getHeight() {
        return this.m_img.getHeight();
    }

    @Override
    public int getWidth() {
        return this.m_img.getWidth();
    }

    @Override
    public void paint(Graphics g) {
        Rectangle rect = this.getBounds();
        if (this.m_img != null) {
            g.drawImage(this.m_img, 0, 0, rect.width, rect.height, this);
        }
    }

    protected void loadImage(String sFilename) {
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(new File(sFilename));
        }
        catch (Exception e) {
            bi = null;
        }
        if (bi == null) {
            System.err.println("Error: File " + sFilename + " could not be loaded");
        }
        this.m_img = bi;
    }
}

