/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class GreyBandsImage
extends BufferedImage {
    private int m_height;
    private int m_width;

    public GreyBandsImage() {
        super(100, 100, 2);
        this.generateImage();
        this.m_height = 100;
        this.m_width = 100;
    }

    private void generateImage() {
        int width = this.getWidth();
        int height = this.getHeight();
        WritableRaster raster = this.getRaster();
        ColorModel model = this.getColorModel();
        int BAND_PIXEL_WIDTH = 5;
        int nBands = width / BAND_PIXEL_WIDTH;
        int greyDelta = 255 / nBands;
        for (int i = 0; i < nBands; ++i) {
            Color c = new Color(i * greyDelta, i * greyDelta, i * greyDelta);
            int argb = c.getRGB();
            Object colorData = model.getDataElements(argb, null);
            for (int j = 0; j < height; ++j) {
                for (int k = 0; k < BAND_PIXEL_WIDTH; ++k) {
                    raster.setDataElements(j, i * 5 + k, colorData);
                }
            }
        }
    }

    public int[] getRawData() {
        WritableRaster oRaster = this.getRaster();
        Rectangle oBounds = oRaster.getBounds();
        int[] data = new int[this.m_height * this.m_width * 4];
        data = oRaster.getPixels(0, 0, 100, 100, data);
        return data;
    }

    public int getH() {
        return this.m_height;
    }

    public int getW() {
        return this.m_width;
    }
}

