/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.javab;

import com.rsi.javab.ClassUtil;
import com.rsi.javab.ReflPromotion;
import com.rsi.javab.ReflUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TreeSet;
import java.util.Vector;

public class ReflObject {
    public static final int CHECK_NOSUPERCLASSES = 0;
    public static final int CHECK_SUPERCLASSES = 1;
    public static final int METHODNAME_MATCH_LOOSE = 0;
    public static final int METHODNAME_MATCH_EXACTCASE = 2;
    public static final int DATA_PROMOTION_MATCH = 4;
    public static final int DATA_NOPROMOTION_MATCH = 0;
    public static final int RETURNTYPE_CHECK = 0;
    public static final int RETURNTYPE_NOCHECK = 8;
    public static final int JB_DNE = 0;
    public static final int JB_EXISTS = 1;
    public static final int JB_DYNAMIC_MEMBER = 1;
    public static final int JB_STATIC_MEMBER = 2;
    public static final int JB_PUBLIC_MEMBER = 1;
    public static final int JB_PROTECTED_MEMBER = 2;
    public static final int JB_PRIVATE_MEMBER = 3;
    public static Class clsObject;

    public static boolean checkReturnType(int iOpts) {
        return (iOpts & 8) != 8;
    }

    public static boolean isCheckSupers(int iOpts) {
        return (iOpts & 1) == 1;
    }

    public static boolean isLooseMatch(int iOpts) {
        return (iOpts & 2) != 2;
    }

    public static boolean isDataPromotionMatch(int iOpts) {
        return (iOpts & 4) == 4;
    }

    private static Method getMethodByNameAndSig(Class cl, String sMethod, String sSig, int iOpts) {
        Method mRetVal = null;
        String sExactMethod = null;
        sExactMethod = ReflObject.getMethodNameUniqueMatch(cl, sMethod, iOpts);
        if (sExactMethod == null) {
            return null;
        }
        Class[] classArr = ReflUtil.sigToClassArray(sSig);
        if (!ReflObject.isDataPromotionMatch(iOpts)) {
            Method m = ReflObject.getMatchingMethodExactSigAndReturnType(cl, sExactMethod, sSig);
            if (m != null) {
                mRetVal = m;
            }
        } else {
            int nParms = classArr == null ? 0 : classArr.length;
            Vector vMatches = ReflObject.getMatchingMethodsNParmsPromotable(cl, sExactMethod, nParms, sSig, iOpts);
            if (!vMatches.isEmpty()) {
                if (vMatches.size() == 1) {
                    Method m = (Method)vMatches.elementAt(0);
                    if (ReflPromotion.maySigBePromotedToMethod(sSig, m, iOpts)) {
                        mRetVal = m;
                    }
                } else {
                    Method m2;
                    for (Method m2 : vMatches) {
                        if (m2.getDeclaringClass() != cl || !ReflPromotion.doesMethodHaveExactSig(m2, sSig)) continue;
                        mRetVal = m2;
                        break;
                    }
                    if (mRetVal == null && (vMatches = ReflPromotion.eliminatePromotableMethods(vMatches)).size() == 1 && ReflPromotion.maySigBePromotedToMethod(sSig, m2 = (Method)vMatches.elementAt(0), iOpts)) {
                        mRetVal = m2;
                    }
                }
            }
        }
        return mRetVal;
    }

    private static Vector getMethodsByName(Class cl, int iOpts) {
        Vector<Method> setOfMethods = new Vector<Method>();
        Method[] aMethods = null;
        Class superclass = cl;
        while (superclass != null) {
            aMethods = superclass.getDeclaredMethods();
            for (int i = 0; i < aMethods.length; ++i) {
                int mods = aMethods[i].getModifiers();
                if (!Modifier.isPublic(mods)) continue;
                setOfMethods.add(aMethods[i]);
            }
            if (ReflObject.isCheckSupers(iOpts)) {
                Class tmpSuperClass;
                superclass = tmpSuperClass = superclass.getSuperclass();
                continue;
            }
            superclass = null;
        }
        return setOfMethods;
    }

    private static Vector getMethodsByName(String sClass, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getMethodsByName(cl, iOpts);
    }

    private static Class getMethodRTByNameAndSig(String sClass, String sMethod, String sSig, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getMethodRTByNameAndSig(cl, sMethod, sSig, iOpts);
    }

    private static Class getMethodRTByNameAndSig(Class cl, String sMethod, String sSig, int iOpts) {
        Class<?> clMatch = null;
        String sExactMatch = ReflObject.getMethodNameUniqueMatch(cl, sMethod, iOpts);
        if (sExactMatch == null) {
            return null;
        }
        try {
            Method[] aJavaMethods = cl.getMethods();
            if (aJavaMethods == null) {
                return null;
            }
            Class[] classArray = ReflUtil.sigToClassArray(sSig);
            int match = -1;
            for (int i = 0; i < aJavaMethods.length; ++i) {
                if (!sExactMatch.equals(aJavaMethods[i].getName())) continue;
                Class<?>[] acJavaTypes = aJavaMethods[i].getParameterTypes();
                if (classArray == null) {
                    if (acJavaTypes.length != 0) continue;
                    match = i;
                    break;
                }
                if (classArray.length != acJavaTypes.length) continue;
                int j = 0;
                for (j = 0; j < acJavaTypes.length && !(ReflObject.isDataPromotionMatch(iOpts) ? !ReflPromotion.mayClassBePromoted(classArray[j], acJavaTypes[j]) : !acJavaTypes[j].toString().equals(classArray[j].toString())); ++j) {
                }
                if (j != acJavaTypes.length) continue;
                match = i;
                break;
            }
            if (match >= 0) {
                clMatch = aJavaMethods[match].getReturnType();
            }
        }
        catch (Throwable e) {
            System.out.println("ERR getMethodRTByNameAndSig exc:" + e.toString());
            return null;
        }
        return clMatch;
    }

    private static Vector getMatchingMethods(Class cl, String sMethod, int iOpts) {
        boolean iMatches = false;
        Vector<Method> matches = new Vector<Method>();
        Vector setOfMethods = ReflObject.getMethodsByName(cl, iOpts);
        for (Object obj : setOfMethods) {
            Method m = (Method)obj;
            if (!sMethod.equals(m.getName())) continue;
            matches.add(m);
        }
        return matches;
    }

    private static Vector getMatchingMethodsNParms(Class cl, String sMethod, int nParms, int iOpts) {
        int max;
        Method obj = null;
        Vector matches = ReflObject.getMatchingMethods(cl, sMethod, iOpts);
        for (int i = max = matches.size() - 1; i >= 0; --i) {
            obj = (Method)matches.elementAt(i);
            int n = obj.getParameterTypes().length;
            if (nParms == n) continue;
            matches.remove(i);
        }
        return matches;
    }

    private static Vector getMatchingMethodsNParmsPromotable(Class cl, String sMethod, int nParms, String sSig, int iOpts) {
        int max;
        Method obj = null;
        Vector matches = ReflObject.getMatchingMethodsNParms(cl, sMethod, nParms, iOpts);
        for (int i = max = matches.size() - 1; i >= 0; --i) {
            obj = (Method)matches.elementAt(i);
            int n = obj.getParameterTypes().length;
            if (ReflPromotion.maySigBePromotedToMethod(sSig, obj, iOpts)) continue;
            matches.remove(i);
        }
        return matches;
    }

    private static Method getMatchingMethodExactSigAndReturnType(Class cl, String sExactMethod, String sSig) {
        Method m = null;
        Class[] classArr = ReflUtil.sigToClassArray(sSig);
        try {
            m = cl.getMethod(sExactMethod, classArr);
            if (m != null) {
                Class retClass = ReflUtil.sigToReturnType(sSig);
                if (m.getReturnType() != retClass) {
                    m = null;
                }
            }
        }
        catch (NoSuchMethodException retClass) {
        }
        catch (SecurityException e) {
            System.out.println("ERR getMatchingMethodExactSigAndReturnType exc:" + e.toString());
        }
        catch (Throwable e) {
            System.out.println("ERR getMatchingMethodExactSigAndReturnType exc:" + e.toString());
        }
        return m;
    }

    private static String getSignatureByNameAndSig(Class cl, String sMethod, String sSig, int iOpts) {
        String sRetVal = null;
        Method m = ReflObject.getMethodByNameAndSig(cl, sMethod, sSig, iOpts);
        if (m != null) {
            sRetVal = ReflUtil.methodToJNISig(m);
        }
        return sRetVal;
    }

    public static int doesClassExist(String sClass) {
        Class cl = null;
        cl = ClassUtil.findClass(sClass);
        if (cl != null) {
            int mods = cl.getModifiers();
            if (Modifier.isPublic(mods)) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public static String getMethodNameUniqueMatch(String sClass, String sIDLMethod, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getMethodNameUniqueMatch(cl, sIDLMethod, iOpts);
    }

    public static String getMethodNameUniqueMatch(Class cl, String sMethod, int iOpts) {
        String sMethodMatch = null;
        int iMatches = 0;
        TreeSet setOfMethods = ReflObject.getMethodNamesByName(cl, iOpts);
        for (String obj : setOfMethods) {
            if (!ReflObject.isLooseMatch(iOpts)) {
                if (!sMethod.equals(obj)) continue;
                iMatches = 1;
                sMethodMatch = obj;
                break;
            }
            if (sMethod.equals(obj)) {
                sMethodMatch = obj;
                iMatches = 1;
                break;
            }
            if (sMethod.compareToIgnoreCase(obj) != 0) continue;
            sMethodMatch = obj;
            ++iMatches;
        }
        if (iMatches != 1) {
            sMethodMatch = null;
        }
        return sMethodMatch;
    }

    public static int doesClassHaveMethod(Class cl, String sMethod, int iOpts) {
        String obj = ReflObject.getMethodNameUniqueMatch(cl, sMethod, iOpts);
        return obj != null ? 1 : 0;
    }

    public static int doesClassHaveMethod(String sClass, String sMethod, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return 0;
        }
        return ReflObject.doesClassHaveMethod(cl, sMethod, iOpts);
    }

    public static int doesClassHaveMethodAndSig(Class cl, String sMethod, String sSig, int iOpts) {
        Method m = ReflObject.getMethodByNameAndSig(cl, sMethod, sSig, iOpts);
        if (m != null) {
            return Modifier.isStatic(m.getModifiers()) ? 2 : 1;
        }
        return 0;
    }

    public static TreeSet getMethodNamesByName(Class cl, int iOpts) {
        TreeSet<String> setOfMethods = new TreeSet<String>();
        Method[] aMethods = null;
        Class superclass = cl;
        while (superclass != null) {
            aMethods = superclass.getDeclaredMethods();
            for (int i = 0; i < aMethods.length; ++i) {
                int mods = aMethods[i].getModifiers();
                if (!Modifier.isPublic(mods)) continue;
                setOfMethods.add(aMethods[i].getName());
            }
            if (ReflObject.isCheckSupers(iOpts)) {
                Class tmpSuperClass;
                superclass = tmpSuperClass = superclass.getSuperclass();
                continue;
            }
            superclass = null;
        }
        return setOfMethods;
    }

    public static TreeSet getMethodNamesByName(String sClass, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getMethodNamesByName(cl, iOpts);
    }

    public static String getMethodRTNameByNameAndSig(Class cl, String sMethod, String sSig, int iOpts) {
        Class clMatch = null;
        String sMatch = "";
        clMatch = ReflObject.getMethodRTByNameAndSig(cl, sMethod, sSig, iOpts);
        if (clMatch != null) {
            sMatch = clMatch.getName();
        }
        return ReflUtil.convertClassToString(clMatch);
    }

    public static String getMethodRTNameByNameAndSig(String sClass, String sMethod, String sSig, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getMethodRTNameByNameAndSig(cl, sMethod, sSig, iOpts);
    }

    public static int doesClassHaveMethodAndSig(String sClassName, String sMethod, String sSig, int iOpts) {
        int retVal = 0;
        Class cl = ClassUtil.findClass(sClassName);
        if (cl == null) {
            return 0;
        }
        retVal = ReflObject.doesClassHaveMethodAndSig(cl, sMethod, sSig, iOpts);
        return retVal;
    }

    private static TreeSet getFieldNamesByName(Class cl, int iOpts) {
        TreeSet<String> setOfFields = new TreeSet<String>();
        Field[] aFields = null;
        Class superclass = cl;
        while (superclass != null) {
            aFields = superclass.getDeclaredFields();
            for (int i = 0; i < aFields.length; ++i) {
                int mods = aFields[i].getModifiers();
                if (!Modifier.isPublic(mods)) continue;
                setOfFields.add(aFields[i].getName());
            }
            if (ReflObject.isCheckSupers(iOpts)) {
                Class tmpSuperClass;
                superclass = tmpSuperClass = superclass.getSuperclass();
                continue;
            }
            superclass = null;
        }
        return setOfFields;
    }

    private static TreeSet getFieldNamesByName(String sClass, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getFieldNamesByName(cl, iOpts);
    }

    private static Vector getFieldsByName(Class cl, int iOpts) {
        Vector<Field> setOfFields = new Vector<Field>();
        Field[] aFields = null;
        Class superclass = cl;
        while (superclass != null) {
            aFields = superclass.getDeclaredFields();
            for (int i = 0; i < aFields.length; ++i) {
                int mods = aFields[i].getModifiers();
                if (!Modifier.isPublic(mods)) continue;
                setOfFields.add(aFields[i]);
            }
            if (ReflObject.isCheckSupers(iOpts)) {
                Class tmpSuperClass;
                superclass = tmpSuperClass = superclass.getSuperclass();
                continue;
            }
            superclass = null;
        }
        return setOfFields;
    }

    private static Vector getFieldsByName(String sClass, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getFieldsByName(cl, iOpts);
    }

    private static Vector getMatchingFields(Class cl, String sField, int iOpts) {
        boolean iMatches = false;
        Vector<Field> matches = new Vector<Field>();
        Vector setOfFields = ReflObject.getFieldsByName(cl, iOpts);
        for (Object obj : setOfFields) {
            Field f = (Field)obj;
            if (!sField.equals(f.getName())) continue;
            matches.add(f);
        }
        return matches;
    }

    private static Field getMatchingFieldExactType(Class cl, String sExactField, String sType) {
        Field f = null;
        try {
            Class<?> clType;
            String s;
            f = cl.getField(sExactField);
            if (f != null && !(s = ReflUtil.convertClassToString(clType = f.getType())).equals(sType)) {
                f = null;
            }
        }
        catch (NoSuchFieldException clType) {
        }
        catch (SecurityException e) {
            System.out.println("ERR getMatchingFieldExactType exc:" + e.toString());
        }
        catch (Throwable e) {
            System.out.println("ERR getMatchingFieldExactType exc:" + e.toString());
        }
        return f;
    }

    public static String getTypeByFieldNameAndType(Class cl, String sField, String sType, int iOpts) {
        String sRetVal = null;
        Field f = ReflObject.getFieldByNameAndType(cl, sField, sType, iOpts);
        if (f != null) {
            sRetVal = ReflUtil.fieldToJNIType(f);
        }
        return sRetVal;
    }

    public static String getTypeByFieldName(Class cl, String sField, int iOpts) {
        String sRetVal = null;
        Field f = ReflObject.getFieldUniqueMatch(cl, sField, iOpts);
        if (f != null) {
            sRetVal = ReflUtil.fieldToJNIType(f);
        }
        return sRetVal;
    }

    public static String getFieldNameUniqueMatch(String sClass, String sIDLField, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getFieldNameUniqueMatch(cl, sIDLField, iOpts);
    }

    public static String getFieldNameUniqueMatch(Class cl, String sField, int iOpts) {
        String sFieldMatch = null;
        int iMatches = 0;
        TreeSet setOfFields = ReflObject.getFieldNamesByName(cl, iOpts);
        for (String obj : setOfFields) {
            if (!ReflObject.isLooseMatch(iOpts)) {
                if (!sField.equals(obj)) continue;
                iMatches = 1;
                sFieldMatch = obj;
                break;
            }
            if (sField.equals(obj)) {
                sFieldMatch = obj;
                iMatches = 1;
                break;
            }
            if (sField.compareToIgnoreCase(obj) != 0) continue;
            sFieldMatch = obj;
            ++iMatches;
        }
        if (iMatches != 1) {
            sFieldMatch = null;
        }
        return sFieldMatch;
    }

    public static Field getFieldUniqueMatch(String sClass, String sIDLField, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getFieldUniqueMatch(cl, sIDLField, iOpts);
    }

    public static Field getFieldUniqueMatch(Class cl, String sField, int iOpts) {
        Field fieldMatch = null;
        int iMatches = 0;
        Vector setOfFields = ReflObject.getFieldsByName(cl, iOpts);
        for (Field fObj : setOfFields) {
            String strObj = fObj.getName();
            if (!ReflObject.isLooseMatch(iOpts)) {
                if (!sField.equals(strObj)) continue;
                iMatches = 1;
                fieldMatch = fObj;
                break;
            }
            if (sField.equals(strObj)) {
                fieldMatch = fObj;
                iMatches = 1;
                break;
            }
            if (sField.compareToIgnoreCase(strObj) != 0) continue;
            fieldMatch = fObj;
            ++iMatches;
        }
        if (iMatches != 1) {
            fieldMatch = null;
        }
        return fieldMatch;
    }

    public static int doesClassHaveField(Class cl, String sField, int iOpts) {
        String obj = ReflObject.getFieldNameUniqueMatch(cl, sField, iOpts);
        return obj != null ? 1 : 0;
    }

    public static int doesClassHaveFieldWithType(Class cl, String sField, String sType, int iOpts) {
        Field f = ReflObject.getFieldByNameAndType(cl, sField, sType, iOpts);
        if (f != null) {
            return Modifier.isStatic(f.getModifiers()) ? 2 : 1;
        }
        return 0;
    }

    public static int doesClassHaveFieldWithType(String sClassName, String sField, String sType, int iOpts) {
        int retVal = 0;
        Class cl = ClassUtil.findClass(sClassName);
        if (cl == null) {
            return 0;
        }
        retVal = ReflObject.doesClassHaveFieldWithType(cl, sField, sType, iOpts);
        return retVal;
    }

    public static Field getFieldByNameAndType(String sClass, String sField, String sType, int iOpts) {
        Class cl = ClassUtil.findClass(sClass);
        if (cl == null) {
            return null;
        }
        return ReflObject.getFieldByNameAndType(cl, sField, sType, iOpts);
    }

    public static Field getFieldByNameAndType(Class cl, String sField, String sType, int iOpts) {
        Field fRetVal;
        block3: {
            Vector vMatches;
            block4: {
                String sExactField;
                block2: {
                    fRetVal = null;
                    sExactField = null;
                    sExactField = ReflObject.getFieldNameUniqueMatch(cl, sField, iOpts);
                    if (sExactField == null) {
                        return null;
                    }
                    if (ReflObject.isDataPromotionMatch(iOpts)) break block2;
                    Field f = ReflObject.getMatchingFieldExactType(cl, sExactField, sType);
                    if (f == null) break block3;
                    fRetVal = f;
                    break block3;
                }
                vMatches = ReflObject.getMatchingFields(cl, sExactField, iOpts);
                if (vMatches.isEmpty()) break block3;
                if (vMatches.size() != 1) break block4;
                Field f = (Field)vMatches.elementAt(0);
                if (!ReflPromotion.mayTypeBePromotedToField(sType, f, iOpts)) break block3;
                fRetVal = f;
                break block3;
            }
            for (Field f : vMatches) {
                if (f.getDeclaringClass() != cl || !ReflPromotion.mayTypeBePromotedToField(sType, f, iOpts)) continue;
                fRetVal = f;
                break;
            }
        }
        return fRetVal;
    }

    public static int isObjectAnArray(Object obj) {
        Class<?> objClazz = null;
        int iRetVal = 0;
        objClazz = obj.getClass();
        if (objClazz != null && objClazz.isArray()) {
            iRetVal = 1;
        }
        return iRetVal;
    }

    public static String isObjectPrimitiveArray(Object obj) {
        Class<?> objClazz = null;
        Class<?> compClazz = null;
        Object sRetVal = null;
        objClazz = obj.getClass();
        if (objClazz != null && objClazz.isArray()) {
            compClazz = objClazz.getComponentType();
            if (compClazz.isPrimitive()) {
                sRetVal = objClazz.getName();
            } else if (compClazz.isArray() || compClazz.isAssignableFrom(clsObject)) {
                Object[] objArr = (Object[])obj;
                for (int i = 0; i < objArr.length; ++i) {
                    if (objArr[i] == null) continue;
                    sRetVal = ReflObject.isObjectPrimitiveArray(objArr[i]);
                    break;
                }
                if (sRetVal != null) {
                    sRetVal = "[" + (String)sRetVal;
                }
            }
        }
        return sRetVal;
    }

    public static int getObjectArrayDepth(Object obj) {
        Class<?> objClazz = null;
        Class<?> compClazz = null;
        int iDepth = 0;
        objClazz = obj.getClass();
        if (objClazz != null && objClazz.isArray()) {
            compClazz = objClazz.getComponentType();
            if (compClazz.isArray() || compClazz.isAssignableFrom(clsObject)) {
                Object[] objArr = (Object[])obj;
                for (int i = 0; i < objArr.length; ++i) {
                    if (objArr[i] == null) continue;
                    iDepth = ReflObject.getObjectArrayDepth(objArr[i]);
                    break;
                }
                ++iDepth;
            } else {
                iDepth = 1;
            }
        }
        return iDepth;
    }

    static {
        try {
            clsObject = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException e) {
            clsObject = null;
        }
    }
}

