/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.JIDLCanvas;
import com.idl.javaidl.JIDLCursorSupport;
import com.idl.javaidl.JIDLEventExtra;
import com.idl.javaidl.JIDLException;
import com.idl.javaidl.JIDLLong;
import com.idl.javaidl.JIDLNotifyListener;
import com.idl.javaidl.JIDLObjectI;
import com.idl.javaidl.JIDLOutputListener;
import com.idl.javaidl.JIDLPlatform;
import com.idl.javaidl.JIDLProcessInitializer;
import com.idl.javaidl.JIDLProcessLock;
import com.idl.javaidl.JIDLReturnObject;
import com.idl.javaidl.JIDLShutdownThread;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class JIDLPAL {
    private static final String BML_LIB_NAME = "idl_bml";
    private static final String AWT_LIB_NAME = "awt";
    private static final String JAWT_LIB_NAME = "jawt";
    private static final String JAVA_EXPORT_LIB_NAME = "javaidlb";
    private static String g_JavaBinLocation;
    private static String g_JavapalBinLocation;
    private static String g_BMLBinLocation;
    private long m_cookie;
    private JIDLObjectI m_object;
    private boolean m_bInBMLTransaction;
    private boolean m_bObjCreated;
    private int m_iOPSFlags;
    private String m_sProcessName;
    private JIDLProcessLock m_lock;
    private String m_sClassName;
    private String m_sLastError;
    private Vector m_IDLNotifyListeners;
    private static Hashtable g_cookieToPALMapping;
    private Vector m_IDLOutputListeners;
    private static boolean g_bIsListeningToIDL;
    private static int g_debugLevel;
    public static final int JAVAPAL_ERRCODE = -999;
    protected static final int AWTEVENT_RESIZED = 101;
    protected static final int AWTEVENT_SHIFT_MASK = 1;
    protected static final int AWTEVENT_CTRL_MASK = 2;
    protected static final int AWTEVENT_META_MASK = 4;
    protected static final int AWTEVENT_ALT_MASK = 8;
    protected static final int AWTEVENT_ALT_GRAPH_MASK = 32;
    protected static final int AWTEVENT_BUTTON1_MASK = 16;
    protected static final int AWTEVENT_BUTTON2_MASK = 8;
    protected static final int AWTEVENT_BUTTON3_MASK = 4;
    protected static final int AWTEVENT_MOUSE_CLICKED = 500;
    protected static final int AWTEVENT_MOUSE_DRAGGED = 506;
    protected static final int AWTEVENT_MOUSE_ENTERED = 504;
    protected static final int AWTEVENT_MOUSE_EXITED = 505;
    protected static final int AWTEVENT_MOUSE_MOVED = 503;
    protected static final int AWTEVENT_MOUSE_WHEEL_MOVED = 507;
    protected static final int AWTEVENT_MOUSE_PRESSED = 501;
    protected static final int AWTEVENT_MOUSE_RELEASED = 502;
    protected static final int AWTEVENT_KEY_RELEASED = 402;
    protected static final int AWTEVENT_KEY_PRESSED = 401;
    protected static final int AWTEVENT_VK_SHIFT = 16;
    protected static final int AWTEVENT_VK_CONTROL = 17;
    protected static final int AWTEVENT_VK_CAPS_LOCK = 20;
    protected static final int AWTEVENT_VK_META = 157;
    protected static final int AWTEVENT_VK_LEFT = 37;
    protected static final int AWTEVENT_VK_RIGHT = 39;
    protected static final int AWTEVENT_VK_UP = 38;
    protected static final int AWTEVENT_VK_DOWN = 40;
    protected static final int AWTEVENT_VK_PAGE_UP = 33;
    protected static final int AWTEVENT_VK_PAGE_DOWN = 34;
    protected static final int AWTEVENT_VK_HOME = 36;
    protected static final int AWTEVENT_VK_END = 35;
    protected static final int AWTEVENT_VK_DELETE = 127;
    protected static final int AWTEVENT_VK_ENTER = 10;
    public static final int GC_GLDEPTH = 1;
    public static final int GC_MESADEPTH = 2;
    public static final int GC_GLID = 3;
    public static final int GC_MESAID = 4;

    private static native void nativeInitJPAL();

    private static native void nativeShutdownJPAL();

    private static native boolean nativeIsRetValBad(long var0);

    public static native void dumpMemoryMap();

    private native void nativeThrowJIDLException(long var1, String var3, String var4);

    private native String nativeGetLastBMLError(JIDLLong var1);

    private native long nativeAbort(long var1);

    private native long nativeBMLBeginTransaction(long var1);

    private native void nativeBMLEndTransaction(long var1);

    private native long nativeRegisterWrapper(String var1, int var2, String var3);

    private native long nativeReleaseWrapper(long var1);

    private native long nativeCreateObject(long var1, int var3, Object[] var4, int[] var5, JIDLProcessInitializer var6, long var7, String var9);

    private native long nativeDestroyObject(long var1);

    private native long nativeCallProcedure(long var1, String var3, int var4, Object[] var5, int[] var6);

    private native JIDLReturnObject nativeCallFunction(long var1, String var3, int var4, Object[] var5, int[] var6, int var7);

    private native long nativeSetProperty(long var1, String var3, Object var4, int var5);

    private native JIDLReturnObject nativeGetProperty(long var1, String var3, int var4);

    private native long nativeOnEvent(long var1, ComponentEvent var3, JIDLEventExtra var4);

    private native long nativeOnExpose(long var1, JIDLCanvas var3);

    private static native int nativeGetDebugLevel();

    private static native void nativeRegisterOutputCallback();

    private native void nativeRegisterNotifyCallback(long var1);

    private native void nativeUnregisterNotifyCallback(long var1);

    public static void shutdownJPAL() {
        JIDLPAL.nativeShutdownJPAL();
    }

    public JIDLPAL(JIDLObjectI obj, String sProcess) {
        JIDLPAL.printDebug("   =JIDLPAL::JIDLPAL()");
        this.m_cookie = 0L;
        this.m_object = obj;
        this.m_bInBMLTransaction = false;
        this.m_bObjCreated = false;
        this.m_sLastError = null;
        this.m_IDLNotifyListeners = null;
        this.m_IDLOutputListeners = null;
        this.setProcessMembers(sProcess);
        this.m_lock = JIDLProcessLock.Instance(sProcess);
    }

    private void setProcessMembers(String sProcess) {
        if (!this.isObjectCreated()) {
            if (sProcess == null || sProcess.equals("")) {
                this.m_iOPSFlags = 0;
                this.m_sProcessName = "";
            } else {
                this.m_iOPSFlags = 1;
                this.m_sProcessName = sProcess;
            }
        }
    }

    public String getIDLObjectClassName() {
        return this.m_sClassName;
    }

    public synchronized String getProcessName() {
        return this.m_sProcessName;
    }

    public synchronized void setProcessName(String sProcess) {
        this.setProcessMembers(sProcess);
    }

    private boolean verifyOPSName(int iOPSFlags, String sProcessName) {
        boolean bOKName = true;
        if (iOPSFlags == 1) {
            if (sProcessName == null || sProcessName.equals("")) {
                bOKName = false;
            } else {
                for (int i = 0; i < sProcessName.length(); ++i) {
                    char c = sProcessName.charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
                    bOKName = false;
                    break;
                }
            }
        }
        return bOKName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String sClassName) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.createObject(sClassName, 0, null, null, null, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String sClassName, int argc, Object[] argv, int[] argpal, JIDLProcessInitializer initializer) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.createObject(sClassName, argc, argv, argpal, initializer, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String sClassName, int argc, Object[] argv, int[] argpal) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.createObject(sClassName, argc, argv, argpal, null, 0L, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createObject(String sClassName, int argc, Object[] argv, int[] argpal, JIDLProcessInitializer initializer, long lWindowID, String sKeywords) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long retVal = 0L;
            if (!this.verifyOPSName(this.m_iOPSFlags, this.m_sProcessName)) {
                this.setLastError("Invalid OPS server name");
                this.throwJIDLException(-999L, "createObject", false);
            }
            this.m_cookie = this.nativeRegisterWrapper(sClassName, this.m_iOPSFlags, this.m_sProcessName);
            if (JIDLPAL.nativeIsRetValBad(this.m_cookie)) {
                this.throwJIDLException(this.m_cookie, "RegisterWrapper", false);
            }
            JIDLPAL.addCookieToPALMapping(this.m_cookie, this);
            this.beginTransaction(this.m_cookie);
            retVal = this.nativeCreateObject(this.m_cookie, argc, argv, argpal, initializer, lWindowID, sKeywords);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                JIDLLong jErrObj = new JIDLLong(0L);
                String sErr = this.nativeGetLastBMLError(jErrObj);
                this.setLastError(sErr);
                JIDLPAL.removeCookieToPALMapping(this.m_cookie);
                this.nativeReleaseWrapper(this.m_cookie);
                this.throwJIDLException(retVal, "CreateObject", true);
            }
            this.endTransaction(this.m_cookie);
            this.m_sClassName = sClassName;
            this.m_bObjCreated = true;
        }
    }

    public synchronized boolean isObjectCreated() {
        return this.m_bObjCreated;
    }

    private void verifyObjectCreated() {
        if (!this.m_bObjCreated) {
            throw new JIDLException(-1L, "Object has not been created.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject() {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.verifyObjectCreated();
            long retVal = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::destroyObject()");
            JIDLPAL.removeCookieToPALMapping(this.m_cookie);
            this.beginTransaction(this.m_cookie);
            retVal = this.nativeDestroyObject(this.m_cookie);
            this.m_bObjCreated = false;
            long junk = this.nativeReleaseWrapper(this.m_cookie);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "DestroyObject", true);
            }
            if (JIDLPAL.nativeIsRetValBad(junk)) {
                this.throwJIDLException(junk, "ReleaseWrapper", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::destroyObject()");
        }
    }

    public synchronized long getCookie() {
        return this.m_cookie;
    }

    public synchronized JIDLObjectI getObject() {
        return this.m_object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callProcedure(String sMethodName) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.callProcedure(sMethodName, 0, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callProcedure(String sMethodName, int argc, Object[] argv, int[] argpal) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLPAL.printDebug("   >JIDLPAL::callProcedure(" + sMethodName + ")");
            this.verifyObjectCreated();
            this.printParams(argc, argv, argpal);
            this.beginTransaction(this.m_cookie);
            long retVal = this.nativeCallProcedure(this.m_cookie, sMethodName, argc, argv, argpal);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "CallProcedure", true);
            }
            this.printParams(argc, argv, argpal);
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::callProcedure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(String sMethodName) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.callFunction(sMethodName, 0, null, null, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(String sMethodName, int argc, Object[] argv, int[] argpal) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.callFunction(sMethodName, argc, argv, argpal, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object callFunction(String sMethodName, int argc, Object[] argv, int[] argpal, int iPalFlag) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLReturnObject oStatusObj = null;
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::callFunction(" + sMethodName + ")");
            this.printParams(argc, argv, argpal);
            this.beginTransaction(this.m_cookie);
            oStatusObj = this.nativeCallFunction(this.m_cookie, sMethodName, argc, argv, argpal, iPalFlag);
            this.printParams(argc, argv, argpal);
            long retVal = oStatusObj.getStatus();
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "CallFunction", true);
            }
            Object oResult = oStatusObj.getObject();
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::callFunction oResult=" + String.valueOf(oResult));
            return oResult;
        }
    }

    private native int nativeComputeGCData(String var1);

    public boolean computeGCData() {
        long retVal = this.nativeComputeGCData(this.m_sProcessName);
        return !JIDLPAL.nativeIsRetValBad(retVal);
    }

    private native long nativeGetGCData(long var1);

    public long getGCData(long ndx) {
        return this.nativeGetGCData(ndx);
    }

    private native int nativeAttachObject(long var1, long var3, String var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int attachObject(long hvid, String sName) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.nativeAttachObject(this.m_cookie, hvid, sName);
        }
    }

    public native long nativeObjRefCookie2HVID(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long objRefCookie2HVID(long objref) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.nativeObjRefCookie2HVID(this.m_cookie, objref);
        }
    }

    private boolean OKtoProcessEvent() {
        return this.isObjectCreated() && this.m_cookie > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long OnExpose(JIDLCanvas canvas) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long iReturn = -1L;
            if (this.OKtoProcessEvent()) {
                this.beginTransaction(this.m_cookie);
                iReturn = this.nativeOnExpose(this.m_cookie, canvas);
                this.endTransaction(this.m_cookie);
            }
            return iReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long OnEvent(ComponentEvent ev, JIDLEventExtra extra) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long iReturn = -1L;
            if (this.OKtoProcessEvent()) {
                this.beginTransaction(this.m_cookie);
                iReturn = this.nativeOnEvent(this.m_cookie, ev, extra);
                this.endTransaction(this.m_cookie);
            }
            return iReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String sProperty) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            return this.getProperty(sProperty, 16384);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String sProperty, int iPalFlag) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLReturnObject oStatusObj = null;
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::getProperty(" + sProperty + ")");
            this.beginTransaction(this.m_cookie);
            oStatusObj = this.nativeGetProperty(this.m_cookie, sProperty, iPalFlag);
            long retVal = oStatusObj.getStatus();
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "GetProperty", true);
            }
            Object oResult = oStatusObj.getObject();
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::getProperty()");
            return oResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String sProperty, Object obj, int iPalFlag) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            this.verifyObjectCreated();
            long retVal = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::setProperty(" + sProperty + ")");
            this.beginTransaction(this.m_cookie);
            retVal = this.nativeSetProperty(this.m_cookie, sProperty, obj, iPalFlag);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "SetProperty", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::callProperty");
        }
    }

    private native String nativeGetObjVariableName(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIDLObjectVariableName() {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            String sVariable = "";
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::getIDLObjectVariableName() cookie=" + this.m_cookie);
            this.beginTransaction(this.m_cookie);
            sVariable = this.nativeGetObjVariableName(this.m_cookie);
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::getIDLObjectVariableName() sVar=" + sVariable);
            return sVariable;
        }
    }

    private native JIDLReturnObject nativeGetIDLVariable(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getIDLVariable(String sVar) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            JIDLReturnObject oStatusObj = null;
            this.verifyObjectCreated();
            JIDLPAL.printDebug("   >JIDLPAL::getIDLVariable(" + sVar + ") cookie=" + this.m_cookie);
            this.beginTransaction(this.m_cookie);
            oStatusObj = this.nativeGetIDLVariable(this.m_cookie, sVar);
            long retVal = oStatusObj.getStatus();
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "GetIDLVariable", true);
            }
            Object oVariable = oStatusObj.getObject();
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::getIDLVariable() oVar=" + String.valueOf(oVariable));
            return oVariable;
        }
    }

    private native int nativeSetIDLVariable(long var1, String var3, Object var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIDLVariable(String sVar, Object obj) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long retVal = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::setIDLVariable(" + sVar + ") cookie=" + this.m_cookie);
            this.verifyObjectCreated();
            this.beginTransaction(this.m_cookie);
            retVal = this.nativeSetIDLVariable(this.m_cookie, sVar, obj);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "SetIDLVariable", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::setIDLVariable");
        }
    }

    private native int nativeExecuteString(long var1, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeString(String sCmd) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long retVal = 0L;
            JIDLPAL.printDebug("   >JIDLPAL::executeString(" + sCmd + ") cookie=" + this.m_cookie);
            this.verifyObjectCreated();
            this.beginTransaction(this.m_cookie);
            retVal = this.nativeExecuteString(this.m_cookie, sCmd);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "ExecuteString", true);
            }
            this.endTransaction(this.m_cookie);
            JIDLPAL.printDebug("   <JIDLPAL::executeString");
        }
    }

    public synchronized void addIDLOutputListener(JIDLOutputListener l) {
        if (l != null) {
            if (this.m_IDLOutputListeners == null) {
                this.m_IDLOutputListeners = new Vector(1);
            }
            if (!this.m_IDLOutputListeners.contains(l)) {
                this.m_IDLOutputListeners.add(l);
                if (!g_bIsListeningToIDL) {
                    JIDLPAL.nativeRegisterOutputCallback();
                    g_bIsListeningToIDL = true;
                }
            }
        }
    }

    public synchronized void removeIDLOutputListener(JIDLOutputListener l) {
        if (this.m_IDLOutputListeners != null && l != null) {
            this.m_IDLOutputListeners.remove(l);
        }
    }

    public void broadcastIDLOutput(String s1) {
        if (this.m_IDLOutputListeners != null && !this.m_IDLOutputListeners.isEmpty()) {
            for (int i = 0; i < this.m_IDLOutputListeners.size(); ++i) {
                JIDLOutputListener listener = (JIDLOutputListener)this.m_IDLOutputListeners.elementAt(i);
                listener.IDLoutput(this.m_object, s1);
            }
        }
    }

    protected static void routeIDLOutputToObject(long cookie, String s) {
        final JIDLPAL pal = JIDLPAL.getPALFromCookie(cookie);
        final String s2 = s;
        if (pal != null) {
            try {
                if (pal.canRouteInThisThread()) {
                    pal.broadcastIDLOutput(s2);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                pal.broadcastIDLOutput(s2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void broadcastCursorChange(String sCursor) {
        if (JIDLCursorSupport.class.isAssignableFrom(this.m_object.getClass())) {
            ((JIDLCursorSupport)((Object)this.m_object)).setCursor(sCursor);
        }
    }

    protected static void routeCursorChangeToObject(long cookie, String sCursor) {
        final JIDLPAL pal = JIDLPAL.getPALFromCookie(cookie);
        final String s2 = sCursor;
        if (pal != null) {
            try {
                if (pal.canRouteInThisThread()) {
                    pal.broadcastCursorChange(s2);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                pal.broadcastCursorChange(s2);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized void addIDLNotifyListener(JIDLNotifyListener l) {
        if (l != null) {
            if (this.m_IDLNotifyListeners == null) {
                this.m_IDLNotifyListeners = new Vector(1);
            }
            if (!this.m_IDLNotifyListeners.contains(l)) {
                this.m_IDLNotifyListeners.add(l);
                this.nativeRegisterNotifyCallback(this.m_cookie);
            }
        }
    }

    public synchronized void removeIDLNotifyListener(JIDLNotifyListener l) {
        if (this.m_IDLNotifyListeners != null && l != null) {
            this.m_IDLNotifyListeners.remove(l);
        }
        if (this.m_IDLNotifyListeners == null || this.m_IDLNotifyListeners.size() == 0) {
            this.nativeUnregisterNotifyCallback(this.m_cookie);
        }
    }

    private void broadcastNotify(String s1, String s2) {
        if (this.m_IDLNotifyListeners != null && !this.m_IDLNotifyListeners.isEmpty()) {
            JIDLNotifyListener listener = null;
            for (int i = 0; i < this.m_IDLNotifyListeners.size(); ++i) {
                listener = (JIDLNotifyListener)this.m_IDLNotifyListeners.elementAt(i);
                listener.OnIDLNotify(this.m_object, s1, s2);
            }
        }
    }

    protected static void routeNotifyToObject(long cookie, String s1, String s2) {
        final JIDLPAL pal = JIDLPAL.getPALFromCookie(cookie);
        final String s1_copy = s1;
        final String s2_copy = s2;
        if (pal != null) {
            try {
                if (pal.canRouteInThisThread()) {
                    pal.broadcastNotify(s1_copy, s2_copy);
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                pal.broadcastNotify(s1_copy, s2_copy);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void abort() {
        long retVal = 0L;
        this.verifyObjectCreated();
        retVal = this.nativeAbort(this.m_cookie);
        if (retVal == -2003L) {
            this.throwSpecificException(retVal, "Current object not allowed to abort another object's IDL activity.", false, "abort");
        } else if (retVal == -2004L) {
            this.throwSpecificException(retVal, "There is no IDL activity to abort.", false, "abort");
        }
        if (JIDLPAL.nativeIsRetValBad(retVal)) {
            this.throwJIDLException(retVal, "abort", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(long cookie) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            long retVal = 0L;
            retVal = this.nativeBMLBeginTransaction(cookie);
            if (JIDLPAL.nativeIsRetValBad(retVal)) {
                this.throwJIDLException(retVal, "beginTransaction", false);
            }
            this.m_bInBMLTransaction = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction(long cookie) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            if (this.m_bInBMLTransaction) {
                this.nativeBMLEndTransaction(cookie);
            }
            this.m_bInBMLTransaction = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwSpecificException(long errCode, String message, boolean bEndTransaction, String methodName) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            if (bEndTransaction) {
                this.endTransaction(this.m_cookie);
            }
            if (errCode == 0L && JIDLPAL.getTrackedObjectsCount() == 0) {
                System.err.println("Fatal error: The BML/IDL have failed initialization");
                System.err.println("Often this due to a library mismatch or missing library");
                System.err.println("Check for existence of and BML compatability with the following libraries:");
                System.err.println("  libidl.so (Unix)           / idl.dll (Windows)");
                System.err.println("  libidl_ops.so (Unix)       / idl_ops.dll (Windows)");
                System.err.println("  libidl_ipcclient.so (Unix) / idl_ipcclient.dll (Windows)");
            }
            this.nativeThrowJIDLException(errCode, message, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void throwJIDLException(long retVal, String methodName, boolean bEndTransaction) {
        JIDLProcessLock jIDLProcessLock = this.m_lock;
        synchronized (jIDLProcessLock) {
            String sErr = null;
            long errCode = 0L;
            sErr = this.getLastError();
            if (sErr != null) {
                errCode = -999L;
            } else {
                JIDLLong jErrObj = new JIDLLong(0L);
                sErr = this.nativeGetLastBMLError(jErrObj);
                errCode = jErrObj.longValue();
            }
            if (sErr == null) {
                errCode = -999L;
                sErr = "Unknown JavaPAL error occurred";
            }
            this.throwSpecificException(errCode, sErr, bEndTransaction, methodName);
        }
    }

    public static int getTrackedObjectsCount() {
        return g_cookieToPALMapping.size();
    }

    public static JIDLObjectI[] getAllTrackedObjects() {
        int len = g_cookieToPALMapping.size();
        if (len == 0) {
            return null;
        }
        JIDLObjectI[] objects = new JIDLObjectI[len];
        int i = 0;
        Enumeration e = g_cookieToPALMapping.elements();
        while (e.hasMoreElements()) {
            JIDLPAL pal = (JIDLPAL)e.nextElement();
            JIDLObjectI obj = pal.getObject();
            objects[i++] = obj;
        }
        return objects;
    }

    private static JIDLPAL getPALFromCookie(long cookie) {
        Object o = g_cookieToPALMapping.get(new Long(cookie));
        return (JIDLPAL)o;
    }

    private static void addCookieToPALMapping(long cookie, Object obj) {
        g_cookieToPALMapping.put(new Long(cookie), obj);
    }

    private static void removeCookieToPALMapping(long cookie) {
        if (g_cookieToPALMapping != null) {
            g_cookieToPALMapping.remove(new Long(cookie));
        }
    }

    protected static void setLastError(long cookie, String s1) {
        JIDLPAL pal = JIDLPAL.getPALFromCookie(cookie);
        if (pal != null) {
            pal.setLastError(s1);
        }
    }

    public synchronized void setLastError(String sErr) {
        this.m_sLastError = sErr;
    }

    public synchronized String getLastError() {
        String s = this.m_sLastError;
        this.m_sLastError = null;
        return s;
    }

    private boolean canRouteInThisThread() {
        boolean retVal = false;
        if (!this.m_object.isObjectDisplayable()) {
            retVal = true;
        } else if (EventQueue.isDispatchThread()) {
            retVal = true;
        }
        return retVal;
    }

    private static void printDebug(String sMsg) {
        if (g_debugLevel > 0) {
            System.out.println(sMsg);
        }
    }

    private void printParams(int argc, Object[] argv, int[] argpal) {
        JIDLPAL.printDebug("      argc=" + argc);
        if (argc > 0) {
            for (int i = 0; i < argc; ++i) {
                if (argv[i] != null) {
                    JIDLPAL.printDebug("      arg[" + i + "]:  hash:" + argv[i].hashCode() + " class:" + argv[i].getClass().toString() + " flags:0x0" + Integer.toHexString(argpal[i]));
                    continue;
                }
                JIDLPAL.printDebug("      arg[" + i + "]: null");
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[cookie=" + this.m_cookie + " bObjCreated=" + this.m_bObjCreated + "]";
    }

    static {
        g_debugLevel = 0;
        g_JavaBinLocation = JIDLPlatform.getJavaLibraryLocation();
        g_JavapalBinLocation = JIDLPlatform.getJavaPALLibraryLocation();
        g_BMLBinLocation = JIDLPlatform.getBMLLibraryLocation();
        if (!JIDLPlatform.isWindows() || JIDLPlatform.loadNeededLibrary(g_BMLBinLocation, BML_LIB_NAME) < 0) {
            // empty if block
        }
        if (JIDLPlatform.platformSupportsOutOfProcessGraphics()) {
            if (JIDLPlatform.loadNeededLibrary(g_JavaBinLocation, AWT_LIB_NAME) < 0) {
                // empty if block
            }
            if (JIDLPlatform.loadNeededLibrary(g_JavaBinLocation, JAWT_LIB_NAME) < 0) {
                // empty if block
            }
        }
        if (JIDLPlatform.loadNeededLibrary(g_JavapalBinLocation, JAVA_EXPORT_LIB_NAME) < 0) {
            // empty if block
        }
        JIDLPAL.nativeInitJPAL();
        g_debugLevel = JIDLPAL.nativeGetDebugLevel();
        g_cookieToPALMapping = new Hashtable();
        g_bIsListeningToIDL = false;
        Runtime.getRuntime().addShutdownHook(new JIDLShutdownThread());
    }
}

