/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map.layer;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.datasource.IFeatureDataSource;
import com.rsi.pdf.map.layer.AbstractLayer;
import com.rsi.pdf.map.layer.Feature;
import com.rsi.pdf.map.symbol.ISymbol;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;

public class FeatureLayer
extends AbstractLayer {
    private List<Feature> features = null;
    private int gStateCnt = 0;

    public FeatureLayer(PdfMap pdfMap, String name, float opacity, IFeatureDataSource featureSource) {
        super(pdfMap, name, opacity);
        if (featureSource == null || featureSource.getFeatures() == null) {
            throw new IllegalArgumentException("Argument(s) cannot be null");
        }
        this.features = featureSource.getFeatures();
    }

    @Override
    public void render(PDPageContentStream cStream) throws IOException {
        cStream.saveGraphicsState();
        float opaqueness = this.getOpacity();
        if (opaqueness < 1.0f) {
            String gStateName = "GraphicsState_" + this.getName() + this.gStateCnt;
            this.addGraphicsState(gStateName, opaqueness);
            cStream.appendRawCommands("/" + gStateName + " gs\n");
            ++this.gStateCnt;
        }
        for (int n = 0; n < this.features.size(); ++n) {
            Feature feature = this.features.get(n);
            Geometry geom = feature.getGeometry();
            ISymbol symbol = feature.getSymbol();
            Map<String, Object> attribs = feature.getAttributeMap();
            this.drawGeometry(geom, symbol, cStream);
        }
        cStream.restoreGraphicsState();
    }
}

