/*
 * Decompiled with CFR 0.152.
 */
package com.rsi.pdf.map;

import com.rsi.pdf.map.PdfMap;
import com.rsi.pdf.map.datasource.GeoJSONFeatureDataSource;
import com.rsi.pdf.map.datasource.RasterFileDataSource;
import com.rsi.pdf.map.layer.AbstractLayer;
import com.rsi.pdf.map.layer.FeatureLayer;
import com.rsi.pdf.map.layer.RasterLayer;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GeospatialPDF {
    private static final String OBJECT_TYPE = "type";
    private static final String LAYER = "layer";
    private static final String RASTER_LAYER = "Raster";
    private static final String FEATURE_LAYER = "Feature";
    private static final String ANNOTATION_LAYER = "Annotation";
    private static final String NAME = "name";
    private static final String OPACITY = "opacity";
    private static final String EXTENT = "extent";
    private static final String CLIP_EXTENT = "clipExtent";
    private static final String GEOG_EXTENT = "geogExtent";
    private static final String PROJ_EXTENT = "projExtent";
    private static final String DATA_PATH = "datapath";
    private static final String PDF_MAP = "pdfMap";
    private static final String EXPORT_FILE = "exportFile";
    private static final String COORDINATE_REFERENCE_SYSTEM = "coordinateReferenceSystem";
    private static final String PAGE_SIZE = "pageSize";
    private static final String HIDE_LAYER = "hide";
    private static final String DOCUMENT_INFO = "documentInfo";
    private static final String DOCUMENT_INFO_AUTHOR = "author";
    private static final String DOCUMENT_INFO_CREATOR = "creator";
    private static final String DOCUMENT_INFO_KEYWORDS = "keywords";
    private static final String DOCUMENT_INFO_SUBJECT = "subject";
    private static final String DOCUMENT_INFO_TITLE = "title";
    private static final String BACKGROUND_COLOR = "backgroundColor";
    private PdfMap pdfMap = null;
    private final String pdfProducer = "rsi";

    public GeospatialPDF(String jsonPdfMap) throws ParseException, IOException {
        this.pdfMap = this.parseJsonPdfMap(jsonPdfMap);
        this.pdfMap.setCreationDate(Calendar.getInstance());
        this.pdfMap.setModificationDate(Calendar.getInstance());
        this.pdfMap.setProducer(this.pdfProducer);
    }

    public void addLayer(String jsonLayer) throws ParseException, IOException, InstantiationException, IllegalAccessException {
        AbstractLayer layer = this.parseJsonLayer(jsonLayer, this.pdfMap);
        this.pdfMap.addLayer(layer);
    }

    public void setDocumentInfo(String jsonDocumentInformation) throws ParseException {
        this.parseJsonDocumentInfo(jsonDocumentInformation);
    }

    public void setBackgroundColor(String jsonBackgroundColor) throws ParseException {
        this.setBGColor(jsonBackgroundColor);
    }

    public void export(String jsonExportFile) throws ParseException, COSVisitorException, IOException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(jsonExportFile);
        JSONObject jsonObject = (JSONObject)obj;
        String exportPath = (String)jsonObject.get(EXPORT_FILE);
        this.pdfMap.generate(exportPath);
    }

    public String getPointSymbolNames() throws ClassNotFoundException, IOException {
        JSONArray jsonNames = new JSONArray();
        ArrayList<String> names = this.pdfMap.getPointShapeNames();
        for (int i = 0; i < names.size(); ++i) {
            jsonNames.add(names.get(i));
        }
        return jsonNames.toJSONString();
    }

    private AbstractLayer parseJsonLayer(String jsonLayer, PdfMap pdfMap) throws ParseException, IOException, InstantiationException, IllegalAccessException {
        AbstractLayer layer = null;
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(jsonLayer);
        JSONObject jsonObject = (JSONObject)obj;
        Map map = (Map)jsonObject.get(LAYER);
        String type = (String)map.get(OBJECT_TYPE);
        String name = (String)map.get(NAME);
        Number opacity = (Number)map.get(OPACITY);
        Boolean hidden = (Boolean)map.get(HIDE_LAYER);
        boolean visible = true;
        if (hidden != null && hidden.booleanValue()) {
            visible = false;
        }
        if (type.equals(RASTER_LAYER)) {
            Object objExtent = map.get(EXTENT);
            Envelope extent = null;
            if (objExtent instanceof JSONArray) {
                JSONArray extentArray = (JSONArray)objExtent;
                float minX = this.getNumberValue(extentArray, 0).floatValue();
                float maxX = this.getNumberValue(extentArray, 1).floatValue();
                float minY = this.getNumberValue(extentArray, 2).floatValue();
                float maxY = this.getNumberValue(extentArray, 3).floatValue();
                extent = new Envelope(minX, maxX, minY, maxY);
            }
            String strDataPath = (String)map.get(DATA_PATH);
            RasterFileDataSource rasterFileDataSrc = new RasterFileDataSource(pdfMap, strDataPath, extent);
            RasterLayer rasterlayer = new RasterLayer(pdfMap, name, opacity.floatValue(), rasterFileDataSrc);
            layer = rasterlayer;
        } else if (type.equals(FEATURE_LAYER)) {
            String strDataPath = (String)map.get(DATA_PATH);
            Object clip = map.get(CLIP_EXTENT);
            Envelope clipExtent = null;
            if (clip != null && clip instanceof JSONArray) {
                JSONArray extentArray = (JSONArray)clip;
                float minX = this.getNumberValue(extentArray, 0).floatValue();
                float maxX = this.getNumberValue(extentArray, 1).floatValue();
                float minY = this.getNumberValue(extentArray, 2).floatValue();
                float maxY = this.getNumberValue(extentArray, 3).floatValue();
                clipExtent = new Envelope(minX, maxX, minY, maxY);
            }
            GeoJSONFeatureDataSource featureSrc = new GeoJSONFeatureDataSource(pdfMap, strDataPath, clipExtent);
            FeatureLayer featureLayer = new FeatureLayer(pdfMap, name, opacity.floatValue(), featureSrc);
            layer = featureLayer;
        }
        layer.setVisible(visible);
        return layer;
    }

    private Number getNumberValue(JSONArray array, int index) {
        Object obj;
        Number val = null;
        if (array != null && index > -1 && (obj = array.get(index)) != null && obj instanceof Number) {
            val = (Number)obj;
        }
        return val;
    }

    private PdfMap parseJsonPdfMap(String jsonPdfMap) throws ParseException, IOException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(jsonPdfMap);
        JSONObject jsonObject = (JSONObject)obj;
        Map map = (Map)jsonObject.get(PDF_MAP);
        String coordinateReferenceSystem = (String)map.get(COORDINATE_REFERENCE_SYSTEM);
        JSONArray rectArray = (JSONArray)map.get(PAGE_SIZE);
        int w = this.getNumberValue(rectArray, 0).intValue();
        int h = this.getNumberValue(rectArray, 1).intValue();
        PDRectangle rect = new PDRectangle(w, h);
        JSONArray geogExtentArray = (JSONArray)map.get(GEOG_EXTENT);
        double minXge = this.getNumberValue(geogExtentArray, 0).doubleValue();
        double maxXge = this.getNumberValue(geogExtentArray, 1).doubleValue();
        double minYge = this.getNumberValue(geogExtentArray, 2).doubleValue();
        double maxYge = this.getNumberValue(geogExtentArray, 3).doubleValue();
        Envelope geogExtent = new Envelope(minXge, maxXge, minYge, maxYge);
        JSONArray projExtentArray = (JSONArray)map.get(PROJ_EXTENT);
        double minXpr = this.getNumberValue(projExtentArray, 0).doubleValue();
        double maxXpr = this.getNumberValue(projExtentArray, 1).doubleValue();
        double minYpr = this.getNumberValue(projExtentArray, 2).doubleValue();
        double maxYpr = this.getNumberValue(projExtentArray, 3).doubleValue();
        Envelope projExtent = new Envelope(minXpr, maxXpr, minYpr, maxYpr);
        return new PdfMap(geogExtent, projExtent, rect, coordinateReferenceSystem);
    }

    private void setBGColor(String jsonBgColor) throws ParseException {
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(jsonBgColor);
        JSONObject jsonObject = (JSONObject)obj;
        JSONArray colorArray = (JSONArray)jsonObject.get(BACKGROUND_COLOR);
        if (colorArray != null) {
            Long r = (Long)colorArray.get(0);
            Long g = (Long)colorArray.get(1);
            Long b = (Long)colorArray.get(2);
            Color bgColor = new Color(r.intValue(), g.intValue(), b.intValue());
            this.pdfMap.setBackgroundColor(bgColor);
        }
    }

    private void parseJsonDocumentInfo(String jsonDocInfo) throws ParseException {
        String title;
        String subject;
        String keywords;
        String creator;
        JSONParser parser = new JSONParser();
        Object obj = parser.parse(jsonDocInfo);
        JSONObject jsonObject = (JSONObject)obj;
        Map map = (Map)jsonObject.get(DOCUMENT_INFO);
        String author = (String)map.get(DOCUMENT_INFO_AUTHOR);
        if (author != null) {
            this.pdfMap.setAuthor(author);
        }
        if ((creator = (String)map.get(DOCUMENT_INFO_CREATOR)) != null) {
            this.pdfMap.setCreator(creator);
        }
        if ((keywords = (String)map.get(DOCUMENT_INFO_KEYWORDS)) != null) {
            this.pdfMap.setKeywords(keywords);
        }
        if ((subject = (String)map.get(DOCUMENT_INFO_SUBJECT)) != null) {
            this.pdfMap.setSubject(subject);
        }
        if ((title = (String)map.get(DOCUMENT_INFO_TITLE)) != null) {
            this.pdfMap.setTitle(title);
        }
    }
}

