/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.PixelGrabber;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;

public class FrameTest
extends JFrame {
    String m_filename;
    FrameTestImageArea c_imgArea;
    int m_xsize;
    int m_ysize;
    Box c_controlBox;

    public FrameTest(String filename) {
        super("Example IDL-Java Interaction");
        this.m_filename = filename;
        this.setDefaultCloseOperation(2);
        this.m_xsize = 350;
        this.m_ysize = 371;
        this.buildGUI();
    }

    public void buildGUI() {
        this.c_controlBox = Box.createVerticalBox();
        JButton b1 = new JButton("Close");
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameTest.this.dispose();
            }
        });
        this.c_imgArea = new FrameTestImageArea(this.m_filename, new Dimension(this.m_xsize, this.m_ysize));
        Box mainBox = Box.createVerticalBox();
        Box rowBox = Box.createHorizontalBox();
        rowBox.add(b1);
        this.c_controlBox.add(rowBox);
        mainBox.add(this.c_imgArea);
        mainBox.add(this.c_controlBox);
        this.getContentPane().add(mainBox);
        this.pack();
        this.setVisible(true);
        this.c_imgArea.displayImage();
        this.c_imgArea.addResizeListener(new FrameTestImageAreaResizeListener(){

            @Override
            public void areaResized(int newx, int newy) {
                Dimension cdim = FrameTest.this.c_controlBox.getSize(null);
                Insets i = FrameTest.this.getInsets();
                newx = i.left + i.right + newx;
                newy = i.top + cdim.height + newy + i.bottom;
                FrameTest.this.setSize(new Dimension(newx, newy));
            }
        });
    }

    public byte[][][] getImageData() {
        int width = 1;
        int height = 1;
        width = this.m_xsize;
        height = this.m_ysize;
        int[] pixarray = new int[width * height];
        byte[][][] bytearray = new byte[3][width][height];
        PixelGrabber pGrab = new PixelGrabber(this.c_imgArea.getImageObj(), 0, 0, width, height, pixarray, 0, width);
        try {
            boolean bl = pGrab.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("pixel grab interrupted");
            return bytearray;
        }
        int pixi = 0;
        int curpix = 0;
        for (int j = 0; j < this.m_ysize; ++j) {
            for (int i = 0; i < this.m_xsize; ++i) {
                curpix = pixarray[pixi++];
                bytearray[0][i][j] = (byte)(curpix >> 16 & 0xFF);
                bytearray[1][i][j] = (byte)(curpix >> 8 & 0xFF);
                bytearray[2][i][j] = (byte)(curpix & 0xFF);
            }
        }
        return bytearray;
    }
}

