/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import com.idl.javaidl.EBUtilities;
import java.io.File;
import java.net.URL;

public class JIDLPlatform {
    private static final String SEP = File.separator;
    private static final char SEP_CHAR = File.separatorChar;
    private static final String JAVA_DIR_KEYWORD = "JavaDir";
    private static final String JAVAPAL_DIR_KEYWORD = "JavaPALDir";
    private static final String BML_DIR_KEYWORD = "BMLDir";
    private static final String EBUTILS_DIR_KEYWORD = "EBUtilsDir";
    private static final String DEBUG_KEYWORD = "IDL_LOAD_DEBUG";
    protected static String g_osArch;
    protected static String g_osName;
    private static boolean g_bShowLoadDebug;
    private static String g_javaDir;
    private static String g_ebutilsDir;
    private static String g_bmlDir;
    private static String g_javapalDir;

    private static void calcLibraryLocations() {
        if (JIDLPlatform.isWindows()) {
            JIDLPlatform.calcEBUtilsLocation();
            EBUtilities.initialize(g_ebutilsDir);
            g_javapalDir = g_ebutilsDir;
            g_bmlDir = g_ebutilsDir;
        }
    }

    protected static String getJavaPALLibraryLocation() {
        return g_javapalDir;
    }

    protected static String getBMLLibraryLocation() {
        return g_bmlDir;
    }

    protected static String getJavaLibraryLocation() {
        return g_javaDir;
    }

    private static void calcEBUtilsLocation() {
        boolean fromCommandLine = true;
        if (JIDLPlatform.isWindows()) {
            Object ebutilsLocation = System.getProperty(EBUTILS_DIR_KEYWORD);
            if (ebutilsLocation == null) {
                fromCommandLine = false;
                String path = JIDLPlatform.findLoadedJarPath("javaidlb.jar");
                String binDir = "bin.x86";
                if (g_osArch.equals("amd64")) {
                    binDir = "bin.x86_64";
                }
                ebutilsLocation = path + ".." + SEP + ".." + SEP + ".." + SEP + ".." + SEP + "bin" + SEP + binDir;
            }
            g_ebutilsDir = ebutilsLocation;
            if (g_bShowLoadDebug) {
                System.out.println("EBUtils location : " + g_ebutilsDir + (fromCommandLine ? " (set via Java command line)" : " (set relative to javaidlb.jar)"));
            }
        }
    }

    private static void calcJavaLibLocation() {
        boolean fromCommandLine = true;
        g_javaDir = System.getProperty(JAVA_DIR_KEYWORD);
        if (g_javaDir == null) {
            fromCommandLine = false;
            String jreHome = System.getProperty("java.home");
            g_javaDir = JIDLPlatform.isWindows() ? jreHome + SEP + "bin" : jreHome + SEP + "lib";
        }
        if (g_bShowLoadDebug) {
            System.out.println("Java location : " + g_javaDir + (fromCommandLine ? " (set via Java command line)" : " (set relative to java.home property)"));
        }
    }

    public static String findLoadedJarPath(String jarName) {
        String path = null;
        ClassLoader cl = JIDLPlatform.class.getClassLoader();
        URL url = cl.getResource("com/idl/javaidl/JIDLPlatform.class");
        path = url.getFile();
        int index = path.indexOf(jarName);
        if (index >= 0) {
            if ((path = path.substring(0, index)).startsWith("file:")) {
                path = path.substring(5);
            }
            if ((path = path.replace('/', SEP_CHAR)).startsWith(SEP)) {
                path = path.substring(1);
            }
            path = path.replaceAll("%20", " ");
        }
        if (g_bShowLoadDebug) {
            System.out.println("findLoadedJarPath: " + path);
        }
        return path;
    }

    public static boolean platformSupportsGraphics() {
        return true;
    }

    public static boolean platformSupportsOutOfProcessGraphics() {
        return !g_osName.startsWith("Mac");
    }

    protected static boolean isWindows() {
        return g_osName.startsWith("Windows");
    }

    private static int loadLibraryPerDefaultPath(String sLibName) {
        int retVal = 0;
        try {
            System.loadLibrary(sLibName);
        }
        catch (UnsatisfiedLinkError e) {
            if (e.getMessage().toLowerCase().indexOf("already loaded") >= 0) {
                retVal = 0;
            } else {
                if (g_bShowLoadDebug) {
                    System.err.println("*** " + String.valueOf(e));
                }
                retVal = -1;
            }
        }
        catch (Throwable e) {
            if (g_bShowLoadDebug) {
                System.err.println("*** " + String.valueOf(e));
            }
            retVal = -1;
        }
        return retVal;
    }

    private static int loadExplicitLibrary(String sLibLocation, String sLibName) {
        int retVal = 0;
        try {
            String libraryPath = sLibLocation + SEP + System.mapLibraryName(sLibName);
            System.load(libraryPath);
        }
        catch (UnsatisfiedLinkError e) {
            if (e.getMessage().toLowerCase().indexOf("already loaded") >= 0) {
                retVal = 0;
            } else {
                if (g_bShowLoadDebug) {
                    System.err.println("*** " + String.valueOf(e));
                }
                retVal = -1;
            }
        }
        catch (Throwable e) {
            if (g_bShowLoadDebug) {
                System.err.println("*** " + String.valueOf(e));
            }
            retVal = -1;
        }
        return retVal;
    }

    protected static int loadNeededLibrary(String sLibLocation, String sLibName) {
        int retVal = 0;
        retVal = sLibLocation == null || sLibLocation.length() == 0 ? JIDLPlatform.loadLibraryPerDefaultPath(sLibName) : JIDLPlatform.loadExplicitLibrary(sLibLocation, sLibName);
        if (g_bShowLoadDebug && retVal == 0) {
            System.out.println("Successfully loaded " + System.mapLibraryName(sLibName));
        }
        if (retVal != 0) {
            System.err.println("Failed to load " + sLibName + " from: " + (sLibLocation != null && sLibLocation.length() > 0 ? sLibLocation : "default location."));
        }
        return retVal;
    }

    static {
        g_bShowLoadDebug = false;
        g_osArch = System.getProperty("os.arch");
        g_osName = System.getProperty("os.name");
        if (System.getProperty(DEBUG_KEYWORD) != null) {
            g_bShowLoadDebug = true;
        }
        JIDLPlatform.calcJavaLibLocation();
        JIDLPlatform.calcLibraryLocations();
    }
}

